/****************************************************************
	Convert 8bit mode file into screen mode 7 file
			&
	Arrenge data for software sprite

		progurammed by M.kimura
					[ Dec.08, 1992 ]
 ****************************************************************/

#include	<stdio.h>
#include	<strings.h>

#define		ERROR		-1
#define		COMPLETE	0
#define		DSIZE		0x10000
#define		CSIZE		0x400
#define		unchar		unsigned char

unchar	chrbuf[DSIZE] ;
unchar  chrbuf2[DSIZE] ;

main( argc,argv )
int	argc ;
char	**argv ;
{
	char	fname[65] ;

	printf( "Convert 8bit mode file into screen mode 7 file.\n" ) ;
	if ( argc != 2 ) {
		fputs( "usage: cnvmode7 <data name>\n",stderr ) ;
		exit(1) ;
	}
	strcpy( fname,*(++argv)) ;
	strcat( fname,".CGX" ) ;
	if ( chrred( fname,chrbuf,DSIZE ) == ERROR ) {
		fprintf( stderr,"%s: No such file or not 8bit mode.\n",fname ) ;
		exit(1) ;
	}
	conv( chrbuf,CSIZE ) 	;
	
	arrenge( chrbuf,chrbuf2 ) 	;

	strcpy( fname,*argv ) ;
	strcat( fname,".ARG" ) ;
	if ( chrwte( fname,chrbuf2,DSIZE ) == ERROR ) {
		perror( *argv ) ;
		exit(1) ;
	}
	exit(0) ;
}

/******* read character data from file **************************/

chrred( fname,buff,size )
char	*fname,*buff ;
int	size ;
{
	FILE	*fp ;

	if (( fp = fopen( fname,"r" )) == NULL )	  return( ERROR ) ;
/*
	if ( fread( buff,sizeof(char),size,fp ) != size ) return( ERROR ) ;
*/
	fread( buff,sizeof(char),size,fp) ;
	fclose( fp ) ;
	return( COMPLETE ) ;
}


/******* write character data into file *************************/

chrwte( fname,buff,size )
char	*fname,*buff ;
int	size ;
{
	FILE	*fp ;

	if (( fp = fopen( fname,"w" )) == NULL )	   return( ERROR ) ;
	if ( fwrite( buff,sizeof(char),size,fp ) != size ) return( ERROR ) ;
	fclose( fp ) ;
	return( COMPLETE ) ;
}


/******* data arrangement for software sprite********************/
arrenge	(ad1,ad2)
unchar 	*ad1,*ad2   ;
{	
		int	c0,c1,c2,c3,c4,c5,pt1,pt2,selecta;
	pt2=0;
      for   (c0=0;c0<4;c0++){
	for   (c1=0;c1<4;c1++){
	   for   (c2=0;c2<8;c2++){
	      for  (c3=0;c3<32;c3++){

		selecta=0;c5=c3;
	     if (c3>15)  {
			selecta=0x1000;c5=c3-16;}
				
	         for  (c4=0;c4<8;c4++){

		pt1=c0*0x2000+c1*0x400+c2*08+c5*64+c4;
		
		*(ad2+pt2) = *(ad1+selecta+pt1);
		pt2++;
	
		}
	    }
         }
      }
   }
}
/******* convert character **************************************/

conv( data,size )
unchar	*data ;
int	size ;
{
	unchar	buff[0x40], *dt,*bf,*p ;
	int	ct,ix,iy,ii,nn ;

	for ( ct=0 ; ct<size ; ct++ ) {
		bf = buff ;
		dt = data ;
		for ( iy=0 ; iy<8 ; iy++ ) {
			for ( ix=0 ; ix<8 ; ix++ ) {
				for ( p=dt,nn=ii=0 ; ii<4 ; p+=0x10,ii++ ) {
					nn >>= 1 ;
					nn  |= ( *(p+0) & 0x80 ) ;
					nn >>= 1 ;
					nn  |= ( *(p+1) & 0x80 ) ;

					*(p+0) <<= 1 ;
					*(p+1) <<= 1 ;
				}
				*bf++ = nn ;
			}
			dt += 2 ;
		}
		memcpy( data,buff,0x40 ) ;
		data += 0x40 ;
	}
}


/******* memory copy *******************************************/

memcpy( dd,ss,nn )
char	*dd,*ss ;
int	nn ;
{
	while ( nn-- ) {
		*dd++ = *ss++ ;
	}
}
