/****************************************************************
	Convert 2bit mode file into bitmap compressed mode
			&

		proguraiied by M.kimura
					[ Dec.08, 1992 ]
 ****************************************************************/

#include	<stdio.h>
#include	<strings.h>

#define		ERROR		-1
#define		COMPLETE	0
#define		DATASIZE	0x8000
#define		DSIZE		0x8000
#define		CSIZE		0x400
#define		unchar		unsigned char

unchar	chrbuf[DSIZE] ;
unchar	chrbuf2[DSIZE];
unchar	chrbuf3[DSIZE];

main( argc,argv )
int	argc ;
char	**argv ;
{
	char	fname[65] ;

	printf( "Convert 2bit character to bitmap data.\n" ) ;
	if ( argc != 2 ) {
		fputs( "usage: font2bit <data name>\n",stderr ) ;
		exit(1) ;
	}
	strcpy ( fname,*(++argv));
	strcat
	( fname,".cgx" ) ;
	chrred ( fname,chrbuf,DSIZE );


	conv (chrbuf,chrbuf2) ;
	arrenge (chrbuf2,chrbuf3);	

	strcpy( fname,*argv ) ;
	strcat( fname,".bmp" ) ;
	chrwte( fname,chrbuf3,DSIZE ) ;


}

/******* read character data from file **************************/

chrred( fname,buff,size )
char	*fname,*buff ;
int	size ;
{
	FILE	*fp ;

	fp=fopen( fname,"r" );
	fread( buff,sizeof(char),size,fp) ;
	fclose( fp ) ;
}


/******* write character data into file *************************/

chrwte( fname,buff,size )
char	*fname,*buff ;
int	size ;
{
	FILE	*fp ;
	fp=fopen( fname,"w" ) ;
	fwrite( buff,sizeof(char),size,fp) ;
	fclose( fp ) ;
}





/******* arrange data **************************************/
arrenge (ad1,ad2)
unchar	*ad1,*ad2	;

{
	int	c0,c1,c2,pt1,pt2,selecta;

	pt2=0;
	
	for	(c0=0;c0<DATASIZE/0x100;c0++){
	    for  (c1=0;c1<8;c1++){
	       for     (c2=0;c2<16;c2++){

		pt1=c0*0x100+c2*0x10+c1*02;

		*(ad2+pt2) = *(ad1+pt1);
		pt2++;
		pt1++;
		*(ad2+pt2) = *(ad1+pt1);
		pt2++;
		}
	     }
	}
}
/******* convert character **************************************/

conv(data,data2)

unchar	*data,*data2 ;

{

	unchar		*dtr,*dtw ;
	int		ct,mm,nn,ii,ss,ll ;

		dtr = data ;
		dtw = data2 ;

	for (ct=0; ct < DATASIZE ;ct ++){


			nn=00;
			ii = ( *(dtr+00) & 0x80 ) ;
			ii >>=7;
			nn |=ii;
			ii = ( *(dtr+01) & 0x80 ) ;
			ii >>=6;
			nn |=ii;
			ii = ( *(dtr+00) & 0x40 );
			ii >>=4;
			nn |=ii;
			ii = ( *(dtr+01) & 0x40 );
			ii >>=3;
			nn |=ii;
			ii = ( *(dtr+00) & 0x20 );
			ii >>=1;
			nn |=ii;
			ii = ( *(dtr+01) & 0x20 );
			nn |=ii;
			ii = ( *(dtr+00) & 0x10 ) ;
			ii <<=2;
			nn |=ii;
			ii =  *(dtr+01) & 0x10 ;
			ii <<=3;
			nn |=ii;

			mm=00;
			ii = ( *(dtr+00) & 0x8 ) ;
			ii >>=3;
			mm |=ii;
			ii = ( *(dtr+01) & 0x8 ) ;
			ii >>=2;
			mm |=ii;
			ii = ( *(dtr+00) & 0x4 );
			mm |=ii;
			ii = ( *(dtr+01) & 0x4 );
			ii <<=1;
			mm |=ii;
			ii = ( *(dtr+00) & 0x2 );
			ii <<=3;
			mm |=ii;
			ii = ( *(dtr+01) & 0x2 );
			ii <<=4;
			mm |=ii;
			ii = ( *(dtr+00) & 0x1 ) ;
			ii <<=6;
			mm |=ii;
			ii =  *(dtr+01) & 0x1 ;
			ii <<=7;
			mm |=ii;


			
			*dtw++ = nn;
			*dtw++ = mm;
			dtr +=02;
						
					}
}


/**************memcopy********************/


memcopy (dd,ss,nn)
char	*dd,*ss ;
int	nn ;

{
	while ( nn-- ) {
		*dd++ = *ss++ ;
	}
}

