/*****************************************************************
   Convert-Program  					 [3D_ID.C]
	ID_COL(*.dat) -> 3d-cad ID_data (ASCII-TEXT)
						 (MS-DOS:Ver 1.10)
     Programed By SHIGEKI YAMASHIRO [NCL/EAD]	     [Apl,13,1992]
 ****************************************************************/
#include	<stdio.h>
#include	"id.h"

main(argc,argv)
int argc ;
char *argv[];
{
	FILE *fp,*fopen();
	char read_name[64];	/* In :color_data */
	char *write_name = "id_tabl.asm";  /* Out:color_data */
	ID data[8] ;
	unsigned char work[0x40] ;
	int count,files,id ;
	int flag,i,j,k,n ;

	if(argc == 1)	usage(1);

	for(files=0;files<(argc -1);files++){
		*argv ++;
		/* In:*.STD*/
		strcpy(read_name,*argv);
		strcut(read_name,'.');
		strcat(read_name,".STD");
/* t@C`FbN (File-Read) */
		 if ((fp=fopen(read_name,"rb"))==NULL){
			printf(" File : %s\n",read_name) ;
			perror(read_name);
			exit(1);
		}
		printf("READ:%s\n",read_name);
/* Data read */
		for(count=0;count<=0x3f;count++){
			fread(work,0x40,sizeof(char),fp) ;
			data_set_0(&data[files*2],&work,count) ;
			data_set_1(&data[files*2+1],&work,count) ;
		}
		fclose(fp);
	}

/* file Label Write */
/* t@C`FbN (File_Write) */
	 if ((fp=fopen(write_name,"w"))==NULL){
		printf(" File : %s\n",write_name) ;
		perror(write_name);
		exit(1);
	}
	printf("Write:%s\n",write_name);
	id = (argc-1)*2 ;
	fprintf(fp,";******************************************************************************\n");
	fprintf(fp,"ID\n");
	/* dl labele */
	for(i=0;i<=255;i++){
		fprintf(fp,"		dl		ID_flag%02d,ID%02d		;%d\n",0,0,i) ;
	}
	fprintf(fp,";******************************************************************************\n");
	fprintf(fp,";*           Light Source shading ... 0 , DePth cue         ... 1\n");
	fprintf(fp,";*           Color Animation      ... 2 , Soft ware Spright ... 4\n");
	fprintf(fp,";******************************************************************************\n");
	/* ID label */
	for(i=0;i<id;i++){
		flag = 1 ;
		for(j=0;j<=255;j+=16){
			if(data[i].code[j]==3) break ;
			if(j == 0)	fprintf(fp,"ID_flag%02d\n",i) ;
			for(k=0;k<=15;k++){
				if(data[i].code[j+k]!=3){
					if(k == 0){
						fprintf(fp,"		byte		");
						fprintf(fp,"%d",data[i].code[j+k]) ;
					}
					else	fprintf(fp,",%d",data[i].code[j+k]) ;
				}
				else{
					flag = 0;
					break ;
				}
			}
			fprintf(fp,"\n") ;
			if(flag == 0) break ;
		}
	}
	fprintf(fp,";******************************************************************************\n");
	fprintf(fp,";*                         Color table                        		  *\n");
	fprintf(fp,";******************************************************************************\n");
	fprintf(fp,"Color_table     ;Light Source shading    DePth\n");
	fprintf(fp,";Color Animation         Soft ware Spright\n");
	/* Color label */
	for(i=0;i<id;i++){
		flag = 1 ;
		for(j=0;j<=255;j+=8){ /* data counter (L) */
			if(flag == 0) break ;
			if(data[i].code[j]==3) break ;
			if(j == 0)	fprintf(fp,"ID%02X\n",i) ;
			for(k=0;k<=7;k++){
				if(k == 0)	fprintf(fp,"		dl		");
				switch(data[i].code[j+k]){
					case 0 :/* Light Source */
						if(k != 0)	fprintf(fp,",") ;
						fprintf(fp,"LS%02X",data[i].number[j+k]);
						break ;
					case 1 :/* DePth Quew */
						if(k != 0)	fprintf(fp,",") ;
						fprintf(fp,"DP%02X",data[i].number[j+k]);
						break ;
					case 2 :/* Color Animetion */
						if(k != 0)	fprintf(fp,",") ;
						fprintf(fp,"CA%02X",data[i].number[j+k]);
						break ;
					case 3 :/* END */
						fprintf(fp,"\n") ;
						flag = 0 ;
						break ;
					case 4 :/* Memory Mapping */
						if(k != 0)	fprintf(fp,",") ;
						fprintf(fp,"MM%02X",data[i].number[j+k]);
						break ;
				}
				if(k == 7)	fprintf(fp,"\n") ;
				if(flag == 0)	break ;
			}
		}
	}
	fclose(fp);
}
/**********************************/
/*	data set to id_data	  */
/**********************************/
data_set_0(data,work,count)
ID *data ;
unsigned char *work ;
int count ;
{
	/* code (0) */
	data->code[count]       = code(work[0x04]) ;
	data->number[count]     = num(work[0x05],work[0x06]) ;
	data->code[count+64]    = code(work[0x0C]) ;
	data->number[count+64]  = num(work[0x0D],work[0x0E]) ;
	data->code[count+128]   = code(work[0x14]) ;
	data->number[count+128] = num(work[0x15],work[0x16]) ;
	data->code[count+192]   = code(work[0x1C]) ;
	data->number[count+192] = num(work[0x1D],work[0x1E]) ;
}
data_set_1(data,work,count)
ID *data ;
unsigned char *work ;
int count ;
{
	/* code (1) */
	data->code[count]       = code(work[0x24]) ;
	data->number[count]     = num(work[0x25],work[0x26]) ;
	data->code[count+64]    = code(work[0x2C]) ;
	data->number[count+64]  = num(work[0x2D],work[0x2E]) ;
	data->code[count+128]   = code(work[0x34]) ;
	data->number[count+128] = num(work[0x35],work[0x36]) ;
	data->code[count+192]   = code(work[0x3C]) ;
	data->number[count+192] = num(work[0x3D],work[0x3E]) ;
}
/* Code Change */
code(n)
int n ;
{
	switch(n){
		case 0x11: /* L */
			return(0) ;
		case 0x12: /* D */
			return(1) ;
		case 0x13: /* C */
			return(2) ;
		case 0x15: /* E */
		case 0x16: /* N */
		case 0x17: /* D */
			return(3) ;
		default: /* M */
			return(4) ;
	}
}
/* Number Change */
num(H,L)
int H ;
int L ;
{
	if((H<0)||(H>=0x10))	return(0);
	if((L<0)||(L>=0x10))	return(0);
	return(H*0x10+L) ;
}
/***********************************
* @̌납̂P *
* @ AȌJbgB*
***********************************/
strcut(str,chr)
char *str ;	/* string */
int chr ;	/* char */
{
	int i ;

	for (i = strlen(str) ; i >= 0 ;i --){
		if ( str[i] == chr ){
			str[i] = 0 ;
			return (0) ;

		}
	}
	return (1) ;
}

/************************************************
	usage  \
************************************************/
usage(n)
int n ;
{
	printf("\n\n Usage :\n");
	printf("       3D_ID File(.STD) \n");
	printf("          [3d-TOOL COLOR_DATA]\n");
	printf("               (.STD) -> .ASM \n");
	printf("                                 (Ver. 1.0)");
	exit(n) ;
}
