/*****************************************************************
	NEWS_CAD(*.STD) -> ӂǂ(ASM-TEXT)  Combert Program
					[DEPTH_DATA](UNIX:Ver 1.0)
     Programed By SHIGEKI YAMASHIRO [NCL/EAD]	    [Mar.,26,1993]
 ****************************************************************/
#include	<stdio.h>

main(argc,argv)
int argc ;
char *argv[];
{
	FILE *fp, *fopen();
	char read_file[64] ;	/* In :color_data */
	char write_file[64] ;	/* Out:color_data */
	unsigned char data[4][0x100] ;	/* depth color data */
	char work[0x40] ;
	int count ;
	int group,V_count ;

/*** IvV@́@`FbN ***/
	if(argc != 2)		usage(1);
/*** t@C l[@ 쐬 ***/
	*argv ++;
	/* In:color_data (STD-File)*/
	strcpy(read_file,*argv);
	strcut(read_file,'.');
	strcat(read_file,".STD");
	/* Out:color_data (text)*/
	strcpy(write_file,*argv);
	strcut(write_file,'.');
	strcat(write_file,".asm");
/*** t@C G[ `FbN (READ) ***/
	 if (( fp = fopen(read_file,"rb")) == NULL ){
		printf(" File : %s\n",read_file ) ;
		perror(read_file) ;
		exit(1) ;
	}
	printf("read:%s\n",read_file) ;
/* File Read & Change */
	for(count=0;count<=0x1f;count++){
		fread(work,0x40,sizeof(char),fp) ;
		data_set(&data,work,count) ;
	}
	fclose(fp);
/*** t@C G[ `FbN (WRITE) ***/
	 if (( fp = fopen(write_file, "w")) == NULL ) {
		printf(" File : %s\n",write_file ) ;
		perror(write_file);
		exit(1);
	}
	printf("  -> %s\n",write_file);
/* file Label Write */
	fprintf(fp,";---------------------------    Depth Color Data    ---------------------------\n") ;
	for(V_count=0;V_count<=0xff;V_count++){
			if(data[0][V_count]==0)	break ;
			fprintf(fp,"DP%02X\n",V_count);
			fprintf(fp,"	byte	");
			fprintf(fp,"%03xh,%03xh,%03xh,%03xh\n",data[0][V_count],data[1][V_count],data[2][V_count],data[3][V_count]) ;
	}
	fclose(fp);
	printf("End : %03X H\n",V_count-1) ;
	return(V_count-1) ;
}
/**********************************/
/*	DATA SET TO DEPTH         */
/**********************************/
data_set(data,work,V_pos)
unsigned char  data[4][0x100] ;
char *work ;
int V_pos ;
{
	int count;

	for(count=0;count<=3;count++)	data[count][V_pos+0x00]=work[0x02+count] ;
	for(count=0;count<=3;count++)	data[count][V_pos+0x20]=work[0x0A+count] ;
	for(count=0;count<=3;count++)	data[count][V_pos+0x40]=work[0x12+count] ;
	for(count=0;count<=3;count++)	data[count][V_pos+0x60]=work[0x1A+count] ;
	for(count=0;count<=3;count++)	data[count][V_pos+0x80]=work[0x22+count] ;
	for(count=0;count<=3;count++)	data[count][V_pos+0xA0]=work[0x2A+count] ;
	for(count=0;count<=3;count++)	data[count][V_pos+0xC0]=work[0x32+count] ;
	for(count=0;count<=3;count++)	data[count][V_pos+0xE0]=work[0x3A+count] ;
	return(0) ;
}
/***********************************
* @̌납̂P *
* @ AȌJbgB*
***********************************/
strcut(str,chr)
char *str ;	/* string */
int chr ;	/* char */
{
	int i ;

	for (i=strlen(str);i>=0;i--){
		if ( str[i] == chr ){
			str[i] = 0 ;
			return (0) ;
		}
	}
	return (1) ;
}

/************************************************
	usage  \
************************************************/
usage(code)
int	code ;
{
	printf("\n\n Usage :\n");
	printf("       NEWS_CAD File(.STD) \n");
	printf("          [3d-TOOL COLOR_DATA]\n");
	printf("               (.STD) -> .ASM \n");
	printf("              1993.3.25 [Ver.1.00]\n");
	exit(code) ;
}
