/****************************************************************
	Convert intel-hex into binary file version 1.00
					[ Nov.24, 1989 ]
 ****************************************************************/

#include	<stdio.h>
#include	<strings.h>

#define		ERROR		1
#define		COMPLETE	0

void main( argc,argv )
int	argc ;
char	**argv ;
{
	char	hex_name[65],bin_name[65] ;

	puts( "Convert intel-hex into binary file version 1.00" ) ;
	if ( argc != 2 ) {
		puts( "Usage: hex2bin <data name>" ) ;
		exit( 1 ) ;
	}
	argv++ ;
	strcpy( hex_name, *argv ) ;
	strcpy( bin_name, *argv ) ;
	strcat( hex_name,".hex" ) ;
	strcat( bin_name,".bin" ) ;
	if ( convert( hex_name,bin_name ) == ERROR ) {
		perror( *argv ) ;
		exit( 1 ) ;
	}
	exit( 0 ) ;
}

/******* Convert main *******************************************/

int convert( hex,bin )
char	*hex,*bin ;
{
	FILE	*rp,*wp ;
	char	*str,buff[256] ;
	int	ct,len,dat,sum,lin=0 ;

	if (( rp = fopen( hex,"r" )) == NULL ) return ( ERROR ) ;
	if (( wp = fopen( bin,"w" )) == NULL ) return ( ERROR ) ;

	while ( fgets( buff,255,rp ) != NULL ) {
		str = buff ;
		lin ++ ;

		if ( *str++ != ':' ) {
			puts( "file is not intel-hex format" ) ;
			break ;
		}
		if (( sum = len = getnum( &str )) == 0 ) break ;
		for ( ct=0 ; ct<3 ; ct++ ) sum += getnum( &str ) ;

		for ( ct=0 ; ct<len ; ct++ ) {
			sum += ( dat = getnum( &str )) ;
			fputc( dat,wp ) ;
		}
		if ( (sum+getnum(&str)) & 0xff ) printf( "check sum error.  line = %d\n",lin ) ;
	}
	return ( COMPLETE ) ;
}

/******* get number *********************************************/

int getnum( str )
char	**str ;
{
	int	nn ;

	nn  = (( *(*str+0) <= '9' ) ? *(*str+0) - '0' : *(*str+0) - 'A'+10 ) * 16 ;
	nn +=  ( *(*str+1) <= '9' ) ? *(*str+1) - '0' : *(*str+1) - 'A'+10 ;
	(*str) += 2 ;
	return ( nn ) ;
}
