/************************************************************************
	Convert HP assembler source into NEWS assembler source
						[ Nov.22, 1990 ]
 ************************************************************************/

#include	<stdio.h>

#define		endstr(a)	(((a)=='\n')||((a)=='\0'))
#define		endwrd(a)	(((a)=='\n')||((a)=='\0')||((a)==' '))

void	line_convert(),line_copy() ;


void main( argc,argv )
int	argc ;
char	**argv ;
{
	FILE	*rfp,*wfp ;
	char	HP_buf[256],NEWS_buf[256] ;

	printf( "Convert HP assembler source into NEWS assembler source\n" ) ;
	if ( argc != 3 ) {
		printf( "Usage: hp2news  <HPsource> <NEWSsource>\n" ) ;
		exit( 1 ) ;
	}
	if (( rfp = fopen( *++argv,"r" )) == NULL ) {
		perror( *argv ) ;
		exit( 1 ) ;
	}
	if (( wfp = fopen( *++argv,"w" )) == NULL ) {
		perror( *argv ) ;
		exit( 1 ) ;
	}

	fgets( HP_buf,256,rfp ) ;		/*  read processor name		*/

	while ( fgets( HP_buf,256,rfp ) != NULL ) {
		line_convert( HP_buf,NEWS_buf ) ;
		fputs( NEWS_buf,wfp ) ;
	}

	fclose( rfp ) ;
	fclose( wfp ) ;
	printf( "Compeleted.\n" ) ;
}

/************************************************************************/
/*		Convert main function					*/
/************************************************************************/

void line_convert( rbf,wbf )
char	*rbf,*wbf ;
{
	int	clm,cc ;

	if ( *rbf == '*' ) {
		*wbf++ = ';' ;
		line_copy( rbf,wbf,1 ) ;
		return ;
	}
	if ( *rbf == ';' ) {
		line_copy( rbf,wbf,0 ) ;
		return ;
	}

	clm = word_copy( &rbf,&wbf,0 ) ;		/* label copy		*/
	if ( skip_space( &rbf,&wbf,&clm ) <= 0 ) {	/* skip space code	*/
		*wbf++ = '\n' ;
		*wbf++ = '\0' ;
		return ;
	}
	cc = *rbf ;
	clm = word_copy( &rbf,&wbf,clm ) ;		/* Mnemonic copy	*/
	if ( skip_space( &rbf,&wbf,&clm ) <= 0 ) {	/* skip space code	*/
		*wbf++ = '\n' ;
		*wbf++ = '\0' ;
		return ;
	}
	clm = operand_copy( &rbf,&wbf,clm,cc ) ;
	line_copy( rbf,wbf,clm ) ;	
}

/************************************************************************/
/*		Copy one line						*/
/************************************************************************/

void line_copy( rbf,wbf,clm )
char	*rbf,*wbf ;
int	clm ;
{
	int	len ;

	while ( !endstr( *rbf )) {
		if ( *rbf == ' ' ) {
			if ( skip_space( &rbf,&wbf,&clm ) <= 0 ) break ;
		}
		*wbf++ = *rbf++ ;
		clm++ ;
	}
	*wbf++ = '\n' ;
	*wbf++ = '\0' ;
}

/************************************************************************/
/*		Copy one word						*/
/************************************************************************/

int word_copy( rbf,wbf,clm )
char	**rbf,**wbf ;
int	clm ;
{
	char	*rpt,*wpt ;

	rpt = *rbf ;
	wpt = *wbf ;

	while ( !endwrd( *rpt )) {
		*wpt++ = *rpt++ ;
		clm++ ;
	}
	*rbf = rpt ;
	*wbf = wpt ;
	return ( clm ) ;
}

/************************************************************************/
/*		Copy operand						*/
/************************************************************************/

int operand_copy( rbf,wbf,clm,cc )
char	**rbf,**wbf ;
int	clm,cc ;
{
	char	*rpt,*wpt ;

	rpt = *rbf ;
	wpt = *wbf ;

	while ( !endwrd( *rpt )) {
		switch ( *rpt ) {
			case '>':
				if ( *(rpt+1) == '>' ) {
					rpt++ ;
					*wpt++ = '>' ;
				} else {
					*wpt++ = '!' ;
				}
				break ;	
			case '[':
				*wpt++ = '(' ;
				if ( cc != 'J' && *(rpt+1) != '<' ) {
					*wpt++ = '<' ;
					clm++ ;
				}
				else if ( cc == 'J' && *(rpt+1) != '>' ) {
 					*wpt++ = '!' ;
					clm++ ;
				}
				break ;
			case '{':
				*wpt++ = '[' ;
				if ( *(rpt+1) != '<' ) {
					*wpt++ = '<' ;
					clm++ ;
				}
				break ;
			case ']':
				*wpt++ = ')' ;
				break ;
			case '}':
				*wpt++ = ']' ;
				break ;
			default:
				*wpt++ = *rpt ;
				break ;
		}
		clm++ ;
		rpt++ ;
	}
	*rbf = rpt ;
	*wbf = wpt ;
	return ( clm ) ;
}

/************************************************************************/
/*		Skip space code						*/
/************************************************************************/

int skip_space( rbf,wbf,clm )
char	**rbf,**wbf ;
int	*clm ;
{
	int	len ;

	if (( len = space_length( *rbf )) == 0 ) return ( 0 ) ;

	*rbf += len ;
	if ( endstr( **rbf )) return ( -1 ) ;
	*clm = set_space( wbf,*clm,len ) ;
	return ( len ) ;
}

/************************************************************************/
/*		Set space into buffer ( insert tab code	)		*/
/************************************************************************/

int set_space( str,clm,len )
char	**str ;
int	clm,len ;
{
	int	cur,tab ;
	char	*pnt ;

	pnt = *str ;
	if ( len == 1 ) {
		*pnt++ = ' ' ;
		clm++ ;
	}
	else {
		cur = clm + len ;
		tab = ( clm+8 ) & 0xfffffff8 ;

		while ( tab <= cur ) {
			clm = tab ;
			*pnt++ = '\t' ;
			tab = clm + 8 ;
		}
		while ( clm < cur ) {
			*pnt++ = ' ' ;
			clm++ ;
		}
	}
	*str = pnt ;
	return ( clm ) ;
}

/************************************************************************/
/*		Check space length					*/
/************************************************************************/

int space_length( str )
char	*str ;
{
	int	cnt=0 ;

	while ( *str++ == ' ' ) cnt++ ;
	return ( cnt ) ;
}
