/************************************************************************
		    Binary file editor	version 1.00
			Programmed by Y.Nishida
						[ Jul.14, 1989 ]
 ************************************************************************/

#include	<stdio.h>
#include	<strings.h>
#include	<ctype.h>
#include	<sys/ioctl.h>

#define		unchar		unsigned char
#define		prtchr(a)	write(1,a,1)
#define		TRUE		1
#define		FALSE		0
#define		ERROR		-1

#define		BUFSIZE		0x200000
#define		BUFFSIZE	 0x200000
#define		LASTADR		0x1fffff


unchar	datbuf[BUFSIZE] ;		/* data buffer		*/
int	edit_mo = 0 ;			/* edit mode		*/
int	top_adr=0, cur_adr=0 ;
int	chr_ct=0 ;
int	cur_px=0, cur_py=0, cur_hl=0 ;


main()
{
	int	cc,fg=TRUE ;

	set_tty( 1 ) ;

	while ( fg ) {
		prtstr( "\033[2J\033[1;7m\033[1;1H" ) ;
		prtspc( 80 ) ;
		prtstr( "\033[1;25HBinary file editor version 1.00\033[0m\033[5;1H" ) ;

		prtstr( "\t\t        menu \n" ) ;
		prtstr( "\t\t      ============================\n" ) ;
		prtstr( "\t\t          1: read binary file.    \n" ) ;
		prtstr( "\t\t          2: write binary file.   \n" ) ;
		prtstr( "\t\t          3: edit data buffer.    \n" ) ;
		prtstr( "\t\t          4: clear data buffer.   \n" ) ;
		prtstr( "\t\t          5: exit.                \n" ) ;
		prtstr( "\t\t      ============================\n" ) ;
		prtstr( "\t\t                 number = " ) ;

		do {
			cc = getch() ;
		} while ( cc < '1' || '5' < cc ) ;

		switch ( cc ) {
			case '1': file_read() ;		break ;
			case '2': file_write() ;	break ;
			case '3': buff_edit() ;		break ;
			case '4': buff_fill() ;		break ;
			case '5': fg = FALSE ;		break ;
		}
	}
	set_tty( 2 ) ;
	prtstr( "\033[2J" ) ;
}

/************************************************************************/
/*		buffer edit routines					*/
/************************************************************************/

buff_edit()
{
	int	cc,fg=TRUE ;

	prtstr( "\033[2J\033[1;7m\033[1;1H" ) ;
	prtspc( 80 ) ;
	prtstr( "\033[1;25HEdit data buffer\033[0m" ) ;
	disp_scrn( top_adr ) ;

	while ( fg ) {
		if ( edit_mo == 0 ) locate( cur_px+10,cur_py+6 ) ;
			       else locate( chr_ct+60,cur_py+6 ) ;

		cc = getch() ;
		if ( edit_mo == 0 && isxdigit( cc )) inphex( cc ) ;
		else if ( edit_mo == 1 && isprint( cc )) inpasc( cc ) ;
		else {
			switch ( cc ) {
				case  '-': page_down() ;	break ;
				case  '+': page_up() ;		break ;
				case  ',': page_set() ;		break ;
				case 0x1b: fg = escape() ;	break ;
				case 0x08: fg = command() ;	break ;
				case '\t': chg_mode( 1 ) ;	break ;
				case '\n': chg_mode( 0 ) ;	break ;
				case  'I':
				case  'i': ins_byte() ;		break ;
				case  'X':
				case  'x': del_byte() ;		break ;
				case  'Q':
				case  'q': fg = FALSE ;		break ;
			}
		}
	}
}

/*************** change edit mode **************************************/

chg_mode( mo )
int	mo ;
{
	if ( mo ) {
		if ( edit_mo == 0 ) {
			edit_mo = 1 ;
			cur_hl	= 0 ;
			cur_px	= chr_ct * 3 ;
		}
	}
	else {
		if ( edit_mo == 1 ) edit_mo = 0 ;
	}
}

/*************** input hex code ****************************************/

inphex( nn )
int	nn ;
{
	unchar	c1,c2 ;

	c1 = ( nn < 'a' ) ? nn : nn - 0x20 ;

	if	( nn <= '9' )  nn -= '0' ;
	else if ( nn <= 'F' )  nn -= 'A' - 10 ;
	else		       nn -= 'a' - 10 ;

	if ( cur_hl ) nn = datbuf[cur_adr] & 0xf0 | nn ;
		 else nn = datbuf[cur_adr] & 0x0f | nn*16 ;

	c2 = datbuf[cur_adr] = (unchar)nn ;
	if ( !isprint( c2 )) c2 = '.' ;

	prtchr( &c1 ) ;
	locate( chr_ct+60,cur_py+6 ) ;
	prtchr( &c2 ) ;
	cur_right() ;
}

/*************** input ascii code ***************************************/

inpasc( nn )
int	nn ;
{
	unchar	buf[3],cc ;

	setnum( buf,nn ) ;
	buf[2] = '\0' ;
	cc = datbuf[cur_adr] = (unchar)nn ;

	prtchr( &cc ) ;
	locate( cur_px+10,cur_py+6 ) ;
	prtstr( buf ) ;
	cur_right() ;
}

/*************** insert byte *********************************************/

ins_byte()
{
	register unchar *p ;
	register int	ad,iy ;

	if ( cur_adr < LASTADR ) {
		for ( p=datbuf+LASTADR,ad=LASTADR ; ad>cur_adr ; p--,ad-- ) {
			*p = *(p-1) ;
		}
	}
	datbuf[cur_adr] = 0x00 ;

	for ( ad=top_adr+cur_py*16,iy=cur_py+6 ; iy<22 ; ad+=16,iy++ ) {
		disp_line( ad,iy ) ;
	}
}

/*************** delete byte *********************************************/

del_byte()
{
	register unchar *p ;
	register int	ad,iy ;

	if ( cur_adr < LASTADR ) {
		for ( p=datbuf+cur_adr,ad=cur_adr ; ad<LASTADR ; p++,ad++ ) {
			*p = *(p+1) ;
		}
	}
	datbuf[LASTADR] = 0x00 ;

	for ( ad=top_adr+cur_py*16,iy=cur_py+6 ; iy<22 ; ad+=16,iy++ ) {
		disp_line( ad,iy ) ;
	}
}

/*************** command mode ********************************************/

command()
{
	char	com[65] ;
	int	fg,st=TRUE ;

	while ( st ) {
		fg = FALSE ;
		prtstr( "\033[24;3H\033[0K>" ) ;
		com[0] = '\0' ;
		if ( inpstr( 64,com ) <= 0 ) break ;

		switch ( com[0] ) {
			case 'm':
			case 'M': fg = movmem( com+1 ) ;	break ;
			case 'c':
			case 'C': fg = clrmem( com+1 ) ;	break ;
			case 'q':
			case 'Q': st = FALSE ;			break ;
			default : fg = TRUE ;			break ;
		}
		if ( fg ) {
			prtstr( "\033[24;3H\033[0K? command error. [hit any key]" ) ;
			getch() ;
		}
	}
	prtstr( "\033[24;3H\033[0K" ) ;
	return ( st ) ;
}

/*************** move memory ********************************************/

movmem( com )
char	*com ;
{
	int	ad1,ad2,ad3,iy ;

	if (( ad1 = get_addr( &com )) > LASTADR ) return ( TRUE ) ;
	if ( *com++ != ',' ) return ( TRUE ) ;

	ad2 = get_addr( &com ) ;
	if ( *com++ != ',' ) return ( TRUE ) ;
	if ( ad1 > ad2 || ad2 > LASTADR ) return ( TRUE ) ;

	if (( ad3 = get_addr( &com )) > LASTADR ) return ( TRUE ) ;
	if ( *com != '\0' ) return ( TRUE ) ;

	if ( ad3 <= ad1 ) {
		for ( ; ad1<=ad2 && ad3<BUFFSIZE ; ad1++,ad3++ ) {
			datbuf[ad3] = datbuf[ad1] ;
		}
	}
	else {
		if (( ad3 += ad2 - ad1 ) > LASTADR ) {
			ad2 -= ad3 - LASTADR ;
			ad3  = LASTADR ;
		}
		for ( ; ad2>=ad1 ; ad2--,ad3-- ) {
			datbuf[ad3] = datbuf[ad2] ;
		}
	}
	for ( ad1=top_adr,iy=6 ; iy<22 ; ad1+=16,iy++ ) {
		disp_line( ad1,iy ) ;
	}
	return ( FALSE ) ;
}

/*************** clear memory *******************************************/

clrmem( com )
char	*com ;
{
	int	ad1,ad2,da,iy ;

	if (( ad1 = get_addr( &com )) > LASTADR ) return ( TRUE ) ;
	if ( *com++ != ',' ) return ( TRUE ) ;

	ad2 = get_addr( &com ) ;
	if ( *com++ != ',' ) return ( TRUE ) ;
	if ( ad1 > ad2 || ad2 > LASTADR ) return ( TRUE ) ;

	if (( da = get_addr( &com )) > 0xff ) return ( TRUE ) ;
	if ( *com != '\0' ) return ( TRUE ) ;

	for ( ; ad1<=ad2 ; ad1++ ) datbuf[ad1] = da ;

	for ( ad1=top_adr,iy=6 ; iy<22 ; ad1+=16,iy++ ) {
		disp_line( ad1,iy ) ;
	}
	return ( FALSE ) ;
}

/******* get address ****************************************************/

get_addr( p )
char	**p ;
{
	char	*s ;
	int	n = 0 ;

	s = *p ;
	while ( isxdigit( *s )) {
		if	( *s <= '9' )  n = n * 16 + *s++ - '0' ;
		else if ( *s <= 'F' )  n = n * 16 + *s++ - 'A' + 10 ;
		else		       n = n * 16 + *s++ - 'a' + 10 ;
	}
	*p = s ;
	return ( n ) ;
}

/*************** escape code ********************************************/

escape()
{
	int	fg=TRUE ;

	switch ( getch()) {
		case '[':
			switch ( getch()) {
				case 'A': cur_up() ;	break ;
				case 'B': cur_down() ;	break ;
				case 'C': cur_right() ; break ;
				case 'D': cur_left() ;	break ;
			}
			break ;
		case  '-': page_down() ;	break ;
		case  '+': page_up() ;		break ;
		case  ',': page_set() ;		break ;
		case 'Q':
		case 'q': fg = FALSE ;		break ;
	}
	return ( fg ) ;
}

/*************** cursor up **********************************************/

cur_up()
{
	if ( cur_py > 0 ) {
		cur_py -- ;
		cur_adr -= 16 ;
	}
	else {
		if ( top_adr > 15 ) {
			prtstr( "\033[7;1H\033[1L" ) ;
			disp_line( top_adr-16,6 ) ;
			top_adr -= 16 ;
			cur_adr -= 16 ;
		}
	}
}

/*************** cursor down ********************************************/

cur_down()
{
	if ( cur_py < 15 ) {
		cur_py ++ ;
		cur_adr += 16 ;
	}
	else {
		if ( top_adr+256+15 < BUFFSIZE ) {
			prtstr( "\033[7;1H\033[1M" ) ;
			disp_line( top_adr+256,21 ) ;
			top_adr += 16 ;
			cur_adr += 16 ;
		}
	}
}

/*************** cursor right *******************************************/

cur_right()
{
	if ( edit_mo == 0 ) {
		if ( cur_px < 46 ) {
			cur_px	+= cur_hl + 1 ;
			chr_ct	+= cur_hl ;
			cur_adr += cur_hl ;
			cur_hl	^= 1 ;
		}
		else {
			cur_px	 = 0 ;
			chr_ct	 = 0 ;
			cur_hl	 = 0 ;
			cur_adr -= 15 ;
			cur_down() ;
		}
	}
	else {
		if ( chr_ct < 15 ) {
			cur_px += 3 ;
			chr_ct ++ ;
			cur_adr ++ ;
		}
		else {
			cur_px	 = 0 ;
			chr_ct	 = 0 ;
			cur_adr -= 15 ;
			cur_down() ;
		}
	}
}

/*************** cursor left ********************************************/

cur_left()
{
	if ( edit_mo == 0 ) {
		if ( cur_px > 0 ) {
			cur_px	-= 2 - cur_hl ;
			chr_ct	-= 1 - cur_hl ;
			cur_adr -= 1 - cur_hl ;
			cur_hl	^= 1 ;
		}
		else {
			cur_px	 = 46 ;
			chr_ct	 = 15 ;
			cur_hl	 = 1 ;
			cur_adr += 15 ;
			cur_up() ;
		}
	}
	else {
		if ( chr_ct > 0 ) {
			cur_px -= 3 ;
			chr_ct -- ;
			cur_adr -- ;
		}
		else {
			cur_px	 = 45 ;
			chr_ct	 = 15 ;
			cur_adr += 15 ;
			cur_up() ;
		}
	}
}

/*************** page up ************************************************/

page_up()
{
	int	ad,iy ;

	if ( top_adr+511 < BUFFSIZE ) {
		top_adr += 256 ;
		cur_adr += 256 ;

		for ( ad=top_adr,iy=6 ; iy<22 ; ad+=16,iy++ ) {
			disp_line( ad,iy ) ;
		}
	}
}

/*************** page down *********************************************/

page_down()
{
	int	ad,iy ;

	if ( top_adr >= 256 ) {
		top_adr -= 256 ;
		cur_adr -= 256 ;
	} else {
		top_adr = 0 ;
		cur_adr = cur_py * 16 + chr_ct ;
	}
	for ( ad=top_adr,iy=6 ; iy<22 ; ad+=16,iy++ ) {
		disp_line( ad,iy ) ;
	}
}

/*************** input display address **********************************/

page_set()
{
	char	addr[6] ;
	int	nn,ad,iy ;

	addr[0] = '\0' ;
	prtstr( "\033[24;3Haddress : $" ) ;
	if (( nn = inpstr( 5,addr )) >= 0 ) {
		if ( nn )  ad = hexnum( addr ) ;
		     else  ad = 0 ;

		if ( ad > LASTADR&(~0xff)) ad = LASTADR&(~0xff) ;

		if ( ad != top_adr ) {
			top_adr = cur_adr = ad ;
			chr_ct = cur_px = cur_py = cur_hl = 0 ;

			for ( iy=6 ; iy<22 ; ad+=16,iy++ ) {
				disp_line( ad,iy ) ;
			}
		}
	}
	prtstr( "\033[24;3H\033[0K" ) ;
}

/*************** print 256 byte *****************************************/

disp_scrn( ad )
int	ad ;
{
	int	iy ;

	prtstr( "\033[03;1H                                   Data buffer size $20000 byte ( 1M bit )    " ) ;
	prtstr( "\033[04;1H------------------------------------------------------------------------------" ) ;
	prtstr( "\033[05;1H   addr : +0 +1 +2 +3 +4 +5 +6 +7 +8 +9 +A +B +C +D +E +F : 0123456789ABCDEF  " ) ;
	prtstr( "\033[06;1H------------------------------------------------------------------------------" ) ;
	prtstr( "\033[23;1H------------------------------------------------------------------------------" ) ;

	for ( iy=6 ; iy<22 ; iy++ ) {
		disp_line( ad,iy ) ;
		ad += 16 ;
	}
}

/*************** print 16 byte ******************************************/

disp_line( ad,nn )
int	ad,nn ;
{
	char	buf[80],*p ;
	int	i,c ;

	p = buf ;
	*p++ = ( ad < 65536 ) ? '0' : '1' ;

	setnum( p, ( ad & 0x0ff00 ) >> 8 ) ;
	p += 2 ;
	setnum( p, ad & 0x000ff ) ;
	p += 2 ;

	*p++ = ' ' ;
	*p++ = ':' ;
	*p++ = ' ' ;

	for ( i=0 ; i<16 ; ad++,i++ ) {
		setnum( p,datbuf[ad] ) ;
		p += 2 ;
		*p++ = ' ' ;
		buf[58+i] = ( isprint(datbuf[ad])) ? datbuf[ad] : '.' ;
	}
	buf[56] = ':' ;
	buf[57] = ' ' ;
	buf[74] = '\0' ;
	locate( 2,nn ) ;
	prtstr( buf ) ;
}

/*************** set number *********************************************/

setnum( s,n )
char	*s ;
int	n ;
{
	register int	ch,cl ;

	ch = n / 16 ;
	cl = n % 16 ;
	*s++ = ( ch < 10 ) ? '0' + ch : 'A' + ch-10 ;
	*s++ = ( cl < 10 ) ? '0' + cl : 'A' + cl-10 ;
}

/************************************************************************/
/*		read file into edit buffer				*/
/************************************************************************/

file_read()
{
	static	char	fname[65],offs[6],addr[6],leng[6] ;
	int	nn,ad,of,ln ;

	do {
		prtstr( "\033[2J\033[1;7m\033[1;1H" ) ;
		prtspc( 80 ) ;
		prtstr( "\033[1;25HRead binary file\033[0m" ) ;

		prtstr( "\033[3;4HRead file name       : " ) ;
		if ( inpstr( 64,fname ) <= 0 ) return ;

		prtstr( "\033[4;4HRead data offset     : $" ) ;
		if (( nn = inpstr( 5,offs )) < 0 ) return ;
		if ( nn )
			of = hexnum( offs ) ;
		else  {
			of = 0 ;
			prtstr( "00000" ) ;
		}

		do {
			prtstr( "\033[5;4H\033[0KRead data length     : $" ) ;
			if (( nn = inpstr( 5,leng )) < 0 ) return ;
			if ( nn )
				ln = hexnum( leng ) ;
			else {
				ln = BUFFSIZE ;
				prtstr( "200000" ) ;
			}
		} while ( ln == 0 || ln > BUFFSIZE ) ;

		do {
			prtstr( "\033[6;4H\033[0KBuffer start address : $" ) ;
			if (( nn = inpstr( 5,addr )) < 0 ) return ;
			if ( nn )
				ad = hexnum( addr ) ;
			else  {
				ad = 0 ;
				prtstr( "000000" ) ;
			}
		} while ( ad > LASTADR ) ;

		read_data( fname,ad,of,ln ) ;

		prtstr( "\033[15;4H[Escape] : return to menu." ) ;
		prtstr( "\033[16;4H[Return] : read other file.\n" ) ;
	} while ( check() == '\n' ) ;
}

/*************** read data **********************************************/

read_data( fname,addr,offs,leng )
char	*fname ;
int	addr,offs,leng ;
{
	FILE	*fp ;
	unchar	*pt ;
	int	ad,ch,ln ;

	if (( fp = fopen( fname,"r" )) == NULL ) {
		prtstr( "\033[9;4HError: file not found." ) ;
	}
	else {
		prtstr( "\033[9;4HReading data into buffer. " ) ;

		if ( offs ) fseek( fp,(long)offs,0 ) ;

		pt = datbuf + addr ;
		for ( ad=addr ; ad<BUFFSIZE ; ad++ ) {
			if ( leng-- <= 0 ) break ;
			if (( ch = fgetc( fp )) == EOF ) break ;
			*pt++ = (unchar)ch ;
		}
		fclose( fp ) ;
		printf( "\033[11;4HRead buffer $%05X - $%05X ( length $%05X )\n",addr,ad-1,ad-addr ) ;
	}
}

/************************************************************************/
/*		write file into edit buffer				*/
/************************************************************************/

file_write()
{
	static	char	fname[65],addr1[6],addr2[6] ;
	int	nn,ad1,ad2 ;

	do {
		prtstr( "\033[2J\033[1;7m\033[1;1H" ) ;
		prtspc( 80 ) ;
		prtstr( "\033[1;25HWrite binary file\033[0m" ) ;

		prtstr( "\033[3;4HWrite file name     : " ) ;
		if ( inpstr( 64,fname ) <= 0 ) return ;

		do {
			prtstr( "\033[4;4H\033[0KBuffer start address : $" ) ;
			if (( nn = inpstr( 5,addr1 )) < 0 ) return ;
			if ( nn )
				ad1 = hexnum( addr1 ) ;
			else {
				ad1 = 0 ;
				prtstr( "000000" ) ;
			}
		} while ( ad1 > LASTADR ) ;

		do {
			prtstr( "\033[5;4H\033[0KBuffer end address   : $" ) ;
			if (( nn = inpstr( 5,addr2 )) < 0 ) return ;
			if ( nn )
				ad2 = hexnum( addr2 ) ;
			else {
				ad2 = LASTADR ;
				prtstr( "1FFFFF" ) ;
			}
		} while (  ad2 < ad1 || LASTADR < ad2 ) ;

		write_data( fname,ad1,ad2 ) ;

		prtstr( "\033[14;4H[Escape] : return to menu." ) ;
		prtstr( "\033[15;4H[Return] : read other file.\n" ) ;
	} while ( check() == '\n' ) ;
}

/*************** write data *********************************************/

write_data( fname,addr1,addr2 )
char	*fname ;
int	addr1,addr2 ;
{
	FILE	*fp ;
	unchar	*pt ;
	int	ad,ch,ln ;

	if (( fp = fopen( fname,"w" )) == NULL ) {
		prtstr( "\033[8;4HError: file cannot create." ) ;
	}
	else {
		prtstr( "\033[8;4HWriting data into buffer. " ) ;

		pt = datbuf + addr1 ;
		for ( ad=addr1 ; ad<=addr2 ; ad++ ) {
			fputc( (int)*pt++,fp ) ;
		}
		fclose( fp ) ;
		printf( "\033[10;4HWrite buffer $%05X - $%05X ( length $%05X )\n",addr1,addr2,addr2-addr1+1 ) ;
	}
}

/************************************************************************/
/*		clear data buffer					*/
/************************************************************************/

buff_fill()
{
	static	char	addr1[6],addr2[6],data[3] ;
	int	nn,ad1,ad2,dt ;

	prtstr( "\033[2J\033[1;7m\033[1;1H" ) ;
	prtspc( 80 ) ;
	prtstr( "\033[1;25HClear data buffer\033[0m" ) ;

	do {
		prtstr( "\033[4;4H\033[0KClear start address : $" ) ;
		if (( nn = inpstr( 5,addr1 )) < 0 ) return ;
		if ( nn )
			ad1 = hexnum( addr1 ) ;
		else {
			ad1 = 0 ;
			prtstr( "000000" ) ;
		}
	} while ( ad1 > LASTADR ) ;

	do {
		prtstr( "\033[5;4H\033[0KClear end address   : $" ) ;
		if (( nn = inpstr( 5,addr2 )) < 0 ) return ;
		if ( nn )
			ad2 = hexnum( addr2 ) ;
		else {
			ad2 = LASTADR ;
			prtstr( "1FFFFF" ) ;
		}
	} while (  ad2 < ad1 || LASTADR < ad2 ) ;

	prtstr( "\033[6;4HClear code          : $" ) ;
	if (( nn = inpstr( 2,data )) < 0 ) return ;
	if ( nn )
		dt = hexnum( data ) ;
	else {
		dt = 0 ;
		prtstr( "00" ) ;
	}

	while ( ad1 <= ad2 ) {
		datbuf[ad1++] = dt ;
	}
}

/*************** get hex number *****************************************/

hexnum( s )
char	*s ;
{
	int	n = 0 ;

	while ( isxdigit( *s )) {
		if	( *s <= '9' )  n = n * 16 + *s++ - '0' ;
		else if ( *s <= 'F' )  n = n * 16 + *s++ - 'A' + 10 ;
		else		       n = n * 16 + *s++ - 'a' + 10 ;
	}
	return ( n ) ;
}

/*************** check RETURN and ESC ***********************************/

check()
{
	int	cc ;

	do {
		cc = getch() ;
	} while ( cc != '\n' && cc != '\033' ) ;
	return ( cc ) ;
}

/*************** print string no buffering ******************************/

prtstr( s )
char	*s ;
{
	int	n ;

	if ( n = strlen( s )) {
		write( 1,s,n ) ;
	}
}

/*************** print space ********************************************/

prtspc( nn )
int	nn ;
{
	char	cc = ' ' ;

	while ( nn-- > 0 ) {
		prtchr( &cc ) ;
	}
}

/*************** input string buffering *********************************/

inpstr( max,str )
int	max ;
char	*str ;
{
	static	char	bs[4] = { 0x08,0x20,0x08,0x00 } ;
	char	cc,*pt ;
	int	ct ;

	prtstr( str ) ;
	ct = strlen( str ) ;
	pt = str + ct ;
	cc = (char)getch() ;

	while ( cc != '\n' && cc != '\033' ) {
		if ( cc == 0x08 && ct > 0 ) {
			-- ct ;
			*--pt = '\0' ;
			prtstr( bs ) ;
		}
		else if ( isprint(cc) && ct < max ) {
			++ ct ;
			*pt++ = cc ;
			prtchr( &cc ) ;
		}
		cc = (char)getch() ;
	}
	*pt = '\0' ;
	return ( ( cc == '\033' ) ? -1 : ct ) ;
}

/*************** cursor location ****************************************/

locate( x,y )
int	x,y ;
{
	static	char	buf[9] = { '\033','[','0','0',';','0','0','H','\0' } ;

	buf[2] = '0' + (y+1)/10 ;
	buf[3] = '0' + (y+1)%10 ;
	buf[5] = '0' + (x+1)/10 ;
	buf[6] = '0' + (x+1)%10 ;
	write( 1,buf,9 ) ;
}

/*************** get chracter from console ******************************/

getch()
{
	char	cc ;

	if ( read( 0,&cc,1 ) == ERROR ) cc = 0 ;
	return ( cc ) ;
}

/*************** set tty ************************************************/

set_tty( mo )
int	mo ;
{
	static	struct	sgttyb	ttyctrl ;
	static	short	backstat = 0 ;

	if ( mo == 1 ) {
		ioctl( 0,TIOCGETP,&ttyctrl ) ;
		backstat	 = ttyctrl.sg_flags ;
		ttyctrl.sg_flags = ( ttyctrl.sg_flags & ~ECHO ) | CBREAK ;
		ioctl( 0,TIOCSETP,&ttyctrl ) ;
		puts( "\033[7;22r" ) ;
	}
	else if ( mo == 2 ) {
		ioctl( 0,TIOCGETP,&ttyctrl ) ;
		ttyctrl.sg_flags = backstat ;
		ioctl( 0,TIOCSETP,&ttyctrl ) ;
		puts( "\033[r" ) ;
	}
}
