/*****************************************************************
   Convert-Program  					 [3D_ID.C]
	ID_DATA(*.std) -> ID_data 3D_Car-Race (For Argonaut-ASM)
		 				    (UNIX:Ver 1.0)
     Programed By SHIGEKI YAMASHIRO [NCL/EAD]	     [Apl,27,1992]
 ****************************************************************/
#include	<stdio.h>
#include	"id.h"

main(argc,argv)
int argc ;
char *argv[];
{
	FILE *fp,*fopen();
	char read_name[64];	/* In :color_data */
	char *write_name="id_table.asm";/* Out:color_data */
	ID data[8] ;
	unsigned char work[0x40] ;
	int count,files,id ;
	int flag,i,j,k ;

	if(argc == 1)	usage(1);
	for(files=0;files<(argc -1);files++){	/* max 4_files(ID=8) */
		*argv ++;
		/* In:*.STD*/
		strcpy(read_name,*argv);
		strcut(read_name,'.');
		strcat(read_name,".STD");
/* t@C`FbN (File-Read) */
		 if ((fp=fopen(read_name,"r"))==NULL){
			printf(" File : %s\n",read_name) ;
			perror(read_name);
			exit(1);
		}
		printf("READ:%s\n",read_name);
/* Data read */
		for(count=0;count<=0x3f;count++){
			fread(work,0x40,sizeof(char),fp) ;
			data_set_0(&data[files*2],&work,count) ;
			data_set_1(&data[files*2+1],&work,count) ;
		}
		fclose(fp);
	}

/* t@C`FbN (File_Write) */
	 if ((fp=fopen(write_name,"w"))==NULL){
		printf(" File : %s\n",write_name) ;
		perror(write_name);
		exit(1);
	}
	printf("Write:%s\n",write_name);
	id = (argc-1)*2 ;
	/* ID label */
	fprintf(fp,";--------------- ID DATA_TABLE ---------------\n");
	for(i=0;i<id;i++){
		if((data[i].code[0])==3)	continue ;
		fprintf(fp,"ID_%02X\n",i) ;
		flag = 0 ;
		for(j=0;j<=255;j++){ /* data counter */
			if(flag == 1)	break ;
			switch(data[i].code[j]){
				case 0 :/* Light Source */
					fprintf(fp,"	COLLITE		$%02x",data[i].number[j]);
					break ;
				case 1 :/* Depth */
					fprintf(fp,"	COLDEPTH	$%02X",data[i].number[j]);
					break ;
				case 2 :/* Color Animetion */
					fprintf(fp,"	COLANIM 	CA_%02X",data[i].number[j]);
					break ;
				case 3 :/* END */
					flag = 1 ;
					break ;
				case 4 :/* NONE */
					fprintf(fp,"	COLNONE 	$%02X",data[i].number[j]);
					break ;
			}
			if(flag == 0)	fprintf(fp,"		; %02d \n",j) ;
		}
	}
	fclose(fp);

}
/**********************************/
/*	data set to id_data	  */
/**********************************/
data_set_0(data,work,count)
ID *data ;
unsigned char *work ;
int count ;
{
	/* code (0) */
	data->code[count]       = code(work[0x04]) ;
	data->number[count]     = num(work[0x05],work[0x06]) ;
	data->code[count+64]    = code(work[0x0C]) ;
	data->number[count+64]  = num(work[0x0D],work[0x0E]) ;
	data->code[count+128]   = code(work[0x14]) ;
	data->number[count+128] = num(work[0x15],work[0x16]) ;
	data->code[count+192]   = code(work[0x1C]) ;
	data->number[count+192] = num(work[0x1D],work[0x1E]) ;
}
data_set_1(data,work,count)
ID *data ;
unsigned char *work ;
int count ;
{
	/* code (1) */
	data->code[count]       = code(work[0x24]) ;
	data->number[count]     = num(work[0x25],work[0x26]) ;
	data->code[count+64]    = code(work[0x2C]) ;
	data->number[count+64]  = num(work[0x2D],work[0x2E]) ;
	data->code[count+128]   = code(work[0x34]) ;
	data->number[count+128] = num(work[0x35],work[0x36]) ;
	data->code[count+192]   = code(work[0x3C]) ;
	data->number[count+192] = num(work[0x3D],work[0x3E]) ;
}
/* Code Change */
code(n)
int n ;
{
	switch(n){
		case 0x11: /* L */
			return(0) ;
		case 0x12: /* D */
			return(1) ;
		case 0x13: /* C */
			return(2) ;
		case 0x15: /* E */
		case 0x16: /* N */
		case 0x17: /* D */
			return(3) ;
		default: /* M */
			return(4) ;
	}
}
/* Number Change */
num(H,L)
int H ;
int L ;
{
	if((H<0)||(H>=0x10))	return(0);
	if((L<0)||(L>=0x10))	return(0);
	return(H*0x10+L) ;
}
/***********************************
* @̌납̂P *
* @ AȌJbgB*
***********************************/
strcut(str,chr)
char *str ;	/* string */
int chr ;	/* char */
{
	int i ;

	for (i = strlen(str) ; i >= 0 ;i --){
		if ( str[i] == chr ){
			str[i] = 0 ;
			return (0) ;
		}
	}
	return (1) ;
}

/************************************************
	usage  \
************************************************/
usage(n)
int n ;
{
	printf("\n\n Usage :\n");
	printf("       3D_ID File(.STD) \n");
	printf("          [NEWS CAD DATA]\n");
	printf("               (*.STD) -> *.ASM (For Argonaut)\n");
	printf("                        	 [UNIX-Ver. 1.00]\n");
	printf("  Programed by Shigeki Yamashiro [Nintendo NCL/EAD]\n");
	exit(n) ;
}
