/*********************************************************************
   NEWS_CAD(*.STD) -> 3D_Car-Race (For Arugonaut-ASM) Combert Program
				[DEPTH_DATA]		(UNIX:Ver 1.0)
   Programed By SHIGEKI YAMASHIRO [NCL/EAD]	    	[Apr,27,1993]
**********************************************************************/
#include	<stdio.h>

main(argc,argv)
int argc ;
char *argv[];
{
	FILE *fp, *fopen();
	char read_file[64] ;	/* In :color_data */
	char write_file[64] ;	/* Out:color_data */
	unsigned char data[4][0x100] ;	/* depth color data */
	unsigned char chr ;
	char work[0x40] ;
	int cc,flag;
	int group,V_cnt ;

/*** IvV@́@`FbN ***/
	if( argc != 2)		usage(1);
/*** t@C l[@ 쐬 ***/
	*argv ++;
	/* In:color_data (STD-File)*/
	strcpy(read_file,*argv);
	strcut(read_file,'.');
	strcat(read_file,".STD");
	/* Out:color_data (text)*/
	strcpy(write_file,*argv);
	strcut(write_file,'.');
	strcat(write_file,".asm");
/*** t@C G[ `FbN (READ) ***/
	 if (( fp = fopen(read_file,"rb")) == NULL ){
		printf(" File : %s\n",read_file ) ;
		perror(argv[1]) ;
		exit(1) ;
	}
	printf("read:%s\n",read_file) ;
/* File Read & Change */
	for(V_cnt=0;V_cnt<=0x1f;V_cnt++){
		fread(work,0x40,sizeof(char),fp) ;
		data_set(&data,work,V_cnt) ;
	}
	fclose(fp);
/*** t@C G[ `FbN (WRITE) ***/
	 if (( fp = fopen(write_file, "w")) == NULL ) {
		printf(" File : %s\n",write_file ) ;
		perror(argv[1]);
		exit(1);
	}
	printf("  -> %s\n",write_file);
/* file Label Write */
	fprintf(fp,";---------------------------    Depth Color Data    ---------------------------\n");
	for(group=0;group<=3;group++){
		fprintf(fp,"Depth_%d\n",group);
		flag = 1 ;
		V_cnt= 0 ;
		while(flag){
			for(cc=0;cc<=7;cc++){
				if((chr=data[group][V_cnt+cc])!=0){
					if(cc==0)	fprintf(fp,"	dbh	") ;
					fprintf(fp,"%02x",chr) ;
					if(cc!=7)	fprintf(fp,",") ;
					else		fprintf(fp,"\n") ;
				}
				else {
					flag = 0 ;
					break ;
				}
			}
			V_cnt += cc ;
		}
	}
	fclose(fp);
}
/**********************************/
/*	DATA SET TO DEPTH         */
/**********************************/
data_set(data,work,V_pos)
unsigned char  data[4][0x100] ;
char *work ;
int V_pos ;
{
	int count;

	for(count=0;count<=3;count++){
		data[count][V_pos+0x00]=work[0x02+count] ;
		data[count][V_pos+0x20]=work[0x0A+count] ;
		data[count][V_pos+0x40]=work[0x12+count] ;
		data[count][V_pos+0x60]=work[0x1A+count] ;
		data[count][V_pos+0x80]=work[0x22+count] ;
		data[count][V_pos+0xA0]=work[0x2A+count] ;
		data[count][V_pos+0xC0]=work[0x32+count] ;
		data[count][V_pos+0xE0]=work[0x3A+count] ;
	}
}
/***********************************
* @̌납̂P *
* @ AȌJbgB*
***********************************/
strcut(str,chr)
char *str ;	/* string */
int chr ;	/* char */
{
	int i ;

	for (i=strlen(str);i>=0;i--){
		if ( str[i] == chr ){
			str[i] = 0 ;
			return (0) ;
		}
	}
	return (1) ;
}
/************************************************
	usage  \
************************************************/
usage(code)
int	code ;
{
	printf("\n\n Usage :\n");
	printf("       NEWS_CAD File(.STD) \n");
	printf("          [NEWS CAD_DATA]\n");
	printf("               (.STD) -> .ASM (For Arugonaut)\n");
	printf("              1993.4.27 [UNIX-Ver.1.00]\n");
	exit(code) ;
}
