/*****************************************************************
   ID-Data Auto Write Program (map 20 & 21 )    [ID.C]   (Ver 1.0)
      -- Main Routine --	      [Jul,1,1992 -- Jul,10,1992]
    Programed By SHIGEKI YAMASHIRO  ( Nintendo Co.,Ltd./ EAD )
*****************************************************************/

#include	<stdio.h>
#include	<ctype.h>

main(argc,argv)
int argc;
char *argv[];
{
	unsigned int sum ;
	char data_buf[32],fna[32] ;

	/* option check */
	if (argc != 3 ){
		man (0) ;
		exit(1) ;
	}
	argv ++ ;
	if(**argv == '-'){
		(*argv)++ ;
		switch(**argv){
			case 'w':/* write mode */
				printf("Write_mode \n") ;
				argv ++ ;
				strcpy(fna,*argv);
				file_read(fna,data_buf) ;
				sum = write_id (data_buf,*argv) ;
				sum = sum&0x0000ffff ;
				printf("sum = %04X \n",sum) ;
				break ;
			case 'l':/* look_data mode */
				printf("look-data_mode \n") ;
				argv ++ ;
				strcpy(fna,*argv);
				file_read(fna,data_buf) ;
				print_id (data_buf) ;
				break ;
			case 'm':/* make_data mode */
				printf("make-data_mode \n") ;
				break ;
			case 's':/* print sum mode */
				printf("print sum_mode \n") ;
				argv ++ ;
				sum = SUM(*argv) ;
				sum = sum&0x0000ffff ;
				printf("sum = %02X \n",sum) ;
				break ;
			default :/* option_error */
				printf("option_error \n") ;
				break ;
		}
	}
}

/************************************************
 Print MANUAL On Console
************************************************/
man(code)
int code ;
{
	switch(code){
		case 0:
			printf(" Usage : id (-w,-l,-m,-s) File_Name \n");
			printf("	options \n");
			printf("		-w : Id_Data Write On File\n");
			printf("	 	-l : Id_Data Look (*.id) \n");
/*
			printf("	 	-m : Id_Data_file Make (*.id)\n");
*/
			printf("	 	-s : print Sum_Check \n");
		default :
			printf("					id.c [Ver-1.00] 1992.7 \n");
			printf("	Programed By Shigeki Yamashiro    (Nintendo [NCL]/EAD)\n");
			break ;
	}
	exit(1);
}

/************************************************
 Data_File_Read (*.id)
************************************************/
file_read(fna,data)
char fna[32]  ;		/* Data_File_name :(*.id) */
char data[32] ;		/* Read Buff */
{
	FILE *fp,*fopen();
	char chr[2] ;
	int count,flag=0 ;

	/* file_name make */
	strcut(fna,'.'); 
	strcat(fna,".id"); 
	/*** File Read Routine ***/
	/* Open (FILE READ) */
	printf("file (read) :%s\n",fna);
	 if (( fp = fopen(fna,"r")) == NULL )	return(f_error(1)) ;
	/* Title Read & Check */
	for(count=0;count<=20;count++){
		if(flag==0){
			chr[0] = fgetc(fp) ;
/*
			if(isprint(chr[0]) == 0) return(f_error(2)) ;
			if(iskana(chr[0]) == 0) return(f_error(2)) ;
*/
			if(chr[0]==','){
				flag = 1 ;
				data[count] = ' ';
				continue ;
			}
			data[count] = chr[0] ;
		}
		else	data[count] = ' ';
	}
	/* Id_Data Read & Check */
	for(count=21;count<=27;count++){
		chr[0] = fgetc(fp) ;
		chr[1] = fgetc(fp) ;
		chr[2] = fgetc(fp) ;
		if((chr[2]==',')||(chr[2]==0x0A))	chr[2] = 0 ;
		else	return(f_error(3)) ;
		data[count] = HEX(chr[0])*0x10+HEX(chr[1]) ;
	}
	/* ␔check & Sum_check */	
	data[28] = 0xff ;
	data[29] = 0xff ;
	data[30] = 0 ;
	data[31] = 0 ;
	fclose(fp) ;
}

/************************************************
@Print for Id_File Data 
************************************************/
print_id (data_buf)
unsigned char data_buf[32] ;
{
	int counter,cc ;
	char chr[3] ;
	/* print title */
	printf("TiTle :") ;
	for(counter=0;counter<=20;counter++){
		printf("%c",data_buf[counter]) ;
	}
	/* map_mode */
	printf("\n data :") ;
	for(counter=21;counter<=31;counter++){
		printf("%02x,",data_buf[counter]) ;
	}
	printf("\n") ;
}

/************************************************
@Write ID_data to Rom_data
************************************************/
write_id (data_buf,fna)
unsigned char data_buf[32] ;
unsigned char fna  [32] ;
{
	FILE *fp,*fopen();
	int counter,cc ;
	char chr[3] ;
	long id_start ;
	unsigned int sum,rev ;
	unsigned char buf[4] ;

	/* file-open Rom_data_file */
	 if (( fp = fopen(fna,"a")) == NULL )	return(f_error(4)) ;
	printf("file (write):%s\n",fna);
	/* Map_mode select */
	switch(data_buf[21]){
		case 0x20 :
		case 0x21 :
			id_start = 0x7FC0 ;
			break ;
		case 0x30 :
		case 0x31 :
			id_start = 0xFFC0 ;
			break ;
		default :
			printf("map_mode_error :%x",data_buf[21]);
			exit(1) ;
			break ;
	}
	/* ID_write */
	fseek(fp,id_start,0) ;
	fwrite(data_buf,sizeof(char),0x20,fp) ;
	fclose(fp) ;
	/* sum_check */
	sum = SUM(fna) ;
	rev = 0xffff - sum ;
	/* Sum_write */
	if (( fp = fopen(fna,"a")) == NULL )	return(f_error(4)) ;
	buf[0] = rev&0x00ff ;
	buf[1] = rev>>8 ;
	buf[2] = sum&0x00ff ;
	buf[3] = sum>>8 ;
	id_start = id_start + 0x1C ;
	fseek(fp,id_start,0) ;
	fwrite(buf,sizeof(char),4,fp) ;
	fclose(fp) ;
	return(sum) ;
}

/***********************************
* @@@`FbNT@vZ@ @    *
***********************************/
SUM(fna)
char *fna ;
{
	FILE *fp, *fopn() ;
	register int cc ,sum = 0;

	if (( fp = fopen(&fna[0], "rb")) == NULL ) return(f_error(1));
	printf("file (sum)  :%s\n",fna);
	while (( cc = fgetc(fp)) != EOF ) {
		sum += cc ;
	}
	return(sum);
}

/************************************************
@File_Open ERROR Process 
************************************************/
f_error(code)
int code ;	/*error code */
{
	switch(code){
		case 1:
			printf("No Data_File [01] \n") ;
			break ;
		case 2:
			printf("ILLEGAL CHR FOUND [02]\n") ;
			break ;
		case 3:
			printf("ILLEGAL CHR FOUND [03]\n") ;
			break ;
		default :
			break ;
	}
	exit(1) ;
}

/************************************************
* `rbhh  gdwϊ  (1 BYTE_Size) *
************************************************/
/* 1 byte */
HEX(i)
int i ;
{
	if ((isxdigit(i)) != 0){
		/* a,b,c,d,e,f */
		if ((i>='a') && (i<='f'))	return (i-0x57);
		/* A,B,C,D,E,F */
		if ((i>='A') && (i<='F'))	return (i-0x37);
		/* 0,1,2,3,4,5,6,7,8,9 */
 		if ((i>='0') && (i<='9'))	return (i-0x30);
	}
	else {	/* hex number error !! */
		return (0xff) ;
	}
}

/***********************************
* @̌납̂P *
* @ AȌJbgB*
***********************************/
strcut(str,chr)
char *str ;	/* string */
int chr ;	/* char */
{
	int i ;

	for (i = strlen(str) ; i >= 0 ;i --){
		if ( str[i] == chr ){
			str[i] = 0 ;
			return (0) ;
		}
	}
	return (1) ;
}

