/************************************************************************
		Kanji code clear program  version 1.00
		      Programmed by Y.Nishida
						[ Jun.06, 1991 ]
 ************************************************************************/

#include	<stdio.h>
#include	<string.h>

#define		COMPLETE	0
#define		ERROR		1


/************************************************************************/
/*		Main function.						*/
/************************************************************************/

int main( argc,argv )
int	argc ;
char	**argv ;
{
	char	destination[65] ;

	printf( "Kanji code clear program  version 1.00\n" ) ;
	if ( argc != 2 ) {
		printf( "Usage: jisclr <source file name>\n" ) ;
		exit( ERROR ) ;
	}
	if ( Destination_name( *++argv,destination ) == ERROR ) exit( ERROR ) ;
	if ( Convert_source( *argv,destination ) == ERROR ) exit( ERROR ) ;
	return ( COMPLETE ) ;
}

/************************************************************************/
/*		Convert source file.					*/
/************************************************************************/

int Convert_source( source_name,destination_name )
char *source_name,*destination_name ;
{
	FILE	*rfp,*wfp ;
	register int	code ;

	if (( rfp = fopen( source_name,"r" )) == NULL ) {
		perror( source_name ) ;
		return ( ERROR ) ;
	}
	if (( wfp = fopen( destination_name,"w" )) == NULL ) {
		perror( destination_name ) ;
		return ( ERROR ) ;
	}
	while (( code = fgetc( rfp )) != EOF ) {
		if ( code >= 0x7f )
			fputc( ' ',wfp ) ;
		else
			fputc( code,wfp ) ;
	}
	fclose( rfp ) ;
	fclose( wfp ) ;
	return ( COMPLETE ) ;
}

/************************************************************************/
/*	Create destination file name from source file name.		*/
/************************************************************************/

int Destination_name( source_name,destination_name )
char	*source_name,*destination_name ;
{
	int	length ;

	length = strlen( source_name ) ;
	if ( strcmp( source_name+length-4,".s65" )) {
		printf( "%s: Bad file name.\n", source_name ) ;
		return ( ERROR ) ;
	}
	strcpy( destination_name,source_name ) ;
	strcpy( destination_name+length-4,".asm" ) ;
	return ( COMPLETE ) ;
}
