/************************************************************************
		1M ROM data generate program  version 1.00
		    Programmed by Y.Nishida
						[ Aug.03, 1989 ]
 ************************************************************************/

#include	<stdio.h>
#include	<memory.h>
#include	<strings.h>
#include	<ctype.h>

#define		unchar		unsigned char
#define		unshort		unsigned short
#define		TRUE		1
#define		FALSE		0
#define		ERROR		-1
#define		COMPLETE	0
#define		MAXBUF		0x20000

unchar	rombuf[MAXBUF] ;		/*  ROM data buffer	*/


main( argc,argv )
int	argc ;
char	**argv ;
{
	FILE	*tp,*wp ;
	char	comlin[81] ;
	char	tbl_name[65],sce_name[65],dst_name[65] ;
	int	ofs,len,adr,cnt=1 ;

	puts( "\n1M ROM data generate program  version 1.00" ) ;
	if ( argc != 2 ) {
		puts( "usage: mkrom1 <ROM name>\n" ) ;
		exit( 1 ) ;
	}
	strcpy( tbl_name,*(++argv)) ;
	strcat( tbl_name,".ROM" ) ;
	if (( tp = fopen( tbl_name,"r" )) == NULL ) {
		perror( tbl_name ) ;
		exit( 1 ) ;
	}
	strcpy( dst_name,*argv ) ;
	strcat( dst_name,".DAT" ) ;
	if (( wp = fopen( dst_name,"w" )) == NULL ) {
		perror( dst_name ) ;
		exit( 1 ) ;
	}
	clrbuf() ;
	while ( fgets( comlin,79,tp ) != NULL ) {
		if ( comlin[0] != '#' && comlin[0] != '\n' ) {
			if ( set_param( comlin,sce_name,&ofs,&len,&adr ) == COMPLETE ) {
				printf( "%2d: read file \"%s\"    \t",cnt++,sce_name ) ;
				read_data( sce_name,ofs,len,adr ) ;
			} else {
				printf( "%2d: Parameter is bad. :%s",cnt++,comlin ) ;
			}
		}
	}
	fwrite( rombuf,sizeof(unchar),MAXBUF,wp ) ;
	fclose( tp ) ;
	fclose( wp ) ;
	exit( 0 ) ;
}

/************************************************************************/
/*		clear ROM buffer					*/
/************************************************************************/

clrbuf()
{
	unchar	*pt ;
	int	ct ;

	for ( pt=rombuf,ct=0 ; ct<MAXBUF ; ct++ ) {
		*pt++ = 0xff ;
	}
}

/************************************************************************/
/*		set parameter						*/
/************************************************************************/

set_param( data,name,ofs,len,adr )
char	*data,*name ;
int	*ofs,*len,*adr ;
{
	if ( !getstr( &data,name ))	return ( ERROR ) ;
	if ( !skpspc( &data      ))	return ( ERROR ) ;
	if ( !gethex( &data,ofs  ))	return ( ERROR ) ;
	if ( !skpspc( &data      ))	return ( ERROR ) ;
	if ( !gethex( &data,len  ))	return ( ERROR ) ;
	if ( !skpspc( &data      ))	return ( ERROR ) ;
	if ( !gethex( &data,adr  ))	return ( ERROR ) ;
	return ( COMPLETE ) ;
}

/*************** get string ********************************************/

getstr( dt,st )
char	**dt,*st ;
{
	char	*pt ;
	int	ct = 0 ;

	pt = *dt ;
	while ( *pt ) {
		if ( isspace( *pt )) break ;
		*st++ = *pt++ ;
		ct++ ;
	}
	*st = '\0' ;
	*dt = pt ;
	return ( ct ) ;
}

/*************** get hex number ****************************************/

gethex( dt,nm )
char	**dt ;
int	*nm ;
{
	char	*pt ;
	int	ct=0, nn=0 ;

	pt = *dt ;
	while ( isxdigit( *pt )) {
		if      ( *pt <= '9' )  nn = nn * 16 + *pt++ - '0' ;
		else if ( *pt <= 'F' )  nn = nn * 16 + *pt++ - 'A' + 10 ;
		else 			nn = nn * 16 + *pt++ - 'a' + 10 ;
		ct++ ;
	}
	*dt = pt ;
	*nm = nn ;
	return ( ct ) ;
}

/************** skip until hex number ***********************************/

skpspc( dt )
char	**dt ;
{
	char	*pt ;

	pt = *dt ;
	while ( *pt ) {
		if ( isxdigit( *pt )) break ;
		pt++ ;
	}
	*dt = pt ;
	return ( *pt ) ;
}

/************************************************************************/
/*		read data into ROM buffer				*/
/************************************************************************/

read_data( fname,ofs,len,adr )
char	*fname ;
int	ofs,len,adr ;
{
	FILE	*fp ;
	unchar	*pt ;
	int	ad,ch,ln ;

	if ( adr >= MAXBUF ) {
		printf( ": address is over the range.  ( $%05X )\n", adr ) ;
		return ;
	}
	if (( fp = fopen( fname,"r" )) == NULL ) {
		puts( ": no such file." ) ;
		return ;
	}

	if ( ofs ) fseek( fp,(long)ofs,0 ) ;

	pt = rombuf + adr ;
	for ( ad=adr ; ad<MAXBUF ; ad++ ) {
		if ( len-- <= 0 ) break ;
		if (( ch = fgetc( fp )) == EOF ) break ;
		*pt++ = (unchar)ch ;
	}
	fclose( fp ) ;
	printf( ": $%05X - $%05X ( length $%05X )\n",adr,ad-1,ad-adr ) ;
}
