/************************************************************************/
/*	Binary file partition program					*/
/*		    Programmed by Y.Nishida				*/
/*						[ Apr.02, 1991 ]	*/
/************************************************************************/

#include	<stdio.h>

#define		TRUE		1
#define		FALSE		0


int main( argc,argv )
int	argc ;
char	**argv ;
{
	FILE	*rfp ;
	int	size = 1024 ;

	printf( "Partition binary file\n" ) ;
	if ( argc != 2 && argc != 3 ) {
		printf( "Usage: partition [-lnn] <file name>\n" ) ;
		printf( "   -l: size of partition file ( Kbyte )\n" ) ;
		exit( 1 ) ;
	}
	if ( argc == 3 ) {
		if (( size = atoi( (*++argv)+2 )) == 0 ) {
			printf( "%s: Illegal file size.\nabort.\n",*argv+2 ) ;
			exit( 1 ) ;
		}
	}
	if (( rfp = fopen( *++argv,"r" )) == NULL ) {
		perror( *argv ) ;
		exit( 1 ) ;
	}
	if ( partition( *argv,size,rfp )) {
		printf( "aborted.\n" ) ;
		exit( 1 ) ;
	}
	fclose( rfp ) ;
	printf( "Completed.\n" ) ;
	return ( 0 ) ;
}

/************************************************************************/
/*		Convert source data					*/
/************************************************************************/

int partition( str,size,rfp )
char	*str ;
int	size ;
FILE	*rfp ;
{
	void	make_fname() ;
	FILE	*wfp ;
	char	fname[256],datbuf[1024] ;
	int	flg=FALSE,cnt=0,len,nn ;

	do {
		if (( nn = fread( datbuf,sizeof(char),1024,rfp )) != 0 ) {
			if ( !flg ) {
				make_fname( fname,str ) ;
				if (( wfp = fopen( fname,"w" )) == NULL ) {
					perror( fname ) ;
					return( TRUE ) ;
				}
				len = 0 ;
				flg = TRUE ;
			}
			fwrite( datbuf,sizeof(char),nn,wfp ) ;
			len += nn ;

			if ( ++cnt == size ) {
				cnt = 0 ;
				flg = FALSE ;
				fclose( wfp ) ;
				printf( "File \"%s\" : %10d byte(s) write.\n",fname,len ) ;
			}
		}
	} while ( nn == 1024 ) ;

	if ( flg ) {
		fclose( wfp ) ;
		printf( "File \"%s\" : %10d byte(s) write.\n",fname,len ) ;
	}
	return( FALSE ) ;
}

/************************************************************************/
/*		Make file name						*/
/************************************************************************/

void make_fname( fname,str )
char	*fname,*str ;
{
	static int	number = 0 ;
	char	numstr[16] ;

	sprintf( numstr,"%d",number++ ) ;
	strcpy( fname,str ) ;
	strcat( fname,"_" ) ;
	strcat( fname,numstr ) ;
}
