/************************************************************************
		PC-PR201 printer driver
					[ Oct.17, 1990 ]
 ************************************************************************/

#include	<stdio.h>
#include	<ctype.h>
#include	<signal.h>

#define		TABSIZ		8
#define		ESC		0x1b
#define		KANA		0
#define		KANJI		1

int	width = 136 ;		/*  paper width		*/
int	length = 66 ;		/*  paper length	*/


main( argc,argv )
int	argc;
char	**argv;
{

	while ( --argc && **++argv == '-' ) {
		switch ( *++*argv ) {
			case 'w': width  = atoi(++*argv); break ;
			case 'l': length = atoi(++*argv); break ;
		}
	}
	printf( "\033c1\033H\034B" ) ;		/*  printer mode set		*/
	filetoprn( stdin ) ;			/*  transfer file to printer	*/
	exit ( 0 ) ;
}

/********************************************************************************/
/*		Transfer file to printer					*/
/********************************************************************************/

filetoprn( fp )
FILE	*fp;
{
	int	kanji_flag,colum,line ;
	register int	cc,n ;

	colum      = 0 ;
	line       = 0 ;
	kanji_flag = KANA ;

	while (( cc = getc( fp )) != EOF ) {
		if ( cc == '\031' ) {
			if ((cc = getc( fp )) == '\1' ) {
				fflush( stdout ) ;
				kill( 0,SIGSTOP ) ;
				continue ;
			} else {
				ungetc( cc,fp ) ;
				cc = '\031';
			}
		}
		if ( iskanji( cc )) {
			if ( colum > width - 2 ) carrige_return( &colum,&line ) ;
			kanji_flag = kanji_put( kanji_flag,cc,getc( fp )) ;
			colum += 2 ;
			continue ;
		}
		if ( isprint( cc ) || iskana( cc )) {
			kanji_flag = alpha_put( kanji_flag,cc ) ;
			if ( ++colum >= width ) {
				colum = 0;
				if ( ++line >= length ) {
					line = 0 ;
					putchar( '\f' ) ;
				}
				continue;
			}
		}
		if ( cc == '\t' ) {
			n = (( colum / TABSIZ ) + 1 ) * TABSIZ - colum ;
			if (( colum += n ) >= width ) {
				carrige_return( &colum,&line ) ;
				continue ;
			}
			while ( n-- ) kanji_flag = alpha_put ( kanji_flag,' ' ) ;
			continue ;
		}
		if ( cc == '\f' ) {
			colum = 0 ;
			line  = 0 ;
			putchar( '\r' ) ;
			putchar( '\f' ) ;
			continue ;
		}
		if ( cc == '\n' ) {
			carrige_return( &colum,&line ) ;
			continue ;
		}
	}
	kanji_out() ;
}

/***************  Carrige return  ***************************************/

carrige_return( colum,line )
int	*colum,*line ;
{
	*colum = 0 ;
	if ( ++(*line) >= length ) {
		*line = 0 ;
		putchar( '\r' ) ;
		putchar( '\f' ) ;
	} else {
		putchar( '\r' ) ;
		putchar( '\n' ) ;
	}
}

/***************  kanji in  *******************************************/

kanji_in()
{
	putchar( ESC ) ;
	putchar( 'K' ) ;
}

/***************  kanji out  *****************************************/

kanji_out()
{
	putchar	( ESC );
	putchar	( 'H' );
}

/**************  alpha put  ******************************************/

alpha_put( fg,cc )
register int	fg,cc ;
{
	if ( fg == KANJI ) kanji_out() ;
	putchar( cc ) ;
	return ( KANA ) ;
}

/**************  kanji put  ******************************************/

kanji_put( fg,hi,lo )
register int	fg,hi,lo ;
{
	hi -= ( hi <= 0x9f ) ? 0x71 : 0xb1 ;
	hi = hi * 2 + 1 ;
	if ( lo >  0x7f ) {
		lo -= 1;
	}
	if ( lo >= 0x9e ) {
		lo -= 0x7d;
		hi += 1;
	} else {
		lo -= 0x1f;
	}
	if ( fg == KANA ) kanji_in() ;
	putchar( hi ) ;
	putchar( lo ) ;
	return ( KANJI ) ;
}
