/************************************************************************
	Binary file dump program version 1.00
		Programmed by Y.Nishida
						[ Oct.25, 1990 ]
 ************************************************************************/

#include	<stdio.h>
#include	<ctype.h>

#define		ERROR		-1
#define		COMPLETE	0

unsigned	start_address = 0x000000 ;
unsigned	end_address   = 0xffffff ;
unsigned	disp_offset   = 0x008000 ;



main( argc,argv )
int	argc ;
char	**argv ;
{
	FILE	*fp ;
	void	file_dump() ;

	if ( argc < 2 ) {
		fputs( "Binary file dump program version 1.00  for Super Famicom\n",stderr ) ;
		fputs( "  usage: sfxdmp  filename [ options ]\n", stderr ) ;
		fputs( "     -s: dump start address.\n",	  stderr ) ;
		fputs( "     -e: dump end address.\n",		  stderr ) ;
		fputs( "     -o: address display offset.\n",	  stderr ) ;
		exit( 1 ) ;
	}
	if (( fp = fopen( *++argv,"r" )) == NULL ) {
		perror( *argv ) ;
		exit( 1 ) ;
	}
	if ( check_option( --argc,argv ) == ERROR ) exit( 1 ) ;

	fprintf( stderr,"Dump start address : $%X\n", start_address ) ;
	fprintf( stderr,"Dump end address   : $%X\n", end_address   ) ;
	fprintf( stderr,"Display offset     : $%X\n", disp_offset   ) ;

	file_dump( fp ) ;
	fclose( fp ) ;
	exit( 0 ) ;
}

/************************************************************************/
/*		file dump main						*/
/************************************************************************/

void file_dump( fp )
FILE	*fp ;
{
	unsigned	ct,ad ;
	char		buf[17] ;
	int		cc,colum = 0 ;

	for ( ad=0 ; ad < start_address ; ad++ ) fgetc( fp ) ;

	for ( ad=disp_offset,ct=start_address ; ct<= end_address ; ct++ ) {
		if (( cc = fgetc( fp )) == EOF ) break ;

		if ( isprint( cc )) buf[colum] = (char)cc ;
			       else buf[colum] = '.' ;

		switch ( colum++ ) {
			case 0:
				printf( "%06X: %02X ", ad,cc ) ;
				ad += 16 ;
				break ;
			case 15:
				buf[16] = '\0' ;
				printf( "%02X  : %s\n", cc,buf ) ;
				colum = 0 ;
				break ;
			default:
				printf( "%02X ",cc ) ;
				break ;
		}
	}		
	if ( colum > 0 ) {
		buf[colum] = '\0' ;
		while ( colum++ < 16 ) printf( "   " ) ;
		printf( " : %s\n", buf ) ;
	}
}

/************************************************************************/
/*		Check options						*/
/************************************************************************/

int check_option( argc,argv )
int	argc ;
char	**argv ;
{
	unsigned	htou() ;

	while ( --argc ) {
		if ( **++argv == '-' ) {
			switch ( *++*argv ) {
				case 's': start_address = htou( ++*argv ) ;	break ;
				case 'e': end_address   = htou( ++*argv ) ;	break ;
				case 'o': disp_offset   = htou( ++*argv ) ;	break ;
			}
		}
	}
	if ( start_address > end_address ) {
		fprintf( stderr, "address is bad: start = $%X    end = $%X\n", start_address,end_address ) ;
		return ( ERROR ) ;
	}
	return ( COMPLETE ) ;
}

/************************************************************************/
/*		type change hex-digit to unsigned integer		*/
/************************************************************************/

unsigned htou( str )
char	*str ;
{
	unsigned	num = 0 ;

	while ( isxdigit( *str )) {
		if      ( *str <= '9' ) num = num * 16 + *str++ - '0' ;
		else if ( *str <= 'F' ) num = num * 16 + *str++ - 'A' + 10 ;
		else			num = num * 16 + *str++ - 'a' + 10 ;
	}
	return ( num ) ;
}
