/************************************************************************
		Source program typewriter for ditroff

		      Programmed by Y.Nishida

						[ Dec.16, 1991 ]
 ************************************************************************/

#include	<stdio.h>
#include	<ctype.h>

#define MAX_COLUM	120
#define ASCII		0
#define KANJI		1

int	kmode = ASCII ;
int	line  = 1 ;
int	colum = 0 ;
void	TypeSourceFile() ;

/************************************************************************/
/*	Main function							*/
/************************************************************************/

int main( argc,argv )
int	argc ;
char	**argv ;
{
	FILE	*fp ;

	if ( argc != 2 ) {
		fprintf( stderr,"Source program typewriter for ditroff\n" ) ;
		fprintf( stderr,"Usage: type <file name>\n" ) ;
		return ( 1 ) ;
	}
	if (( fp = fopen( *++argv,"r" )) == NULL ) {
		fprintf( stderr,"%s: file not found\n", *argv ) ;
		return ( 1 ) ;
	}
	TypeSourceFile( fp ) ;
	fclose( fp ) ;
	return ( 0 ) ;
}

/************************************************************************/
/*	Change TAB code to space code					*/
/************************************************************************/

void TabToSpace()
{
	if ( kmode != ASCII ) {
		kmode = ASCII ;
		printf( "\\f(CW" ) ;
	}
	if ( colum == MAX_COLUM ) {
		printf( "\n    :         " ) ;
		colum = 8 ;
	}
	else {
		do {
			putchar( ' ' ) ;
		} while ( ++colum % 8 ) ;
	}
}

/************************************************************************/
/*	Carriage return process						*/
/************************************************************************/

void CarriageReturn()
{
	if ( kmode != ASCII ) {
		kmode = ASCII ;
		printf( "\\f(CW" ) ;
	}
	putchar( '\n' ) ;
	colum = 0 ;
}

/************************************************************************/
/*	Print Kanji							*/
/************************************************************************/

void PrintKanji( cc1,cc2 )
int	cc1,cc2 ;
{
	if ( colum >= MAX_COLUM-1 ) {
		kmode = KANJI ;
		printf( "\\f(CW\n    : \\fR%c%c", cc1,cc2 ) ;
		colum = 2 ;
	}
	else {
		if ( kmode != KANJI ) {
			kmode = KANJI ;
			printf( "\\fR" ) ;
		}
		putchar( cc1 ) ;
		putchar( cc2 ) ;
		colum += 2 ;
	}
}

/************************************************************************/
/*	Print character							*/
/************************************************************************/

void PrintChar( cc )
int	cc ;
{
	if ( kmode != ASCII ) {
		kmode = ASCII ;
		printf( "\\f(CW" ) ;
	}
	if ( colum == MAX_COLUM ) {
		printf( "\n    : " ) ;
		colum = 0 ;
	}
	switch ( cc ) {
		case '\\': printf( "\\e" ) ;		break ;
		case '.' : printf( "\\." ) ;		break ;
		case 0x7f: printf( "\\o'?='" ) ;	break ;
		default:
			if ( cc < ' ' ) {
				printf( "\\o'%c='",cc+'@' ) ;
			} else {
				putchar( cc ) ;
			}
			break ;
	}
	colum++ ;
}

/************************************************************************/
/*	Type Program source file					*/
/************************************************************************/

void TypeSourceFile( fp )
FILE	*fp ;
{
	int	cc ;

	printf( ".po 1c\n.ll 7i\n.vs 9\n.ps 8\n.ft CW\n.nf\n" ) ;

	while (( cc = getc( fp )) != EOF ) {
		if ( colum == 0 )  printf( "%4d: ",line++ ) ;

		switch ( cc ) {
			case '\t': TabToSpace() ;	break ;
			case '\n': CarriageReturn() ;	break ;
			default:
				if ( iskanji( cc )) {
					PrintKanji( cc,getc( fp )) ;
				} else {
					PrintChar( cc ) ;
				}
				break ;
		}
	}
}
