/************************************************************************
					R|S\pbP[W

					 IuWFNg`惂W[

					   Programmed by Y.Nishida

												[ Nov.18, 1993 ]
 ************************************************************************/

#include <math.h>
#include "ToolBox.h"
#include "External.h"
#include "Prototype.h"
#include "PolyPack.h"
#include "caduser"

#define	DrawHorizontalLine(points)		DrawGroundLine(points,1,2)
#define	DrawVerticalLine(points)		DrawGroundLine(points,2,1)

typedef struct {
	short	minz;
	short	maxz;
	short	pntcnt;
	short	pntnum;
	short	select;
	short	link;
} PolyList;

static SPoint *scrnPoint;
static PolyList *polygonList;
static int firstPolygon;

/************************************************************************
	nʂ̃[hE[e[VsȂ.
 ************************************************************************/

static void GroundRotation(matrix,points,posx,posy,posz,offset)
RMatrix	matrix;
DPoint *points;
double posx,posy,posz;
DOffset *offset;
{
	points->x = posx * matrix[0][0] + posy * matrix[1][0] + posz * matrix[2][0] + offset->x;
	points->y = posx * matrix[0][1] + posy * matrix[1][1] + posz * matrix[2][1] + offset->y;
	points->z = posx * matrix[0][2] + posy * matrix[1][2] + posz * matrix[2][2] + offset->z;
}

/************************************************************************
	nʂ̃C̓ϊsȂ.iRcNbsOtj
 ************************************************************************/

static int ProjectGroundLine(point,x1,y1,z1,x2,y2,z2)
XSegment *point;
double x1,y1,z1,x2,y2,z2;
{
	if (z1 < 16) {
		if (z2 < 16) return(0);
		x1 = (x2-x1)*(16-z1)/(z2-z1) + x1;
		y1 = (y2-y1)*(16-z1)/(z2-z1) + y1;
		z1 = 16;
	}
	else if (z2 < 16) {
		x2 = (x1-x2)*(16-z2)/(z1-z2) + x2;
		y2 = (y1-y2)*(16-z2)/(z1-z2) + y2;
		z2 = 16;
	}
	point->x1 = persView.centerX + (int)(Convert((x1 * 512.0) / z1) );
	point->y1 = persView.centerY - (int)(Convert((y1 * 512.0) / z1) );
	point->x2 = persView.centerX + (int)(Convert((x2 * 512.0) / z2) );
	point->y2 = persView.centerY - (int)(Convert((y2 * 512.0) / z2) );

	return(1);
}

/************************************************************************
	nʂ̃Ct[̕`sȂ.
 ************************************************************************/

static void DrawGroundLine(points,endpnt,vecpnt)
DPoint points[3];
int endpnt,vecpnt;
{
	XSegment segment[21];
	int index,count,srn_sx,srn_sy,srn_ex,srn_ey;

	double pos_sx = points[0].x;
	double pos_sy = points[0].y;
	double pos_sz = points[0].z;

	double pos_ex = points[endpnt].x;
	double pos_ey = points[endpnt].y;
	double pos_ez = points[endpnt].z;

	double vecx = (points[vecpnt].x - points[0].x) / 20.0;
	double vecy = (points[vecpnt].y - points[0].y) / 20.0;
	double vecz = (points[vecpnt].z - points[0].z) / 20.0;

	for (index=0,count=0; count<21; count++) {
		index  += ProjectGroundLine(&segment[index],pos_sx,pos_sy,pos_sz,pos_ex,pos_ey,pos_ez);
		pos_sx += vecx;
		pos_sy += vecy;
		pos_sz += vecz;
		pos_ex += vecx;
		pos_ey += vecy;
		pos_ez += vecz;
	}
	if (index > 0) XDrawSegments(display,persView.pixmap,polygonGPort,segment,index);
}

/************************************************************************
	nʂ`.
************************************************************************/

extern void DrawGround(matrix,offset)
RMatrix matrix;
DOffset *offset;
{
	DPoint points[3];

	GroundRotation(matrix,&points[0], -512.0, 0.0, -512.0, offset);
	GroundRotation(matrix,&points[1],  512.0, 0.0, -512.0, offset);
	GroundRotation(matrix,&points[2], -512.0, 0.0,  512.0, offset);

	DrawHorizontalLine(points);
	DrawVerticalLine(points);
}

/************************************************************************
	SĂ̒_XN[Wɕϊ.
 ************************************************************************/

static void RotateAllPoints(matrix,offset)
RMatrix matrix;
DOffset *offset;
{
	int count;
	Point *world   = polyData.point;
	SPoint *screen = scrnPoint;

	for (count=0; count<polyData.npoints; count++) {
		if (world->flags) {
			int pntx    = (int)Convert(world->pointx) * 4;
			int pnty    = (int)Convert(world->pointy) * 4;
			int pntz    = (int)Convert(world->pointz) * 4;
			double rotx = pntx * matrix[0][0] + pnty * matrix[1][0] + pntz * matrix[2][0] + offset->x;
			double roty = pntx * matrix[0][1] + pnty * matrix[1][1] + pntz * matrix[2][1] + offset->y;
			double rotz = pntx * matrix[0][2] + pnty * matrix[1][2] + pntz * matrix[2][2] + offset->z;

			if ((screen->z = (short)rotz) >= 16) {
				screen->x = persView.centerX + (int)(Convert((rotx * 512.0) / rotz) );
				screen->y = persView.centerY - (int)(Convert((roty * 512.0) / rotz) );
				screen->z = (int)(Convert(rotz));
			}
		}
		world  += 1;
		screen += 1;
	}
}

/************************************************************************
	Oς߂.
 ************************************************************************/

static int CrossProduct(pnt1)
int pnt1;
{
	int pnt2 = polyData.point[pnt1].nextPoint;
	int pnt3 = polyData.point[pnt2].nextPoint;

	int ux = scrnPoint[pnt2].x - scrnPoint[pnt1].x;
	int uy = scrnPoint[pnt2].y - scrnPoint[pnt1].y;
	int vx = scrnPoint[pnt3].x - scrnPoint[pnt2].x;
	int vy = scrnPoint[pnt3].y - scrnPoint[pnt2].y;

	return(ux*vy-vx*uy);
}

/************************************************************************
	|S_̂yW̍őlƍŏl߂.
 ************************************************************************/

static void SetMinMaxZ(polylist)
PolyList *polylist;
{
	int count;
	int pntnum = polylist->pntnum;

	polylist->minz = scrnPoint[pntnum].z;
	polylist->maxz = scrnPoint[pntnum].z;

	for (count=0; count<polylist->pntcnt; count++) {
		int posz = scrnPoint[pntnum].z;

		if (posz < polylist->minz) polylist->minz = posz;
		if (posz > polylist->maxz) polylist->maxz = posz;
		pntnum = polyData.point[pntnum].nextPoint;
	}
}

/************************************************************************
	|SN.
 ************************************************************************/

static void LinkPolygonList(current)
int current;
{
	int count;
	int	before	 = -1;
	int	polylink = firstPolygon;

	for (count=0; count<current; count++) {
		if (polygonList[current].maxz > polygonList[polylink].maxz) break;
		before	 = polylink;
		polylink = polygonList[polylink].link;
	}
	polygonList[current].link = polylink;

	if (before == -1) firstPolygon			   = current;
				 else polygonList[before].link = current;
}

/************************************************************************
	|S̃\[gsȂ.
 ************************************************************************/

static int SortPolygons()
{
	Polygon *polygon   = polyData.polygon;
	int count,index = 0;

	firstPolygon = -1;
	for (count=0; count<polyData.npolygons; polygon++,count++) {
		if (polygon->flags) {
			if (polygon->npoints >= 3 && CrossProduct(polygon->firstPoint) <= 0) continue;

			polygonList[index].pntcnt = polygon->npoints;
			polygonList[index].pntnum = polygon->firstPoint;
			polygonList[index].select = polygon->selectFlag;

			SetMinMaxZ(&polygonList[index]);
			LinkPolygonList(index);
			index++;
		}
	}
	return(index);
}

/************************************************************************
	|SCt[ŕ`.
 ************************************************************************/

static void DrawWirePolygon(pntnum,npoints)
int pntnum,npoints;
{
	XPoint	pointList[32];
	int index;

	for (index=0; index<npoints; index++) {
		if (scrnPoint[pntnum].z < 16) return;

		pointList[index].x = scrnPoint[pntnum].x;
		pointList[index].y = scrnPoint[pntnum].y;
		pntnum			   = polyData.point[pntnum].nextPoint;
	}
	pointList[index].x = pointList[0].x;
	pointList[index].y = pointList[0].y;

	XDrawLines(display,persView.pixmap,polygonGPort,pointList,npoints+1,CoordModeOrigin);
}

/************************************************************************
	CEt[ŃIuWFNg`.
 ************************************************************************/

extern void DrawWireFrame(matrix,offset)
RMatrix matrix;
DOffset *offset;
{
	int index;

	if ((scrnPoint = (SPoint *)calloc(polyData.npoints,sizeof(SPoint))) != NULL) {
		RotateAllPoints(matrix,offset);

		for (index=0; index<polyData.npolygons; index++) {
			Polygon *poly = &polyData.polygon[index];

			if (poly->flags != 0) {
				DrawWirePolygon(poly->firstPoint,poly->npoints);
			}
		}
		free(scrnPoint);
	}
}

/************************************************************************
	|Shׂ.
 ************************************************************************/

static void DrawFilledPolygon(pntnum,npoints,color)
int pntnum,npoints,color;
{
	XPoint	pointList[32];
	int index;

	for (index=0; index<npoints; index++) {
		pointList[index].x = scrnPoint[pntnum].x;
		pointList[index].y = scrnPoint[pntnum].y;
		pntnum			   = polyData.point[pntnum].nextPoint;
	}
	pointList[index].x = pointList[0].x;
	pointList[index].y = pointList[0].y;

	XSetForeground(display,polygonGPort,color);
	if (npoints > 2) {
		XFillPolygon(display,persView.pixmap,polygonGPort,pointList,npoints+1,Convex,CoordModeOrigin);
	} else {
/*		XSetForeground(display,polygonGPort,28);*/
		XDrawLine(display,persView.pixmap,polygonGPort,
					pointList[0].x,pointList[0].y,pointList[1].x,pointList[1].y);
/*		XSetForeground(display,polygonGPort,color);*/
	}
}

/************************************************************************
	Cg\[XEVF[fBO.
 ************************************************************************/

static int LightSourceShading(matrix,pnt1,count)
RMatrix matrix;
int pnt1,count;
{
	int value = 39;

	if (count > 2) {
		int pnt2  = polyData.point[pnt1].nextPoint;
		int pnt3  = polyData.point[pnt2].nextPoint;

		double ux = polyData.point[pnt2].pointx - polyData.point[pnt1].pointx;
		double uy = polyData.point[pnt2].pointy - polyData.point[pnt1].pointy;
		double uz = polyData.point[pnt2].pointz - polyData.point[pnt1].pointz;
		double vx = polyData.point[pnt3].pointx - polyData.point[pnt2].pointx;
		double vy = polyData.point[pnt3].pointy - polyData.point[pnt2].pointy;
		double vz = polyData.point[pnt3].pointz - polyData.point[pnt2].pointz;
		double Nx = uy*vz - uz*vy;
		double Ny = uz*vx - ux*vz;
		double Nz = ux*vy - uy*vx;
		double Na = sqrt(Nx*Nx + Ny*Ny + Nz*Nz);

		Nx /= Na;
		Ny /= Na;
		Nz /= Na;
		value = 24 - (int)((Nx*matrix[0][2] + Ny*matrix[1][2] + Nz*matrix[2][2])*15);
	}
	else {
		value = 28;   /*̎*/
	}
	return(value);
}

/************************************************************************
	|SŃIuWFNg`.
 ************************************************************************/

extern void DrawFPolygon(matrix,offset)
RMatrix matrix;
DOffset *offset;
{
	int count,npolys,polynum;

	scrnPoint   = (SPoint   *)calloc(polyData.npoints	 ,sizeof(SPoint  ));
	polygonList = (PolyList *)calloc(polyData.npolygons+1,sizeof(PolyList));

	if (scrnPoint != NULL && polygonList != NULL) {
		RotateAllPoints(matrix,offset);
		npolys  = SortPolygons();
		polynum = firstPolygon;

		for (count=0; count<npolys; count++) {
			PolyList *poly = &polygonList[polynum];
			int color = ((poly->select)==1) ? 8 : LightSourceShading(matrix,poly->pntnum,poly->pntcnt);

			DrawFilledPolygon(poly->pntnum,poly->pntcnt,color);
			polynum = poly->link;
		}
	}
	if (scrnPoint   != NULL) free(scrnPoint  );
	if (polygonList != NULL) free(polygonList);
}
