/************************************************************************
					R|S\pbP[W

						CEW[

					  Programmed by Y.Nishida

												[ Nov.18, 1993 ]
 ************************************************************************/

#include <math.h>
#include "ToolBox.h"
#include "External.h"
#include "PolyPack.h"
#include "caduser"

#define DISTANCE	1000

GC polygonGPort;					/* Rcʕ`pfb				*/

WindowInfo	persView;		/* R\pEBhE		*/
PolyData	polyData;

static RMatrix rotationMatrix;		/* J]s					*/
static DAngle  cameraAngle;			/* J̉]pxiWAj		*/
static DOffset cameraOffset;		/* J̃ItZbg				*/

static int cameraAngleX;			/* Ĵw]pxixj		*/
static int cameraAngleY;			/* Ĵx]pxixj		*/
static int cameraAngleZ;			/* Ĵy]pxixj		*/

static int cameraOffsetX;			/* JEɂ炷		*/
static int cameraOffsetY;			/* J㉺ɂ炷		*/
static int cameraOffsetZ;			/* JOɂ炷		*/

static int motionSelect = 0;
static int motionPointX;
static int motionPointY;

static int drawMode = 1;

/************************************************************************
	]s쐬.
 ************************************************************************/

static void SetRotationMatrix(matrix,angle)
RMatrix matrix;
DAnglePtr angle;
{
	double sinA = sin(angle->x);
	double cosA = cos(angle->x);
	double sinB = sin(angle->y);
	double cosB = cos(angle->y);
	double sinC = sin(angle->z);
	double cosC = cos(angle->z);

	matrix[0][0] =    cosB * cosC + sinA * sinB * sinC;
	matrix[0][1] =  - cosB * sinC + sinA * sinB * cosC;
	matrix[0][2] =    cosA * sinB;

	matrix[1][0] =    cosA * sinC;
	matrix[1][1] =    cosA * cosC;
	matrix[1][2] =  - sinA;

	matrix[2][0] =  - sinB * cosC + sinA * cosB * sinC;
	matrix[2][1] =    sinB * sinC + sinA * cosB * cosC;
	matrix[2][2] =    cosA * cosB;
}

/************************************************************************
	Rcr[EEBhE̕`揈sȂ.
 ************************************************************************/

static void DrawPersViewWindow()
{
	WCorePtr wcore = (WCorePtr)persView.window;
	Window window  = wcore->windowID;
	Pixmap pixmap  = persView.pixmap;
/*
	int souPx = (persView.width  - (wcore->width -  16)) / 2;
	int souPy = (persView.height - (wcore->height - 36)) / 2;
*/

	int souPx = (persView.width  - wcore->width ) / 2;
	int souPy = (persView.height - wcore->height) / 2;

	XCopyArea(display,pixmap,window,systemGPort,souPx,souPy,wcore->width,wcore->height,0,0);
}

/************************************************************************
	R`XN[ɃIuWFNg`悷.
 ************************************************************************/

static void DrawObject()
{
	WCorePtr wcore = (WCorePtr)persView.window;

	cameraAngle.x =   ((double)cameraAngleX * M_PI) / 180.0;
	cameraAngle.y =   ((double)cameraAngleY * M_PI) / 180.0;
	cameraAngle.z = - ((double)cameraAngleZ * M_PI) / 180.0;

	cameraOffset.x = (double)cameraOffsetX;
	cameraOffset.y = (double)cameraOffsetY;
	cameraOffset.z = (double)(cameraOffsetZ + DISTANCE);

	SetRotationMatrix(rotationMatrix,&cameraAngle);
	XSetForeground(display,polygonGPort,backColor);
	XFillRectangle(display,persView.pixmap,polygonGPort,0,0,persView.width,persView.height);

	XSetForeground(display,polygonGPort,1);
	DrawGround(rotationMatrix,&cameraOffset);

	if (drawMode == 0) {
		XSetForeground(display,polygonGPort,2);
		DrawWireFrame(rotationMatrix,&cameraOffset);
	} else {
		DrawFPolygon(rotationMatrix,&cameraOffset);
	}
	DrawPersViewWindow();
}

extern void Draw3DWindow()
{
	DrawObject();
}

/************************************************************************
	XN[Eo[ɂJ̉]sȂ.
 ************************************************************************/

static int DoCameraRotation(ctrl,code,angle)
ControlPtr ctrl;
int code,*angle;
{
	int minval = GetCtrlMinval(ctrl);
	int maxval = GetCtrlMaxval(ctrl);

	switch (code) {
		case 1: ctrl->value = ctrl->value -  1;					break;
		case 2:	ctrl->value = ctrl->value +  1;					break;
		case 3: ctrl->value = ((ctrl->value / 45) - 1) * 45;	break;
		case 4:	ctrl->value = ((ctrl->value / 45) + 1) * 45;	break;
	}
	if (ctrl->value < minval) ctrl->value = minval;
	if (ctrl->value > maxval) ctrl->value = maxval;

	*angle = ctrl->value;
	DrawObject();
}

/************************************************************************
	XN[Eo[ɂJ̉]sȂ.
 ************************************************************************/

extern void Do3DViewAction(ctrl,code)
ControlPtr ctrl;
int code;
{
	switch (ctrl->refCon) {
		case 1:	DoCameraRotation(ctrl,code,&cameraAngleX);	break;
		case 2:	DoCameraRotation(ctrl,code,&cameraAngleY);	break;
		case 3:	DoCameraRotation(ctrl,code,&cameraAngleZ);	break;
	}
	XFlush(display);
	XSync(display,0);
}

/************************************************************************
	Y[{^ɂJ̃Y[̐ݒsȂij
 ************************************************************************/
extern void ZoomInOffsetZ(ctrl,code)
ControlPtr ctrl;
int code;
{
	int posx,posy,x,y,key;

	cameraOffsetZ -= 50 * 4;

	if (cameraOffsetZ < -1000) cameraOffsetZ = -1000;

	motionPointX = posx;
	motionPointY = posy;
	DrawObject();
}
/************************************************************************
	Y[{^ɂJ̃Y[̐ݒsȂ.ij
 ************************************************************************/
extern void ZoomOutOffsetZ(ctrl,code)
ControlPtr ctrl;
int code;
{
	int posx,posy,x,y,key;

	cameraOffsetZ += 50 * 4;

	if (cameraOffsetZ >  2000) cameraOffsetZ =  2000;

	motionPointX = posx;
	motionPointY = posy;
	DrawObject();
}
/************************************************************************
	}EẌړɂĴwxm]sȂ.
 ************************************************************************/

static RotateCameraAngleXY()
{
	WCorePtr wcore = (WCorePtr)persView.window;
	Window root,child;
	int posx,posy,x,y;
	unsigned int key;

	XQueryPointer(display,wcore->windowID,&root,&child,&posx,&posy,&x,&y,&key);
	cameraAngleY -= (motionPointX - posx);
	cameraAngleX -= (motionPointY - posy);

	while (cameraAngleX >  180) cameraAngleX -= 360;
	while (cameraAngleX < -180) cameraAngleX += 360;
	while (cameraAngleY >  180) cameraAngleY -= 360;
	while (cameraAngleY < -180) cameraAngleY += 360;

	SetCtrlValue(persView.rotXBar,cameraAngleX);
	SetCtrlValue(persView.rotYBar,cameraAngleY);

	motionPointX = posx;
	motionPointY = posy;
	DrawObject();
}

/************************************************************************
	}EẌړɂĴy]sȂ.
 ************************************************************************/

static RotateCameraAngleZ()
{
	WCorePtr wcore = (WCorePtr)persView.window;
	Window root,child;
	int posx,posy,x,y;
	unsigned int key;

	XQueryPointer(display,wcore->windowID,&root,&child,&posx,&posy,&x,&y,&key);
	cameraAngleZ -= (motionPointY - posy);

	while (cameraAngleZ >  180) cameraAngleZ -= 360;
	while (cameraAngleZ < -180) cameraAngleZ += 360;

	SetCtrlValue(persView.rotZBar,cameraAngleZ);

	motionPointX = posx;
	motionPointY = posy;
	DrawObject();
}

/************************************************************************
	}EẌړɂJ̃ItZbg̐ݒsȂ.
 ************************************************************************/

static SetCameraOffsetXY()
{
	WCorePtr wcore = (WCorePtr)persView.window;
	Window root,child;
	int posx,posy,x,y;
	unsigned int key;

	XQueryPointer(display,wcore->windowID,&root,&child,&posx,&posy,&x,&y,&key);
	cameraOffsetX -= (motionPointX - posx);
	cameraOffsetY += (motionPointY - posy);

	if (cameraOffsetX >  1000) cameraOffsetX =  1000;
	if (cameraOffsetX < -1000) cameraOffsetX = -1000;
	if (cameraOffsetY >  1000) cameraOffsetY =  1000;
	if (cameraOffsetY < -1000) cameraOffsetY = -1000;

	motionPointX = posx;
	motionPointY = posy;
	DrawObject();
}

/************************************************************************
	}EẌړɂJ̃Y[̐ݒsȂ.
 ************************************************************************/

static SetCameraOffsetZ()
{
	WCorePtr wcore = (WCorePtr)persView.window;
	Window root,child;
	int posx,posy,x,y;
	unsigned int key;

	XQueryPointer(display,wcore->windowID,&root,&child,&posx,&posy,&x,&y,&key);
	cameraOffsetZ += (motionPointY - posy) * 4;

	if (cameraOffsetZ >  2000) cameraOffsetZ =  2000;
	if (cameraOffsetZ < -1000) cameraOffsetZ = -1000;

	motionPointX = posx;
	motionPointY = posy;
	DrawObject();
}

/************************************************************************
	}EXE{^ꂽ̏sȂ.
 ************************************************************************/

static void ButtonPressEvent(event,wcore)
XEventPtr event;
WCorePtr wcore;
{
	Window root,child;
	int posx,posy,x,y;
	unsigned int key;

	motionSelect = 0;
	XQueryPointer(display,wcore->windowID,&root,&child,&motionPointX,&motionPointY,&x,&y,&key);

/*	if (key & ShiftMask) {
		motionSelect = event->xbutton.button;
	}
	else if (key & Mod1Mask) {
		motionSelect = event->xbutton.button + 3;
	}*/

	if (key & ShiftMask) motionSelect = 4;
	else 				 motionSelect = event->xbutton.button;


}

/************************************************************************
	}EXړ̏sȂ.
 ************************************************************************/

static void PointerMotionEvent(event,wcore)
XEventPtr event;
WCorePtr wcore;
{
	XEvent ahead;

	while (XEventsQueued(display,QueuedAfterReading) > 0) {
		XPeekEvent(display,&ahead);
		if (ahead.type != MotionNotify) break;
		if (ahead.xmotion.window != event->xmotion.window) break;
		XNextEvent(display,event);
	}

/*	switch (motionSelect) {
		case 1: RotateCameraAngleXY();	break;
		case 2: RotateCameraAngleZ();	break;
		case 4: SetCameraOffsetXY();	break;
		case 5: SetCameraOffsetZ();		break;
	}*/

	switch (motionSelect) {
		case 1: RotateCameraAngleXY();	break;
		case 2: SetCameraOffsetZ();		break;
		case 3: SetCameraOffsetXY();	break;
		case 4: RotateCameraAngleZ();	break;
	}
}

/************************************************************************
	Rc\EBhEւ̃Cxg.
 ************************************************************************/

extern void Do3DViewEvent(event,wcore)
XEventPtr event;
WCorePtr wcore;
{
	switch (event->type) {
		case 		  Expose: DrawPersViewWindow();				break;
		case ButtonPressMask: ButtonPressEvent(event,wcore);	break;
		case	MotionNotify: PointerMotionEvent(event,wcore);	break;
	}
}

/************************************************************************
	R|S\pbP[ŴnsȂ.
 ************************************************************************/
extern void InitPolygonOffset()
{

	cameraAngleX  = GetCtrlValue(persView.rotXBar);
	cameraAngleY  = GetCtrlValue(persView.rotYBar);
	cameraAngleZ  = 0;

	cameraOffsetX = 0;
	cameraOffsetY = 0;
	cameraOffsetZ = 0;

	polygonGPort = XCreateGC(display,mainWindow,0,NULL);
	XSetForeground(display,polygonGPort,1);
	XSetBackground(display,polygonGPort,0);
	XSetLineAttributes(display,polygonGPort,0,LineSolid,CapButt,JoinMiter);
	XSetGraphicsExposures(display,polygonGPort,false);

	DrawObject();

}

/************************************************************************
	R|S\pbP[W̏sȂ.
 ************************************************************************/

extern void InitPolygonPackage(design,point,npoints,polygon,npolygons)
DesignPtr design;
Point *point;
Polygon *polygon;
int npoints,npolygons;
{
	persView.window	   = design->contents;
	persView.rotXBar   = design->scrlHBar;		/* gƂqt	*/
	persView.rotYBar   = design->scrlRBar;
	persView.rotZBar   = design->scrlLBar;
	persView.pixmap	   = design->foreScreen;
	persView.width	   = design->width;
	persView.height	   = design->height;
	persView.centerX   = design->width  / 2;
	persView.centerY   = design->height / 2;

	polyData.npoints   = npoints;
	polyData.point	   = point;
	polyData.npolygons = npolygons;
	polyData.polygon   = polygon;

	InitPolygonOffset();
}

/************************************************************************
	R|S\[h̐ݒ.
 ************************************************************************/

extern void Set3DViewMode(mode)
int mode;
{
	drawMode = mode != 0;
}
