/************************************************************************
		IWAMOTO CAD ̃t@Cf[^
		ӂǂ̃t@Cf[^tH[}bgɕϊB
											by Daiki Iwamoto
 ************************************************************************/

#include 	<stdio.h>
#include	<string.h>
#include	<ctype.h>
#include 	<math.h>
#include    "FunCad.h"
#include    "caduser"

#define		unchar		unsigned char
#define		FRAMENUM 64


/************************************************************************
		 Rc-b`cvOpϐ`
 ************************************************************************/

typedef struct {
	char	flags;			/* tbO											*/
	char	selectFlag;
	short	parentObject;	/* eIuWFNgւ̃CfbNX					*/
	short	nextBrother;	/* ̌ZIuWFNgւ̃CfbNX				*/
	short	childObject;	/* ŏ̎qIuWFNgւ̃CfbNX				*/
	short	firstPolygon;	/* ŏ̃|Sւ̃CfbNX					*/
	double	offsetx;		/* eƂ̃ItZbgw								*/
	double	offsety;		/* eƂ̃ItZbgx								*/
	double	offsetz;		/* eƂ̃ItZbgy								*/
} Object;

typedef struct {
	char	flags;			/* tbO											*/
	char	selectFlag;
	short	nextPolygon;	/* O[ṽ|Sւ̃CfbNX			*/
	short	firstPoint;		/* |S\钸_ւ̃CfbNX			*/
	short	animation;
	short	both;			/* ʃ|ŜƂ̕Бւ̃CfbNX			*/
	unchar  side;			/* |S̕\̃tbO							*/
	unchar	color;			/* |S̐F										*/
	unchar	npoints;		/* |S̒_									*/
} Polygon;

typedef struct {
	char	flags;			/* tbO											*/
	char	selectFlag;
	short	nextPoint;		/* ̃|Cgւ̃CfbNX						*/
	double	pointx;			/* wW											*/
	double	pointy;			/* xW											*/
	double	pointz;			/* yW											*/
} Point;

typedef struct {		/*Aj[ṼCfbNX*/
	char flag;
	short frame[FRAMENUM];

} IndexRecord, Index;

static Object	DATAObject[OBJNUMBER];
static Polygon	DATAPolygon[POLYGONNUMBER];
static Point	DATAPoint[8192];
static Index	AnimIndex[256];

static char animationFlag = 0; 			/*Aj[Vt@C̃tO*/
/************************************************************************
			VFCvf[^obt@
 ************************************************************************/


static short PointBuffer[POINTNUMBER][FRAMENUM];
static short   pointNumber = 0;
static short   frameNumber = 0;

static short	PointData[POINTNUMBER];	/* |Cgf[^̃obt@ */
static short	ShiftData[POINTNUMBER];	/* |Cgf[^̉̃obt@ */


static int		PointTotal;				/* |Cg̃g[^ 	*/
static int		PolygonTotal;

/*************************************************************************************
			_f[^ľܓ֐

*************************************************************************************/
static int Convert(point)
double point;
{
	double Float;
	double convPoint;

	Float = modf(point,&convPoint);

	if (point >= 0) {
			if (Float >= 0.5) convPoint++;
	}
	else	if (Float <= -0.5) convPoint--;

	return(convPoint);
}

/************************************************************************
		b`cf[^̓ǂݍ
 ************************************************************************/

ReadCad(inputFP)
FILE	*inputFP;

{
	int	object_counter = 0;
	int	polygon_counter = 0;
	int	point_counter = 0;
	char	headder;
	short	pt;


		while ( fread (&headder,sizeof(char),1,inputFP) != NULL ){
			switch 	(headder){

				case	0:		/*object*/

					fread (&pt,sizeof(short),1,inputFP);
					fread (&DATAObject[pt],sizeof(Object),1,inputFP);
					break;
	
				case	1:		/*Polygon*/

					fread (&pt,sizeof(short),1,inputFP);
					fread (&DATAPolygon[pt],sizeof(Polygon),1,inputFP);
					break;

				case	2:		/*Point*/

					fread (&pt,sizeof(short),1,inputFP);
					fread (&DATAPoint[pt],sizeof(Point),1,inputFP);
					break;

				case    3:		/*AnimIndex*/
					fread (&pt,sizeof(short),1,inputFP);
					fread (&AnimIndex[pt],sizeof(IndexRecord),1,inputFP);
					break;
			
				case    4:		/*AnimationPoint*/
					fread (&pt,sizeof(short),1,inputFP);
					fread (&DATAPoint[pt],sizeof(Point),1,inputFP);
					animationFlag = 1;
					break;
					

			}

		}

}


/************************************************************************
			|Cgf[^obt@Ɋi[
 ************************************************************************/
static void BuffPoint(void)
{
	short polyNo = DATAObject[0].firstPolygon;
	short pointNo;
	short frame_no = 0;
	short pointCounter = 0;

	while (polyNo != -1) {
		pointNo = DATAPolygon[polyNo].firstPoint;
		
		while (pointNo != -1) {
				PointBuffer[pointCounter][0] = pointNo;
				pointNo = DATAPoint[pointNo].nextPoint;
				pointCounter ++;
		}

		polyNo = DATAPolygon[polyNo].nextPolygon;
	}

	pointNumber = pointCounter;
	frameNumber = 1;


}


/************************************************************************
			Aj[V|Cgf[^obt@Ɋi[
 ************************************************************************/
static void AnimBuffPoint(void)
{
	short polyNo = DATAObject[0].firstPolygon;
	short index,pointNo;
	short frame_no = 0;
	short pointCounter = 0;
	short k;

	short i;

	while (polyNo != -1) {
		index = DATAPolygon[polyNo].animation;
		pointNo = AnimIndex[index].frame[frame_no];

		while (pointNo != -1) {
			k = 0;
			while (pointNo != -1) {
				PointBuffer[pointCounter+k][frame_no] = pointNo;
				pointNo = DATAPoint[pointNo].nextPoint;
				k++;
			}
			
			frame_no++;
			pointNo = AnimIndex[index].frame[frame_no];
			
		}

		if (frameNumber == 0) frameNumber = frame_no;
		pointCounter += k;
		polyNo = DATAPolygon[polyNo].nextPolygon;
		frame_no = 0;
	}

	pointNumber = pointCounter;

}

/************************************************************************
			|Cgf[^ǂ̃`FbN
 ************************************************************************/
static char SamePointCheck(short point1,short point2)
{
	int x1,y1,z1,x2,y2,z2;
	char check = 0;

		x1 = Convert(DATAPoint[point1].pointx);
		y1 = Convert(DATAPoint[point1].pointy);
		z1 = Convert(DATAPoint[point1].pointz);
	
		x2 = Convert(DATAPoint[point2].pointx);
		y2 = Convert(DATAPoint[point2].pointy);
		z2 = Convert(DATAPoint[point2].pointz);

	if (x1==x2 && y1==y2 && z1==z2) check = 1;

	return (check);
}
/************************************************************************
			|Cgf[^̃obt@瓯̂𒲂ׂ
 ************************************************************************/
static void BuffPointCheck(void)
{
	short counter,serchNo,frame_no;
	char check = 0;
	short i,No;

	ShiftData[0] = -1;

	for (counter=0; counter<pointNumber; counter++) {
		serchNo = counter-1;

		while (serchNo != -1) {
			for  (frame_no=0; frame_no<frameNumber; frame_no++) {
				check = SamePointCheck(PointBuffer[counter][frame_no],PointBuffer[serchNo][frame_no]);
				if (check == 0) break;
			}
			if (check == 0) ShiftData[counter] = -1;
			else {
				if (ShiftData[serchNo] == -1) ShiftData[counter] = serchNo;
				else						  ShiftData[counter] = ShiftData[serchNo];
				break;
			}
			serchNo--;
		}
	}

	counter = 0;
	for (i=0; i<pointNumber; i++)	{	/*̃obt@{̃obt@w*/
		if ( (No = ShiftData[i]) == -1) {
			PointData[i] = counter;
			counter++;
		}
		else PointData[i] = PointData[No];
	}

	PointTotal = counter;
}


/************************************************************************
		obt@ӂǂtH[}bgւȂ
 ************************************************************************/

WriteCad(outputFP)
FILE	*outputFP;

{
	short i;
	short frame_no;
	short counts = 0;
	short polyNo = DATAObject[0].firstPolygon;
	short pointNo,npoints;

	if (animationFlag == 1) {
		fprintf (outputFP,"3DAN\r\n");
		fprintf (outputFP,"%d\r\n",PointTotal);
		fprintf (outputFP,"%d\r\n",frameNumber);
	}
	else {
		fprintf (outputFP,"3DG1\r\n");
		fprintf (outputFP,"%d\r\n",PointTotal);
	}

	for (frame_no=0; frame_no<frameNumber; frame_no++) {
		for (i=0; i<pointNumber; i++) {
			if (ShiftData[i] == -1) {
				pointNo = PointBuffer[i][frame_no];
				fprintf(outputFP,"%d %d %d\r\n",Convert(DATAPoint[pointNo].pointx),
								Convert(DATAPoint[pointNo].pointy),Convert(DATAPoint[pointNo].pointz));
			}
		}
	}

	while (polyNo != -1) {
		npoints = DATAPolygon[polyNo].npoints;
		fprintf(outputFP,"%d ",npoints);

		for (i=0; i<npoints; i++) {
			fprintf(outputFP,"%d ",PointData[counts]);
			counts++;
		}

		fprintf(outputFP,"%d\r\n",DATAPolygon[polyNo].color);


		polyNo = DATAPolygon[polyNo].nextPolygon;
	}

	fputc(0x1a, outputFP);




}

/************************************************************************
			C[`
 ************************************************************************/

extern int ConvertTxtFile(char *path )

{

	FILE	*inputFP;		/* b`c(mdvr)f[^̃t@C|C^		*/
	FILE	*outputFP;		/* ӂǂ(sws)f[^̃t@C|C^ */
	char *Message = "t@CςłII";
	short i,k;

	animationFlag = 0;
	pointNumber = 0;
	frameNumber = 0;

	if ((inputFP = fopen(".cadDatafile","r")) == NULL ){
		return(0);
	}


	ReadCad(inputFP);			/* b`cf[^ǂݍ 	*/

	if (animationFlag == 1) AnimBuffPoint();
	else 					BuffPoint();					/* b`cf[^WJ		*/
	BuffPointCheck();
	if ((outputFP = fopen(path,"w")) == NULL ){
		AlertDialog(150,150,390,100,0,2,1,&Message);
		return(0);
	}


	WriteCad(outputFP);			/* ӂǂtH[}bgłq`l֏ */

	fclose(outputFP);
	fclose(inputFP);


	return(1);
}
