/***************************************************************************************
					Aj[V֌W̃vO
															by D.IWAMOTO
****************************************************************************************/
#include <stdio.h>
#include <math.h>
#include "ToolBox.h"
#include "External.h"
#include "Prototype.h"
#include "caduser"

Point animPoint[ANPOINTNUM];
static ControlPtr animScr;				/*AjEChẼXN[o[̃|C^[*/
Index animIndex[INDEX_NUMBER];

char animationFlag = 0;

static short maxFrame = 1;			/*t[*/
short frameNo = 0;					/*݂̃t[*/

/*************************************************************************************
			Aj[Vf[^̃NA[
*************************************************************************************/
static void AnimationClear()
{
	short i,k;

	for (i=0; i<POLYGONNUMBER; i++) {
		polygonData[i].animation = -1;
	}

	for (i=0; i<INDEX_NUMBER; i++) {
		animIndex[i].flag = 0;
		for (k=0; k<FRAMENUM; k++) {
			animIndex[i].frame[k] = -1;
		}
	}

	for (i=0; i<ANPOINTNUM; i++) animPoint[i].flags = 0;

	SetCtrlMaxval(animScr,1);
	maxFrame = 1;
	frameNo = 0;
}

/***************************************************************************************
					݃t[̏
****************************************************************************************/
static void WriteNowFrame()
{
	WindowPtr window = animWindow;
	char str[10];
	String string;

	sprintf(str,"%d",frameNo);
	string = str;

	XClearArea(display,GetWindowID(window),140,13,40,13,False);
	PrintText(window,140,25,1,&string);
}
	





/************************************************************************************
		|S̃f[^Aj[Ṽf[^ŃRs[
*************************************************************************************/
static short AnimPolygonCpy(polyNo)
short polyNo;
{
	short pointNo = polygonData[polyNo].firstPoint;
	short firstPoint = -2;
	short root_point = -2;
	short i;

	while (pointNo != -1) {
		for (i=0; i<ANPOINTNUM; i++) {
			if (animPoint[i].flags == 0) {
				animPoint[i].flags = 1;
				if (firstPoint == -2) firstPoint = i;
				animPoint[i].nextPoint = -1;
				if (root_point != -2) animPoint[root_point].nextPoint = i;
				root_point = i;
				animPoint[i].pointx = pointData[pointNo].pointx;
				animPoint[i].pointy = pointData[pointNo].pointy;
				animPoint[i].pointz = pointData[pointNo].pointz;
				break;
			}
		}
		pointNo = pointData[pointNo].nextPoint;
	}

	return (firstPoint);
}



/************************************************************************************/
/************************************************************************************
		|S̃f[^Aj[Ṽf[^iSt[j
*************************************************************************************/
static void AllFrameDataMove(polyNo,movex,movey,movez,pointNum)
short polyNo;
int movex,movey,movez;
short pointNum;
{
	short pointNo = polygonData[polyNo].firstPoint;
	short ApointNo;
	short frame_no;
	short points;

	for (frame_no=0; frame_no<maxFrame; frame_no++) {
		points = pointNum;
		ApointNo = animIndex[polygonData[polyNo].animation].frame[frame_no];
		while (points != 0) {
			ApointNo = animPoint[ApointNo].nextPoint;
			points--;
		}
		animPoint[ApointNo].pointx += movex;
		animPoint[ApointNo].pointy += movey;
		animPoint[ApointNo].pointz += movez;
	}

}
/************************************************************************************
		Aj[Ṽf[^iSt[j
*************************************************************************************/
static void AllAnimPolyDataMove(short polyNo,short frame_no)
{
	short pointNo = polygonData[polyNo].firstPoint;
	short ApointNo = animIndex[polygonData[polyNo].animation].frame[frame_no];
	int movex,movey,movez;
	short pointNum = 0;

	while (pointNo != -1) {
		if (pointData[pointNo].selectFlag == 1) {
			movex = pointData[pointNo].pointx - animPoint[ApointNo].pointx;
			movey = pointData[pointNo].pointy - animPoint[ApointNo].pointy;
			movez = pointData[pointNo].pointz - animPoint[ApointNo].pointz;
			AllFrameDataMove(polyNo,movex,movey,movez,pointNum);
		}
		pointNo = pointData[pointNo].nextPoint;
		ApointNo = animPoint[ApointNo].nextPoint;
		pointNum++;
	}


}
/************************************************************************************
		|S̃f[^Aj[Ṽf[^iSt[j
*************************************************************************************/
static void AllFrameDataScale(polyNo,pointNum)
short polyNo;
short pointNum;
{
	short pointNo = polygonData[polyNo].firstPoint;
	short ApointNo;
	short frame_no;
	short points;
	double x1,y1,z1;

	for (frame_no=0; frame_no<maxFrame; frame_no++) {
		points = pointNum;
		ApointNo = animIndex[polygonData[polyNo].animation].frame[frame_no];
		while (points != 0) {
			ApointNo = animPoint[ApointNo].nextPoint;
			points--;
		}

	 	x1 = animPoint[ApointNo].pointx;
	 	y1 = animPoint[ApointNo].pointy;
		z1 = animPoint[ApointNo].pointz;
		if (editFlag == 4) {
			switch (centerFlag) {
				case 0: Rotate(x1,z1,y1,&x1,&z1,&y1,angle_num); break;
				case 1:	Rotate(x1,y1,z1,&x1,&y1,&z1,angle_num); break;
				case 2:	Rotate(z1,y1,x1,&z1,&y1,&x1,angle_num);
			}
		}
	    if (editFlag == 5)	ScaleSize(x1,y1,z1,&x1,&y1,&z1,(scale_num-1)*100);

	 	animPoint[ApointNo].pointx = x1;
	 	animPoint[ApointNo].pointy = y1;
		animPoint[ApointNo].pointz = z1;

	}

}
/************************************************************************************
		Aj[Ṽf[^iSt[jkaiten
*************************************************************************************/
static void AllAnimPolyDataScale(short polyNo,short frame_no)
{
	short pointNo = polygonData[polyNo].firstPoint;
	short ApointNo = animIndex[polygonData[polyNo].animation].frame[frame_no];
	short pointNum = 0;

	while (pointNo != -1) {
		if (pointData[pointNo].selectFlag == 1) {
			AllFrameDataScale(polyNo,pointNum);
		}
		pointNo = pointData[pointNo].nextPoint;
		ApointNo = animPoint[ApointNo].nextPoint;
		pointNum++;
	}


}
/************************************************************************************
		|S̃f[^Aj[Ṽf[^
*************************************************************************************/
extern void AnimPolyDataMove(short polyNo,short frame_no)

{
	ControlPtr allctrl = GetControlPtr(animWindow,10);
	short pointNo = polygonData[polyNo].firstPoint;
	short ApointNo = animIndex[polygonData[polyNo].animation].frame[frame_no];
	int all_switch = GetCtrlValue(allctrl);

	if (all_switch == 1) {
		if (editFlag == 31) AllAnimPolyDataMove (polyNo,frame_no);  /*move*/
		if (editFlag ==  4) AllAnimPolyDataScale(polyNo,frame_no);  /*rotate*/
		if (editFlag ==  5) AllAnimPolyDataScale(polyNo,frame_no);  /*scale*/
	}
	else {
		while (pointNo != -1) {
			if (pointData[pointNo].selectFlag == 1) {
				animPoint[ApointNo].pointx = pointData[pointNo].pointx;
				animPoint[ApointNo].pointy = pointData[pointNo].pointy;
				animPoint[ApointNo].pointz = pointData[pointNo].pointz;
			}
			pointNo = pointData[pointNo].nextPoint;
			ApointNo = animPoint[ApointNo].nextPoint;
		}
	}

}

/************************************************************************************
		Aj[Ṽf[^폜
*************************************************************************************/
static void AnimDelData(AnimTa,frame_no)
short AnimTa;
short frame_no;
{
	short point_No = animIndex[AnimTa].frame[frame_no];
	short be_point;

	while (point_No != -1) {
		animPoint[point_No].flags = 0;
		be_point = point_No;
		point_No = animPoint[point_No].nextPoint;
		animPoint[be_point].nextPoint = -1;
	}
	
	animIndex[AnimTa].frame[frame_no] = -1;
}

/*************************************************************************************
			_CAÔd
*************************************************************************************/
static void Animexpose(event,wcore)
XEventPtr event;
WCorePtr wcore;
{
	WindowPtr window = (WindowPtr)wcore;

	String message = "t[߂Ă";

	if (event->type == Expose) {
		PrintText(window,10,30,1,&message);
	}

}	
/***************************************************************************************
					_CAO
****************************************************************************************/
static int AnimaDialog(frame_num,tenkey)
int frame_num;
int tenkey;
{
	WindowPtr window = NewApplWindow((topLevel.window.width-300),30,300,100,"",0x00,(long)window,Animexpose);
	TxEditPtr txedit = CreateTextEdit(window,150,60,40,20,"0",(long)1,FilterFunc);
	char string[10];
	int flag;
	
	tenkeyMax = tenkey+1;
	sprintf(string,"%d",frame_num);
	SetTxEditString(txedit,string);

	XSelectInput(display,GetWindowID(window),ExposureMask);
	ShowApplWindow(window);

	SetWindowRefCon(tenKeyWindow,(long)window);

	if ((flag = ModalDialog(tenKeyWindow)) == 1) {
		GetTxEditString(txedit,string);
		frame_num = atoi(string);
	}
		DisposeApplWindow(window);
		HighCloseTenKey();
		tenkeyMax = 0;

	return (frame_num);
}

/***************************************************************************************
***************************************************************************************
					t[`
****************************************************************************************/
static WriteFrameNumber(window)
WindowPtr window;
{
	char str[10];
	String string;

	XClearArea(display,GetWindowID(window),10,3,40,13,False);
	sprintf(str,"%d",maxFrame);
	string = str;
	PrintText(window,10,15,1,&string);

}
/************************************************************************************
		Aj[V̓o^
*************************************************************************************/
static void AnimDesignCpy(last_frame)
short last_frame;
{

	short i,k;
	short polyNo;


  for (polyNo=0; polyNo<POLYGONNUMBER; polyNo++) {
	if (polygonData[polyNo].flags != 0) {
		if (polygonData[polyNo].animation == -1) {
			for (i=0; i<INDEX_NUMBER; i++) {
				if (animIndex[i].flag == 0) {
					animIndex[i].flag = 1;
					polygonData[polyNo].animation = i;
					break;
				}
			}
		}

		if (last_frame < maxFrame) {
			for (k=last_frame; k<maxFrame; k++) animIndex[polygonData[polyNo].animation].frame[k] = AnimPolygonCpy(polyNo);
		}
		else {
			for (k=last_frame; k>=maxFrame; k--) AnimDelData(polygonData[polyNo].animation,k);
    	}
	}

  }
}
/***************************************************************************************
					t[߂
****************************************************************************************/
static void SetFrameNumber(event,wcore)
XEventPtr event;
WCorePtr wcore;
{

	WindowPtr window = (WindowPtr) wcore;
	short last_frame = maxFrame;

	maxFrame = AnimaDialog(maxFrame,64);
	if (maxFrame == 0 ) maxFrame = 1;

	SetCtrlMaxval(animScr,maxFrame-1);
	SetCtrlValue(animScr,0);
	WriteFrameNumber(window);

	AnimDesignCpy(last_frame);

	frameNo = 0;
	WriteNowFrame();


}
/***************************************************************************************
					t[̃Cxg		it[j
****************************************************************************************/
static void FrameNumberEvent(event,wcore)
XEventPtr event;
WCorePtr wcore;
{
	WindowPtr window = (WindowPtr) wcore;

	switch (event->type ) {
		case Expose      : WriteFrameNumber(window); break;
		case ButtonPress : SetFrameNumber(event,wcore);

	}
}
/****************************************************************************************/




/*************************************************************************************
			t[ړɂf[^̏
*************************************************************************************/
static void WriteAnimPolygonData(frame_no)
short frame_no;
{
	short i;
	short APointNo,pointNo;

	for (i=0; i<POLYGONNUMBER; i++) {
		if (polygonData[i].flags != 0 && polygonData[i].animation != -1) {
			APointNo = animIndex[polygonData[i].animation].frame[frame_no];
			pointNo  = polygonData[i].firstPoint;

				while (pointNo != -1) {
					pointData[pointNo].pointx = animPoint[APointNo].pointx;
					pointData[pointNo].pointy = animPoint[APointNo].pointy;
					pointData[pointNo].pointz = animPoint[APointNo].pointz;
					pointNo = pointData[pointNo].nextPoint;
					APointNo = animPoint[APointNo].nextPoint;
				}
			PolygonSideCheck(i);
		}
	}


}

/*************************************************************************************
			t[ړɂ`
*************************************************************************************/
static void WriteAnimPolygon()
{
	short i;

	WriteAnimPolygonData(frameNo);

	for (i=0; i<3; i++) {
		WriteEditScreen(&designWinInfo[i]);
		WriteForeScreen(&designWinInfo[i]);
		DrawDesignContents(&designWinInfo[i],14);
	}
	Draw3DWindow();

}
/***************************************************************************************
					擪t[ւ̈ړ
****************************************************************************************/
static void MoveTopFrame(ctrl,code)
ControlPtr ctrl;
int code;
{
	SetCtrlValue(animScr,0);

	DrawControl(animScr);
	frameNo = 0;
	WriteNowFrame();

	WriteAnimPolygon();

}
/***************************************************************************************
					Õt[ւ̈ړ
****************************************************************************************/
static void MoveBeforeFrame(ctrl,code)
ControlPtr ctrl;
int code;
{
	short i;

	if (frameNo > 0) frameNo = GetCtrlValue(animScr) - 1;
	else {	if (frameNo == 0) frameNo = maxFrame - 1;  }

	SetCtrlValue(animScr,frameNo);
	DrawControl(animScr);
	WriteNowFrame();

	WriteAnimPolygon();

}
/***************************************************************************************
					̃t[ւ̈ړ
****************************************************************************************/
static void MoveNextFrame(ctrl,code)
ControlPtr ctrl;
int code;
{
	short i;

	if (frameNo < maxFrame -1) frameNo = GetCtrlValue(animScr) + 1;
	else {	if (frameNo == maxFrame-1) frameNo = 0;       }

	SetCtrlValue(animScr,frameNo);
	DrawControl(animScr);
	WriteNowFrame();

	WriteAnimPolygon();
}
/***************************************************************************************
					ŏIt[ւ̈ړ
****************************************************************************************/
static void MoveLastFrame(ctrl,code)
ControlPtr ctrl;
int code;
{
	SetCtrlValue(animScr,maxFrame-1);
	DrawControl(animScr);
	frameNo = maxFrame-1;
	WriteNowFrame();

	WriteAnimPolygon();
}


/***************************************************************************************
					t[XN[o[ł̈ړ
****************************************************************************************/
static void SetScrollBar(ctrl)
ControlPtr ctrl;
{
	int scr_value = GetCtrlValue(ctrl);

	if (scr_value == -1)       {scr_value = maxFrame-1; ctrl->value = maxFrame-1;}
	if (scr_value == maxFrame) {scr_value = 0; ctrl->value = 0;}

	frameNo = scr_value;
	DrawControl(animScr);
	WriteNowFrame();

	WriteAnimPolygon();
}
/***************************************************************************************
					t[XN[o[
****************************************************************************************/
static void FrameScrollBar(ctrl,code)
ControlPtr ctrl;
int code;
{
	switch (code) {
		case 0: 				  SetScrollBar(ctrl);  break;
		case 1: ctrl->value -= 1; SetScrollBar(ctrl);  break;
		case 2: ctrl->value += 1; SetScrollBar(ctrl);  break;
		case 3: ctrl->value -= 1; SetScrollBar(ctrl);  break;
		case 4: ctrl->value += 1; SetScrollBar(ctrl);  break;
	}

	XFlush(display);
	XSync(display,0);

}


/***************************************************************************************
					t[[vifnj
****************************************************************************************/
static void WarpFrame(ctrl,code)
ControlPtr ctrl;
int code;
{

	frameNo = AnimaDialog(frameNo,maxFrame-1);
	SetCtrlValue(animScr,frameNo);
	WriteNowFrame();

	WriteAnimPolygon();
}










/****************************************************************************************/

/************************************************************************************
		 t@C[hƂ̃Aj[Vt[Ȃǂ̓o^
*************************************************************************************/
extern void AnimLoadData()
{
	ControlPtr frameNum = GetControlPtr(animWindow,1);
	WindowPtr window = (WindowPtr) frameNum;
	short i,k;

	for (i=0; i<INDEX_NUMBER; i++) {
		if (animIndex[i].flag == 1) {
			for (k=0; k<FRAMENUM; k++) {
				if (animIndex[i].frame[k] == -1) {
						maxFrame = k;
						break;
				}
			}
			break;
		}
	}

	SetCtrlMaxval(animScr,maxFrame-1);
	frameNo = 0;
	SetCtrlValue(animScr,0);
	WriteFrameNumber(window);
	WriteAnimPolygon();

}

/************************************************************************************
		 Aj[Vf[^̃Rs[
				it[̃Rs[Ȃǁj
*************************************************************************************/
static short AnimDataCpy(animTable,frame_no)
short animTable,frame_no;
{
	short pointNo = animIndex[animTable].frame[frame_no];
	short firstPoint = -2;
	short root_point = -2;
	short i;


	while (pointNo != -1) {
		for (i=0; i<ANPOINTNUM; i++) {
			if (animPoint[i].flags == 0) {
				animPoint[i].flags = 1;
				if (firstPoint == -2) firstPoint = i;
				animPoint[i].nextPoint = -1;
				if (root_point != -2) animPoint[root_point].nextPoint = i;
				root_point = i;
				animPoint[i].pointx = animPoint[pointNo].pointx;
				animPoint[i].pointy = animPoint[pointNo].pointy;
				animPoint[i].pointz = animPoint[pointNo].pointz;
				break;
			}
		}
		pointNo = animPoint[pointNo].nextPoint;
	}

	return (firstPoint);
}

/************************************************************************************
		 Aj[Vf[^̃Rs[iWύXj
*************************************************************************************/
static short AnimCordCpy(animTable,frame_no,cpFrame_no)
short animTable,frame_no,cpFrame_no;
{
	short pointNo = animIndex[animTable].frame[frame_no];
	short cpPointNo = animIndex[animTable].frame[cpFrame_no];

	while (pointNo != -1) {
		animPoint[cpPointNo].pointx = animPoint[pointNo].pointx;
		animPoint[cpPointNo].pointy = animPoint[pointNo].pointy;
		animPoint[cpPointNo].pointz = animPoint[pointNo].pointz;
		
		pointNo = animPoint[pointNo].nextPoint;
		cpPointNo = animPoint[cpPointNo].nextPoint;
	}

}		

/************************************************************************************
		 t[̃Rs[
*************************************************************************************/
static void AnimCopyEvent(ctrl,code)
ControlPtr ctrl;
int code;
{
	short frame_No,i;
	char *Message = "㏑ĂłH";

	frame_No = AnimaDialog(frameNo,maxFrame-1);

	for (i=0; i<INDEX_NUMBER; i++) {
		if (animIndex[i].flag == 1) {
			if (animIndex[i].frame[frame_No] == -1) animIndex[i].frame[frame_No] = AnimDataCpy(i,frameNo);
			else									AnimCordCpy(i,frameNo,frame_No);
		}
	}

			/*if (animIndex[i].frame[frame_No] != -1) {*/
			/*	if ((AlertDialog(150,150,400,100,1,2,1,&Message)) == 1) {*/

}
/************************************************************************************
		 t[̕Rs[
*************************************************************************************/
static void PartAnimCpy(ctrl,code)
ControlPtr ctrl;
int code;
{
	short frame_no,poly_no,i;

	frame_no = AnimaDialog(frameNo,maxFrame-1);

	for (i=0; i<POINTNUMBER; i++) {
		if (pointData[i].flags != 0 && pointData[i].selectFlag == 1) {
			poly_no = PolygonFromPoint(i);
			AnimPolyDataMove(poly_no,frame_no);
		}
	}


}

/************************************************************************************
		 t[̍폜
*************************************************************************************/
static void DeleteFrame(ctrl,code)
ControlPtr ctrl;
int code;
{
	ControlPtr frameNum = GetControlPtr(animWindow,1);
	WindowPtr window = (WindowPtr) frameNum;
	short frame_num;
	short i;
	short posx = GetWindowPosX(animWindow);
	short posy = GetWindowPosY(animWindow);
	char *Message = "폜ĂłH";
	char *Message2 = "ȏ폜ł܂II";

	if (maxFrame == 1) {
		AlertDialog(posx+10,posy+70,400,100,0,2,1,&Message2);
	}
	else {

	if ((AlertDialog(posx+10,posy+70,400,100,1,2,1,&Message)) == 1) {
		maxFrame -= 1;
		for (i=0; i<INDEX_NUMBER; i++) {
			if (animIndex[i].flag == 1) {
				frame_num = frameNo;
				AnimDelData(i,frameNo);
				while (frame_num < maxFrame) {
						animIndex[i].frame[frame_num] = animIndex[i].frame[frame_num +1];
						frame_num++;
				}
				animIndex[i].frame[maxFrame] = -1;
			}
		}
	}
	SetCtrlMaxval(animScr,maxFrame-1);
	if (frameNo >= maxFrame) frameNo--;
	WriteFrameNumber(window);
	WriteNowFrame();

	WriteAnimPolygon();

/*	printf("animIndex0   %d,%d,%d,%d \n ",animIndex[0].frame[0],animIndex[0].frame[1],animIndex[0].frame[2],animIndex[0].frame[3]);
	for (i=0; i<20; i++) printf("animPoint %d ..%d.%d\n",i,animPoint[i].flags, animPoint[i].nextPoint);
*/
   }

}

/************************************************************************************
		 t[̒ǉ
*************************************************************************************/
static void AddFrame(ctrl,code)
ControlPtr ctrl;
int code;
{
	ControlPtr frameNum = GetControlPtr(animWindow,1);
	WindowPtr window = (WindowPtr) frameNum;
	short frame_no;
	short i;

	int frame_number = AnimaDialog(frameNo+1,maxFrame);
	/*printf("%d\n",frame_number);*/


	for (i=0; i<INDEX_NUMBER; i++) {
		if (animIndex[i].flag == 1){
			frame_no = maxFrame;
			while (frame_no > frame_number) {
				animIndex[i].frame[frame_no] = animIndex[i].frame[frame_no - 1];
				frame_no--;
			}
			animIndex[i].frame[frame_number] = AnimDataCpy(i,frameNo);
		}
	}


	maxFrame += 1;
	SetCtrlMaxval(animScr,maxFrame-1);
	WriteFrameNumber(window);
	
}


/************************************************************************************
		 VKȊÔƂ̃|Sǉ
*************************************************************************************/
static void AddAnimPolygon()
{

	short i,k;
	short fNum;

	for (i=0; i<POLYGONNUMBER; i++) {
		if (polygonData[i].flags != 0 && polygonData[i].animation == -1) {
			for (k=0; k<INDEX_NUMBER; k++) {
				if (animIndex[k].flag == 0) {
					animIndex[k].flag = 1;
					polygonData[i].animation = k;
					break;
				}
			}
			
			for (fNum=0; fNum<maxFrame; fNum++) animIndex[k].frame[fNum] = AnimPolygonCpy(i);
		}
	}		

	printf ("%d,,\n",polygonData[1].animation);

}

/************************************************************************************
		Aj[Vp̂tCxg
*************************************************************************************/
static void AnimUndoEvent()
{
	short i;

	UndoEvent();
	
	for (i=0; i<POLYGONNUMBER; i++) {
		if (polygonData[i].animation != -1) AnimPolyDataMove(i,frameNo);
	}

}
/************************************************************************************
		c[EChẼ{^Cxg
*************************************************************************************/
extern void AnimButtonEvent(ctrl,code)
ControlPtr ctrl;
int code;
{
	int buttonNo = (int)ctrl->refCon;

	switch (buttonNo) {
		case  8 : 
#if TransOnOff == 1
				  TransFileSave();
				  TransferEvent(); 	
#endif												
													break;
		case 10 : AnimUndoEvent();					break;
		case 17 : StateEvent();		                break;
		case 18 : CpyToolData();  RSetColor();		break;
	}
}

/************************************************************************************
		Animation Change FirstPoint
*************************************************************************************/
extern void AnimChangeFirstPointEvent(short polyNo,short count)
{
	short i,k;
	short polyNum = polygonData[polyNo].npoints;
	short index = polygonData[polyNo].animation;
	short first_num = polyNum - (count+1); 
	short first_point;
	short befo_point;
	short last_point;
	short apoint;

	for (i=0; i<FRAMENUM; i++) {
		if (animIndex[index].frame[i] != -1 ) {
			count = first_num;
			apoint = animIndex[index].frame[i];
			for (k=0; k<count; k++) { 
				befo_point = apoint;
				apoint = animPoint[apoint].nextPoint;
				first_point = apoint;
			}

			while (apoint != -1) {
				last_point = apoint;
				apoint = animPoint[apoint].nextPoint;
			}
			animPoint[last_point].nextPoint = animIndex[index].frame[i];
			animPoint[befo_point].nextPoint = -1;
			animIndex[index].frame[i] = first_point;
		}
	}

}
/***************************************************************************************/
/***************************************************************************************
					RcAj[V
****************************************************************************************/
static void ViewAnimation(ctrl,code)
ControlPtr ctrl;
int code;
{
	XEvent event;
	WCorePtr wcore;
	WindowPtr animWindow = (WindowPtr) ctrl->refCon;
	ControlPtr stopCtrl = GetControlPtr(animWindow,16);
	ControlPtr toggle = GetControlPtr(animWindow,11);
	Window windowID = (Window) stopCtrl->window.windowID;
	short i;
	short frame_no = 0;
	int betime = TickCount();
	int time;


	while (GetCtrlValue(ctrl) == 1) {

		if (XCheckMaskEvent(display,0xffffffff,&event) !=0) {
			XFindContext(display,event.xany.window,eventContext,(caddr_t*)&wcore);
		
			if (event.type == KeyPress  	||
				event.type == KeyRelease	||
				event.type == ButtonPress	||
				event.type == ButtonRelease ||
				event.type == MotionNotify		) {
				
				if (event.xany.window == windowID) {
					(*wcore->eventProc)(&event,wcore);
				}
			}
			else {
					(*wcore->eventProc)(&event,wcore);
			}
		}
		else {
			time = TickCount();				/*^C}[荞*/
			if (time >= betime +300){

				WriteAnimPolygonData(frame_no);
				Draw3DWindow();
				frame_no++;
				if (frame_no == maxFrame) {
					if (GetCtrlValue(toggle) == 1) frame_no = 0;
					else 						   SetCtrlValue(ctrl,0);
				}
				betime = TickCount();
			}

		}

	}

			WriteAnimPolygonData(frameNo);					/*ɖ߂*/
			Draw3DWindow();

}

/***************************************************************************************
					RcAj[VXgbv
****************************************************************************************/
static void ViewStopAnimation(ctrl,code)
ControlPtr ctrl;
int code;
{
	ControlPtr Sctrl = (ControlPtr) ctrl->refCon;

	SetCtrlValue(Sctrl,0);

}

/***************************************************************************************/
/***************************************************************************************
					Aj[VEChE߂
****************************************************************************************/
static void CloseAnimWindow(ctrl,code)
ControlPtr ctrl;
int code;
{
	WindowPtr window = (WindowPtr) ctrl->refCon;
	char *Message = "Aj[VI܂H";
	int px,py;

	/**i\ɗ悤ɐݒj **/
	px = (topLevel.window.width - 300)/2;
	py = (topLevel.window.height - 80)/2;

	if (AlertDialog(px,py,300,80,1,1,1,&Message) == 1) {
		HideApplWindow(window);
		animationFlag = 0;
		AnimSaveInit();

		EnableMenuItem(margeMenu,2,1);		/*}[Wgp֎~ɉ*/
		EnableMenuItem(margeMenu,3,1);
	 	EnableMenuItem(margeMenu,4,1);
	}

}

/***************************************************************************************
					Aj[VEChÊ
****************************************************************************************/
static void AnimationWindowExpose(event,wcore)
XEventPtr event;
WCorePtr wcore;
{
	WindowPtr window = (WindowPtr) wcore;
	char str[10];
	String string;
	String string2 = "݂̃t[  No";

	if (event->type == Expose) {
		XDrawLine(display,GetWindowID(window),systemGPort,0,28,430,28);
		XSetLineAttributes(display,systemGPort,3,LineSolid,CapButt,JoinMiter);
		XDrawRectangle(display,GetWindowID(window),systemGPort,18,48,177,51);
		XSetLineAttributes(display,systemGPort,1,LineSolid,CapButt,JoinMiter);
		sprintf(str,"%d",frameNo);
		string = str;
		PrintText(window,5,25,1,&string2);
		PrintText(window,140,25,1,&string);
	}
}

/***************************************************************************************
					Aj[VEChE
****************************************************************************************/
extern WindowPtr MakeAnimationWin()
{
	WindowPtr window = NewApplWindow(CADWIDTH/2-165,CADHEIGHT/2-175,430,150,"",0x11,NULL,AnimationWindowExpose);
	ControlPtr frameNum = CreateSubWindow (window,313,30,30,20,3,NULL,FrameNumberEvent);		 /*frame Number*/
	ControlPtr Sctrl,STctrl;

	animScr = CreateScrollBar (window,20,125,320,15,0,64,0,NULL,FrameScrollBar);

	CreatePictButton(window,20,50,24,48,animIcons[1],0,0,MoveTopFrame);         /*top*/
	CreatePictButton(window,44,50,24,48,animIcons[0],0,0,NULL);         		/*bef*/
	CreatePictButton(window,68,50,24,48,animIcons[2],0,0,MoveBeforeFrame);      /*before*/
	CreatePictButton(window,92,50,30,48,animIcons[3],0,0,WarpFrame);         		/*go*/
	CreatePictButton(window,122,50,24,48,animIcons[4],0,0,MoveNextFrame);       /*next*/
	CreatePictButton(window,146,50,24,48,animIcons[5],0,0,NULL);         		/*nex*/
	CreatePictButton(window,170,50,24,48,animIcons[1],0,0,MoveLastFrame);       /*top*/


	CreatePushSwitch(window,210,35,60,20,"AllMove",0,NULL);					    /*AllMove*/
/*	CreatePictSwitch(window,218,30,30,20,animIcons[6],3,0,NULL);         		/*k+*/
/*	CreatePictButton(window,263,30,30,20,animIcons[7],3,0,NULL);		 		/*k-*/
	CreatePictSwitch(window,365,30,48,20,animIcons[11] ,3,0,NULL);		 		/*togru*/

	CreatePushButton(window,210,65,60,20,"Add ",0,AddFrame);					/*ADD*/
	CreatePushButton(window,210,90,60,20,"delete",0,DeleteFrame);				/*partsCopy*/
	CreatePushButton(window,280,65,70,20,"AllCopy",0,AnimCopyEvent);			/*copy*/
	CreatePushButton(window,280,90,70,20,"PartCopy",0,PartAnimCpy);				/*partsCopy*/
	
	STctrl = CreatePictButton(window,365,65,24,48,animIcons[1],3,0,ViewStopAnimation);		 		/*stop*/
	Sctrl = CreatePictSwitch(window,389,65,24,48,animIcons[4],3,0,ViewAnimation);		 		/*saisei*/

	CreatePushButton(window,365,123,48,24,"end",(long)window,CloseAnimWindow); /*end*/


	XSelectInput(display,GetWindowID(window), ExposureMask);
	
	XSelectInput(display,GetWindowID(frameNum),
		ExposureMask|ButtonPressMask);

	STctrl->refCon = (long)Sctrl;
	Sctrl->refCon = (long)window;


	return(window);
}
/***************************************************************************************
					Aj[VEChE
****************************************************************************************/
extern void ShowAnimation(item)
MItemPtr item;
{
	char *Message = "VKŃAj[V쐬܂H";
	static char *buttonTitle[] = {"YES","NO","CANCEL"};
	int dialog;


	dialog = AlertDialog2(150,150,400,100,1,3,buttonTitle,1,&Message);

	switch (dialog) {
		 case 1: AnimationClear();
				 AnimDesignCpy(0);
				 break;
		 case 2: AddAnimPolygon;
				 break;
		 case 3: return;
	}

	 animationFlag = 1;
     AnimSaveInit();
	 ShowApplWindow(animWindow);

	 EnableMenuItem(margeMenu,2,0);		/*}[Wgp֎~ɂ*/
	 EnableMenuItem(margeMenu,3,0);
	 EnableMenuItem(margeMenu,4,0);
}
	





