/************************************************************************************
			|CgACÑCxgvO
											by Daiki Iwamoto
*************************************************************************************/
#include <stdio.h>
#include <ctype.h>
#include <math.h>
#include <X11/cursorfont.h>   /*J[\̃tHg̃wb_t@C*/
#include "ToolBox.h"
#include "External.h"
#include "Prototype.h"
#include "caduser"

Point pointData[POINTNUMBER];
Polygon polygonData[POLYGONNUMBER];
Object objectData[OBJNUMBER];

short creatingPoint = -1;
short newPoint = -1;
short drawFlag = -1;
short pointNum = 0;
short firsPoint = -1;

short reverseFlag = 0;				/*`Ƃ̃tO*/

short rootPolygon = -1;
short newPolygon = -1;

extern void DrawDragPointLine(void);

int beposx,beposy;
int beforeX,beforeY;

static struct pointList{
		short flag;
		short list;
       } Plist[16];

static short poly_list[16];
static short npoly_points;
short nlists = 0;



/************************************************************************************
		xł̒r[߂

*************************************************************************************/
extern void ReturnPoint()
{
	pointData[creatingPoint].nextPoint = -2;
	newPoint = creatingPoint;
	pointNum--;
	drawFlag = -1;
	
}

/*************************************************************************************
			_dɑłĂȂ̃`FbN
*************************************************************************************/
static void DoublePointCheck(short point)
{

	short point_no = firsPoint;
	short forePoint;

	while (point_no != -2) {
		if (Convert(pointData[point].pointx) == Convert(pointData[point_no].pointx) &&
			Convert(pointData[point].pointy) == Convert(pointData[point_no].pointy) &&
			Convert(pointData[point].pointz) == Convert(pointData[point_no].pointz) &&
			point != point_no														) {

			DeleteNopolygonPointData(point);
			break;
		}

		point_no = pointData[point_no].nextPoint;
	}	
	

}
/*************************************************************************************
			ZNg_ŕʃ`FbN
*************************************************************************************/
static short SelectFlatPolygon2(void)
{
	short i,k;
	short temp_lists[20];
	short check = 1;
	short point;
	short chPoint = newPoint;

	for (i=0; i<pointNum-1; i++) {
		point = firsPoint;
		k = 0;
		while (k!= i) {
			temp_lists[k] = point;
			point = pointData[point].nextPoint;
			k++;
		}
		temp_lists[k] = newPoint;
		while (k!= pointNum-1) {
			temp_lists[k+1] = point;
			point = pointData[point].nextPoint;
			k++;
		}
		
		if ((check = PolygonFlatCheck(temp_lists,pointNum) ) == 0) {
			if (i == 0) firsPoint = temp_lists[0];
			else 		pointData[temp_lists[i-1]].nextPoint = newPoint;
			if (i == pointNum) pointData[newPoint].nextPoint = -2;
			else 			 pointData[newPoint].nextPoint = temp_lists[i+1];
			pointData[newPoint].flags  = 1;
			pointData[newPoint].selectFlag = 1;
			for (i=0; i<3; i++) PointDesignWindow(&designWinInfo[i],'E',newPoint);
	
			newPoint = temp_lists[pointNum-1];
			pointData[newPoint].nextPoint = -2;
			creatingPoint = newPoint;

			DoublePointCheck(chPoint);							/*dłh*/

			break;
		}

	}

	return(check);
}			


/*************************************************************************************
			ZNg_ŕʃ`FbN
*************************************************************************************/
static void SelectFlatPolygon(int windowNo)
{
	char *Message = "ʂ쐬ł܂!!\n̓_͖ɂ܂";
	short i;
	short alertflag = 0;
	short temp_point;
	int check = 0;
	int support = GetMenuMark(optionMenu,5);


    short nextpoint = pointData[firsPoint].nextPoint;
	double x1 = pointData[firsPoint].pointx;
	double y1 = pointData[firsPoint].pointy;
	double z1 = pointData[firsPoint].pointz;
	double x2 = pointData[nextpoint].pointx;
	double y2 = pointData[nextpoint].pointy;
	double z2 = pointData[nextpoint].pointz;
	double x3,y3,z3;
	double A,B,C,D;
	double x = pointData[newPoint].pointx;
	double y = pointData[newPoint].pointy;
	double z = pointData[newPoint].pointz;

	nextpoint = pointData[nextpoint].nextPoint;
	x3 = pointData[nextpoint].pointx;
	y3 = pointData[nextpoint].pointy;
	z3 = pointData[nextpoint].pointz;

	A = (y2-y1)*(z3-z2)-(z2-z1)*(y3-y2);	  /*ʂ̕߂*/
	B = (z2-z1)*(x3-x2)-(x2-x1)*(z3-z2);	  /*`{a{b{cO*/
	C = (x2-x1)*(y3-y2)-(y2-y1)*(x3-x2);
	D = -(A*x3 + B*y3 + C*z3);

	if (support  == 1) {

		switch(windowNo) {
			case 0 : if (B != 0 ) pointData[newPoint].pointy = (-(A*x+C*z+D)/B);
					else		 alertflag = 1;
					break;
			case 1 : if (C != 0 ) pointData[newPoint].pointz = (-(A*x+B*y+D)/C);
					else		 alertflag = 1;
					break;
			case 2 : if (A != 0 ) pointData[newPoint].pointx = (-(B*y+C*z+D)/A);
					else		  alertflag = 1;
					break;
		}
	}
	else {
		if (drawFlag == -1) {
			drawFlag = windowNo;
			return;
		}
		else drawFlag = -1;
	}

	if (alertflag == 1 || (check = SelectFlatPolygon2()) == 1) {
		AlertDialog(50,20,300,80,0,3,1,&Message);
		newPoint = creatingPoint;
		pointNum--;
		ButtonNoCheck(-1);							/*}EX̃{^*/
		for (i=0; i<3; i++)	  WriteEditScreen(&designWinInfo[i]);
	}

}






/*************************************************************************************
			gbvr[ł̂oCxg
*************************************************************************************/
static void TopViewEvent(event,design)
XEventPtr event;
DesignPtr design;
{
	int X,Y,hZ,wZ,i;
	int support = GetMenuMark(optionMenu,5);
	

	if (drawFlag == -1) {
		pointData[newPoint].pointx = ConvInt(design,event->xbutton.x,1);
		pointData[newPoint].pointz = ConvInt(design,event->xbutton.y,2);

		if (pointNum < 4) {
			if (creatingPoint != -1) pointData[creatingPoint].nextPoint = newPoint;
			drawFlag = 0;
		}
		else SelectFlatPolygon(TOP_VIEW);
	}
	else {

	if (drawFlag == 0) {
		pointData[newPoint].pointy = 0;
		for (i=0; i<3; i++) PointDesignWindow(&designWinInfo[i],'E',newPoint);
	}
	if (drawFlag == 1) {
		pointData[newPoint].pointz = ConvInt(design,event->xbutton.y,2);
		for (i=0; i<3; i++) PointDesignWindow(&designWinInfo[i],'E',newPoint);
	}

	if (drawFlag == 2) {
		pointData[newPoint].pointx = ConvInt(design,event->xbutton.x,1);
		for (i=0; i<3; i++) PointDesignWindow(&designWinInfo[i],'E',newPoint);
	}

	if (support == 0 && pointNum > 3) SelectFlatPolygon(TOP_VIEW);
	else {
		if (firsPoint == -1) firsPoint = newPoint;
		pointData[newPoint].flags  = 1;
		pointData[newPoint].selectFlag = 1;
		pointData[newPoint].nextPoint = -2;
		creatingPoint = newPoint;
		drawFlag = -1;
		DoublePointCheck(newPoint);
	}
	}

}

/*************************************************************************************
			tgr[ł̂oCxg

*************************************************************************************/
static void FrontViewEvent(event,design)
XEventPtr event;
DesignPtr design;
{
	int X,Y,wZ,hZ,i;
	int support = GetMenuMark(optionMenu,5);

	if (drawFlag == -1) {
		pointData[newPoint].pointx = ConvInt(design,event->xbutton.x,1);
		pointData[newPoint].pointy = ConvInt(design,event->xbutton.y,2);


		if (pointNum < 4) {
				if (creatingPoint != -1) pointData[creatingPoint].nextPoint = newPoint;
				drawFlag = 1;
		}
		else 	SelectFlatPolygon(FRONT_VIEW);

	}

	else {

	if (drawFlag == 1) {
		pointData[newPoint].pointz = 0;
		for (i=0; i<3; i++) PointDesignWindow(&designWinInfo[i],'E',newPoint);
	}

	if (drawFlag == 0) {
		pointData[newPoint].pointy = ConvInt(design,event->xbutton.y,2);
		for (i=0; i<3; i++) PointDesignWindow(&designWinInfo[i],'E',newPoint);
	}

	if (drawFlag == 2) {
		pointData[newPoint].pointx = ConvInt(design,event->xbutton.x,1);
		for (i=0; i<3; i++) PointDesignWindow(&designWinInfo[i],'E',newPoint);
	}

	if (support == 0 && pointNum > 3) SelectFlatPolygon(FRONT_VIEW);
	else {
		if (firsPoint == -1) firsPoint = newPoint;
		pointData[newPoint].flags  = 1;
		pointData[newPoint].selectFlag = 1;
		pointData[newPoint].nextPoint = -2;
		creatingPoint = newPoint;
		drawFlag = -1;
		DoublePointCheck(newPoint);
	}
	}
}

/*************************************************************************************
			Cgr[ł̂oCxg

*************************************************************************************/
static void RightViewEvent(event,design)
XEventPtr event;
DesignPtr design;
{
	int X,Y,wZ,hZ,i;
	int support = GetMenuMark(optionMenu,5);

	if (drawFlag == -1) {
		pointData[newPoint].pointz = ConvInt(design,event->xbutton.x,1);
		pointData[newPoint].pointy = ConvInt(design,event->xbutton.y,2);

		if (pointNum < 4) {
				if (creatingPoint != -1) pointData[creatingPoint].nextPoint = newPoint;
				drawFlag = 2;
		}
		else  SelectFlatPolygon(RIGHT_VIEW);
	}

	else {

	if (drawFlag == 2) {
		pointData[newPoint].pointx = 0;
		for (i=0; i<3; i++) PointDesignWindow(&designWinInfo[i],'E',newPoint);
	}

	if (drawFlag == 0) {
		pointData[newPoint].pointy = ConvInt(design,event->xbutton.y,2);
		for (i=0; i<3; i++) PointDesignWindow(&designWinInfo[i],'E',newPoint);
	}

	if (drawFlag == 1) {
		pointData[newPoint].pointz = ConvInt(design,event->xbutton.x,1);
		for (i=0; i<3; i++) PointDesignWindow(&designWinInfo[i],'E',newPoint);
	}

	if (support == 0 && pointNum > 3) SelectFlatPolygon(RIGHT_VIEW);
	else {
		if (firsPoint == -1) firsPoint = newPoint;
		pointData[newPoint].flags  = 1;
		pointData[newPoint].selectFlag = 1;
		pointData[newPoint].nextPoint = -2;
		creatingPoint = newPoint;
		drawFlag = -1;
		DoublePointCheck(newPoint);
	}
	}
}

/*************************************************************************************
			oCxg
*************************************************************************************/
extern void PointEvent(event,wcore)
XEventPtr event;
WCorePtr wcore;
{
	ControlPtr ctrl = (ControlPtr)wcore;
	DesignPtr design = (DesignPtr)ctrl->refCon;
	int i;

	XSetForeground(display,bitmapGC,1);	  /*			*/
	XSetLineAttributes(display,bitmapGC,5,LineSolid,CapRound,JoinRound);

	if (drawFlag == -1) {		/*_i[ꏊT*/
		for (i=0; i<POINTNUMBER; i++) {
			if (pointData[i].flags == 0) {newPoint = i; pointNum++; break;}
		}
	}

	switch (design->windowNo)  {
		case 0: TopViewEvent(event,design);	  break;
		case 1: FrontViewEvent(event,design); break;
		case 2: RightViewEvent(event,design); break;
	}
	

	for (i=0; i<3; i++)	  DrawDesignContents(&designWinInfo[i],8);
	
	if (centerLineWin != -1) PointerLineEvent(event,wcore,event->xbutton.x,event->xbutton.y);

}


/*************************************************************************************
			fUCEChEɃ|S̐`(|Sʁj
*************************************************************************************/
static void DesignPolygonLine(design,polygonNo,startPoint,endPoint)
DesignPtr design;
short polygonNo;
short startPoint,endPoint;
{
	char flag;

	switch (design->windowNo) {			/*ǂ𔻕ʂ*/
		case 0 : flag = 0x01; break;
		case 1 : flag = 0x02; break;
		case 2 : flag = 0x04; break;
	}

	if (reverseFlag == 1) {
		XSetLineAttributes(display,bitmapGC,2,LineSolid,CapButt,JoinMiter);	/*MakePolygonLine Size flag*/
		if (flag & polygonData[polygonNo].side) 	
			DesignLine(design,design->editScreen,startPoint,endPoint);
		else															
			DesignLine(design,design->foreScreen2,startPoint,endPoint);

	}
	else	{
	    XSetLineAttributes(display,bitmapGC,0,LineSolid,CapButt,JoinMiter);
		DesignLine(design,design->editScreen,startPoint,endPoint);
	}

}

/*************************************************************************************
			fUCEChEɃ|S`

*************************************************************************************/
extern void DrawPolygon(int polygonNo,char screenName)

{
	int i;
	short startPoint = polygonData[polygonNo].firstPoint;
	short pointNum = polygonData[polygonNo].npoints;
	short endPoint;

	XSetForeground(display,bitmapGC,1);	  /*			*/

  while ( pointNum > 1) {
	endPoint = pointData[startPoint].nextPoint;
	for (i=0; i<3; i++)	 {
		if (screenName == 'E')	{
			DesignPolygonLine(&designWinInfo[i],polygonNo,startPoint,endPoint);
			XSetLineAttributes(display,bitmapGC,4,LineSolid,CapRound,JoinRound);
			PointDesignWindow(&designWinInfo[i],'E',startPoint);
		}
		else			{
			XSetLineAttributes(display,bitmapGC,0,LineSolid,CapButt,JoinMiter);
			DesignLine(&designWinInfo[i],designWinInfo[i].foreScreen,startPoint,endPoint);
			XSetLineAttributes(display,bitmapGC,4,LineSolid,CapRound,JoinRound);
			PointDesignWindow(&designWinInfo[i],'F',startPoint);
		}
	}
	startPoint = endPoint;
	pointNum--;
  }

	for(i=0; i<3; i++)	{
		if (screenName == 'E')		{
			DesignPolygonLine(&designWinInfo[i],polygonNo,startPoint,polygonData[polygonNo].firstPoint);
			XSetLineAttributes(display,bitmapGC,4,LineSolid,CapRound,JoinRound);
			PointDesignWindow(&designWinInfo[i],'E',startPoint);
		}
		else					{
			XSetLineAttributes(display,bitmapGC,0,LineSolid,CapButt,JoinMiter);
			DesignLine(&designWinInfo[i],designWinInfo[i].foreScreen,startPoint,polygonData[polygonNo].firstPoint);
			XSetLineAttributes(display,bitmapGC,4,LineSolid,CapRound,JoinRound);
			PointDesignWindow(&designWinInfo[i],'F',startPoint);
		}
	}


}


/*************************************************************************************
			lCxg

*************************************************************************************/
extern void MakeEvent()

{
	int i,point;

	pointData[newPoint].nextPoint = -1;
	creatingPoint = -1;

	for (i=0; i<POLYGONNUMBER; i++) {
			if(polygonData[i].flags == 0) {newPolygon = i; break;}
	}
	polygonData[newPolygon].flags = 1;

	if (rootPolygon == -1) {
		objectData[0].firstPolygon = newPolygon;
		objectData[0].flags = 1;
	}
	else polygonData[rootPolygon].nextPolygon = newPolygon;

	rootPolygon = newPolygon;

	polygonData[newPolygon].nextPolygon = -1;
	polygonData[newPolygon].npoints = pointNum;
	polygonData[newPolygon].firstPoint = firsPoint;
	polygonData[newPolygon].animation = -1;
	polygonData[newPolygon].both = -1;				/*Ƃ肠ЖʂɂĂ*/
	PolygonSideCheck(newPolygon);

	point = firsPoint;
	do {
		pointData[point].flags = 2;
		point = pointData[point].nextPoint;
		} while (point != -1);	 /*|CgtOQɂ*/

	firsPoint = -1;
	pointNum = 0;

}


/*************************************************************************************
			|S̃J[̂d

*************************************************************************************/
static void ColorExpose(event,wcore)
XEventPtr event;
WCorePtr wcore;
{
	WindowPtr window = (WindowPtr)wcore;

	String message = "r@o@mI";
	String message1 = "m";

	if (event->type == Expose) {
		PrintText(window,10,30,1,&message);
		PrintText(window,100,77,1,&message1);
	}

}	


/*************************************************************************************
			|S̃J[ݒ肷

*************************************************************************************/
extern short SetColorWindow(short colorNo)

{
	
	WindowPtr window = NewApplWindow((topLevel.window.width-300),30,300,100,"",0x00,(long)window,ColorExpose);
	TxEditPtr colorWindow = CreateTextEdit(window,150,60,40,22,"0",(long)1,FilterFunc);
	char string[50];
	int flag;
	
	sprintf(string,"%d",colorNo);
	SetTxEditString(colorWindow,string);
	
	tenkeyMax = 256;
	XSelectInput(display,GetWindowID(window),ExposureMask);
	ShowApplWindow(window);

	SetWindowRefCon(tenKeyWindow,(long)window);
	if ((flag = ModalDialog(tenKeyWindow)) == 1) {
		GetTxEditString(colorWindow,string);
		colorNo = atoi(string);
	}
	else colorNo = -1;

	DisposeApplWindow(window);
	HighCloseTenKey();
	tenkeyMax = 0;


	return(colorNo);
}
/*************************************************************************************
			l\`FbNEChE

*************************************************************************************/
static short MakeFaceCheck()
{
	char *Message = "ʃ|Sɂ܂H";
	char *Message2 = "\tɂ܂H";
	static char *buttonTitle[] = {"NO","YES","CANCEL"};
	short PPolygon = newPolygon;
	short i,flag;

		flag = AlertDialog2(52,22,300,80,0,3,buttonTitle,1,&Message);/*ʂɂ*/
	if ( flag != 1)  {
			if (flag == 3) return(1);
			MakePolyCopy(newPolygon);
			FaceFlipPolygon(newPolygon);
			polygonData[PPolygon].both = newPolygon;
			polygonData[newPolygon].both = PPolygon;

			PolygonSideCheck(PPolygon);
			for (i=0; i<3; i++) InitEditScreen(&designWinInfo[i]);
			DrawPolygon(PPolygon,'E');
		 	for (i=0; i<3; i++) DrawDesignContents(&designWinInfo[i],14);
			polygonData[PPolygon].color = SetColorWindow(0);			

			PolygonSideCheck(newPolygon);
			for (i=0; i<3; i++) InitEditScreen(&designWinInfo[i]);
			DrawPolygon(newPolygon,'E');
		 	for (i=0; i<3; i++) DrawDesignContents(&designWinInfo[i],14);
			polygonData[newPolygon].color = SetColorWindow(0);
	}
	else  {
		flag = AlertDialog2(52,22,300,80,0,3,buttonTitle,1,&Message2);
		if ( flag != 1)	{
			if (flag == 3) return(1);
			FaceFlipPolygon(newPolygon);
			PolygonSideCheck(newPolygon);

			for (i=0; i<3; i++) InitEditScreen(&designWinInfo[i]);
			DrawPolygon(newPolygon,'E');
		 	for (i=0; i<3; i++) DrawDesignContents(&designWinInfo[i],14);
			
			polygonData[newPolygon].color = SetColorWindow(0);
		}
		else  polygonData[newPolygon].color = SetColorWindow(0);

		polygonData[newPolygon].both = -1;
	}
	
	return(0);
}


/*************************************************************************************
			lCxg`FbN

*************************************************************************************/
extern void MakeCheck()
{

	char *Message = "|S܂!!";
	int px = 50;
	int py = 20;
	int i;
	int check = 0;

	if (editFlag == 1 || editFlag == 31 || editFlag ==4 || editFlag == 5) 
												check = SelectPointForMake();

	if (pointNum <= 1 || check == 1 ) AlertDialog(px,py,300,80,0,3,1,&Message);
	else		{
		MakeEvent();
		reverseFlag = 1;
		DrawPolygon(newPolygon,'E');
		for (i=0; i<3; i++)	DrawDesignContents(&designWinInfo[i],10);

		if (MakeFaceCheck() == 1) {
			UndoEvent(); 
			reverseFlag = 0;
			return;
		}

		reverseFlag = 0;
		
		InitSelectPoint();

		for (i=0; i<3; i++)	 {
			InitEditScreen(&designWinInfo[i]);
			WriteForeScreen(&designWinInfo[i]);
		 	DrawDesignContents(&designWinInfo[i],14);
		}

			Draw3DWindow();

   }
	nlists = 0;

}



/*************************************************************************************




/*************************************************************************************
			zɓ_f[^ɋK
*************************************************************************************/
static void WriteSelectPoint(pointNo)
short pointNo;
{
	short k;

	pointNum++;
	newPoint = pointNo;

	if (firsPoint == -1) firsPoint = newPoint;
	pointData[newPoint].flags = 1;
	pointData[newPoint].selectFlag = 1;
	pointData[newPoint].nextPoint = -2;
	if (creatingPoint != -1) pointData[creatingPoint].nextPoint = newPoint;
	creatingPoint = newPoint;

}

/*************************************************************************************
			ZNg_̃Xgוς
*************************************************************************************/
static int ListSort(int index) 
{
	short count,check;

/*	printf("YY %d---%d\n",npoly_points,Plist[index].list);*/

	poly_list[npoly_points] = Plist[index].list;
	npoly_points++;
	Plist[index].flag = 1;

	if (npoly_points == nlists) {
		check = PolygonFlatCheck(poly_list,nlists);
	/*	printf("WW %d   %d\n",nlists,check);*/
	}
	else {
		for (count=0; count<nlists; count++) {
			if (Plist[count].flag == 0) {
				if (ListSort(count) == 0) return(0);
				else 					  check = 1;
			}
		}
	}

	npoly_points -= 1;
	Plist[index].flag = 0;
	
	return(check);
}



/*************************************************************************************
			ZNg__f[^
*************************************************************************************/
static short StoreSelectPoint(short selectPoint)
{
	short i;

	for (i=0; i<POINTNUMBER; i++) {
		if (pointData[i].flags == 0) {
			pointData[i].flags = 3;
			pointData[i].pointx = Convert(pointData[selectPoint].pointx);
			pointData[i].pointy = Convert(pointData[selectPoint].pointy);
			pointData[i].pointz = Convert(pointData[selectPoint].pointz);
			break;
		}

	}

	return(i);
}

/*************************************************************************************
			ZNg_|S
*************************************************************************************/
extern int SelectPointForMake()
{

	short i,k,checkPoint;
	short flag = 0;
	short point = firsPoint;
	Cursor cs;

	cs = XCreateFontCursor(display,XC_watch);

	nlists = 0;

	while (point >= 0) {
		Plist[nlists].list = point;
		nlists++;
		point = pointData[point].nextPoint;
	}

	for (i=0; i<POINTNUMBER; i++) {
		if (pointData[i].flags == 2 && pointData[i].selectFlag == 1) {

			for (k=0; k<nlists; k++) {
					if (Convert(pointData[Plist[k].list].pointx) == Convert(pointData[i].pointx) && 
						Convert(pointData[Plist[k].list].pointy) == Convert(pointData[i].pointy) &&
						Convert(pointData[Plist[k].list].pointz) == Convert(pointData[i].pointz)    ) 
					{flag = 1; break;}
			}

			if (flag == 0) {
				Plist[nlists].list = StoreSelectPoint(i); 
				nlists++;
				if (nlists > 16) {
					for (i=0; i<nlists; i++) {
						if (pointData[Plist[i].list].flags == 3) {pointData[Plist[i].list].flags = 0;}
					}
					nlists = 0;
					return(1);
				}
			}
			flag = 0;
		}
	}

	if (nlists != 0) {
		npoly_points = 0;
		for (k=0; k<16; k++) Plist[k].flag = 0;

	    XDefineCursor(display,mainWindow,cs);
		XFlush(display);
		if (ListSort(0) == 1) 	{
		    XUndefineCursor(display,mainWindow);
			for (i=0; i<nlists; i++) {
				if (pointData[Plist[i].list].flags == 3) pointData[Plist[i].list].flags = 0;
			}
			nlists = 0;
			return(1);
		}

	    XUndefineCursor(display,mainWindow);
		firsPoint = -1;
		creatingPoint = -1;
		pointNum = 0;

		for (i=0; i<nlists; i++)	WriteSelectPoint(poly_list[i]);
		InitSelectPoint();

	}
	return(0);
}

/*    for (k=0; k<nlists; k++) printf("@@Plist %d\n",Plist[k].list);*/
/*    for (k=0; k<nlists; k++) printf("@@poly %d\n",poly_list[k]);*/







/*************************************************************************************
/*************************************************************************************
			Set together Color 
*************************************************************************************/
extern void TogetherSetColor()
{
	short colorNumber;
	int i;
	
	if ((colorNumber = SetColorWindow(0)) == -1) {
		for (i=0; i<POLYGONNUMBER; i++)  {
			if (polygonData[i].flags != 0 && polygonData[i].selectFlag == 2) {
				polygonData[i].selectFlag = 1;
			}
		}
		return;
	}
	else {
		for (i=0; i<POLYGONNUMBER; i++)  {
			if (polygonData[i].flags != 0 && polygonData[i].selectFlag == 2) {
				polygonData[i].color = colorNumber;
				polygonData[i].selectFlag = 0;
			}
		}
	}

}

/*************************************************************************************
			Set Colors Respective
*************************************************************************************/
static void IndivSetColor()
{
	short colorNo;
	short i,k;
	
	reverseFlag = 1;

	for (i=0; i<POLYGONNUMBER; i++) {
		if (polygonData[i].flags != 0 && polygonData[i].selectFlag == 2) {

			polygonData[i].selectFlag = 1;
			for (k=0; k<3; k++)	InitEditScreen(&designWinInfo[k]);
			DrawPolygon(i,'E');
			for (k=0; k<3; k++)	DrawDesignContents(&designWinInfo[k],10);
			Draw3DWindow();

			if ((colorNo = SetColorWindow(polygonData[i].color)) == -1) {
				for (i=0; i<POLYGONNUMBER; i++) {
					if (polygonData[i].flags != 0 && polygonData[i].selectFlag == 2) {
						polygonData[i].selectFlag = 1;
					}
				}
				reverseFlag = 0; return;
			}
			else	polygonData[i].color = colorNo;
			polygonData[i].selectFlag = 0;
		}
	}

	reverseFlag = 0;

}

/*************************************************************************************
			Set Color once more
*************************************************************************************/
extern void RSetColor()
{
	char *Message = "J[Aꊇݒɂ܂H";
	static char *buttonTitle[] = {"NO","YES"};
	int i;

	for (i=0; i<POLYGONNUMBER; i++) {
		if (polygonData[i].flags != 0 && polygonData[i].selectFlag == 1) {
			polygonData[i].selectFlag = 2;
		}
	}

	if (AlertDialog2(52,150,300,100,0,2,buttonTitle,1,&Message) != 1)  TogetherSetColor();
	else	IndivSetColor();

	for (i=0; i<3; i++) {
		WriteEditScreen(&designWinInfo[i]);
	 	DrawDesignContents(&designWinInfo[i],10);
	}
	Draw3DWindow();
}







/*************************************************************************************
			|CgłƂ̃|C^[C֌W
*************************************************************************************/

/*************************************************************************************
			ĉQ̃|C^[C`

*************************************************************************************/
static void OtherPointerDesign(design,wx,wy)
DesignPtr design;
int wx,wy;
{
	int posx,posy;

	switch (design->windowNo) {
		case 0: posx = DesignFromPoint(&designWinInfo[1],ConvInt(design,wx,1),'x');
		 		posy = DesignFromPoint(&designWinInfo[2],ConvInt(design,wy,2),'x');
				XDrawLine(display,designWinInfo[1].editScreen,bitmapGC,posx,0,posx,1024);
				XDrawLine(display,designWinInfo[2].editScreen,bitmapGC,posy,0,posy,1024);
				break;
		case 1: posx = DesignFromPoint(&designWinInfo[0],ConvInt(design,wx,1),'x');
		 		posy = DesignFromPoint(&designWinInfo[2],ConvInt(design,wy,2),'y');
				XDrawLine(display,designWinInfo[0].editScreen,bitmapGC,posx,0,posx,1024);
				XDrawLine(display,designWinInfo[2].editScreen,bitmapGC,0,posy,1024,posy);
				break;
		case 2: posx = DesignFromPoint(&designWinInfo[0],ConvInt(design,wx,1),'y');
		 		posy = DesignFromPoint(&designWinInfo[1],ConvInt(design,wy,2),'y');
				XDrawLine(display,designWinInfo[0].editScreen,bitmapGC,0,posx,1024,posx);
				XDrawLine(display,designWinInfo[1].editScreen,bitmapGC,0,posy,1024,posy);
	
	}
}

/*************************************************************************************
			|C^[CCxg

*************************************************************************************/
extern void DrawPointLeave(event,wcore)
XEventPtr event;
WCorePtr wcore;
{
	ControlPtr ctrl = (ControlPtr)wcore;
	DesignPtr design = (DesignPtr)ctrl->refCon;
	int i;

if (centerLineWin != -1) {
	XSetFunction(display,bitmapGC,GXxor);
	XSetLineAttributes(display,bitmapGC,0,LineSolid,CapButt,JoinMiter);

	XDrawLine(display,design->editScreen,bitmapGC,beposx,0,beposx,1024);
 	XDrawLine(display,design->editScreen,bitmapGC,0,beposy,1024,beposy);
	OtherPointerDesign(design,beforeX,beforeY);


	beposx = -2000; beposy = -2000;
	beforeX = -2000; beforeY = -2000;
	
	centerLineWin = -1;

	XSetFunction(display,bitmapGC,GXcopy);
	
	for (i=0; i<3; i++) DrawDesignContents(&designWinInfo[i],8);
}
}
/*************************************************************************************
			|C^[CCxg

*************************************************************************************/
extern void PointerLineEvent(event,wcore,wx,wy)
XEventPtr event;
WCorePtr wcore;
int wx,wy;
{  
	ControlPtr ctrl = (ControlPtr)wcore;
	DesignPtr design = (DesignPtr)ctrl->refCon;
	char i;
	int posx,posy;
	int x,y,wz,hz;
	

	XSetFunction(display,bitmapGC,GXxor);
	XSetLineAttributes(display,bitmapGC,0,LineSolid,CapButt,JoinMiter);

	if (centerLineWin == -1) centerLineWin = design->windowNo;
	else {
		XDrawLine(display,design->editScreen,bitmapGC,beposx,0,beposx,1024);
	 	XDrawLine(display,design->editScreen,bitmapGC,0,beposy,1024,beposy);
		if (drawFlag == -1) OtherPointerDesign(design,beforeX,beforeY);
	}

	ConvertDesignData(design,newPoint,&x,&y,&wz,&hz);
	switch(drawFlag) {
		case -1 : posx = ConvertForPosition(design,wx,'x');
				  posy = ConvertForPosition(design,wy,'y');
				  OtherPointerDesign(design,wx,wy);
				  break;
		case  0 : switch (design->windowNo) {
					case 0: posx = x; posy = hz; 								break;
					case 1: posx = x; posy = ConvertForPosition(design,wy,'y'); break;
					case 2: posx = wz;posy = ConvertForPosition(design,wy,'y'); 
				  }
				  break;
		case  1 : switch (design->windowNo) {
					case 0: posx = x; posy = ConvertForPosition(design,wy,'y');	break;
					case 1: posx = x; posy = y; 								break;
					case 2: posx = ConvertForPosition(design,wx,'x'); posy = y; 
				  }
				  break;
		case  2 : switch (design->windowNo) {
					case 0: posx = ConvertForPosition(design,wx,'x'); posy = hz;break;
					case 1: posx = ConvertForPosition(design,wx,'x'); posy = y; break;
					case 2: posx = wz;posy = y; 
				  }

	}	


		XDrawLine(display,design->editScreen,bitmapGC,posx,0,posx,1024);
		XDrawLine(display,design->editScreen,bitmapGC,0,posy,1024,posy);

	beposx = posx;  beposy = posy;
	if (drawFlag == -1) {beforeX = wx; beforeY = wy;}

	XSetFunction(display,bitmapGC,GXcopy);
	for (i=0; i<3; i++) DrawDesignContents(&designWinInfo[i],8);
	
		
}




