/*************************************************************************************
			ƕ֗Ȋ֐̃vO
													by D.Iwamoto
*************************************************************************************/
#include <stdio.h>
#include <math.h>
#include "ToolBox.h"
#include "External.h"
#include "Prototype.h"
#include "caduser"


/*************************************************************************************
			|S̃ZNg
*************************************************************************************/
extern void InitSelectPolygon()
{
	short i;

	for (i=0; i<POLYGONNUMBER; i++) {
		if (polygonData[i].selectFlag == 1) polygonData[i].selectFlag = 0;
	}
}
/*************************************************************************************
			|Cg̃ZNg
*************************************************************************************/
extern void InitSelectPoint()
{
	short i;

	for (i=0; i<POINTNUMBER; i++) {
		if (pointData[i].selectFlag == 1 && pointData[i].flags == 2) pointData[i].selectFlag = 0;
	}
}

/*************************************************************************************
			_Aǂ̃|SɊ܂܂Ă邩ׂ

*************************************************************************************/
extern short PolygonFromPoint(short pointNo)
{
	int i;
	short checkPoint;
	short polygonNo = -1;

	for (i=0; i<POLYGONNUMBER; i++) {
	  if (polygonData[i].flags != 0) {
		checkPoint = polygonData[i].firstPoint;
		while (checkPoint != -1) {
			if (checkPoint == pointNo) { polygonNo = i; break;}
			checkPoint = pointData[checkPoint].nextPoint;
		}
	  }
	  if (polygonNo != -1) break;
	}

	return (polygonNo);
}

/*************************************************************************************
			O̓_𒲂ׂ

*************************************************************************************/
extern short CheckForePoint(short pointNo)
{
	short ForePoint;
	int i,flag = -1;

	for (i=0; i<POINTNUMBER; i++) {
		if (pointData[i].flags != 0 && pointData[i].nextPoint == pointNo) {
			ForePoint = i;	flag = 1; break;
		}
	}
	if (flag == -1) ForePoint = -1;



	return(ForePoint);
}

/*************************************************************************************
			Õ|S𒲂ׂ

*************************************************************************************/
extern short CheckForePolygon(short polygonNo)
{
	short ForePolygon;
	int i,flag = -1;

	for (i=0; i<POLYGONNUMBER; i++) {
		if (polygonData[i].flags != 0 && polygonData[i].nextPolygon == polygonNo) {
			ForePolygon = i;	flag = 1; break;
		}
	}
	if (flag == -1) ForePolygon = -1;



	return(ForePolygon);
}

/*************************************************************************************
			_f[^ľܓ֐

*************************************************************************************/
extern int Convert(point)
double point;
{
	double Float;
	double convPoint;

	Float = modf(point,&convPoint);

	if (point >= 0) {
			if (Float >= 0.5) convPoint++;
	}
	else	if (Float <= -0.5) convPoint--;

/*	printf(" //%f;;\n",convPoint);*/

	return(convPoint);
}

/*************************************************************************************
			}EX̉ꂽꏊ_f[^ɕϊ֐

*************************************************************************************/
extern double ConvInt(design,position,xy)
DesignPtr design;
int position,xy;
{
	WCorePtr wcore = (WCorePtr)design->contents;
	short width = wcore->width;
	short height = wcore->height;
	float Scale = design->scale;
	int lineWidth = (Scale)*10;
	int Scrollx = design->scrollx;
	int Scrolly = design->scrolly;
	int centerX = (0 - Scrollx)*Scale + width/2;
	int centerY = (0 - Scrolly)*Scale + height/2;
	int X,Y;
	double point;

	if (xy == 1) {	/*W̏ꍇ*/
		X = (position - centerX);
		if (X>=0) point = (X+lineWidth/2)/lineWidth;
		else		 point = (X-lineWidth/2)/lineWidth;
	}
	else		{	/*W̏ꍇ*/
		Y = -(position - centerY);
		if (Y>=0) point = (Y+lineWidth/2)/lineWidth;
		else		point = (Y-lineWidth/2)/lineWidth;
	}
	return(point);
}
/*************************************************************************************
			_ł֐iCw肷j

*************************************************************************************/
extern void DrawPoint(DesignPtr design,char scr,int posx,int posy)

{
	WCorePtr wcore = (WCorePtr)design->contents;
	Pixmap screen;
	short width = wcore->width;
	short height = wcore->height;
	float Scale = design->scale;
	int lineWidth = Scale*10;
	int Scrollx = design->scrollx;
	int Scrolly = design->scrolly;
	int centerX = (0 - Scrollx)*Scale + width/2;
	int centerY = (0 - Scrolly)*Scale + height/2;
	int X,Y;

	if (scr == 'E') screen = design->editScreen;
	else		 screen = design->foreScreen;

	X  = centerX + posx * lineWidth;
	Y  = centerY - posy * lineWidth;

	XSetLineAttributes(display,bitmapGC,3,LineSolid,CapRound,JoinRound);
	XDrawLine(display,screen,bitmapGC,X,Y,X,Y);
}
/*************************************************************************************
			|Cgf[^EChE̍Wɕϊ

*************************************************************************************/
extern void ConvertDesignData(design,point,x,y,wz,hz)
DesignPtr design;
int point;
int *x,*y,*wz,*hz;
{
	WCorePtr wcore = (WCorePtr)design->contents;
	short width = wcore->width;
	short height = wcore->height;
	float Scale = design->scale;
	int lineWidth = Scale*10;
	int Scrollx = design->scrollx;
	int Scrolly = design->scrolly;
	int centerX = (0 - Scrollx)*Scale + width/2;
	int centerY = (0 - Scrolly)*Scale + height/2;

	*x  = centerX + Convert(pointData[point].pointx) * lineWidth;
	*y  = centerY - Convert(pointData[point].pointy) * lineWidth;
	*wz = centerX + Convert(pointData[point].pointz) * lineWidth;  /*x for LightView*/
	*hz = centerY - Convert(pointData[point].pointz) * lineWidth;  /*y for TopView*/

}
/*************************************************************************************
			fUCEChEɓ_ł֐

*************************************************************************************/
extern void PointDesignWindow(DesignPtr design,char scr,int point)

{
	Pixmap screen;
	int X,Y,wZ,hZ;

	ConvertDesignData(design,point,&X,&Y,&wZ,&hZ);

	if (scr == 'E') screen = design->editScreen;
	else		 screen = design->foreScreen;


	switch (design->windowNo) {
		case 0 :	XDrawLine(display,screen,bitmapGC,X,hZ,X,hZ); break;
		case 1 :	XDrawLine(display,screen,bitmapGC,X,Y,X,Y);	  break;
		case 2 :	XDrawLine(display,screen,bitmapGC,wZ,Y,wZ,Y); break;
	}
}

/*************************************************************************************
			fUCEChEɐ`֐

*************************************************************************************/
extern void DesignLine(design,Screen,startPoint,endPoint)
DesignPtr design;
Pixmap Screen;
int startPoint,endPoint;
{
	int stX,stY,stWZ,stHZ,enX,enY,enWZ,enHZ;

	ConvertDesignData(design,startPoint,&stX,&stY,&stWZ,&stHZ);
	ConvertDesignData(design,endPoint,&enX,&enY,&enWZ,&enHZ);

	switch (design->windowNo) {
		case 0: XDrawLine(display,Screen,bitmapGC,stX,stHZ,enX,enHZ);
			   break;
		case 1: XDrawLine(display,Screen,bitmapGC,stX,stY,enX,enY);
			   break;
		case 2: XDrawLine(display,Screen,bitmapGC,stWZ,stY,enWZ,enY);
			   break;
	}
}
/*************************************************************************************
			|C^[̈ʒuľܓꏊ𒲂ׂ

*************************************************************************************/
extern int ConvertForPosition(DesignPtr design,int pos,char xy)

{
	WCorePtr wcore = (WCorePtr)design->contents;
	short width = wcore->width;
	short height = wcore->height;
	float Scale = design->scale;
	int lineWidth = Scale*10;
	int Scrollx = design->scrollx;
	int Scrolly = design->scrolly;
	int centerX = (0 - Scrollx)*Scale + width/2;
	int centerY = (0 - Scrolly)*Scale + height/2;
	int conPos;

	if (xy == 'x')	conPos  = centerX + Convert(ConvInt(design,pos,1)) * lineWidth;
	else 			conPos  = centerY - Convert(ConvInt(design,pos,2)) * lineWidth;
	
	return (conPos);
}

/*************************************************************************************
			|CgWEChËʒu߂
*************************************************************************************/
extern int DesignFromPoint(DesignPtr design,double posi,char cor)
{

	WCorePtr wcore = (WCorePtr)design->contents;
	short width = wcore->width;
	short height = wcore->height;
	float Scale = design->scale;
	int lineWidth = Scale*10;
	int Scrollx = design->scrollx;
	int Scrolly = design->scrolly;
	int centerX = (0 - Scrollx)*Scale + width/2;
	int centerY = (0 - Scrolly)*Scale + height/2;
	int position;

	if (cor == 'x')  position = centerX + posi * lineWidth;
	else 			 position = centerY - posi * lineWidth;

	return(position);
}


/*************************************************************************************
			|S|Cg̃ZNgtOĂ
*************************************************************************************/
extern void PointSelectForPolygon(short polyNo)

{
	short point_no = polygonData[polyNo].firstPoint;
	
	while (point_no != -1) {
		pointData[point_no].selectFlag = 1;
		point_no = pointData[point_no].nextPoint;
	}
}

/*************************************************************************************
			ʂȃ|Cg\
*************************************************************************************/
extern void DrawExtraPoint(short pointNo)
{
	int posx = Convert(pointData[pointNo].pointx);
	int posy = Convert(pointData[pointNo].pointy);
	int posz = Convert(pointData[pointNo].pointz);

	DrawPoint(&designWinInfo[0],'E',posx,posz);
	DrawPoint(&designWinInfo[1],'E',posx,posy);
	DrawPoint(&designWinInfo[2],'E',posz,posy);
	
	XSetLineAttributes(display,bitmapGC,0,LineSolid,CapButt,JoinMiter);
	XDrawRectangle(display,designWinInfo[0].editScreen,bitmapGC,
			DesignFromPoint(&designWinInfo[0],(double)posx,'x')-3,DesignFromPoint(&designWinInfo[0],(double)posz,'y')-3,6,6);
	XDrawRectangle(display,designWinInfo[1].editScreen,bitmapGC,
			DesignFromPoint(&designWinInfo[1],(double)posx,'x')-3,DesignFromPoint(&designWinInfo[1],(double)posy,'y')-3,6,6);
	XDrawRectangle(display,designWinInfo[2].editScreen,bitmapGC,
			DesignFromPoint(&designWinInfo[2],(double)posz,'x')-3,DesignFromPoint(&designWinInfo[2],(double)posy,'y')-3,6,6);
	
}



/************************************************************************************/
/*************************************************************************************
			`FbN
*************************************************************************************/
static short PolygonCrossCheck(double a,double b,double c,
									short k,short ncounts,short *points)
{
	double x0,y0,z0,x1,x2,x3,y1,y2,y3,z1,z2,z3,x,y,z;
	double A,B,C,A1,B1,C1;
	short flag;

	if (k != 1) {
		x0  = Convert(pointData[*(points+k-2)].pointx);
		y0  = Convert(pointData[*(points+k-2)].pointy);
		z0  = Convert(pointData[*(points+k-2)].pointz);
	}
		x1  = Convert(pointData[*(points+k-1)].pointx);
		y1  = Convert(pointData[*(points+k-1)].pointy);
		z1  = Convert(pointData[*(points+k-1)].pointz);

		x2  = Convert(pointData[*(points+k)].pointx);
		y2  = Convert(pointData[*(points+k)].pointy);
		z2  = Convert(pointData[*(points+k)].pointz);

		x3  = Convert(pointData[*(points)].pointx);
		y3  = Convert(pointData[*(points)].pointy);
		z3  = Convert(pointData[*(points)].pointz);



	A = (y2-y1)*(z3-z2)-(z2-z1)*(y3-y2);	  /*ʂ̕߂*/
	B = (z2-z1)*(x3-x2)-(x2-x1)*(z3-z2);	  /*`{a{b{cO*/
	C = (x2-x1)*(y3-y2)-(y2-y1)*(x3-x2);

	if (k != 1) {
		A1 = (y1-y0)*(z2-z1)-(z1-z0)*(y2-y1);	  
		B1 = (z1-z0)*(x2-x1)-(x1-x0)*(z2-z1);	  
		C1 = (x1-x0)*(y2-y1)-(y1-y0)*(x2-x1);
	}
	else {A1=0; B1=0; C1=0;}

/*	printf("%f,,%f,,%f,,%f,,%f,,%f\n",A,B,C,A1,B1,C1);*/

	if (A*a < 0 || B*b < 0 || C*c < 0 || A1*a < 0 || B1*b < 0 || C1*c < 0) flag = 1;
	else 							   									   flag = 0;

	return (flag);

}
/*************************************************************************************
			wC`FbN
*************************************************************************************/
extern int PolygonFlatCheck(short *list,short ncounts)
{
	short k;
	int check = 0;
	short points[20];
	double x1,x2,x3,y1,y2,y3,z1,z2,z3,x,y,z;
	double A,B,C,D;

	x1 = Convert(pointData[*(list+ncounts-1)].pointx);
	y1 = Convert(pointData[*(list+ncounts-1)].pointy);
	z1 = Convert(pointData[*(list+ncounts-1)].pointz);
	x2 = Convert(pointData[*(list)].pointx);
	y2 = Convert(pointData[*(list)].pointy);
	z2 = Convert(pointData[*(list)].pointz);
	x3 = Convert(pointData[*(list+1)].pointx);
	y3 = Convert(pointData[*(list+1)].pointy);
	z3 = Convert(pointData[*(list+1)].pointz);

	A = (y2-y1)*(z3-z2)-(z2-z1)*(y3-y2);	  /*ʂ̕߂*/
	B = (z2-z1)*(x3-x2)-(x2-x1)*(z3-z2);	  /*`{a{b{cO*/
	C = (x2-x1)*(y3-y2)-(y2-y1)*(x3-x2);
	D = -(A*x3 + B*y3 + C*z3);

	for (k=1; k<ncounts; k++) {
		x    = Convert(pointData[*(list+k)].pointx);
		y    = Convert(pointData[*(list+k)].pointy);
		z    = Convert(pointData[*(list+k)].pointz);

		if (A*x+B*y+C*z+D != 0 || 
				(PolygonCrossCheck(A,B,C,k,ncounts,list) == 1)) {check = 1; break;}
	}

	return(check);
}



