/*************************************************************************************
				fUCEChẼXN[vO
												h
*************************************************************************************/
#include <stdio.h>
#include <math.h>
#include "ToolBox.h"
#include "External.h"
#include "Prototype.h"
#include "caduser"


/*************************************************************************************
				wiXN[̍Wv
												
*************************************************************************************/
static void WriteXYZ(design,width,height)
DesignPtr design;
short width,height;
{
	Pixmap screen = design->backScreen;
	Font font;
	GC gc;

	gc = XCreateGC (display,screen,0,0);
	font = XLoadFont(display,"*adobe-helvetica-bold-r*140*");
	XSetFont(display,gc,font);
	
	XSetForeground(display,gc,1);
	XSetLineAttributes(display,bitmapGC,4,LineSolid,CapButt,JoinMiter);
	XDrawLine(display,screen,bitmapGC,10,height-50,10,height-10);
	XDrawLine(display,screen,bitmapGC,10,height-10,50,height-10);

	switch (design->windowNo) {
		case 0 :XDrawString(display,screen,gc,5,height-55,"Z",1);
				XDrawString(display,screen,gc,55,height-5,"X",1);
				break;
		case 1 :XDrawString(display,screen,gc,5,height-55,"Y",1);
				XDrawString(display,screen,gc,55,height-5,"X",1);
				break;
		case 2 :XDrawString(display,screen,gc,5,height-55,"Y",1);
				XDrawString(display,screen,gc,55,height-5,"Z",1);
				break;
	}


}	

/*************************************************************************************
				wiXN[̍W`
*************************************************************************************/
static void WriteBackScreen1(design)
DesignPtr design;
{
	Pixmap screen = design->backScreen;
	WCorePtr wcore = (WCorePtr)design->contents;
	short width = wcore->width;
	short height = wcore->height;
	int lineWidth = (design->scale)*10;
	int x,y;
	float Scale = design->scale;
	int Scroolx = design->scrollx;
	int Scrooly = design->scrolly;
	int centerX = (0 - Scroolx)*Scale + width/2;
	int centerY = (0 - Scrooly)*Scale + height/2;

	XSetForeground(display,bitmapGC,0);   /*obN̔h*/
	XFillRectangle(display,screen,bitmapGC,0,0,DESIGN_WIDTH,DESIGN_HEIGHT);

	XSetForeground(display,bitmapGC,1);   /*          */
	XSetLineAttributes(display,bitmapGC,0,LineSolid,CapButt,JoinMiter);
	for (x = centerX; x>=0; x -= lineWidth) {
		if (x <= width)	XDrawLine(display,screen,bitmapGC,x,0,x,(int)height);
	}
	for (x = centerX; x <= width; x += lineWidth)
						XDrawLine(display,screen,bitmapGC,x,0,x,(int)height);

	for (y = centerY; y>=0; y -= lineWidth) {
		if (y <= height)	XDrawLine(display,screen,bitmapGC,0,y,(int)width,y);
	}
	for (y = centerY; y <= height; y += lineWidth)
						XDrawLine(display,screen,bitmapGC,0,y,(int)width,y);
	

	XSetLineAttributes(display,bitmapGC,2,LineSolid,CapButt,JoinMiter);
	for (x = centerX; x>=0; x -= lineWidth*10) {
		if (x <= width)	XDrawLine(display,screen,bitmapGC,x,0,x,(int)height);
	}
	for (x = centerX; x <= width; x += lineWidth*10)
						XDrawLine(display,screen,bitmapGC,x,0,x,(int)height);

	for (y = centerY; y>=0; y -= lineWidth*10) {
		if (y <= height)	XDrawLine(display,screen,bitmapGC,0,y,(int)width,y);
	}
	for (y = centerY; y <= height; y += lineWidth*10)
						XDrawLine(display,screen,bitmapGC,0,y,(int)width,y);

	XSetLineAttributes(display,bitmapGC,3,LineSolid,CapButt,JoinMiter);
	XDrawLine(display,screen,bitmapGC,centerX,0,centerX,DESIGN_HEIGHT);
	XDrawLine(display,screen,bitmapGC,0,centerY,DESIGN_WIDTH,centerY);

	WriteXYZ(design,width,height);		
}

/*************************************************************************************
				wiXN[̍W`2
*************************************************************************************/
static void WriteBackScreen2(design)
DesignPtr design;
{
	Pixmap screen = design->backScreen;
	WCorePtr wcore = (WCorePtr)design->contents;
	short width = wcore->width;
	short height = wcore->height;
	int lineWidth = (design->scale)*10;
	int x,y;
	float Scale = design->scale;
	int Scroolx = design->scrollx;
	int Scrooly = design->scrolly;
	int centerX = (0 - Scroolx)*Scale + width/2;
	int centerY = (0 - Scrooly)*Scale + height/2;

	XSetForeground(display,bitmapGC,0);   /*obN̔h*/
	XFillRectangle(display,screen,bitmapGC,0,0,DESIGN_WIDTH,DESIGN_HEIGHT);

	XSetForeground(display,bitmapGC,1);   /*          */
	XSetLineAttributes(display,bitmapGC,0,LineSolid,CapButt,JoinMiter);

	for (x = centerX; x>=0; x -= lineWidth*10) {
		if (x <= width)	XDrawLine(display,screen,bitmapGC,x,0,x,(int)height);
	}
	for (x = centerX; x <= width; x += lineWidth*10)
						XDrawLine(display,screen,bitmapGC,x,0,x,(int)height);

	for (y = centerY; y>=0; y -= lineWidth*10) {
		if (y <= height)	XDrawLine(display,screen,bitmapGC,0,y,(int)width,y);
	}
	for (y = centerY; y <= height; y += lineWidth*10)
						XDrawLine(display,screen,bitmapGC,0,y,(int)width,y);

	XSetLineAttributes(display,bitmapGC,2,LineSolid,CapButt,JoinMiter);
	XDrawLine(display,screen,bitmapGC,centerX,0,centerX,DESIGN_HEIGHT);
	XDrawLine(display,screen,bitmapGC,0,centerY,DESIGN_WIDTH,centerY);

	WriteXYZ(design,width,height);		
}
/*************************************************************************************
				wiXN[̏
*************************************************************************************/
extern void InitBackScreen(design)
DesignPtr design;
{
	float scale = design->scale;

	if (scale > 0.4) WriteBackScreen1(design);
	else			 WriteBackScreen2(design);

}
/*************************************************************************************
				OiXN[̏
				idʁj								
*************************************************************************************/
extern void InitEditScreen(design)
DesignPtr design;
{
	
	XSetForeground(display,bitmapGC,0);   /*obN̔h*/
	XFillRectangle(display,design->editScreen,bitmapGC,0,0,DESIGN_WIDTH,DESIGN_HEIGHT);
	XFillRectangle(display,design->foreScreen2,bitmapGC,0,0,DESIGN_WIDTH,DESIGN_HEIGHT);

	XSetForeground(display,bitmapGC,1);   /*          */
	XSetLineAttributes(display,bitmapGC,5,LineSolid,CapRound,JoinRound);


}


/*************************************************************************************
				OiXN[̏
				i|Sʁj								
*************************************************************************************/
extern void InitForeScreen(design)
DesignPtr design;
{
	
	XSetForeground(display,bitmapGC,0);   /*obN̔h*/
	XFillRectangle(display,design->foreScreen,bitmapGC,0,0,DESIGN_WIDTH,DESIGN_HEIGHT);

	XSetForeground(display,bitmapGC,1);   /*          */
	XSetLineAttributes(display,bitmapGC,0,LineSolid,CapButt,JoinMiter);

	
}

/************************************************************************************
			fUCEChÊ̕
				@@
*************************************************************************************/
extern void DrawDesignContents(DesignPtr design,char code)

{
	WCorePtr wcore = (WCorePtr)design->contents;

	if (code & 0x01) {
	XSetPlaneMask(display,pixmapGC,1);
	XCopyPlane(display,design->backScreen,wcore->windowID,pixmapGC,0,
						0,wcore->width,wcore->height,0,0,1);
	}
	if (code & 0x02) {
	XSetPlaneMask(display,pixmapGC,2);
	XCopyPlane(display,design->foreScreen2,wcore->windowID,pixmapGC,0,
						0,wcore->width,wcore->height,0,0,1);
	}
	if (code & 0x04) {
	XSetPlaneMask(display,pixmapGC,4);
	XCopyPlane(display,design->foreScreen,wcore->windowID,pixmapGC,0,
						0,wcore->width,wcore->height,0,0,1);
	}
	if (code & 0x08) {
	XSetPlaneMask(display,pixmapGC,8);
	XCopyPlane(display,design->editScreen,wcore->windowID,pixmapGC,0,
						0,wcore->width,wcore->height,0,0,1);
	}
}

/*************************************************************************************
				GfBbgʂ̏
												
*************************************************************************************/
extern void WriteEditScreen(design)
DesignPtr design;
{
	int i;

	InitEditScreen(design);

	for (i=0; i<POINTNUMBER; i++) {
		if (pointData[i].flags == 1 ) 
						PointDesignWindow(design,'E',i);

		if (pointData[i].flags != 0 && pointData[i].selectFlag == 1) 
						PointDesignWindow(design,'E',i);
	}

	for (i=0; i<POLYGONNUMBER; i++) {
		if (polygonData[i].flags != 0 && polygonData[i].selectFlag ==1)
						 DrawPolygon(i,'E');
	}

	if (editFlag ==  4 && design->windowNo == centerFlag) DrawCenterPoint(design,rotateX,rotateY);
	if (editFlag == 12 && design->windowNo == centerFlag) DrawCenterPoint(design,rotateX,rotateY);
	if (editFlag == 5 || editFlag == 13) DrawScaleCenterPoint(design);


	if (editFlag == 16) {
		if (cutPoint1 != -1) DrawExtraPoint(cutPoint1);
		if (cutPoint2 != -1) DrawExtraPoint(cutPoint2);
	}

	XSetLineAttributes(display,bitmapGC,0,LineSolid,CapButt,JoinMiter);
	if (rect.flag != -1) WriteSelectSquare(design);


}

/*************************************************************************************
				|Sʂ̏
												
*************************************************************************************/
extern void WriteForeScreen(design)
DesignPtr design;
{
	short flag;
	short Fpoint,Spoint,Epoint,pointNum;
	int i;

	InitForeScreen(design);

	for (i=0; i<POLYGONNUMBER; i++) {
		if (polygonData[i].flags != 0) {
			pointNum = polygonData[i].npoints;
			Fpoint = polygonData[i].firstPoint;
			Spoint = Fpoint;

			while (pointNum > 1) {
				Epoint = pointData[Spoint].nextPoint;
				DesignLine(design,design->foreScreen,Spoint,Epoint);
				Spoint = Epoint;
				pointNum--;
			}
			DesignLine(design,design->foreScreen,Spoint,Fpoint);
		}
	}

	/******_**********************/
	XSetForeground(display,bitmapGC,1);   
	XSetLineAttributes(display,bitmapGC,4,LineSolid,CapRound,JoinRound);
	for (i=0; i<POINTNUMBER; i++) {
		if (pointData[i].flags == 2 ) PointDesignWindow(design,'F',i);
	}	

	
}

/*************************************************************************************
				fUCEChẼY[C
												
*************************************************************************************/
extern void ZoomInContents(ctrl,code)
ControlPtr ctrl;
int code;
{
	DesignPtr design = (DesignPtr) ctrl->refCon;
	
	if ( (design->scale) < 2) {
	design->scale = (design->scale)+0.1;
	InitBackScreen(design);
	WriteForeScreen(design);
	WriteEditScreen(design);
	DrawDesignContents(design,15);
	}
}
/*************************************************************************************
				fUCEChẼY[AEg
												
*************************************************************************************/
extern void ZoomOutContents(ctrl,code)
ControlPtr ctrl;
int code;
{
	DesignPtr design = (DesignPtr) ctrl->refCon;
	float Scale = design->scale;

	if (Scale > 0.2) {
	design->scale = (design->scale)-0.1;
	InitBackScreen(design);
	WriteForeScreen(design);
	WriteEditScreen(design);
	DrawDesignContents(design,15);
	}
	
}


/************************************************************************************
			XN[o[̃XN[ړ
				iXN[܂݂ɂړj
*************************************************************************************/
static void SetScrollPosition(ctrl)
ControlPtr ctrl;
{
	DesignPtr design = (DesignPtr)ctrl->refCon;
	float scr;
	int lineWidth = (design->scale)*10;

	if (((WCorePtr)ctrl)->type == scrollBarH) {
		scr = floor(GetCtrlValue(ctrl)/lineWidth);
		if ((design->scale) < 1)  scr = floor(scr*lineWidth/10)*10;
		else				      scr = scr*lineWidth;
		design->scrollx = scr;
		ctrl->value = scr;
	}
	else			{
		scr = floor(GetCtrlValue(ctrl)/lineWidth);
		if ((design->scale) < 1)  scr = floor(scr*lineWidth/10)*10;
		else				      scr = scr*lineWidth;
		design->scrolly = scr;
		ctrl->value = scr;
	}
/*	printf("%d.>>>%d\n",design->scrollx,design->scrolly);*/

	InitBackScreen(design);
	WriteForeScreen(design);
	WriteEditScreen(design);
	DrawDesignContents(design,15);
}

/************************************************************************************
			XN[o[̃XN[ړ
				ĩXCb`ɂƂړj
*************************************************************************************/
static void ScrollContents(ctrl,offset)
ControlPtr ctrl;
int offset;
{
	DesignPtr design = (DesignPtr)ctrl->refCon;
	WCorePtr wcore = (WCorePtr)design->contents;

	ctrl->value += offset;
	if (ctrl->value < ctrl->minval) ctrl->value = ctrl->minval;
	if (ctrl->value > ctrl->maxval) ctrl->value = ctrl->maxval;

	if (((WCorePtr)ctrl)->type == scrollBarH) design->scrollx = ctrl->value;
	else								  design->scrolly = ctrl->value;

/*	printf("%d.>>>%d\n",design->scrollx,design->scrolly);*/

	InitBackScreen(design);
	WriteForeScreen(design);
	WriteEditScreen(design);
	DrawDesignContents(design,15);
}


/************************************************************************************
			XN[o[̃XN[y[Wړ
				
*************************************************************************************/
static void PageContents(ctrl,time)
ControlPtr ctrl;
int time;
{
	DesignPtr design = (DesignPtr)ctrl->refCon;
	WCorePtr wcore = (WCorePtr)design->contents;
	int lineWidth = (design->scale)*10;

	if (((WCorePtr)ctrl)->type == scrollBarH) {
	ctrl->value += time*lineWidth;
	if (ctrl->value < ctrl->minval) ctrl->value = ctrl->minval;
	if (ctrl->value > ctrl->maxval) ctrl->value = ctrl->maxval;
	design->scrollx = ctrl->value;
	}
	else		{
	ctrl->value += time*lineWidth;
	if (ctrl->value < ctrl->minval) ctrl->value = ctrl->minval;
	if (ctrl->value > ctrl->maxval) ctrl->value = ctrl->maxval;
	design->scrolly = ctrl->value;
	}
/*	printf("%d.>>>%d\n",design->scrollx,design->scrolly);*/

	InitBackScreen(design);
	WriteForeScreen(design);
	WriteEditScreen(design);
	DrawDesignContents(design,15);
}
	
/************************************************************************************
			XN[o[̃Cxg

*************************************************************************************/
extern void DesignScrollEvent(ctrl,code)
ControlPtr ctrl;
int code;
{

	switch (code) {
		case 0: SetScrollPosition(ctrl);  break;
		case 1: ScrollContents(ctrl,-40); break;
		case 2: ScrollContents(ctrl,40);  break;
		case 3: PageContents(ctrl,-20);   break;
		case 4: PageContents(ctrl,20);    break;
	}

	XFlush(display);
	XSync(display,0);
}

/*************************************************************************************
		}EXɂZ^[C̈ړ

*************************************************************************************/
extern void ControlCenterLine(event,wcore,wx,wy)
XEventPtr event;
WCorePtr wcore;
int wx,wy;
{
	ControlPtr ctrl = (ControlPtr)wcore;
	DesignPtr design = (DesignPtr)ctrl->refCon;
	int posx,posy;
	float width = (design->scale);

	posx = (wx - moveGroundX)/width;
	posy = (wy - moveGroundY)/width;

	switch (design->windowNo) {
		case 0: if (posx != 0) {
					ScrollContents(designWinInfo[0].scrlRBar,-posx);
					ScrollContents(designWinInfo[1].scrlRBar,-posx);
					moveGroundX = wx;
				}
				if (posy != 0) {
					ScrollContents(designWinInfo[0].scrlHBar,-posy);
					ScrollContents(designWinInfo[2].scrlRBar,posy);
					moveGroundY = wy;
				}
				break;
		case 1: if (posx != 0) {
					ScrollContents(designWinInfo[1].scrlRBar,-posx);
					ScrollContents(designWinInfo[0].scrlRBar,-posx);
					moveGroundX = wx;
				}
				if (posy != 0) {
					ScrollContents(designWinInfo[1].scrlHBar,-posy);
					ScrollContents(designWinInfo[2].scrlHBar,-posy);
					moveGroundY = wy;
				}
				break;
		case 2: if (posx != 0) {
					ScrollContents(designWinInfo[0].scrlHBar,posx);
					ScrollContents(designWinInfo[2].scrlRBar,-posx);
					moveGroundX = wx;
				}
				if (posy != 0) {
					ScrollContents(designWinInfo[1].scrlHBar,-posy);
					ScrollContents(designWinInfo[2].scrlHBar,-posy);
					moveGroundY = wy;
				}
	}
	centerLineWin = -1;  /*|C^[̃C*/
}
/************************************************************************************
			fUCEChÊdCxg

*************************************************************************************/
extern void ExposeDesignWindow(event,wcore)
XEventPtr event;
WCorePtr wcore;
{

	ControlPtr ctrl = (ControlPtr)wcore;
	DesignPtr design = (DesignPtr)ctrl->refCon;

	int desX = event->xexpose.x; 
	int desY = event->xexpose.y;
	int sizeX = event->xexpose.width;
	int sizeY = event->xexpose.height;
	int souX = desX;
	int souY = desY;

	XSetPlaneMask(display,pixmapGC,1);
	XCopyPlane(display,design->backScreen,wcore->windowID,pixmapGC,souX,souY,sizeX,
						sizeY,desX,desY,1);  
	XSetPlaneMask(display,pixmapGC,2);
	XCopyPlane(display,design->foreScreen2,wcore->windowID,pixmapGC,souX,souY,sizeX,
						sizeY,desX,desY,1);  
	XSetPlaneMask(display,pixmapGC,4);
	XCopyPlane(display,design->foreScreen,wcore->windowID,pixmapGC,souX,souY,sizeX,
						sizeY,desX,desY,1);  
	XSetPlaneMask(display,pixmapGC,8);
	XCopyPlane(display,design->editScreen,wcore->windowID,pixmapGC,souX,souY,sizeX,
						sizeY,desX,desY,1);  


}


