/************************************************************************************
			EBhE֌W̃vO
									iwamoto
*************************************************************************************/
#include <stdio.h>
#include "ToolBox.h"
#include "External.h"
#include "ThreeView.h"
#include "Prototype.h"
#include "PolyPack.h"
#include "caduser"

#define   TOP_VIEW  0
#define FRONT_VIEW  1
#define RIGHT_VIEW  2
#define THREE_VIEW  3

WindowPtr toolWindow;
WindowPtr tenKeyWindow;
WindowPtr infoWindow;
WindowPtr infoWindow2;
WindowPtr animWindow;
WindowPtr designWindow[4];

DesignRecord designWinInfo[4];

static void ResizeDesignWindow(WindowPtr);

/************************************************************************************
			fUCEChẼXN[̃~b^[
					(ݒj
*************************************************************************************/
static void AdjustDesignScroll(design)
DesignPtr design;
{
	WCorePtr contents = (WCorePtr)design->contents;

	int maxvalH = 5000;
	int maxvalV = 5000;
	int minvalH = -5000;
	int minvalV = -5000;

	SetCtrlMaxval(design->scrlHBar,maxvalH);
	SetCtrlMaxval(design->scrlRBar,maxvalV);
	SetCtrlMinval(design->scrlHBar,minvalH);
	SetCtrlMinval(design->scrlRBar,minvalV);
	SetCtrlValue(design->scrlHBar,0);
	SetCtrlValue(design->scrlRBar,0);
	design->scrollx = 0;
	design->scrolly = 0;
	design->scale   = 0.4;
}
/************************************************************************************
			Z^[Cʒuɖ߂

*************************************************************************************/
extern void HomeEvent(item)
MItemPtr item;
{
	int i;

	for(i=0; i<3; i++) {
		AdjustDesignScroll(&designWinInfo[i]);
		InitBackScreen(&designWinInfo[i]);
		WriteForeScreen(&designWinInfo[i]);
		WriteEditScreen(&designWinInfo[i]);
		DrawDesignContents(&designWinInfo[i],15);
	}
	SetCtrlValue(designWinInfo[3].scrlHBar,0);
	SetCtrlValue(designWinInfo[3].scrlRBar,0);
	InitPolygonOffset();

}
/************************************************************************************
			fUCEChẼftHgTCYvZ

*************************************************************************************/
static void SetDesignWindowSize(window)
WindowPtr window;
{
	DesignPtr design = &designWinInfo[GetWindowRefCon(window)];
	int sizeX1 = (DESIGN_WIDTH + 16);
	int sizeY1 = (DESIGN_HEIGHT +16+20);
	int sizeX2 = topLevel.window.width - 20;
	int sizeY2 = topLevel.window.height - 40;

	if (design->scrlLBar != NULL) sizeX1 = sizeX1+15;

	if (sizeX1 > sizeX2) sizeX1 = sizeX2;
	if (sizeY1 > sizeY2) sizeY1 = sizeY2;
	SetWindowStdSize(window,10,30,sizeX1,sizeY1);
}

/************************************************************************************
			fUCEChẼftHgTCYݒ

*************************************************************************************/
extern void ResetDesignWindowSize()
{
	int number;

	for (number=0; number<4; number++) {
		SetDesignWindowSize(designWindow[number]);
	}
}

/************************************************************************************
			EChEʒuɂǂ
						ib@j
*************************************************************************************/
extern void ControlCleanUp(item)

MItemPtr item;
{
	int i;
	int width =  (topLevel.window.width-15)/2;
	int height = (topLevel.window.height-90)/2;
							
	for (i=0; i<4; i++) {					/*fUCEChE*/
		HideApplWindow(designWindow[i]);
		GrowApplWindow(designWindow[i],width,height);
	}
	MoveApplWindow(designWindow[0],2,80);
	MoveApplWindow(designWindow[1],2,height+85);
	MoveApplWindow(designWindow[2],width+10,height+85);
	MoveApplWindow(designWindow[3],width+10,80);

	SetCtrlValue(designWinInfo[3].scrlHBar,0);
	SetCtrlValue(designWinInfo[3].scrlRBar,0);
	InitPolygonOffset();

	for (i=0; i<3; i++)	AdjustDesignScroll(&designWinInfo[i]);
	for (i=0; i<4; i++) ResizeDesignWindow(designWindow[i]); 
	for (i=0; i<4; i++) ShowApplWindow(designWindow[i]);

	HideApplWindow(toolWindow);			/*c[EChE*/
	MoveApplWindow(toolWindow,2,25);
	ShowApplWindow(toolWindow);

	RaiseApplWindow(infoWindow);
	RaiseApplWindow(stateWindow);
}
/************************************************************************************
			fUCEChEJ

*************************************************************************************/
static void OpenDesignWindow(window)

WindowPtr window;
{
	int num = GetWindowRefCon(window);

	ShowApplWindow(window);
	SetMenuMark(windowMenu,num+1,1);
}
/************************************************************************************
			fUCEChE߂

*************************************************************************************/
static void CloseDesignWindow(window)

WindowPtr window;
{
	int num = GetWindowRefCon(window);

	HideApplWindow(window);
	SetMenuMark(windowMenu,num+1,0);
}
/************************************************************************************
			j[ɂfUCEChE̊J

*************************************************************************************/
extern void ControlDesignWindow(item)

MItemPtr item;
{
	WindowPtr window = designWindow[GetItemRefCon(item)-1];
	int mark = GetItemMark(item);

	if (mark == 0)  OpenDesignWindow(window);
	else			CloseDesignWindow(window);
}

/************************************************************************************
			fUCEChȆ傫̒
				iXN[o[̒j
*************************************************************************************/
static void ResizeDesignWindow(window)

WindowPtr window;

{
	DesignPtr design = &designWinInfo[GetWindowRefCon(window)];
	int WHeight = GetWinHeight(window);
	int WWidth = GetWinWidth(window);
	
	HideControl(design->scrlHBar);
	MoveControl(design->scrlHBar,WWidth-16,19);
	GrowControl(design->scrlHBar,15,WHeight-36);
	ShowControl(design->scrlHBar);

	HideControl(design->scrlRBar);
	MoveControl(design->scrlRBar,64,WHeight-16);
	GrowControl(design->scrlRBar,WWidth-81,15);
	ShowControl(design->scrlRBar);

	/*Rc@̍o[ */
	if ( design->scrlLBar != NULL) {
		HideControl(design->scrlLBar);
		GrowControl(design->scrlLBar,15,WHeight-36);
		ShowControl(design->scrlLBar);
		GrowControl(design->contents,WWidth-31,WHeight-36); 
	}
	else	 {
		GrowControl(design->contents,WWidth-16,WHeight-36);
		InitBackScreen(design);
		WriteForeScreen(design);
		WriteEditScreen(design);
		DrawDesignContents(design,15);
	}

	MoveControl(design->zoomIn,-1,WHeight-16);
	MoveControl(design->zoomOut,31,WHeight-16);

}		
/************************************************************************************
			eL[o

*************************************************************************************/
extern void HighCloseTenKey()
{
	int mark;

	if ((mark = GetMenuMark(windowMenu,9)) == 0) HideApplWindow(tenKeyWindow);
		

}

/************************************************************************************
			eL[o

*************************************************************************************/
extern void ShowTenKey(item)
MItemPtr item;
{
	WindowPtr window = tenKeyWindow;
	int mark = GetItemMark(item);

	if (mark == 0)  {
		ShowApplWindow(window);
		SetMenuMark(windowMenu,9,1);
	}
	else			{
		HideApplWindow(window);
		SetMenuMark(windowMenu,9,0);
	}
	
}
	
/************************************************************************************
			eL[߂

*************************************************************************************/
static void CloseTenKey(window)
WindowPtr window;
{
	if (tenkeyMax == 0){
		HideApplWindow(window);
		SetMenuMark(windowMenu,9,0);
	}
}
/************************************************************************************
			eL[̃Cxg[`

*************************************************************************************/
static void TenExpose(event,wcore)
XEventPtr event;
WCorePtr wcore;
{
	WindowPtr window = (WindowPtr)wcore;
	String message = "sj";

	if (event->type == Expose) {
		PrintText(window,40,25,1,&message);
	}

	if (tenkeyMax != 0) {
		if (event->type == KeyPress) {
			InputKeyBord(event,wcore);
		}

	}

}

/************************************************************************************
			eL[

*************************************************************************************/
static WindowPtr CreateTenKey()
{
	WindowPtr window = NewApplWindow(300,100,130,150,"TenKey",0x11,NULL,TenExpose);
	SetWindowCloseProc(window,CloseTenKey);
	
	CreatePushButton(window,-1     ,9     ,35,15,"Esc"  ,'e',InputTenKey);

	CreatePushButton(window,27     ,115     ,25,25,"0"  ,0    ,InputTenKey);
	CreatePushButton(window,27+25*1,115     ,25,25,"clr",'c'  ,InputTenKey);
	CreatePushButton(window,27+25*2,115     ,25,25,"ret",'r'  ,InputTenKey);
	CreatePushButton(window,27     ,115-25*1,25,25,"1"  ,1    ,InputTenKey);
	CreatePushButton(window,27+25*1,115-25*1,25,25,"2"  ,2    ,InputTenKey);
	CreatePushButton(window,27+25*2,115-25*1,25,25,"3"  ,3    ,InputTenKey);
	CreatePushButton(window,27     ,115-25*2,25,25,"4"  ,4    ,InputTenKey);
	CreatePushButton(window,27+25*1,115-25*2,25,25,"5"  ,5    ,InputTenKey);
	CreatePushButton(window,27+25*2,115-25*2,25,25,"6"  ,6    ,InputTenKey);
	CreatePushButton(window,27     ,115-25*3,25,25,"7"  ,7    ,InputTenKey);
	CreatePushButton(window,27+25*1,115-25*3,25,25,"8"  ,8    ,InputTenKey);
	CreatePushButton(window,27+25*2,115-25*3,25,25,"9"  ,9    ,InputTenKey);
	XSelectInput(display,GetWindowID(window),ExposureMask | ButtonPressMask | KeyPressMask);

	return(window);
}

/************************************************************************************
			CtH[VEChE(Wvj

*************************************************************************************/
static WindowPtr InfoMationWindow()
{
	WindowPtr window = NewApplWindow(CADWIDTH-360,30,350,100,"COODINATES",0x08,1,InfoExpose);
	SetApplEventMask(window,ExposureMask);

	return(window);
}
/************************************************************************************
			CtH[VEChEij

*************************************************************************************/
static WindowPtr InfoMationWindow2()
{
	WindowPtr window = NewApplWindow(500,200,300,100,"INFOMATION2",0x08,1,InfoExpose2);
	XSelectInput(display,GetWindowID(window),ExposureMask);

	return(window);
}
/************************************************************************************
			c[EChEJ

*************************************************************************************/
static void OpenToolWindow(window)

WindowPtr window;
{
	ShowApplWindow(window);
	SetMenuMark(windowMenu,7,1);
}

/************************************************************************************
			c[EChE߂

*************************************************************************************/
static void CloseToolWindow(window)

WindowPtr window;
{
	HideApplWindow(window);
	SetMenuMark(windowMenu,7,0);
}
/************************************************************************************
			j[ɂc[EChE̊J

*************************************************************************************/
extern void ControlToolWindow(item)

MItemPtr item;
{
	WindowPtr window = toolWindow;
	int mark = GetItemMark(item);

	if (mark == 0)  OpenToolWindow(window);
	else			CloseToolWindow(window);
	
}

/************************************************************************************
			Aj[V[hǂ̕2

*************************************************************************************/
static void ButtonEventTurning(ctrl,code)
ControlPtr ctrl;
int code;
{
	if (animationFlag == 1) AnimButtonEvent(ctrl,code);	/*Aj[VpXCb`*/
	else					ButtonEvent(ctrl,code);

}
/************************************************************************************
			c[EChE(|Cg[hj̍쐬

*************************************************************************************/
static WindowPtr CreateToolWindow()
{
	int button;
	
	WindowPtr window = NewApplWindow(2,40,10+33*24,48,NULL,0x19,1,NULL);
	
	SetWindowCloseProc(window,CloseToolWindow);

	CreatePictSwitch(window,10+33*0 ,-1,32,48,toolIcons[2]  ,1,2,SwitchCheck);			/*point*/
	CreatePictButton(window,10+33*1 ,-1,32,48,toolIcons[22] ,1,14,NULL);  				/*primitive*/
	CreatePictButton(window,10+33*2 ,-1,32,48,toolIcons[3]  ,1,3,ButtonEventTurning);	/*make*/
	CreatePictSwitch(window,10+33*3 ,-1,32,48,toolIcons[0]  ,1,1,SwitchCheck);			/*pointselect*/
	CreatePictSwitch(window,10+33*4 ,-1,32,48,toolIcons[1]  ,1,11,SwitchCheck);			/*faceselect*/
	CreatePictSwitch(window,10+33*5 ,-1,32,48,toolIcons[6]  ,1,31,SwitchCheck);			/*pointmove*/
	CreatePictSwitch(window,10+33*6 ,-1,32,48,toolIcons[7]  ,1,24,SwitchCheck);			/*facemove*/
	CreatePictSwitch(window,10+33*7 ,-1,32,48,toolIcons[14] ,1,34,SwitchCheck);  		/*flip*/
	CreatePictSwitch(window,10+33*8 ,-1,32,48,toolIcons[15] ,1,33,SwitchCheck);  		/*Mirror*/
	CreatePictSwitch(window,10+33*9 ,-1,32,48,toolIcons[8]  ,1,4,SwitchCheck);			/*pointrotate*/
	CreatePictSwitch(window,10+33*10,-1,32,48,toolIcons[9]  ,1,12,SwitchCheck);			/*facerotate*/
	CreatePictSwitch(window,10+33*11,-1,32,48,toolIcons[10] ,1,5,SwitchCheck);			/*pointscale*/
	CreatePictSwitch(window,10+33*12,-1,32,48,toolIcons[11] ,1,13,SwitchCheck);			/*facescale*/
	CreatePictSwitch(window,10+33*13,-1,32,48,toolIcons[17] ,1,40,SwitchCheck);			/*facecopy*/
	CreatePictButton(window,10+33*14,-1,32,48,toolIcons[16] ,1,14,ButtonEventTurning);  /*faceflip*/
	CreatePictButton(window,10+33*15,-1,32,48,toolIcons[19] ,1,15,ButtonEvent);  		/*faceside*/ 
	CreatePictSwitch(window,10+33*16,-1,32,48,toolIcons[4]  ,1,25,SwitchCheck);			/*addpoint*/
	CreatePictSwitch(window,10+33*17,-1,32,48,toolIcons[18] ,1,16,SwitchCheck);			/*facecut*/
	CreatePictButton(window,10+33*18,-1,32,48,toolIcons[5]  ,1,18,ButtonEventTurning);	/*color*/
	CreatePictButton(window,10+33*19,-1,32,48,toolIcons[21] ,1,8,ButtonEventTurning);  	/*Transfer*/
	CreatePictButton(window,10+33*20,-1,32,48,toolIcons[20] ,1,17,ButtonEventTurning);  /*state*/
	CreatePictButton(window,10+33*21,-1,32,48,toolIcons[12] ,1,32,ButtonEventTurning); 	/*delPoint*/
	CreatePictButton(window,10+33*22,-1,32,48,toolIcons[13] ,1,26,ButtonEventTurning);	/*delface*/
	CreatePictButton(window,10+33*23,-1,32,48,toolIcons[23] ,1,10,ButtonEventTurning);  		/*UNDO*/

	return(window);
}



/************************************************************************************
			fUCEChE̍쐬

*************************************************************************************/
static WindowPtr CreateDesignWindow(num,px,py,width,height,name,design)

int num,px,py,width,height;
String name;
DesignPtr design;
{
	WindowPtr window = NewApplWindow(px,py,width,height,name,0x0f,num,NULL);

	SetWindowCloseProc(window,CloseDesignWindow);
	SetWindowGrowProc(window,ResizeDesignWindow);
	SetWindowZoomProc(window,ResizeDesignWindow);

	design->foreScreen = XCreatePixmap(display,mainWindow,DESIGN_WIDTH,DESIGN_HEIGHT,1);
	design->foreScreen2 = XCreatePixmap(display,mainWindow,DESIGN_WIDTH,DESIGN_HEIGHT,1);
	design->editScreen = XCreatePixmap(display,mainWindow,DESIGN_WIDTH,DESIGN_HEIGHT,1);
	design->backScreen = XCreatePixmap(display,mainWindow,DESIGN_WIDTH,DESIGN_HEIGHT,1);
	design->contents = CreateSubWindow(window,-1,19,width-16,height-36,1,(long)design,DesignEvent);
	design->scrlHBar = CreateScrollBar(window,width-16,18,15,height-37,0,100,50,(long)design,DesignScrollEvent);
	design->scrlRBar = CreateScrollBar(window,64,height-14,width-81,15,0,100,50,(long)design,DesignScrollEvent);
	design->scrlLBar = NULL;

	design->windowNo = num;
	design->window = window;
	design->homex = (DESIGN_WIDTH - (width-16))/2;
	design->homey = (DESIGN_HEIGHT - (height-36))/2;
	design->width = DESIGN_WIDTH;
	design->height = DESIGN_HEIGHT;
	design->scale = 1;
	design->scrollx = 0;
	design->scrolly = 0;

	design->zoomIn  = CreatePictButton(window,0,height-15,32,15,scaleUpPict,1,(long)design,ZoomInContents);
	design->zoomOut = CreatePictButton(window,32,height-15,32,15,scaleDownPict,1,(long)design,ZoomOutContents);

	AdjustDesignScroll(design);
	InitBackScreen(design);
	InitEditScreen(design);
	InitForeScreen(design);
	ResizeDesignWindow(window);

	SetWindowSizeLimit(window,128,128,DESIGN_WIDTH+16+15,DESIGN_HEIGHT+16+20);
	XSelectInput(display,GetWindowID(design->contents),
			ButtonPressMask|PointerMotionMask|PointerMotionHintMask|ButtonReleaseMask|ExposureMask|LeaveWindowMask|
			KeyPressMask);
	return(window);
}
/************************************************************************************
			RcEChE̍쐬

*************************************************************************************/
static WindowPtr Create3DWindow(num,px,py,width,height,name,design)

int num,px,py,width,height;
String name;
DesignPtr design;
{
	WindowPtr window = NewApplWindow(px,py,width,height,name,0x0f,num,NULL);

	SetWindowCloseProc(window,CloseDesignWindow);
	SetWindowGrowProc(window,ResizeDesignWindow);
	SetWindowZoomProc(window,ResizeDesignWindow);

	design->foreScreen = XCreatePixmap(display,mainWindow,DESIGN_WIDTH,DESIGN_HEIGHT,defaultDepth);

	design->contents = CreateSubWindow(window,14,19,width-31,height-36,1,0,Do3DViewEvent);
	design->scrlHBar = CreateScrollBar(window,width-16,18,15,height-37,-180,180,0,1,Do3DViewAction);
	design->scrlRBar = CreateScrollBar(window,64,height-15,width-81,15,-180,180,0,2,Do3DViewAction);
	design->scrlLBar = CreateScrollBar(window,-1,19,15,height-35,	  -180,180,0,3,Do3DViewAction);

	design->windowNo = num;
	design->window = window;
	design->homex = (DESIGN_WIDTH - (width-16))/2;
	design->homey = (DESIGN_HEIGHT - (height-36))/2;
	design->width = DESIGN_WIDTH;
	design->height = DESIGN_HEIGHT;

	design->zoomIn  = CreatePictButton(window,0,height-15,32,15,scaleUpPict,1,0,ZoomInOffsetZ);
	design->zoomOut = CreatePictButton(window,32,height-15,32,15,scaleDownPict,1,0,ZoomOutOffsetZ);

	XSelectInput(display,GetWindowID(design->contents),
		ExposureMask|ButtonMotionMask|PointerMotionHintMask|ButtonPressMask|ButtonReleaseMask);

	ResizeDesignWindow(window);

	SetWindowSizeLimit(window,128,128,DESIGN_WIDTH+16+15,DESIGN_HEIGHT+16+20);
	return(window);
}
/************************************************************************************
			AvPCVEBhȄ

*************************************************************************************/
extern void InitWindows()

{
	int i;
	toolWindow			=  CreateToolWindow();
	designWindow[  TOP_VIEW] = CreateDesignWindow(  TOP_VIEW, 60, 40,460,320,    "Top",&designWinInfo[0]);
	designWindow[FRONT_VIEW] = CreateDesignWindow(FRONT_VIEW, 60,370,460,320,  "Front",&designWinInfo[1]);
	designWindow[RIGHT_VIEW] = CreateDesignWindow(RIGHT_VIEW,530,370,460,320,  "Right",&designWinInfo[2]);
	designWindow[THREE_VIEW] = Create3DWindow(THREE_VIEW,530, 40,460,320,"3D View",&designWinInfo[3]);
	tenKeyWindow 			 = CreateTenKey();
	infoWindow				 = InfoMationWindow();
	infoWindow2              = InfoMationWindow2();
	animWindow 				 = MakeAnimationWin();
	MakeStateWindow();

	ShowApplWindow(toolWindow);
	for (i=0; i<=3; i++) 	ShowApplWindow(designWindow[i]);

#if COODINATE 
	ShowApplWindow(infoWindow);
	SetMenuMark(windowMenu,6,1);
#endif

	InitPolygonPackage(&designWinInfo[3],pointData,POINTNUMBER,polygonData,POLYGONNUMBER);

}

