/************************************************************************************
			t@C֘ÃvO
											by Iwamoto Daiki
*************************************************************************************/
#include <stdio.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>      /*t@C֌W̕W֐*/
#include <dirent.h>		  /*fBNg[֌W̕W֐*/
#include "ToolBox.h"
#include "External.h"
#include "Prototype.h"
#include "FunCad.h"
#include "caduser"

char colorData[0x200];
char paletteData[0x8200];

static char path[256];
static char anim_path[256];
static char colPath[256];
static char fileFlag = 0;
short clearCheckFlag;

/************************************************************************************
			t@C̑I

*************************************************************************************/
static int SaveSelectFilter(entry,status)
struct dirent *entry;
struct stat   *status;
{

	int	namlen = strlen(entry->d_name);

	if (status->st_mode & S_IFDIR) return(true);
	if (namlen <4) 		 return(false);

	if (animationFlag == 1) {
		if (!strcmp(&entry->d_name[namlen-4],".anm")) return(true);
		if (!strcmp(&entry->d_name[namlen-4],".ANM")) return(true);
	}
	else {
		if (!strcmp(&entry->d_name[namlen-4],".txt")) return(true);
		if (!strcmp(&entry->d_name[namlen-4],".TXT")) return(true);
	}

	return(false);
}

/************************************************************************************
			I[vt@C̑I

*************************************************************************************/
static int LoadSelectFilter(entry,status)
struct dirent *entry;
struct stat   *status;
{
	int		namlen = strlen(entry->d_name);

	if (status->st_mode & S_IFDIR) 	return(true);
	if (namlen <4) 					 return(false);

	if (!strcmp(&entry->d_name[namlen-4],".anm")) return(true);
	if (!strcmp(&entry->d_name[namlen-4],".txt")) return(true);
	return(false);
}

/************************************************************************************
			f[^̏

*************************************************************************************/
extern void InitData()
{
	int i,k;

	for (i=0; i<POINTNUMBER; i++)  { 
		moveData[i].flags = 0;
		pointData[i].flags = 0;
		pointData[i].selectFlag = 0;
		moveData[i].selectFlag = 0;
		pointData[i].nextPoint = -1;
		moveData[i].nextPoint = -1;
	}

	for (i=0; i<POLYGONNUMBER; i++)  { 
		polygonData[i].flags = 0;
		polygonData[i].selectFlag = 0;
		polygonData[i].nextPolygon = -1;
		polygonData[i].animation = -1;
	}

	for (i=0; i<OBJNUMBER; i++)  { 
		objectData[i].firstPolygon = -1;
		objectData[i].flags = 0;
	}

	for (i=0; i<INDEX_NUMBER; i++) {
		animIndex[i].flag = 0;
		for (k=0; k<FRAMENUM; k++) {
			animIndex[i].frame[k] = -1;
		}
	}

	for (i=0; i<ANPOINTNUM; i++) animPoint[i].flags = 0;

	for (i=0; i<3; i++)  { 
		InitEditScreen(&designWinInfo[i]);
		InitForeScreen(&designWinInfo[i]);
	}
	
	firsPoint = -1;
	pointNum = 0;
	drawFlag = -1;
	newPoint = -1;
	rootPolygon = -1;
	newPolygon = -1;
	clearCheckFlag = 0;
	fileFlag = 0;
	nlists = 0;
}

/************************************************************************************
			Aj[Vf[^t@C̒ɏ

*************************************************************************************/
static void AnimWriteFile(fp)
FILE *fp;
{
	char code = 0;
	short i;


	code = 3;
	for (i=0; i<INDEX_NUMBER; i++) {
		if (animIndex[i].flag == 1) {
			fwrite(&code,sizeof(char),1,fp);
			fwrite(&i,sizeof(short),1,fp);
			fwrite(&animIndex[i],sizeof(IndexRecord),1,fp);
		}
	}

	code = 4;
	for (i=0; i<ANPOINTNUM; i++) {
		if (animPoint[i].flags == 1) {
			fwrite(&code,sizeof(char),1,fp);
			fwrite(&i,sizeof(short),1,fp);
			fwrite(&animPoint[i],sizeof(PointRecord),1,fp);
		}
	}
}			
	
/************************************************************************************
			t@C̒Ƀf[^

*************************************************************************************/
static short WriteFile(fp)
FILE *fp;
{
	char code = 0;
	char flag = 0;
	short check = 0;    /*f[^Ă邩ǂ*/
	short i;
	short bakNum;

	for (i=0; i<OBJNUMBER; i++) {
		objectData[i].selectFlag = 0;
		if (objectData[i].flags != 0) {
			fwrite(&code,sizeof(char),1,fp);
			fwrite(&i,sizeof(short),1,fp);
			fwrite(&objectData[i],sizeof(ObjectRecord),1,fp);
			if (check == 0) check = 1;
		}
	}

	code= 1;
	for (i=0; i<POLYGONNUMBER; i++) {
		if (polygonData[i].selectFlag == 1) { polygonData[i].selectFlag = 0; flag = 1;}
		if (animationFlag != 1 && polygonData[i].animation != -1) {
				bakNum = polygonData[i].animation;	
				polygonData[i].animation = -1;}
		if (polygonData[i].flags != 0) {
			fwrite(&code,sizeof(char),1,fp);
			fwrite(&i,sizeof(short),1,fp);
			fwrite(&polygonData[i],sizeof(PolygonRecord),1,fp);
		}
		if (animationFlag != 1 && polygonData[i].animation != -1) polygonData[i].animation = bakNum;
		if (flag == 1) { polygonData[i].selectFlag = 1; flag = 0;}
	}
	
	code = 2;
	for (i=0; i<POINTNUMBER; i++) {
		if (pointData[i].selectFlag == 1) { pointData[i].selectFlag = 0; flag = 1;}
		if (pointData[i].flags == 2) {
			fwrite(&code,sizeof(char),1,fp);
			fwrite(&i,sizeof(short),1,fp);
			fwrite(&pointData[i],sizeof(PointRecord),1,fp);
		}
		if (flag == 1) { pointData[i].selectFlag = 1; flag = 0;}
	}
	
	if (animationFlag == 1) AnimWriteFile(fp);


	return(check);
}

/************************************************************************************
			t@C̍쐬

*************************************************************************************/
static void FileMake()
{

	FILE *fp;
	char *Message = "f[^܂II";
	int convCheck = 0;

	fp = fopen(".cadDatafile","w");

	 if ((WriteFile(fp)) == 1) {
		fclose(fp);
	
		if (animationFlag != 1) 	convCheck = ConvertTxtFile(path);
		else 						convCheck = ConvertTxtFile(anim_path);
		if (convCheck == 0) return;

		fileFlag = 1;
		clearCheckFlag = 0;
	}
	else{
		AlertDialog(150,150,390,100,0,2,1,&Message);
		fclose(fp);
	}		
}
	
/************************************************************************************
			t@C̃`FbN_CAO
*************************************************************************************/
static char SaveFileAlert(file)
char *file;
{
	FILE *fp;
	char St[256];
	char flag = 0;
	char *Message1 = "t@Cl[͂W܂ŁI";
	short count;
	int check;
	String Message;

	count = strlen(rindex(file,'/')+1);				    /*t@C̒𒲂ׂ*/
	if (count > 12) {
	AlertDialog(150,150,390,100,0,3,1,&Message1);
	return(0);
	}

	if ((fp = fopen(file,"r")) == NULL) check = 0;		/*t@C̗L𒲂ׂ*/
	else 								{check = 1; fclose(fp);}
	
	strcpy(St,index((file+5),'/')+1);
	if (check == 0) strcat(St,"\nɃZ[u܂B낵ł?? ");
	else			strcat(St,"\n܂B낵łH");

	Message = St;
	if (AlertDialog(150,150,390,100,1,2,1,&Message) == 1) flag = 1;

	return(flag);
}
/************************************************************************************
			t@C̊gq`FbN

*************************************************************************************/
static void FileCheck()
{
	char check = 0;
	char file[256];
	short count;
	short Acount;

	count = strlen(path);
	Acount = strlen(anim_path);

/*	printf("##path %s\n",path);*/
	printf("##anim_path %s\n",anim_path);
	
	if (animationFlag != 1) {
		if (count < 4 || strcmp(&path[count-4],".txt") != 0) {
			if (strcmp(&path[count-4],".anm") == 0) strcpy(&path[count-4],".txt");     /* Write Over ".anm" to ".txt" */
		    else                                    strcat(path,".txt");
		}
		strcpy(file,path);							/*t@CRs[*/
	}
	else {
		if (Acount < 4 || strcmp(&anim_path[Acount-4],".anm") != 0) {
			if (strcmp(&anim_path[Acount-4],".txt") == 0) 	strcpy(&anim_path[Acount-4],".anm");
			else                                            strcat(anim_path,".anm");
		}
		strcpy(file,anim_path);							/*t@CRs[*/
	}

/*	printf("##file %s\n",file);*/

	if ( (check = SaveFileAlert(file)) == 1) FileMake();


}
/************************************************************************************
			t@C̏

*************************************************************************************/
extern void SaveFileAs(item)
MItemPtr item;
{
	int result;
	int i,flag = 0;
	char save_path[256];


	if (animationFlag == 1) {
		if (result = SelectOutputFile(100,80,save_path,SaveSelectFilter) == 1) 
				{strcpy(anim_path,save_path);	FileCheck(); }
	}
	else 			{
		if (result = SelectOutputFile(100,80,save_path,SaveSelectFilter) == 1) 
				{strcpy(path,save_path);		FileCheck(); }
	}


}

/************************************************************************************
			t@C̏
					(t@CłɎw肳ĂƂj
*************************************************************************************/
extern void SaveFile(item)
MItemPtr item;
{
	if (fileFlag == 1) FileCheck();
	else 		    SaveFileAs(NULL);
}


/************************************************************************************
			Aj[VɂȂƂ̃t@Cl[̏
*************************************************************************************/
extern void AnimSaveInit() 
{

	fileFlag = 0;
}
/************************************************************************************
			[hEE
************************************************************************************
			[hf[^

*************************************************************************************/
static void DrawFileData()
{
	short poly_check;
	int i;

	for (i=0; i<POLYGONNUMBER; i++) {
		if (polygonData[i].flags != 0)  DrawPolygon(i,'F');
	}

	for (i=0; i<POINTNUMBER; i++) {
	  if (pointData[i].flags == 1) {
		XSetForeground(display,bitmapGC,1);   /*ԓh*/
		XSetLineAttributes(display,bitmapGC,5,LineSolid,CapRound,JoinRound);
		PointDesignWindow(&designWinInfo[0],'E',i);
		PointDesignWindow(&designWinInfo[1],'E',i);
		PointDesignWindow(&designWinInfo[2],'E',i);
	  }
	}

	XSetForeground(display,bitmapGC,1);   /*œ_          */
	XSetLineAttributes(display,bitmapGC,4,LineSolid,CapRound,JoinRound);
	for (i=0; i<POINTNUMBER; i++) {
		if (pointData[i].flags == 2) { 
			PointDesignWindow(&designWinInfo[0],'F',i);
			PointDesignWindow(&designWinInfo[1],'F',i);
			PointDesignWindow(&designWinInfo[2],'F',i);
		}
	}	

	poly_check = objectData[0].firstPolygon;
	if (poly_check == -1) rootPolygon = -1;
	else {
		while (poly_check != -1) {
			if (polygonData[poly_check].nextPolygon == -1) {rootPolygon = poly_check; break;}
			poly_check = polygonData[poly_check].nextPolygon;
		}
	}

	if (animationFlag == 1) AnimLoadData();
	else {
		for (i=0; i<3; i++) DrawDesignContents(&designWinInfo[i],14);
		Draw3DWindow();
	}


}


/************************************************************************************
			t@C̃[h

*************************************************************************************/
static void LoadFile()
{
	FILE *fp;
	char i;
	char code;
	short No;
	

	InitData();
	for (i=0; i<3; i++) DrawDesignContents(&designWinInfo[i],14);
	Draw3DWindow();

    fp = fopen(".cadDatafile","r");
		
	while((fread(&code,sizeof(char),1,fp)) != NULL) {	
		fread(&No,sizeof(short),1,fp);
	
		switch (code) {		
			case 0: fread(&objectData[No],sizeof(ObjectRecord),1,fp);    break;
			case 1: fread(&polygonData[No],sizeof(PolygonRecord),1,fp);  break;
			case 2: fread(&pointData[No],sizeof(PointRecord),1,fp);      break;
			case 3: fread(&animIndex[No],sizeof(IndexRecord),1,fp);	 	 break;
			case 4: fread(&animPoint[No],sizeof(PointRecord),1,fp);		 break;
		}
     }

	fclose(fp);

	DrawFileData();

	fileFlag = 1;
	clearCheckFlag = 0;
}

/************************************************************************************
			t@C̓ǂ݂
*************************************************************************************/
extern void FileOpen(item)
MItemPtr item;
{
	int result;
	short flag = 1;
	short count;
	char load_path[256];
	char *Message1 = "f[^Z[uĂ܂EE\n낵ł??";

	if (clearCheckFlag == 1) {
		XBell(display,0);
		flag = AlertDialog(150,150,400,100,1,2,1,&Message1);
	}


	if (flag == 1) {
		result = SelectInputFile(100,80,load_path,LoadSelectFilter);
		if (result == 1) {
			strcpy(path,load_path);
			count = strlen(path);
			if (animationFlag == 0 && count < 4 || strcmp(&path[count-4],".anm") == 0) {
				strcpy(anim_path,path);
				animationFlag = 1;
				frameNo = 0;
				EnableMenuItem(margeMenu,2,0);		/*}[Wgp֎~*/
				EnableMenuItem(margeMenu,3,0);
			 	EnableMenuItem(margeMenu,4,0);
				ShowApplWindow(animWindow);
			}
			if (animationFlag == 1 && count < 4 || strcmp(&path[count-4],".txt") == 0) {
				HideApplWindow(animWindow);
				animationFlag = 0;
				EnableMenuItem(margeMenu,2,1);		/*}[Wgp֎~ɉ*/
				EnableMenuItem(margeMenu,3,1);
			 	EnableMenuItem(margeMenu,4,1);
			}

			ConvertCadFile(path);
			LoadFile();
		}
	}
}



/************************************************************************************
			EChẼNA[
*************************************************************************************/
extern void ClearWindow(item)
MItemPtr item;
{
	char *Message1 = "f[^Z[uĂ܂EE\n낵ł??";
	int i;

	if (clearCheckFlag == 1) {
			XBell(display,0);
			if (AlertDialog(150,150,400,100,1,2,1,&Message1) != 1) return;
	}

	InitData();

	if (animationFlag == 1) {
		HideApplWindow(animWindow);
		frameNo = 0;
		animationFlag = 0;
		EnableMenuItem(margeMenu,2,1);		/*}[Wgp֎~ɉ*/
		EnableMenuItem(margeMenu,3,1);
	 	EnableMenuItem(margeMenu,4,1);
	}

	for (i=0; i<3; i++) DrawDesignContents(&designWinInfo[i],14);
	Draw3DWindow();
	fileFlag = 0;

}

/************************************************************************************
			lr|cnr̂C
*************************************************************************************/
extern void FloppyOn(MItemPtr item) 
{
	FILE	*fp;
	int		data;
	int		buff[100];
	int		dat;
	char *Message = "fBXNZbgĂ܂I";

	if (GetItemMark(item) == 0) {
		system(DISKON);						/*DISKONdefineŒ`*/
		fp = fopen(".msdoscheck", "r");

		if ( ( dat = fread(buff, sizeof(char), 1, fp)) == 0 ){
			SetItemMark(item,1);
		} else {
			AlertDialog(150,150,400,100,0,2,1,&Message);
		}
	}		
	else	{
		SetItemMark(item,0);
		system("umountu /dev/fd0 ");
		system("fe");
	}

}
/************************************************************************************
			vgo
*************************************************************************************/
extern void PrintOut(MItemPtr item)
{
	char i;
	char *Message = "݂̃C[Wf[^o͂܂\n낵łH";

	if (AlertDialog(100,150,300,100,1,1,1,&Message) == 1) {

		HideApplWindow(toolWindow);
		if (GetMenuMark(windowMenu,6) == 1) HideApplWindow(infoWindow);
		if (stateFlag == 1) 				HideApplWindow(stateWindow);
		for (i=0; i<3; i++) DrawDesignContents(&designWinInfo[i],15);
		XFlush(display);

		system ("xwd  -out .xwdfile -name 3Ddraw");
		system ("xwdlpr -Psjlbp -max a4 -rot .xwdfile");

		ShowApplWindow(toolWindow);
		if (GetMenuMark(windowMenu,6) == 1) ShowApplWindow(infoWindow);
		if (stateFlag == 1) 				ShowApplWindow(stateWindow);
	}
}
/************************************************************************************
			Z[uƃyCXg
*************************************************************************************/

/************************************************************************************
			ǉ[h2
*************************************************************************************/
static short LoadPointOfPolygon(Point *BpointData,short Num)
{
	short pointNo = Num;
	short i;
	short rootPoint = -1;
	short firstPoint = -1;

		for (i=0; i<POINTNUMBER; i++) {
			if (pointData[i].flags == 0) {
				pointData[i].flags = 2;
				pointData[i].nextPoint = -1;
				if (rootPoint != -1) pointData[rootPoint].nextPoint = i;
				rootPoint = i;
				pointData[i].pointx = (BpointData+pointNo)->pointx;
				pointData[i].pointy = (BpointData+pointNo)->pointy;
				pointData[i].pointz = (BpointData+pointNo)->pointz;
				if (firstPoint == -1 ) firstPoint = i;

				if ((pointNo = (BpointData+pointNo)->nextPoint) == -1 ) break;
			}
		}

	return(firstPoint);
}

/************************************************************************************
			ǉ[h
*************************************************************************************/
static void AddLoadFile(fp)
FILE *fp;
{
	Object  BobjectData[OBJNUMBER];
	Polygon BpolygonData[POLYGONNUMBER];
	Point   BpointData[POINTNUMBER];
	char code;
	short No;
	short firstPolygon;
	short pointNo;
	short i;

	while((fread(&code,sizeof(char),1,fp)) != NULL) {	
		fread(&No,sizeof(short),1,fp);
		switch (code) {		
			case 0: fread(&BobjectData[No],sizeof(ObjectRecord),1,fp);    break;
			case 1: fread(&BpolygonData[No],sizeof(PolygonRecord),1,fp);  break;
			case 2: fread(&BpointData[No],sizeof(PointRecord),1,fp);      break;
		}
     }
	if (BobjectData[0].flags == 0) return;	


	firstPolygon = BobjectData[0].firstPolygon;

	for (i=0; i<POLYGONNUMBER; i++) {
		if (polygonData[i].flags == 0) {
			polygonData[i].flags = 1;
			polygonData[i].nextPolygon = -1;
			if (rootPolygon == -1) {objectData[0].firstPolygon = i; objectData[0].flags = 1;}
			else				   polygonData[rootPolygon].nextPolygon = i;
			rootPolygon = i;
			polygonData[i].animation = BpolygonData[firstPolygon].animation;
			polygonData[i].side = BpolygonData[firstPolygon].side;
			polygonData[i].npoints = BpolygonData[firstPolygon].npoints;
			polygonData[i].color = BpolygonData[firstPolygon].color;
			pointNo = BpolygonData[firstPolygon].firstPoint;
			polygonData[i].firstPoint = LoadPointOfPolygon(&BpointData[0],pointNo);

			if ((firstPolygon = BpolygonData[firstPolygon].nextPolygon) == -1) break;
		}
	}

}
	

/************************************************************************************
			Z[ûoĂCxg
*************************************************************************************/
extern void PasteEvent(MItemPtr item)
{
	FILE *fp;

	if((fp = fopen(".3DMemoryFile", "r")) == NULL){
		fprintf(stderr, "Can't open %s\n", ".3DMemoryFile");
	}
	else {
		CpyToolData();
		AddLoadFile(fp);
		DrawFileData();
	}

	fclose(fp);

}

/************************************************************************************
			ꎞZ[uCxg
*************************************************************************************/
extern void MemoryEvent(MItemPtr item)
{
	FILE *fp;
	char *Message = "[܂";
	char check;

	if ((AlertDialog(50,30,300,80,1,2,1,&Message)) == 1) {
	
		fp = fopen(".3DMemoryFile", "w");
		WriteFile(fp);
		fclose(fp);	
	}


}

/************************************************************************************
			֌W̃t@Cǂݍ
*************************************************************************************/

/************************************************************************************
			t@C̑I(.col)
*************************************************************************************/
static int SelectFilter2(entry,status)
struct dirent *entry;
struct stat   *status;
{

	int	namlen = strlen(entry->d_name);

	if (status->st_mode & S_IFDIR) return(true);
	if (namlen <4) 		 			return(false);

	if (!strcmp(&entry->d_name[namlen-4],".col")) return(true);
	if (!strcmp(&entry->d_name[namlen-4],".COL")) return(true);
	return(false);
}
/************************************************************************************
			J[t@C̃[h

*************************************************************************************/
static void LoadColorFile()
{
	FILE *fp;
	short data;
	int endflag = 0;

     fp = fopen(colPath,"r");

 	fread(colorData,sizeof(char),0x200,fp);

	fclose(fp);
}
/************************************************************************************
			J[t@C̓ǂ݂

*************************************************************************************/
extern void ColorFileOpen(item)
MItemPtr item;
{
	int result;
	
	if ((result = SelectInputFile(100,80,colPath,SelectFilter2)) == 1) {
		LoadColorFile();
	}
}
/************************************************************************************
			t@C̑I(.pal)

*************************************************************************************/
static int SelectFilter3(entry,status)
struct dirent *entry;
struct stat   *status;
{
	int	namlen = strlen(entry->d_name);

	if (status->st_mode & S_IFDIR) 	return(true);
	if (namlen <4) 		 			return(false);

	if (!strcmp(&entry->d_name[namlen-4],".pal")) return(true);
	if (!strcmp(&entry->d_name[namlen-4],".PAL")) return(true);
	return(false);
}
/************************************************************************************
			J[pbg̃t@C̃[h

*************************************************************************************/
static void LoadPalletFile()
{
	FILE *fp;

    fp = fopen(colPath,"r");

 	fread(paletteData,sizeof(char),0x8200,fp);

	fclose(fp);
}
/************************************************************************************
			J[t@C̓ǂ݂

*************************************************************************************/
extern void PalletFileOpen(item)
MItemPtr item;
{
	int result;
	
	if ((result = SelectInputFile(100,80,colPath,SelectFilter3)) == 1) {
		LoadPalletFile();
	}
}

/************************************************************************************
			Ԃ̃t@C̃obNAbv

*************************************************************************************
*************************************************************************************/



/************************************************************************************
			t@C̃obNAbv

*************************************************************************************/
extern void InitFileSave()
{
	FILE *fp;
	char code;

	animationFlag = 0;

	if ((fp = fopen(".3dCadData","w")) != NULL) {
		WriteFile(fp);
		code = 5;
		fwrite(&code,sizeof(char),1,fp);
		fwrite(&code,sizeof(short),1,fp);
		fwrite(colorData,sizeof(char),0x200,fp);
		fwrite(paletteData,sizeof(char),0x8200,fp);
	}
		
	fclose(fp);

}

/************************************************************************************
			t@C̃[h

*************************************************************************************/
extern void InitFileLoad()
{
	FILE *fp;

	char code;
	char endflag = 0;
	short No;

 if ((fp = fopen(".3dCadData","r")) != NULL)  {
		
		
	while((fread(&code,sizeof(char),1,fp)) != NULL) {	

		fread(&No,sizeof(short),1,fp);
	
		switch (code) {		
			case 0: fread(&objectData[No],sizeof(ObjectRecord),1,fp);    break;
			case 1: fread(&polygonData[No],sizeof(PolygonRecord),1,fp);  break;
			case 2: fread(&pointData[No],sizeof(PointRecord),1,fp);      break;
			case 3: fread(&animIndex[No],sizeof(IndexRecord),1,fp);	 	 break;
			case 4: fread(&animPoint[No],sizeof(PointRecord),1,fp);		 break;
			case 5:	fread(colorData,sizeof(char),0x200,fp);
					fread(paletteData,sizeof(char),0x8200,fp);			 
		}
     }


	fclose(fp);

	DrawFileData();

 }

}
/************************************************************************************
			]̕یobNAbv
*************************************************************************************/
extern void TransFileSave()
{
	FILE *fp;
	char code;

	if ((fp = fopen(".backupdata","w")) != NULL) {
		WriteFile(fp);
	}
		
	fclose(fp);

}

