/************************************************************************
		IWAMOTO CAD Υեǡ
		դɤΥեǡեޥåȤѴ롣
 ************************************************************************/

#include 	<stdio.h>
#include	<string.h>
#include	<ctype.h>
#include 	<math.h>

#define		Debug		0
#define		unchar		unsigned char

/************************************************************************
		 -ãĥץѿ
 ************************************************************************/

typedef struct {
	char	flags;			/* եå											*/
	char	selectFlag;
	short	parentObject;	/* ƥ֥ȤؤΥǥå					*/
	short	nextBrother;	/* η索֥ȤؤΥǥå				*/
	short	childObject;	/* ǽλҥ֥ȤؤΥǥå				*/
	short	firstPolygon;	/* ǽΥݥꥴؤΥǥå					*/
	double	offsetx;		/* ƤȤΥեåȣ								*/
	double	offsety;		/* ƤȤΥեåȣ								*/
	double	offsetz;		/* ƤȤΥեåȣ								*/
} Object;

typedef struct {
	char	flags;			/* եå											*/
	char	selectFlag;
	short	nextPolygon;	/* Ʊ쥰롼ΥݥꥴؤΥǥå			*/
	short	firstPoint;		/* ݥꥴĺؤΥǥå			*/
	short	animation;
	short	both;			/* ξ̥ݥꥴΤȤ¦ؤΥǥå			*/
	unchar  side;			/* ݥꥴɽ΢Υեå							*/
	unchar	color;			/* ݥꥴο										*/
	unchar	npoints;		/* ݥꥴĺ									*/
} Polygon;

typedef struct {
	char	flags;			/* եå											*/
	char	selectFlag;
	short	nextPoint;		/* ΥݥȤؤΥǥå						*/
	double	pointx;			/* غɸ											*/
	double	pointy;			/* ٺɸ											*/
	double	pointz;			/* ںɸ											*/
} Point;


Object	DATAObject[10];
Polygon	DATAPolygon[500];
Point	DATAPoint[1000];

int		ColorData[500];

int		TOTALObject;	
int		TOTALPolygon;
int		TOTALPoint;

/************************************************************************
			ץǡХåե
 ************************************************************************/

#define	pointmax	3000

char	PointData[pointmax];	/* ݥȥǡΥХåե */
int		PointTotal;				/* ݥȤΥȡ 	*/
char	FaceData[300][16];		/* ե(ݥꥴ)ǡ	*/

char	facedatawork[16];

/************************************************************************
			ᥤ롼
 ************************************************************************/

void main ( argc,argv )

int 	argc;
char	*argv[];

{

	FILE	*inputFP;		/* ã(Σţף)ǡΥեݥ		*/
	FILE	*outputFP;		/* դɤ(ԣأ)ǡΥեݥ */

/*----------------------------------------------------------------------*/
/*		顼å													*/
/*----------------------------------------------------------------------*/

		if ( argc != 3 ) {
			fprintf(stderr, "***********************************************\n");
			fprintf(stderr, "*                                             *\n");
			fprintf(stderr, "*    ģã(Σţף)ǡ             *\n");
			fprintf(stderr, "*    դɤΣԣأԥǡѴޤ *\n");
			fprintf(stderr, "*                                             *\n");
			fprintf(stderr, "*    cadfun (filename.cad) (filename.txt)     *\n");
			fprintf(stderr, "*                                             *\n");
			fprintf(stderr, "***********************************************\n");
			exit( 1 ) ;
		}

/*----------------------------------------------------------------------*/
/*		ģã(Σţף)ǡɤ߹							*/
/*----------------------------------------------------------------------*/

		if ((inputFP = fopen(argv[1],"r")) == NULL ){
			fprintf(stderr, "==== ϥե륨顼 (%s) ====\n",argv[1]); 
			exit( 1 ) ;
		}

		printf( "***** ãĥǡ %s եɤ߹ߤޤ*****\n",argv[1]);

/*----------------------------------------------------------------------*/
/*		ǡѴ!!													*/
/*----------------------------------------------------------------------*/

		ReadCad(inputFP);			/* ãĥǡɤ߹ 	*/

		BuffCad();					/* ãĥǡŸ		*/


		if ((outputFP = fopen(argv[2],"w")) == NULL ){
			fprintf(stderr, "==== ϥե륨顼 (%s) ====\n",argv[2]); 
			exit( 1 ) ;
		}


		WriteCad(outputFP);			/* դɤեޥåȤǣңͤؽ񤭹 */

/*----------------------------------------------------------------------*/
/*		λ															*/
/*----------------------------------------------------------------------*/

		fclose(outputFP);
		fclose(inputFP);

/*----------------------------------------------------------------------*/

		printf( "***** Ѵλޤ*****\n");

}

/************************************************************************
		ãĥǡɤ߹
 ************************************************************************/

ReadCad(inputFP)
FILE	*inputFP;

{
	int	object_counter = 0;
	int	polygon_counter = 0;
	int	point_counter = 0;
	char	headder;
	short	pt;


		printf ("*****\n");
		while ( fread (&headder,sizeof(char),1,inputFP) != NULL ){

			switch 	(headder){

				case	0:

					fread (&pt,sizeof(short),1,inputFP);
					fread (&DATAObject[pt],sizeof(Object),1,inputFP);

#if Debug
					printf (" ֥ȹ¤ ======================== \n");
#endif

					break;
	
				case	1:

					fread (&pt,sizeof(short),1,inputFP);
					fread (&DATAPolygon[pt],sizeof(Polygon),1,inputFP);

#if Debug
					printf (" ݥꥴ¤ ************************** \n");
					printf (" ʥС         %d\n",pt);
					printf (" flags       ---> %d\n",DATAPolygon[pt].flags);
					printf (" selectFlag  ---> %d\n",DATAPolygon[pt].selectFlag);
					printf (" nextPolygon ---> %d\n",DATAPolygon[pt].nextPolygon);
					printf (" firstPoint  ---> %d\n",DATAPolygon[pt].firstPoint);
					printf (" animation   ---> %d\n",DATAPolygon[pt].animation);
					printf (" both        ---> %d\n",DATAPolygon[pt].both);
					printf (" side        ---> %d\n",DATAPolygon[pt].side);
					printf (" color       ---> %d\n",DATAPolygon[pt].color);
					printf (" npoints     ---> %d\n",DATAPolygon[pt].npoints);
#endif

					break;

				case	2:

					fread (&pt,sizeof(short),1,inputFP);
					fread (&DATAPoint[pt],sizeof(Point),1,inputFP);

#if	Debug
					printf (" ݥȹ¤ --------------------------- \n");
					printf (" ʥС         %d\n",pt);
					printf (" flags       ---> %d\n",DATAPoint[pt].flags);
					printf (" selectFlag  ---> %d\n",DATAPoint[pt].selectFlag);
					printf (" nextPoint   ---> %d\n",DATAPoint[pt].nextPoint);
					printf (" pointx      ---> %lf\n",DATAPoint[pt].pointx);
					printf (" pointy      ---> %lf\n",DATAPoint[pt].pointy);
					printf (" pointz      ---> %lf\n",DATAPoint[pt].pointz);
#endif

				break;

			}

		}


}

/************************************************************************
		ãĥǡХåեؤ
 ************************************************************************/

BuffCad()

{

		int	polyNO;
		int	pointNO;
		int	search_counter = 0;
		int	point_counter =  0;
		int	face_counter = 0;
		int	faceCT;
		int	px,py,pz,sx,sy,sz;
		int	i;
		int	flag = 0;

			for (i=0;i<pointmax;i++){
				PointData[i] = 0xffff;
			}


			polyNO = DATAObject[0].firstPolygon;

			while ( polyNO != -1 ){

				pointNO = DATAPolygon[polyNO].firstPoint;	/* ǽΥݥꥴκǽֹңţ */
				faceCT = 0;									/* ĺ󥿤򣰤˥ꥻå */

				while ( pointNO != -1 ){
															/* ǽɤߤ */
					if (( DATAPoint[pointNO].pointx ) >= 0 ) 	px = DATAPoint[pointNO].pointx + 0.5;
					else 	px = DATAPoint[pointNO].pointx - 0.5;
					if (( DATAPoint[pointNO].pointy ) >= 0 )	py = DATAPoint[pointNO].pointy + 0.5;
					else 	py = DATAPoint[pointNO].pointy - 0.5;
					if (( DATAPoint[pointNO].pointz ) >= 0 )	pz = DATAPoint[pointNO].pointz + 0.5;
					else 	pz = DATAPoint[pointNO].pointz - 0.5;


					/*=====  ݥȥǡϰϤ򤳤饨顼ե饰ΩƤ  =====*/
					if ( px > 127 || px < -127 || py > 127 || py < -127 || pz > 127 || pz < -127 ){
						flag=1;
					}
				
					search_counter = point_counter;			/* ߤҤȤļ򥵡Ȥ	*/
					if ( point_counter == 0 ) search_counter = -3;	/* ǽɬå				*/

															/* Ʊɸõ	*/
					while ( search_counter >= 0){

						sx = PointData[search_counter+0];
						sy = PointData[search_counter+1];
						sz = PointData[search_counter+2];

						if (px == sx && py == sy && pz == sz){
							break;
						}

						search_counter = search_counter - 3;
					}

					if (search_counter < 0){

						search_counter = point_counter;			/* Ȥʤ롪	*/

						PointData[point_counter+0] = px;
						PointData[point_counter+1] = py;
						PointData[point_counter+2] = pz;

						point_counter = point_counter+3;

					}

															/* ĺֹ򥻥åȤ */
					FaceData[face_counter][faceCT+1] = search_counter/3;

					pointNO = DATAPoint[pointNO].nextPoint;	/* Υݥֹõ */
					faceCT++;								/* ĺο򣱤䤹	*/	

				}

				FaceData[face_counter][0] = faceCT;			/* ĺο */
				ColorData[face_counter]= DATAPolygon[polyNO].color;
															/* եΥ顼 */
				face_counter++;								/* եΥ󥿤ҤȤ䤹 */

				polyNO = DATAPolygon[polyNO].nextPolygon;	/* Υݥꥴֹõ */

			}

			TOTALPoint = point_counter/3;

}

/************************************************************************
		ХåեդɤեޥåȤؤʤ
 ************************************************************************/

WriteCad(outputFP)
FILE	*outputFP;

{

	int	i,j;
	int	faceCT;

		fprintf (outputFP,"3DG1\n");
		fprintf (outputFP,"%d\n",TOTALPoint);

		for (i=0;i<TOTALPoint;i++){
			fprintf (outputFP,"%d %d %d\n",PointData[i*3+0],PointData[i*3+1],PointData[i*3+2]);
		}

		i = 0;
		while	( (faceCT = FaceData[i][0]) != 0 ){

			fprintf (outputFP,"%d",FaceData[i][0]);				/* ĺθĿ	*/

			for (j=0;j<faceCT;j++){
				fprintf (outputFP," %d",FaceData[i][j+1]);		/* ĺֹ		*/
			}

			fprintf (outputFP," %d\n",ColorData[i]);			/* 顼ǡ */
			i++;

		}





}


