/************************************************************************
		makerace = makemap (ưѤ)
		ޥåץǡɤ߹ǤΥޥåפ
		¸ߤ륷ץꥹȤ
 ************************************************************************/

#include 	<stdio.h>
#include	<string.h>
#include	<ctype.h>
#include 	<math.h>

#define		NewFile 		1
#define		SameFile		0

#define		MAXFACE			8000
#define		MAXPOINT		8000

#define		TRUE			1
#define		FALSE			0

#define		MINvector		0.0001	/* ˡ٥ȥ					*/
#define		DXFfile			0		/* ٥٥򤹤٤ɽȤ롪	*/

/************************************************************************
		¤Τ
 ************************************************************************/

/*------ ףϣң̣ģͣФΥ֥쥳ɥǡ ------*/

typedef struct	{
		char	shapeNAME[32];		/* X פ̾		*/
		short	posX;				/* 0 ɸ	X			*/
		short	posY;				/* 1 ɸ	Y			*/
		short	posZ;				/* 2 ɸ	Z			*/
		short	angX;				/* 3 	X			*/
		short	angY;				/* 4 	Y			*/
		short	angZ;				/* 5 	Z			*/
		short	yobi_0;				/* 6 ͽ 				*/
		short	yobi_1;				/* 7 ͽ 				*/
		short	yobi_2;				/* 8 ͽ 				*/
		short	yobi_3;				/* 9 ͽ 				*/
		short	yobi_4;				/* 10 ͽ 				*/
		short	yobi_5;				/* 11 ͽ 				*/
		short	yobi_6;				/* 12 ͽ 				*/
		short	yobi_7;				/* 13 ͽ 				*/
		short	yobi_8;				/* 14 ͽ 				*/
		short	yobi_9;				/* 15 ͽ 				*/
}	SAVEMAP;

/*----- Ͽơ֥ ----*/

typedef	struct	{
		char	shapeNAME[32];		/* X פ̾		*/
}	SHAPES;



/*----- ״طι¤-----*/

typedef	struct	{
	float	vectorX;						/* ׼Ȥλĥ٥ȥ	*/
	float	vectorY;
	float	vectorZ;
}	VECTOR;


typedef	struct	{
	int		pointX;						/* ܥǥɸ		*/
	int		pointY;
	int		pointZ;
	float	vectorX;					/* Τˡ٥ȥ	*/
	float	vectorY;
	float	vectorZ;
}	SHAPEPOINT;

typedef	struct	{
	int		facepoint;						/* եĺ			*/
	int		pointNO[16];					/* max 16				*/
	int		color;							/* 顼ǡ				*/
	float	planeA;							/* ʿ̤Υѥ᡼	*/
	float	planeB;
	float	planeC;
	float	planeD;
	int		planeN;							/* ñ̥٥ȥ礭 = sqrt ( A*A + B*B + C*C )	*/
	int		distance;						/* ʿ̤ޤǤεΥ						*/
	int		side;							/* ̤ˤä¾ʬ̤	*/
	int		xmax;
	int		ymax;
	int		zmax;
	int		xmin;
	int		ymin;
	int		zmin;
} 	SHAPEFACE;

typedef struct	nodebsp	{

	int			keyface;					/* ʬ䤹뤿Υեֹ			*/
	unsigned	char	faceall[256];		/* ϥݥ󥿤Ǥϣˤ⤷ʤ	*/
	unsigned	char	leftface[256];
	unsigned	char	rightface[256];

	struct	nodebsp	*left;
	struct	nodebsp	*right;

}	BSPTREE;

typedef	struct	{

	SHAPEPOINT	*shapepoint;				/* ץݥȹ¤ΤؤΥݥ	*/
	SHAPEFACE	*shapeface;					/* ץե¤ΤؤΥݥ	*/
	BSPTREE		*bsptree;					/* BSPtree¤ΤؤΥݥ			*/
	int			PointTotal;					/* ݥȤΥȡ 				*/
	int 		FaceTotal;					/* եΥȡ					*/
	int			ramNO;						/* ΥǡΥեåȣңaddress	*/
	int			scale;						/* פΥ					*/
	char		*ramPstart;					/* פƬɥ쥹				*/
	int			xmax;						/* פΥꥸ					*/
	int			ymax;
	int			zmax;

}	MAKESHAPE;



/************************************************************************
		ѿ		
 ************************************************************************/

#define	mapobjmax	0x400			/* ޥåפΥǡĿ	*/

SAVEMAP	MapData[mapobjmax];			/* 1024ǡ * 40h	*/
SHAPES	ShapeTable[mapobjmax];
MAKESHAPE	MSPtr;					/* ᥤݥ	*/

/************************************************************************
		ᥤ롼
 ************************************************************************/

void main ( argc,argv )

int 	argc;
char	*argv[];

{

	FILE	*inputFP;	
	FILE	*shapeFP,*worldFP,*tableFP;	
	char	inname[100];
	char	worldname[100],shapename[100],tablename[100];
	int		i;

/*----------------------------------------------------------------------*/
/*		顼å													*/
/*----------------------------------------------------------------------*/

		if ( argc < 2 ){
			fprintf(stderr, "***********************************************\n");
			fprintf(stderr, "*                                             *\n");
			fprintf(stderr, "*    ͣУԣϣϣ̤Υޥåץǡ           *\n");
			fprintf(stderr, "*    ɣΣģ٥ޥåץǡѴޤ *\n");
			fprintf(stderr, "*              (version 2.21)                 *\n");
			fprintf(stderr, "*                                             *\n");
			fprintf(stderr, "*    makerace (filename).map                  *\n");
			fprintf(stderr, "*                                             *\n");
			fprintf(stderr, "*    ϥե̾                         *\n");
			fprintf(stderr, "*    ShapeData.c                              *\n");
			fprintf(stderr, "*    WorldData.c                              *\n");
			fprintf(stderr, "*    ShapeTable.h                             *\n");
			fprintf(stderr, "*    << ǡư >>             *\n");
			fprintf(stderr, "*                                             *\n");
			fprintf(stderr, "*                   Programed By H.Yajima     *\n");
			fprintf(stderr, "*                                1994.4.13    *\n");
			fprintf(stderr, "*                                             *\n");
			fprintf(stderr, "***********************************************\n");
			exit( 1 ) ;
		}

/*----------------------------------------------------------------------*/
/*																*/
/*----------------------------------------------------------------------*/

		printf("(ST) ***** makerace Ѵ򳫻Ϥޤ***** \n");

		for(i=0;i<mapobjmax;i++){
			MapData[i].shapeNAME[0]		= 0;		/* 	*/
			ShapeTable[i].shapeNAME[0] 	= 0;
		}

/*----------------------------------------------------------------------*/
/*		եɤ߹												*/
/*----------------------------------------------------------------------*/
		strcpy (inname,argv[1]);
		strcat (inname,".map");

		if ((inputFP = fopen(inname,"r")) == NULL ){
			fprintf(stderr, "==== ϥե륨顼 (%s) ====\n",inname); 
			exit(1);
		}
		fread(MapData, sizeof(SAVEMAP),mapobjmax ,inputFP);

/*----------------------------------------------------------------------*/
/*		񤭤ե											*/
/*----------------------------------------------------------------------*/

#if	0
		strcpy (shapename,argv[1]);			/* ơ֥ե̾ + CODE	*/
		strcat (shapename,"Shapes.c");
		strcpy (worldname,argv[1]);
		strcat (worldname,"World.c");
		strcpy (tablename,argv[1]);
		strcat (tablename,"Table.h");
#else
		strcpy	(shapename,"ShapeData.c");	/* ̾	*/
		strcpy	(worldname,"WorldData.c");	/* ̾	*/
		strcpy	(tablename,"ShapeTable.h");	/* ̾	*/
#endif

		shapeFP = fopen(shapename,"w");		/*	ץǡꥹ	*/
		worldFP = fopen(worldname,"w");		/* 	ޥåץǡꥹ		*/
		tableFP = fopen(tablename,"w");		/*	׳ꥹ	*/

/*----------------------------------------------------------------------*/
/*		ǡѴ														*/
/*----------------------------------------------------------------------*/

		ConvertData(MapData,ShapeTable,shapeFP,worldFP,tableFP,tablename,argv[1]);

/*----------------------------------------------------------------------*/
/*		λ															*/
/*----------------------------------------------------------------------*/

		fclose(inputFP);
		fclose(shapeFP);
		fclose(worldFP);

		printf("(ED) ***** makerace Ѵޤ*****\n");

}




/************************************************************************
		ǡѴ
 ************************************************************************/

ConvertData(mapdata,shapetable,shapeFP,worldFP,tableFP,tablename,mapname)
SAVEMAP	*mapdata;
SHAPES	*shapetable;
FILE	*shapeFP;		/* ץǡե		*/
FILE	*worldFP;		/* ޥåץǡե			*/
FILE	*tableFP;		/* ơ֥إåե		*/
char	*tablename;
char	*mapname;
{

	int		mapcount = 0;	/* ޥåץǡθĿ	*/
	int		i;
	char	*nameP;			/* ץե̾						*/
	char	labelname[32];	/* ץե뤫ĥҤ̾	*/


		WriteShapeTitle	(shapeFP);				/* ץǡեΥȥ̾	*/
		WriteTableTitle (tableFP);				/* ơ֥إåեΥȥ̾	*/
		WriteWorldTitle (worldFP,tablename);	/* ɥǡեΥȥ̾	*/

		while(1){

			nameP = mapdata->shapeNAME;
			strcpy(labelname,nameP);
			labelname[strlen(labelname)-4] = '\0';

			if ( *nameP == 0) break;					/* ǡʤнλ		*/

			if ( SetShapeTable(nameP,shapetable) == NewFile ){
				AddShapeData(nameP,shapeFP);			/* ץǡɲ		*/
				AddShapeTable(labelname,tableFP);		/* ơ֥ɲ			*/
			} else {
				printf ( "(%s)\n",nameP);
			}
														/* ޥåץǡɲ		*/
			AddWorldData(mapdata,worldFP,labelname,mapcount,mapname);
			mapdata++;
			mapcount++;

		}

		fprintf (tableFP,"\n");							/* ơ֥ǡνλ		*/
														/* ɥǡνλ		*/
		WriteMapInfo(mapname,worldFP,mapcount);

}



/************************************************************************
	ޥå׾ǡ򥻥åȤ
 ************************************************************************/

static	char	testname[] = "TestMap";

WriteMapInfo(mapname,worldFP,mapcount)
char	*mapname;
FILE	*worldFP;
int		mapcount;
{

		fprintf	( worldFP,",\n		{ NULL,0,0,0,0}\n};\n\n" );			/* ǡλ	*/

	/*	fprintf	( worldFP,"WorldInfo	%sData[] = { %d,%sData };\n\n",testname,mapcount,mapname); */

}



/************************************************************************
	ɥǡɲä
 ************************************************************************/

AddWorldData(mapdata,worldFP,labelP,mapcount,mapname)
SAVEMAP	*mapdata;
FILE	*worldFP;
char	*labelP;
int		mapcount;
char	*mapname;
{
	char	shapename[40];
	shapename[0]='&';	
	shapename[1]='\0';
	strcat	(shapename,labelP);

	if (mapcount==0){
		/* fprintf	( worldFP,"GroundInfo	%sData[] = {\n ",mapname); */
		   fprintf	( worldFP,"GroundInfo	map[] = {\n ");			

	} else {
		fprintf	( worldFP,",\n" );
	}


	fprintf(worldFP,"		{ %-10s,SHAPE_GROUND,%4d,%7d,%7d }",
			shapename,
			mapdata->angY,
			mapdata->posX,mapdata->posZ );


}


/************************************************************************
	ơ֥ǡɲä
 ************************************************************************/

AddShapeTable(labelP,tableFP)
char	*labelP;
FILE	*tableFP;
{

		fprintf(tableFP,"extern	ShapeInfo	%s;\n",labelP);

}


/************************************************************************
	ɤ߹ޤ줿פΥפƱɤå
 ************************************************************************/

SetShapeTable(nameP,shapetable)
char	*nameP;
SHAPES	*shapetable;
{
	while( shapetable->shapeNAME[0] != 0 ){
		if (strcmp(nameP,shapetable->shapeNAME) == 0){
			return(SameFile);
		}
		shapetable++;
	}

	strcpy(shapetable->shapeNAME,nameP);	/* ɲä롣	*/

	return(NewFile);
}

/************************************************************************
		ɤ߹ޤ줿դɤ(OBJ)ǡ򥽡Ѵ
 ************************************************************************/

SHAPEFACE	ShapeFace[MAXFACE];				/* ץեǡ				*/
SHAPEPOINT	ShapePoint[MAXPOINT];			/* ݥȥǡΥХåե 			*/

AddShapeData(nameP,shapeFP)
char	*nameP;
FILE	*shapeFP;
{


	char	labelname[32];					/* ٥ѤΥإå						*/
	FILE	*funFP;							/* դɤƥȥեݥ		*/
	char	lineword[256];					/* ƥȥե룱ɤ߹ߥХåե	*/

		if ( (funFP = fopen(nameP,"r")) == NULL ){
			fprintf(stderr, "==== դɤ %s ե뤬Ĥޤ!! ===\n",nameP);
			exit(1);
		}
		strcpy(labelname,nameP);
		labelname[strlen(labelname)-4] = '\0';

		MSPtr.shapepoint 	= ShapePoint;
		MSPtr.shapeface  	= ShapeFace;

		ReadHead(funFP,lineword,nameP);			/*	եإåɤߤ	*/
		ReadTotalPoint(funFP,lineword);			/*	ݥȥȡɤ߹	*/
		ReadPointData(funFP,lineword);			/*	ݥȥǡɤ߹	*/
		ReadFaceData(funFP,lineword);			/*	եǡɤ߹	*/

		printf ( "(->) %-16s 򿷤Ͽޤ\n",nameP);
		fclose(funFP);

		WriteTitle(labelname,shapeFP);			/*	ȥΥȺ				*/
		CalcNomal();							/*	̤٥ȥη׻				*/
		CalcVector();							/* 	٥ȥη׻				*/
		WritePoint(labelname,shapeFP);			/*	ݥȥǡν񤭹			*/
		CalcHitbox();							/*  ̤Υꥸη׻				*/
		WriteFace(labelname,shapeFP);			/*	եǡν񤭹			*/
		WriteInfo(labelname,shapeFP);			/*	ե᡼ǡν񤭹	*/

}


/*======================================================================*/
/*																		*/
/*		ե񤭤롼(ޥåץǡ)					*/
/*																		*/
/*======================================================================*/





/*======================================================================*/
/*																		*/
/*		ե񤭤롼(ץǡ)					*/
/*																		*/
/*======================================================================*/
/************************************************************************
		ץǡȥκ
 ************************************************************************/
WriteShapeTitle(fp)
FILE	*fp;
{
	fprintf (fp,"/************************************************************************\n");
	fprintf (fp,"                                                                         \n");
	fprintf (fp,"               Project Reality Code name RACE1                           \n");
	fprintf (fp,"                                                                         \n");
	fprintf (fp,"                    ++ 3D shape data ++                                  \n");
	fprintf (fp,"                                                                         \n");
	fprintf (fp,"************************************************************************/\n");

	fprintf (fp,"\n");
	fprintf (fp,"#include	\"map.h\"\n");
	fprintf (fp,"\n");


}

/************************************************************************
		ץơ֥ե륿ȥκ
 ************************************************************************/

WriteTableTitle(fp)
FILE	*fp;
{
	fprintf (fp,"/************************************************************************\n");
	fprintf (fp,"                                                                         \n");
	fprintf (fp,"               Project Reality Code name RACE1                           \n");
	fprintf (fp,"                                                                         \n");
	fprintf (fp,"                    ++ ++                                                \n");
	fprintf (fp,"                                                                         \n");
	fprintf (fp,"************************************************************************/\n");

	fprintf (fp,"\n");

}

/************************************************************************
		ɥޥåץե륿ȥκ
 ************************************************************************/
WriteWorldTitle(fp,nameP)
FILE	*fp;
char	*nameP;
{

	fprintf (fp,"/************************************************************************\n");
	fprintf (fp,"                                                                         \n");
	fprintf (fp,"               Project Reality Code name RACE1                           \n");
	fprintf (fp,"                                                                         \n");
	fprintf (fp,"                     ++ 3D world data ++                                 \n");
	fprintf (fp,"                                                                         \n");
	fprintf (fp,"************************************************************************/\n");

	fprintf (fp,"\n");

	fprintf (fp,"\n");
	fprintf (fp,"#include	<stdio.h>\n");
	fprintf (fp,"#include	\"map.h\"\n");
	/* fprintf (fp,"#include	\"%s\"\n",nameP); */
	fprintf (fp,"#include	\"ShapeTable.h\"\n",nameP);
	fprintf (fp,"\n");

}

/************************************************************************
		ȥκ
 ************************************************************************/

WriteTitle(labelP,shapeFP)
char	*labelP;
FILE	*shapeFP;
{
	fprintf (shapeFP,"/************************************************************************\n");
	fprintf (shapeFP," 		The %s 	\n",labelP);
	fprintf (shapeFP,"************************************************************************/\n");
	fprintf (shapeFP,"\n");
}

/************************************************************************
		ˡ٥ȥ׻
 ************************************************************************/
CalcVector()
{

	int		counter;
	int		point1,point2,point3;
	int		NOWpoint,pt,pt2;

	int			pointtotal	= MSPtr.PointTotal;	/* ݥȤκ	*/
	int			facetotal	= MSPtr.FaceTotal;	
	SHAPEPOINT	*point 		= MSPtr.shapepoint;
	SHAPEFACE	*face 		= MSPtr.shapeface;
	SHAPEFACE	*faceroot 	= MSPtr.shapeface;

	double		VX,VY,VZ;
	double		NORMAL;
	VECTOR		vector[32];
	int			Vcount;
	int			ct;

	for(NOWpoint=0;NOWpoint<pointtotal;NOWpoint++){

		/* ޤʿ̤򤹤٤Ƶ	*/
		Vcount=0;
		face = faceroot;
		for (counter = 0;counter<facetotal;counter++){
			if ((face->facepoint)>2){
				for(pt=0;pt<(face->facepoint);pt++){
					if (NOWpoint == face->pointNO[pt]){
						vector[Vcount].vectorX= face->planeA;
						vector[Vcount].vectorY= face->planeB;
						vector[Vcount].vectorZ= face->planeC;
						Vcount++;
					}
				}
			}
			face++;
		}

		/* ٤Ƥ̤ˡ٥ȥʿѤ */
		VX=0.0;	VY=0.0;	VZ=0.0;
		if (Vcount!=0){
			for(ct=0;ct<Vcount;ct++){
				VX = (vector[ct].vectorX)+VX;
				VY = (vector[ct].vectorY)+VY;
				VZ = (vector[ct].vectorZ)+VZ;
			}
			VX = VX/Vcount;
			VY = VY/Vcount;
			VZ = VZ/Vcount;
		} else {
			printf ("(!!) ʿ̤°ʤ(%3d)ȯޤ\n",NOWpoint);
		}

		/* ʿѤ٥ȥ	*/
		NORMAL = sqrt( VX*VX+VY*VY+VZ*VZ );
		if (NORMAL < MINvector){
			(point+NOWpoint)->vectorX = 0;
			(point+NOWpoint)->vectorY = 0;
			(point+NOWpoint)->vectorZ = 0;
		} else {
			(point+NOWpoint)->vectorX = VX/NORMAL;
			(point+NOWpoint)->vectorY = VY/NORMAL;
			(point+NOWpoint)->vectorZ = VZ/NORMAL;
		}

	}

}



/************************************************************************
		ݥȥǡν񤭤
 ************************************************************************/

WritePoint(labelP,shapeFP)
char	*labelP;
FILE	*shapeFP;
{

	int			dmmy = 0;
	int			i;
	int			total  		= MSPtr.PointTotal;
	SHAPEPOINT	*shapeP 	= MSPtr.shapepoint;

		fprintf ( shapeFP, "static PointData %sPoints[] = { \n",labelP );
		for(i=0;i<total;i++){
			fprintf	(shapeFP,"	{ %6d,%6d,%6d,%3d,%9f,%9f,%9f }",
					shapeP->pointX,
					shapeP->pointY,
					shapeP->pointZ,
					dmmy,
					shapeP->vectorX,
					shapeP->vectorY,
					shapeP->vectorZ);
			if (i != (total-1))	fprintf(shapeFP,",\n");
			shapeP++;
		}
		fprintf (shapeFP,"\n};\n\n");

}

/************************************************************************
		̤ˡ٥ȥη׻
 ************************************************************************/
CalcNomal()
{

	int		counter;
	int		point1,point2,point3;

	int			facetotal	= MSPtr.FaceTotal;
	SHAPEPOINT	*point 		= MSPtr.shapepoint;
	SHAPEFACE	*face 		= MSPtr.shapeface;

	for (counter = 0;counter<facetotal;counter++){
			
		switch(face->facepoint){
			case	1:	
			case	2:
				error_vector(face);
				break;
			case	3:
				point1 = face -> pointNO[0];
				point2 = face -> pointNO[1];
				point3 = face -> pointNO[2];
				if (calc_vector(point1,point2,point3,counter,face,point)==TRUE)	break;
				error_vector(face);
				break;
			default:
				point1 = face -> pointNO[0];
				point2 = face -> pointNO[1];
				point3 = face -> pointNO[2];
				if (calc_vector(point1,point2,point3,counter,face,point)==TRUE) break;
				point1 = face -> pointNO[1];
				point2 = face -> pointNO[2];
				point3 = face -> pointNO[3];
				if (calc_vector(point1,point2,point3,counter,face,point)==TRUE) break;
				error_vector(face);
				break;
		}

		face++;
	}

}

/************************************************************************
		åѤ (HIT-BOX) ׻
 ************************************************************************/
CalcHitbox()
{

	int		counter,i;

	int			facetotal	= MSPtr.FaceTotal;
	SHAPEPOINT	*point 		= MSPtr.shapepoint;
	SHAPEFACE	*face 		= MSPtr.shapeface;


		for (counter = 0;counter<facetotal;counter++){

			face->xmax = -32767;	/* -----  ----- */
			face->ymax = -32767;
			face->zmax = -32767;
			face->xmin =  32767;
			face->ymin =  32767;
			face->zmin =  32767;

									/* եõ	*/
			for(i=0;i<(face->facepoint);i++){
				if ( face->xmax < (point+(face->pointNO[i]))->pointX )
					 face->xmax = (point+(face->pointNO[i]))->pointX;
				if ( face->xmin > (point+(face->pointNO[i]))->pointX )
					 face->xmin = (point+(face->pointNO[i]))->pointX;
				if ( face->ymax < (point+(face->pointNO[i]))->pointY )
					 face->ymax = (point+(face->pointNO[i]))->pointY;
				if ( face->ymin > (point+(face->pointNO[i]))->pointY )
					 face->ymin = (point+(face->pointNO[i]))->pointY;
				if ( face->zmax < (point+(face->pointNO[i]))->pointZ )
					 face->zmax = (point+(face->pointNO[i]))->pointZ;
				if ( face->zmin > (point+(face->pointNO[i]))->pointZ )
					 face->zmin = (point+(face->pointNO[i]))->pointZ;
			}

			face++;
		}

}

/************************************************************************
		ץǡν񤭤
 ************************************************************************/

WriteFace(labelP,shapeFP)
char	*labelP;
FILE	*shapeFP;
{

	int	dmmy = 0;
	int	i,count;
	int	total;
	SHAPEFACE	*faceP;

		total 	= MSPtr.FaceTotal;
		faceP 	= MSPtr.shapeface;

		fprintf ( shapeFP, "static FaceData %sFaces[] = { \n",labelP );
		for(i=0;i<total;i++){

			/*======= Ԥκǽ顪========================*/
			if (i!=0)	fprintf(shapeFP,",\n");
			fprintf	(shapeFP,"	{ ");

			/*======= ĺΥǡ======================*/
			fprintf	( shapeFP,"%d,",faceP->facepoint);

			/*======= ե顼Υǡ==============*/
			fprintf	( shapeFP,"%3d,",faceP->color);

			/*======= ǾͤΥǡ==================*/


			fprintf	( shapeFP,"%5d,%5d,%5d,%5d,%5d,%5d,",
					faceP->xmax,
					faceP->xmin,
					faceP->ymax,
					faceP->ymin,
					faceP->zmax,
					faceP->zmin );

#if	DXFfile
			if 	 ( faceP->planeB >= 0 ){
			/*======= Ρޥ٥ȥΥǡ============*/
				fprintf	( shapeFP,"%9f,%9f,%9f,%12f,",faceP->planeA,faceP->planeB,faceP->planeC,faceP->planeD );
			/*======= ĺϢꥹȤΥǡ==============*/
				fprintf (shapeFP,"{");
				for (count=0;count<faceP->facepoint;count++){
					fprintf	( shapeFP,"%3d",faceP->pointNO[count]);
					if (count!=(faceP->facepoint)-1) fprintf(shapeFP,",");
				}
				fprintf (shapeFP,"} }");
			} else {
			/*======= Ρޥ٥ȥΥǡ============*/
				fprintf	( shapeFP,"%9f,%9f,%9f,%12f,",-(faceP->planeA),-(faceP->planeB),-(faceP->planeC),faceP->planeD );
			/*======= ĺϢꥹȤΥǡ==============*/
				fprintf (shapeFP,"{");
				for (count=(faceP->facepoint)-1;count>=0;count--){
					fprintf	( shapeFP,"%3d",faceP->pointNO[count]);
					if (count!=0) fprintf(shapeFP,",");
				}
				fprintf (shapeFP,"} }");
			}
#else
			/*======= Ρޥ٥ȥΥǡ============*/
				fprintf	( shapeFP,"%9f,%9f,%9f,%12f,",faceP->planeA,faceP->planeB,faceP->planeC,faceP->planeD );
			/*======= ĺϢꥹȤΥǡ==============*/
				fprintf (shapeFP,"{");
				for (count=0;count<faceP->facepoint;count++){
					fprintf	( shapeFP,"%3d",faceP->pointNO[count]);
					if (count!=(faceP->facepoint)-1) fprintf(shapeFP,",");
				}
				fprintf (shapeFP,"} }");			
#endif


			/*======= Υǡ========================*/
			faceP++;
		}

		fprintf(shapeFP,"\n};\n\n");

}

/************************************************************************
		ץե᡼ν񤭤
 ************************************************************************/
/*	short		npoints;	/* ݥȥǡ							*/
/*	short		nfaces;		/* ݥꥴǡ							*/
/*	short		nhits;		/* դݥꥴ						*/
/*	short		radius;		/* Ⱦ								*/
/*	short		xmax;		/* ׺ͣ							*/
/*	short		ymax;		/* ׺ͣ							*/
/*	short		zmax;		/* ׺ͣ							*/
/*	short		reserved;	/* ͽ										*/
/*	PointPtr	point;		/* ݥȥǡؤΥݥ				*/
/*	FacePtr		face;		/* եǡؤΥݥ				*/
/*----------------------------------------------------------------------*/
WriteInfo(labelP,shapeFP)
char	*labelP;
FILE	*shapeFP;
{
	int	radius;
	int	dmmy=0;

	radius = ( MSPtr.xmax > MSPtr.zmax ) ? MSPtr.xmax : MSPtr.zmax;

	fprintf(shapeFP,"ShapeInfo	%s = { %d,%d,%d,%d,%d,%d,%d,%d,%sPoints,%sFaces };\n\n",
			labelP,
			MSPtr.PointTotal,
			MSPtr.FaceTotal,
			MSPtr.FaceTotal,
			radius,
			MSPtr.xmax,
			MSPtr.ymax,
			MSPtr.zmax,
			dmmy,
			labelP,
			labelP);
}

/*======================================================================*/
/*																		*/
/*		դɤեɤ߹ߥ롼								*/
/*																		*/
/*======================================================================*/

ReadHead(fp,lineword,nameP)
FILE	*fp;
char	*lineword;
char	*nameP;			/* ץե̾	*/
{
	int	data;

	fgets(lineword,128,fp);
	if (strncmp(lineword,"3DG1",4) !=0 ){
		fprintf(stderr,"Υե(%s)ϤդɤTXTեޥåȤǤϤޤ\n",nameP);		
		exit(1);
	}

	lineword+=5;	/* ݥ󥿤ʤ*/

	GetNumber( &lineword,&data);
	MSPtr.scale = data;

}


/************************************************************************
		ȡݥȿɤ߹
 ************************************************************************/

int	ReadTotalPoint(fp,lineword)
FILE		*fp;
char		*lineword;
{

	int		total;

		if ( fgets( lineword,100,fp ) == NULL ){
			fputs ("ݥȥȡߤߥ顼\n",stderr );
			exit(1);
		}
		GetNumber( &lineword,&total);

		MSPtr.PointTotal =	total;

}

/************************************************************************
		ݥȥǡɤ߹
 ************************************************************************/

ReadPointData(fp,linewordS)
FILE		*fp;
char		*linewordS;			/* ɤ߹ߥݥ		*/
{
	int			i;
	int			ix,iy,iz;
	char 		*lineword;
	SHAPEPOINT	*shapeP = MSPtr.shapepoint;
	int			total 	= MSPtr.PointTotal;
	int			scale	= MSPtr.scale;

	int			xmax = 0;
	int			ymax = 0;
	int			zmax = 0;

	for (i=0;i<total;i++){

		lineword = linewordS;		/* ɤ߹ߥХåեΥݥ󥿤Ȥ᤹	*/
		if ( fgets( lineword,100,fp ) == NULL ){
			fputs ("ɸǡߤߥ顼\n",stderr );
			exit(1);
		}

		GetNumber ( &lineword,&ix );	*lineword++;
		GetNumber ( &lineword,&iy );	*lineword++;
		GetNumber ( &lineword,&iz );

		shapeP->pointX = ix * scale;
		if ( xmax < ix*scale )	xmax = ix*scale;
		shapeP->pointY = iy * scale;
		if ( ymax < iy*scale )	ymax = iy*scale;
		shapeP->pointZ = iz * scale;
		if ( zmax < iz*scale )	zmax = iz*scale;
		shapeP++;

	}

	MSPtr.xmax = xmax;
	MSPtr.ymax = ymax;
	MSPtr.zmax = zmax;

}

/************************************************************************
		եǡɤ߹
 ************************************************************************/

ReadFaceData(fp,linewordS)
FILE		*fp;
char		*linewordS;			/* ɤ߹ߥݥ				*/
{

	int		total;				/* եΥȡ				*/
	char	*lineword;	
	int		pointNO;			/* եݥֹ	*/
	int		topcount;			/* եĺο				*/
	int		color;				/* եΥ顼					*/
	int		facecount;			/* եο򥫥Ȥ		*/
	int		i,counter;

	SHAPEFACE	*face;			/* ե¤ΤؤΥݥ		*/

		face = MSPtr.shapeface;
		lineword = linewordS;
		facecount = 0;

		while ( fgets( lineword,100,fp ) != NULL ){

			GetNumber( &lineword,&topcount  );			/* ĺɤ߹			*/
			*lineword++;
			face->facepoint = topcount;

			for (i=0;i<topcount;i++){					/* եǡɤ߹	*/
				GetNumber( &lineword,&pointNO );
				*lineword++;
				face->pointNO[i] = pointNO;
			}

			GetNumber( &lineword,&color );				/* 顼ǡɤ߹		*/
			/* if ( color > 50 ) color = 0; */			/* Сեк		*/
			face->color = color;

			facecount++;								/* եο򣱤䤹 */
			face++;										/* եݥ󥿤ʤ	*/
			lineword = linewordS;						/* ʸݥ󥿤ꥻå	*/

		} 

		MSPtr.FaceTotal = facecount;					/* եȡ	*/

}

/*======================================================================*/
/*																		*/
/*		֥롼													*/
/*																		*/
/*======================================================================*/
/************************************************************************
		ƥȷοǡ(10դ)
		INT ǡѴ
 ************************************************************************/

GetNumber( dt,nm )
char	**dt;
int		*nm;
{

	char	*pt;
	int	ct=0, nn=0 ;
	int	sign_flag = 0;

		pt = *dt ;	/* Ԥʸݥ󥿤Ȥ */

					/* ޥʥǡΤȤ */
		if ( *pt == '-' ){
			*pt++;
			sign_flag++;
		}

		while ( isdigit( *pt )) {
			nn = nn * 10 + (*pt++ - '0');
			ct++;	/* åݥ */
		}

		if ( sign_flag != 0 ){
			nn = -nn;
		}

		*dt = pt ;	/* Ԥʸݥ󥿤Ϥ */
		*nm = nn ;	/* ǡϤ */

		return ( ct ) ;

}

/*----------------------------------------------------------------------*/
/*	ˡ٥ȥη׻
/*----------------------------------------------------------------------*/
error_vector(face)
SHAPEFACE		*face;
{
		face -> planeA = 1;	/* ʿ̤ˡ٥ȥ	*/
		face -> planeB = 1;
		face -> planeC = 1;
		face -> planeD = 0;
}
/*----------------------------------------------------------------------*/
/*	ˡ٥ȥη׻
/*----------------------------------------------------------------------*/

calc_vector(point1,point2,point3,i,face,sp)
int	point1,point2,point3,i;
SHAPEFACE		*face;
SHAPEPOINT		*sp;
{

	double	nx,ny,nz;
	int	p1,p2,p3;
	int	a1,a2,a3,a4;
	int	x1,y1,z1;

	double	nomal;
	float	nomal_x,nomal_y,nomal_z;


		x1 = (sp+point1)->pointX;			/* ʿ̾Σ		*/
		y1 = (sp+point1)->pointY;
		z1 = (sp+point1)->pointZ;

											/* Ѥη׻				*/

		a1 = (sp+point2)->pointY - (sp+point1)->pointY;
		a2 = (sp+point3)->pointZ - (sp+point2)->pointZ;
		a3 = (sp+point2)->pointZ - (sp+point1)->pointZ;
		a4 = (sp+point3)->pointY - (sp+point2)->pointY;

		nx = a1*a2 - a3*a4;

		a1 = (sp+point2)->pointZ - (sp+point1)->pointZ;
		a2 = (sp+point3)->pointX - (sp+point2)->pointX;
		a3 = (sp+point2)->pointX - (sp+point1)->pointX;
		a4 = (sp+point3)->pointZ - (sp+point2)->pointZ;

		ny = a1*a2 - a3*a4;

		a1 = (sp+point2)->pointX - (sp+point1)->pointX;
		a2 = (sp+point3)->pointY - (sp+point2)->pointY;
		a3 = (sp+point2)->pointY - (sp+point1)->pointY;
		a4 = (sp+point3)->pointX - (sp+point2)->pointX;

		nz = a1*a2 - a3*a4;

		nomal = nx*nx+ny*ny+nz*nz;
		nomal = sqrt ( nomal );

		if ( fabs(nomal) < MINvector )	return(FALSE);	

		nomal_x = nx / nomal; 
		nomal_y = ny / nomal;
		nomal_z = nz / nomal;

#if	0	/*------------------------------------------------------------------*/
		printf ( "<<<<%lf>>> ",ny);
		printf ( "<<<<%lf>>> ",nomal);
		printf ( "%4.0f,%4.0f,%4.0f\n",nomal_x,nomal_y,nomal_z);	
#endif	/*------------------------------------------------------------------*/

		face -> planeA = nomal_x;	/* ʿ̤ˡ٥ȥ	*/
		face -> planeB = nomal_y;
		face -> planeC = nomal_z;
		face -> planeD = -( nomal_x*x1 + nomal_y*y1 + nomal_z*z1 );
									/* ʿ̤ ax+by+cz+D=0 ((D))  !!*/


		return(TRUE);

}

/*====================================================================*/

