/************************************************************************
		դɤΥեǡ
		륵ʬ䤷ƿץǡ
		ץ
 ************************************************************************/

#include 	<stdio.h>
#include	<string.h>
#include	<ctype.h>
#include 	<math.h>

#define		Debug			0
#define		unchar			unsigned char

#define		MAXPOLY			8000
#define		MAXPOINT		8000

#define		Xprintf			printf

/************************************************************************
		ޥåפΥꥢʬ
 ************************************************************************/

#define	divdata	16			/* ʬΥ				*/
#define sizemax	1024		/* ǡκ祵		*/

int		area[divdata][divdata];

/*=======================================================================
			¤
========================================================================*/

/***************** FUNDOSHI POINT RECORD ********************************/
typedef	struct	{
	int	pointX;				/* ܥǥɸ	*/
	int	pointY;
	int	pointZ;
}	SHAPEPOINT;

/***************** FUNDOSHI FACE RECORD ********************************/

typedef	struct	{
	int		facepoint;		/* եĺ			*/
	int		pointNO[16];	/* max 16				*/
	int		color;			/* 顼ǡ				*/
	int		equA;			/* ʿ̤Υѥ᡼	*/
	int		equB;
	int		equC;
	int		equD;
	int		equN;			/* ñ̥٥ȥ礭 = sqrt ( A*A + B*B + C*C )	*/
	int		distance;		/* ʿ̤ޤǤεΥ								*/
	int		side;			/* ̤ˤä¾ʬ̤			*/
	int		BOTH;			/* ξ̥ݥꥴå	*/
	int		SIDE;			/* ɽ΢å			*/
} 	SHAPEFACE;

/***************** MAKE BSP RECORD *************************************/

typedef struct	nodebsp	{
	int			keyface;
	unsigned	char	faceall[256];	
	unsigned	char	leftface[256];
	unsigned	char	rightface[256];
	struct		nodebsp	*left;
	struct		nodebsp	*right;
}	BSPTREE;

/***************** ѴѤζѿ RECORD ******************************/
typedef	struct	{
	SHAPEPOINT	*shapepoint;	/* ץݥȹ¤ΤؤΥݥ	*/
	SHAPEFACE	*shapeface;		/* ץե¤ΤؤΥݥ	*/
	BSPTREE		*bsptree;		/* BSPtree¤ΤؤΥݥ			*/
	int			scale;			/* Ψ								*/
	int			PointTotal;		/* ݥȤΥȡ 				*/
	int 		FaceTotal;		/* եΥȡ					*/
	int			AnimeTotal;		/* ˥᡼Υȡ			*/
	int			ramNO;			/* ΥǡΥեåȣңaddress	*/
	char		*ramPstart;		/* פƬɥ쥹				*/
}	MAKESHAPE;


/************************************************************************
		 -ãĥץѿ
 ************************************************************************/

int		TOTALObject;
int		TOTALPolygon;
int		TOTALPoint;
int		TOTALAnimeTBL;
int		TOTALAnimePNT;

MAKESHAPE	MSPtr;					/* ᥤݥ						*/
SHAPEFACE	ShapeFace[MAXPOLY];		/* ץեǡ				*/
SHAPEPOINT	ShapePoint[MAXPOINT];	/* ݥȥǡΥХåե 			*/
BSPTREE		BSPtree[256];			/* BSPTREEѤΥХåե					*/


/************************************************************************
			ᥤ롼
 ************************************************************************/

void main ( argc,argv )

int 	argc;
char	*argv[];

{
	FILE	*inputFP;		/* դɤ(ԣأ)ǡΥեݥ */
	FILE	*outputFP;		/* ã(Σţף)ǡΥեݥ		*/

	int		fcount;			/* ե륫		*/

	char	txtname[100];
	char	cadname[100];
	int		count;

/*----------------------------------------------------------------------*/
/*		ե᡼												*/
/*----------------------------------------------------------------------*/
	if (argc != 2){
		fprintf(stderr, "***********************************************\n");
		fprintf(stderr, "*                                             *\n");
		fprintf(stderr, "*    դɤΣԣأԥǡ             *\n");
		fprintf(stderr, "*     16x16 ʬ䤷ޤ              *\n");
		fprintf(stderr, "*                                             *\n");
		fprintf(stderr, "*         raceunit file(.txt) => fileNN(.txt) *\n");
		fprintf(stderr, "*                                             *\n");
		fprintf(stderr, "*            ++ Version 0.01 ++               *\n");
		fprintf(stderr, "*                                             *\n");
		fprintf(stderr, "*                                             *\n");
		fprintf(stderr, "*      Programed By H.Yajima  1994.4.13       *\n");
		fprintf(stderr, "*                                             *\n");
		fprintf(stderr, "***********************************************\n");
		exit( 1 ) ;
	}

	Xprintf("(ST) ***** raceunit Ѵ򳫻Ϥޤ***** \n");

/*----------------------------------------------------------------------*/
/*		դɤΤΣԣأԥǡɤ߹						*/
/*----------------------------------------------------------------------*/

		strcpy (txtname,argv[1]);				/* ե̾򥳥ԡ	*/
		strcat (txtname,".txt");

		if ((inputFP = fopen(txtname,"r")) == NULL ){
			fprintf(stderr, "==== ϥե륨顼 (%s) ====\n",txtname); 
			exit(1);
		}

/*----------------------------------------------------------------------*/
/*		ǡѴ!!													*/
/*----------------------------------------------------------------------*/
		ReadFundoshi(inputFP,txtname);		/* դɤǡɤ߹ 	*/

/*----------------------------------------------------------------------*/
/*		ǡʬ䡡!!													*/
/*----------------------------------------------------------------------*/
		Parts();
		Write(argv[1]);

/*----------------------------------------------------------------------*/
/*		ǡ													*/
/*----------------------------------------------------------------------*/
		fclose(inputFP);
/*----------------------------------------------------------------------*/
/*----------------------------------------------------------------------*/
		Xprintf("(ED) ***** raceunit Ѵޤ*****\n");

}

/************************************************************************
		ǡʬ֥å
 ************************************************************************/

Parts()
{

	int			 total 	= MSPtr.FaceTotal;	/* եȡ					*/
	SHAPEFACE	*faceP 	= MSPtr.shapeface;	/* ץǡؤΥݥ			*/
	SHAPEPOINT	*pointP = MSPtr.shapepoint;	/* ץݥȥǡؤΥݥ	*/

	int			i,j;
	int			vertex;						/* ĺ	*/
	int			areaX,areaZ;


	for(i=0;i<divdata;i++){
		for(j=0;j<divdata;j++){
			area[i][j] = 0;		/* ǡꥢ	*/
		}
	}


	for (i=0;i<total;i++){

		/* եΣ */
		areaX = (((pointP+(faceP->pointNO[0]))->pointX)+sizemax)/((sizemax*2)/divdata);
		areaZ = (((pointP+(faceP->pointNO[0]))->pointZ)+sizemax)/((sizemax*2)/divdata);
		if ( areaX > divdata || areaZ > divdata ){
			printf ("data error\n");
			exit(1);
		}
		area[areaZ][areaX] +=1;
		faceP++;
	}

#if	1
	printf ("-----");
	for(i=0;i<divdata;i++){
		printf ("-%3d-",i);
	}
	printf ("\n");

	for(i=0;i<divdata;i++){
		printf ("-%3d-",i);
		for(j=0;j<divdata;j++){
			printf ("(%3d)",area[i][j]);
		}
		printf ("\n");
	}
#endif

}

/************************************************************************
		ʬ䤷ǡ񤭤
 ************************************************************************/
Write(name)
char	*name;
{

	char	filename[18];
	char	areaXname[4],areaZname[4];
	int		Xcount,Zcount;
	FILE	*fp;


	for (Zcount=0;Zcount<divdata;Zcount++){ 

		for	(Xcount=0;Xcount<divdata;Xcount++){

			if (area[Zcount][Xcount] != 0){

				sprintf(areaXname,"%d",Xcount);
				sprintf(areaZname,"%d",Zcount);
				strcpy(filename,name);
				strcat(filename,"_");
				strcat(filename,areaXname);
				strcat(filename,"_");
				strcat(filename,areaZname);
				strcat(filename,".obj");

				if((fp = fopen(filename, "w")) == NULL){
					fprintf(stderr, "Can't open %s\n", filename);
				}

				WriteData(Xcount,Zcount,fp);

				printf("(->) make %s file\n",filename);
	
				fclose(fp);
			
			}

		}
	}

}


/************************************************************************
		ʬ䤷ǡ񤭤
 ************************************************************************/
typedef	struct	{
	int		number;
	int		pointX;
	int		pointY;
	int		pointZ;
}	NEWPOINT;

typedef	struct	{
	int		facepoint;
	int		pointNO[16];
	int		color;
}	NEWFACE;

#define		newmax	2000

NEWPOINT	NewPoint[newmax];
NEWFACE		NewFace[newmax];


WriteData(areaX,areaZ,fp)
int			areaX;		/* ʬ䤵륨ꥢֹ (X)	*/
int			areaZ;		/* ʬ䤵륨ꥢֹ (Z)	*/
FILE		*fp;		/* ʬ䥷ץե̾	*/
{

	int			 total 	= MSPtr.FaceTotal;	/* եȡ					*/
	SHAPEFACE	*faceP 	= MSPtr.shapeface;	/* ץǡؤΥݥ			*/
	SHAPEPOINT	*pointP = MSPtr.shapepoint;	/* ץݥȥǡؤΥݥ	*/

	int			i,j;
	int			vertex;			/* ĺ	*/

	int			npcount;		/* ˺ݥȥǡ	*/
	int			NFcount;		/* ˺եǡ	*/
	int			pointIDX;		/* ꥸʥݥȥǡֹ	*/
	int			samecount;		/* Ʊݥֹ椬뤫ɤΥå	*/
	int			npnumber;		/* ݥֹ */

								/* 2048 ɥ֥åο */

	int			odds = 2048/(sizemax*2/divdata);


	/*---------------------*/
	for(i=0;i<newmax;i++){
		NewPoint[i].number = -1;
	}
	npcount = 0;
	NFcount = 0;


	/*--------ᥤʬ-----------*/
	for (i=0;i<total;i++){

		if ( (((pointP+(faceP->pointNO[0]))->pointZ)+sizemax)/((sizemax*2)/divdata) != areaZ )	goto	next;
		if ( (((pointP+(faceP->pointNO[0]))->pointX)+sizemax)/((sizemax*2)/divdata) != areaX )	goto	next;

		for(vertex=0;vertex<faceP->facepoint;vertex++){

			pointIDX = faceP->pointNO[vertex];

			/*------------ ƱݥȤõ -----------------*/
			samecount = 0;
			npnumber  = -1;
			while (NewPoint[samecount].number != -1){
				if (pointIDX == NewPoint[samecount].number){
					npnumber = samecount;	
					break;
				}
				samecount++;
			}

			/*------------ ݥȥǡ -----------------*/

			switch(npnumber){
				case	-1:

					NewPoint[npcount].number = pointIDX;

					NewPoint[npcount].pointX = (((pointP+pointIDX)->pointX)+sizemax)
								   			- (sizemax*2/divdata)*(areaX+1)+(sizemax*2/divdata/2);
					NewPoint[npcount].pointZ = (((pointP+pointIDX)->pointZ)+sizemax)
								   			- (sizemax*2/divdata)*(areaZ+1)+(sizemax*2/divdata/2);

					NewPoint[npcount].pointY = (pointP+pointIDX)->pointY;

					npnumber = npcount;
					npcount++;
					break;
				default:
					break;

			}
			/*------------ եǡ -----------------*/
			NewFace[NFcount].facepoint 		 = faceP->facepoint;
			NewFace[NFcount].pointNO[vertex] = npnumber;

		}

		NFcount++;		/* եȥå */

		next:
		faceP++;		/* ꥸʥեݥ󥿥ȥå */

	}


	fprintf (fp,"3DG1 %d\n",odds);
	fprintf (fp,"%d\n",npcount);

	i=0;
	while (NewPoint[i].number != -1){
		fprintf (fp,"%d %d %d \n",NewPoint[i].pointX,NewPoint[i].pointY,NewPoint[i].pointZ);
		i++;
	}
	for(i=0;i<NFcount;i++){
		fprintf (fp,"%d ",NewFace[i].facepoint);
		for(j=0;j<NewFace[i].facepoint;j++){
			fprintf (fp,"%d ",NewFace[i].pointNO[j]);
		}
		fprintf (fp,"0\n");		/* color */
	}


}




/************************************************************************
		դɤǡɤ߹
 ************************************************************************/


ReadFundoshi(inputFP,nameP)
FILE	*inputFP;				/* դɤ(ԣأ)ǡΥեݥ */
char	*nameP;
{

	char	lineword[101]; 					/* ơ֥ե룱ԤǤκʸ */

	int		total;							/* ݥȥȡο */
	int		ix,iy,iz;						/* ݥȺɸ x1,x2,x3 */
	int 	facecount;						/* եǡ */
	int		facepointer;	
	int		color;
	int		i,counter;						/* ѥ */

	MSPtr.shapepoint 	= ShapePoint;
	MSPtr.shapeface 	= ShapeFace;

/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
/*		ץǡɤߤ										*/
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */

	ReadHead(inputFP,lineword,nameP);		/*	إåå				*/
	ReadTotalPoint(inputFP,lineword);		/*	ݥȥȡɤ߹	*/
	ReadPointData(inputFP,lineword);		/*	ݥȥǡɤ߹	*/
	ReadFaceData(inputFP,lineword);			/*	եǡɤ߹	*/

/*- - - - - - - - - - - - - - - - - - - */
/*	ɤ߹߽λ						*/
/*- - - - - - - - - - - - - - - - - - - */

}

/*=====================================================================*/
/*																		*/
/*		դɤեɤ߹ߥ롼								*/
/*																		*/
/*======================================================================*/

/************************************************************************
		إåΥå
 ************************************************************************/

ReadHead(fp,lineword,nameP)
FILE	*fp;
char	*lineword;
char	*nameP;
{
	fgets(lineword,128,fp);
	if (strncmp(lineword,"3DG1",4) !=0 ){
		fprintf(stderr,"ΥեϤդɤTXTեޥåȤǤϤޤ(%s)\n",nameP);		
		exit(1);
	}
}

/************************************************************************
		ȡݥȿɤ߹
 ************************************************************************/

int	ReadTotalPoint(fp,lineword)
FILE		*fp;
char		*lineword;
{

	int		total;

	if ( fgets( lineword,100,fp ) == NULL ){
		fputs ("ݥȥȡߤߥ顼\n",stderr );
		exit(1);
	}
	GetNumber( &lineword,&total);

	MSPtr.PointTotal =	total;

}

/************************************************************************
		ݥȥǡɤ߹
 ************************************************************************/

ReadPointData(fp,linewordS)
FILE		*fp;
char		*linewordS;			/* ɤ߹ߥݥ		*/
{
	int			i;
	int			ix,iy,iz;
	char 		*lineword;
	int			total   = MSPtr.PointTotal;	/* ɤ߹ߥݥȿ		*/
	SHAPEPOINT	*shapeP = MSPtr.shapepoint; /* ץݥȹ¤	*/

	for (i=0;i<total;i++){

		lineword = linewordS;		/* ɤ߹ߥХåեΥݥ󥿤Ȥ᤹	*/
		if ( fgets( lineword,100,fp ) == NULL ){
			fputs ("ɸǡߤߥ顼\n",stderr );
			exit(1);
		}

		GetNumber ( &lineword,&ix );	*lineword++;
		GetNumber ( &lineword,&iy );	*lineword++;
		GetNumber ( &lineword,&iz );
		shapeP->pointX = ix;
		shapeP->pointY = iy;
		shapeP->pointZ = iz;
		shapeP++;

	}

}

/************************************************************************
		եǡɤ߹
 ************************************************************************/

ReadFaceData(fp,linewordS)
FILE		*fp;
char		*linewordS;			/* ɤ߹ߥݥ				*/
{

	char	*lineword;	
	int		total;				/* եΥȡ				*/
	int		pointNO;			/* եݥֹ	*/
	int		topcount;			/* եĺο				*/
	int		color;				/* եΥ顼					*/
	int		i,counter;

	int			facecount	= 0;					/* եο򥫥Ȥ		*/
	SHAPEFACE	*face		= MSPtr.shapeface;		/* ե¤ΤؤΥݥ	*/

	lineword = linewordS;

	while ( fgets( lineword,100,fp ) != NULL ){

		GetNumber( &lineword,&topcount  );			/* ĺɤ߹			*/

		if ( topcount== 0 )	break;					/* MSDOS FILE к			*/

		*lineword++;
		face->facepoint = topcount;


		for (i=0;i<topcount;i++){					/* եǡɤ߹	*/
			GetNumber( &lineword,&pointNO );
			*lineword++;
			face->pointNO[i] = pointNO;
		}

		GetNumber( &lineword,&color );				/* 顼ǡɤ߹		*/
		face->color = color;

		facecount++;								/* եο򣱤䤹 */
		face++;										/* եݥ󥿤ʤ	*/
		lineword = linewordS;						/* ʸݥ󥿤ꥻå	*/

	} 

	MSPtr.FaceTotal = facecount;					/* եȡ	*/

}




/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */

/************************************************************************
		ƥȷοǡ(10դ)
		INT ǡѴ
 ************************************************************************/

GetNumber( dt,nm )
char	**dt;
int		*nm;
{

	char	*pt;
	int	ct=0, nn=0 ;
	int	sign_flag = 0;

		pt = *dt ;	/* Ԥʸݥ󥿤Ȥ */

					/* ޥʥǡΤȤ */
		if ( *pt == '-' ){
			*pt++;
			sign_flag++;
		}

		while ( isdigit( *pt )) {
			nn = nn * 10 + (*pt++ - '0');
			ct++;	/* åݥ */
		}

		if ( sign_flag != 0 ){
			nn = -nn;
		}

		*dt = pt ;	/* Ԥʸݥ󥿤Ϥ */
		*nm = nn ;	/* ǡϤ */

		return ( ct ) ;

}


/*----------------------------------------------------------------------*/
/*	ˡ٥ȥη׻
/*----------------------------------------------------------------------*/

calc_vector(point1,point2,point3,i,face,sp)
int	point1,point2,point3,i;
SHAPEFACE		*face;
SHAPEPOINT		*sp;
{

	int	nx,ny,nz;
	int	p1,p2,p3;
	int	a1,a2,a3,a4;
	int	x1,y1,z1;

	double	nomal;
	int		nomal_x,nomal_y,nomal_z;

		x1 = (sp+point1)->pointX;			/* ʿ̾Σ		*/
		y1 = (sp+point1)->pointY;
		z1 = (sp+point1)->pointZ;

											/* Ѥη׻				*/

		a1 = (sp+point2)->pointY - (sp+point1)->pointY;
		a2 = (sp+point3)->pointZ - (sp+point2)->pointZ;
		a3 = (sp+point2)->pointZ - (sp+point1)->pointZ;
		a4 = (sp+point3)->pointY - (sp+point2)->pointY;

		nx = a1*a2 - a3*a4;

		a1 = (sp+point2)->pointZ - (sp+point1)->pointZ;
		a2 = (sp+point3)->pointX - (sp+point2)->pointX;
		a3 = (sp+point2)->pointX - (sp+point1)->pointX;
		a4 = (sp+point3)->pointZ - (sp+point2)->pointZ;

		ny = a1*a2 - a3*a4;

		a1 = (sp+point2)->pointX - (sp+point1)->pointX;
		a2 = (sp+point3)->pointY - (sp+point2)->pointY;
		a3 = (sp+point2)->pointY - (sp+point1)->pointY;
		a4 = (sp+point3)->pointX - (sp+point2)->pointX;

		nz = a1*a2 - a3*a4;

		nomal = nx*nx+ny*ny+nz*nz;
		nomal = sqrt ( nomal );

		if ( nomal == 0 ){
			nomal = 1;
		}

/*DB	Xprintf  ( "%lf\n",nomal);		DB*/

		nomal_x = ( nx / nomal ) * 127;
		nomal_y = ( ny / nomal ) * 127;
		nomal_z = ( nz / nomal ) * 127;

/*DB	Xprintf ( ",%4.0lf,%4.0lf,%4.0lf",nomal_x,nomal_y,nomal_z);	DB*/

		face -> equA = nomal_x;		/* ʿ̤ˡ٥ȥ	*/
		face -> equB = nomal_y;
		face -> equC = nomal_z;

								/* ʿ̤ ax+by+cz+D=0 ((D))	*/
		face -> equD = -( nomal_x*x1 + nomal_y*y1 + nomal_z*z1 );
								/* Υ뤿η׻				*/
		face -> equN = nomal;

}


