/************************************************************************
	   MODE-7 CHARACTER & COLOR
	=> TEXTURE MAPPING CHARACTER
 ************************************************************************/

#include 	<stdio.h>
#include	<string.h>
#include	<ctype.h>
#include 	<math.h>

#define		unchar			unsigned char

/************************************************************************
		main
 ************************************************************************/

void main ( argc,argv )
int 	argc;
char	*argv[];
{

	FILE	*CGXfp;		/* character file pointer	*/
	FILE	*COLfp;		/* color	 file pointer	*/


	/***** message *****/

	if (argc < 2){
		fprintf(stderr, "***********************************************\n");
		fprintf(stderr, "*                                             *\n");
		fprintf(stderr, "*      mode7 character => RGB texture data    *\n");
		fprintf(stderr, "*                                             *\n");
		fprintf(stderr, "*    	g *.CGX *.COL                          *\n");
		fprintf(stderr, "*      Programed By H.Yajima  1994.5.20       *\n");
		fprintf(stderr, "*                                             *\n");
		fprintf(stderr, "***********************************************\n");
		exit( 1 ) ;
	}


	if ((CGXfp = fopen(argv[1],"r")) == NULL ){
		fprintf(stderr, "file read error (%s)\n",argv[1]);
		exit(1);
	}
	if ((COLfp = fopen(argv[2],"r")) == NULL ){
		fprintf(stderr, "file read error (%s)\n",argv[1]);
		exit(1);
	}

	LoadData(CGXfp,COLfp);

	fclose(CGXfp);
	fclose(COLfp);

}



/************************************************************************

 ************************************************************************/

unchar	charBUF[0x10000];	/* 8bit character data	*/
unchar	bitBUF[0x10000];	/* bitmap color	data	*/
unchar	colorBUF[0x200];	/* 256 color palette	*/

LoadData(CGXfp,COLfp)
FILE	*CGXfp,*COLfp;
{

	int	charNO;

	fread(charBUF,sizeof(char),0x4000,CGXfp);
	Convert8bit8bit(0x10000,charBUF,bitBUF);
	fread(colorBUF,sizeof(char),0x200,COLfp);

	for (charNO=0;charNO<256;charNO++){
		MakeData(charNO);
	}

}

/************************************************************************
		8bit CGX character => mode7 DOT COLOR DATA
 ************************************************************************/

MakeData(charNO)
int charNO;
{

	int	H,V;
	int	colordata;
	int	cR,cG,cB;

	printf ( "unsigned long data%d[]= { \n",charNO );

	for (V = 7;V >= 0;V-- ){
		printf	("		");
		for (H = 0;H < 8;H++ ){

			if (H!=0) printf (",");

			colordata  = bitBUF[charNO*0x40+V*8+H];
			cR		   =  (colorBUF[colordata*2+0] & 0x1f ) <<3;	
			cG		   = ((colorBUF[colordata*2+0] & 0xe0 ) >>2 )
					   + ((colorBUF[colordata*2+1] & 0x03 ) <<6 );	
			cB		   =  (colorBUF[colordata*2+1] & 0x7c ) <<1;
			
			printf ( "0xff%02x%02x%02x",cB,cG,cR);
		}
		if (V!=0)	printf ( ",\n");
		else		printf ( "\n};\n" );
	}

}


/************************************************************************
		8bit CGX character => mode7 DOT COLOR DATA
 ************************************************************************/


Convert8bit8bit(data_count,readBUF,writeBUF)
int	data_count;
unsigned char	*readBUF,*writeBUF;
{
	int	i,j;
	int	t1,t2,t3,t4,t5,t6,t7,t8;
	int	char_counter = 0;



	for(i=0;i<data_count;i=i+0x40){

		for(j=0;j<8;j++){

			t1 = readBUF[i+j*2+0];		/* ZP */
			t2 = readBUF[i+j*2+1];		/* ZQ */
			t3 = readBUF[i+j*2+16];		/* ZR */
			t4 = readBUF[i+j*2+17];		/* ZS */
			t5 = readBUF[i+j*2+32];		/* ZT */
			t6 = readBUF[i+j*2+33];		/* ZU */
			t7 = readBUF[i+j*2+48];		/* ZV */
			t8 = readBUF[i+j*2+49];		/* ZW */

			writeBUF[i+j*8+0] = ((t1>>7)&0x1) | ((t2>>6)&0x2) | ((t3>>5)&0x4) | ((t4>>4)&0x8) | ((t5>>3)&0x10) | ((t6>>2)&0x20) | ((t7>>1)&0x40) | ( t8    &0x80);
 			writeBUF[i+j*8+1] = ((t1>>6)&0x1) | ((t2>>5)&0x2) | ((t3>>4)&0x4) | ((t4>>3)&0x8) | ((t5>>2)&0x10) | ((t6>>1)&0x20) | ( t7    &0x40) | ((t8<<1)&0x80);
 			writeBUF[i+j*8+2] = ((t1>>5)&0x1) | ((t2>>4)&0x2) | ((t3>>3)&0x4) | ((t4>>2)&0x8) | ((t5>>1)&0x10) | ( t6    &0x20) | ((t7<<1)&0x40) | ((t8<<2)&0x80);
 			writeBUF[i+j*8+3] = ((t1>>4)&0x1) | ((t2>>3)&0x2) | ((t3>>2)&0x4) | ((t4>>1)&0x8) | ( t5    &0x10) | ((t6<<1)&0x20) | ((t7<<2)&0x40) | ((t8<<3)&0x80);
 			writeBUF[i+j*8+4] = ((t1>>3)&0x1) | ((t2>>2)&0x2) | ((t3>>1)&0x4) | ( t4    &0x8) | ((t5<<1)&0x10) | ((t6<<2)&0x20) | ((t7<<3)&0x40) | ((t8<<4)&0x80);
 			writeBUF[i+j*8+5] = ((t1>>2)&0x1) | ((t2>>1)&0x2) | ( t3    &0x4) | ((t4<<1)&0x8) | ((t5<<2)&0x10) | ((t6<<3)&0x20) | ((t7<<4)&0x40) | ((t8<<5)&0x80);
 			writeBUF[i+j*8+6] = ((t1>>1)&0x1) | ( t2    &0x2) | ((t3<<1)&0x4) | ((t4<<2)&0x8) | ((t5<<3)&0x10) | ((t6<<4)&0x20) | ((t7<<5)&0x40) | ((t8<<6)&0x80);
 			writeBUF[i+j*8+7] = ( t1    &0x1) | ((t2<<1)&0x2) | ((t3<<2)&0x4) | ((t4<<3)&0x8) | ((t5<<4)&0x10) | ((t6<<5)&0x20) | ((t7<<6)&0x40) | ((t8<<7)&0x80);

		}

		char_counter++;
		if ( char_counter > 1024 )	break;

	}
}






/*======================================================================*/
/*======================================================================*/
/*======================================================================*/
