/************************************************************************
	   MODE-7 CHARACTER & COLOR
	=> TEXTURE MAPPING CHARACTER
 ************************************************************************/

#include 	<stdio.h>
#include	<string.h>
#include	<ctype.h>
#include 	<math.h>

#define		unchar		unsigned char

/************************************************************************
		memory
 ************************************************************************/

unchar	charBUF[0x10000];	/* 8bit character data	*/
unchar	bitBUF[0x10000];	/* bitmap color	data	*/
unchar	colorBUF[0x200];	/* 256 color palette	*/

int		PALETTE;
char	*NAME;
/************************************************************************
		main
 ************************************************************************/

void main ( argc,argv )
int 	argc;
char	*argv[];
{

	FILE	*TABLEfp;		/* data table pointer	*/

	/***** message *****/

	if (argc < 2){
		fprintf(stderr, "***********************************************\n");
		fprintf(stderr, "*                                             *\n");
		fprintf(stderr, "*      SFX character => RGB texture data      *\n");
		fprintf(stderr, "*                                             *\n");
		fprintf(stderr, "*    	g (tablename)                          *\n");
		fprintf(stderr, "*      Programed By H.Yajima  1994.5.30       *\n");
		fprintf(stderr, "*                                             *\n");
		fprintf(stderr, "***********************************************\n");
		exit( 1 ) ;
	}

	if ((TABLEfp = fopen(argv[1],"r")) == NULL ){
		fprintf(stderr, "file read error (%s)\n",argv[1]);
		exit(1);
	}

	NAME = argv[1];

	LoadData(TABLEfp);

	fclose(TABLEfp);


}



/************************************************************************
		Read << COL >> File
 ************************************************************************/

FILE	*ReadCOLfile(fp,lineword)
FILE	*fp;
char	*lineword;
{

	fgets(lineword,128,fp);					/**** 1 line read   ****/
	lineword[strlen(lineword)-1] = '\0';	/**** makefile name ****/
	return( fopen(lineword,"r") );			/**** file open     ****/

}

/************************************************************************
		Read << CGX >> File
 ************************************************************************/

FILE	*ReadCGXfile(fp,lineword)
FILE	*fp;
char	*lineword;
{

	fgets(lineword,128,fp);					/**** 1 line read   ****/
	lineword[strlen(lineword)-1] = '\0';	/**** makefile name ****/
	return( fopen(lineword,"r") );			/**** file open     ****/

}

/************************************************************************
		Read Block Data
 ************************************************************************/

unsigned long	RGBbuffer[1024];

ReadBlock(fp,lineword)
FILE	*fp;
char	*lineword;
{

	int		charNO,counter;
	char	*resetline = lineword;
	int		pose_counter = 0;

	while(fgets(lineword,128,fp) != NULL){

		if ( *lineword =='#'    ) continue;
		if ( isspace(*lineword) ) continue;

		for(counter=0;counter<16;counter++){

			switch (*lineword++){
				case	'+':	
					charNO = hexcode(*(lineword+0))*256+hexcode(*(lineword+1))*16+hexcode(*(lineword+2));
					charNO = charNO+0x100;
					SetRGBbuffer(counter,charNO);
					break;
				case	'-':
					charNO = hexcode(*(lineword+0))*256+hexcode(*(lineword+1))*16+hexcode(*(lineword+2));
					charNO = charNO+0x100;
					SetRGBbuffer2(counter,charNO);
					break;
				default:
					fprintf (stderr,"Data Error \n");
					exit(1);
				}
				lineword = lineword+4;

		}		

		write_data(pose_counter);			/* data output	*/

		lineword = resetline;
		pose_counter++;

	}

	write_title(pose_counter);

}

/************************************************************************
		(RGBbuffer)
 ************************************************************************/

SetRGBbuffer2(blocknumber,charNO)
int	blocknumber;
int	charNO;
{
	int	V,H;
	int	colordata;
	unsigned char	cR,cG,cB;
	int	addr;

	for (V=0;V<8;V++){
		for (H=0;H<8;H++){	
			addr = (blocknumber%4)*8 + (blocknumber/4)*256;
		    addr = addr + H + V*32;
				colordata  = bitBUF[charNO*0x40+V*8+(7-H)];
				cR		   =  (colorBUF[colordata*2+0] & 0x1f ) <<3;	
				cG		   = ((colorBUF[colordata*2+0] & 0xe0 ) >>2 )
						   + ((colorBUF[colordata*2+1] & 0x03 ) <<6 );	
				cB		   =  (colorBUF[colordata*2+1] & 0x7c ) <<1;
			if ( (colordata & 0x0f ) == 0)			RGBbuffer[addr] = 0;
			else	RGBbuffer[addr]	= cR+cG*256+cB*256*256+0xff000000;
		}
	}

}



/************************************************************************
		(RGBbuffer)
 ************************************************************************/

SetRGBbuffer(blocknumber,charNO)
int	blocknumber;
int	charNO;
{
	int	V,H;
	int	colordata;
	unsigned char	cR,cG,cB;
	int	addr;

	for (V=0;V<8;V++){
		for (H=0;H<8;H++){	
			addr = (blocknumber%4)*8 + (blocknumber/4)*256;
		    addr = addr + H + V*32;
				colordata  = bitBUF[charNO*0x40+V*8+H];
				cR		   =  (colorBUF[colordata*2+0] & 0x1f ) <<3;	
				cG		   = ((colorBUF[colordata*2+0] & 0xe0 ) >>2 )
						   + ((colorBUF[colordata*2+1] & 0x03 ) <<6 );	
				cB		   =  (colorBUF[colordata*2+1] & 0x7c ) <<1;
			if ( (colordata & 0x0f ) == 0)			RGBbuffer[addr] = 0;
			else	RGBbuffer[addr]	= cR+cG*256+cB*256*256+0xff000000;
		}
	}

}




/************************************************************************
		Write Title
 ************************************************************************/
write_title(total)
int	total;
{

	int		i;

	printf (	"unsigned	long	*%s_data[] = {\n",NAME );

	for (i=0;i<total;i++){
		if (i!=0) printf(",\n");
		printf ( "data%d",i);
	}

	printf ( "\n};\n\n");
	
}

/************************************************************************
		Write Datas
		( RGBbuffer )
 ************************************************************************/

write_data(dct)
int	dct;
{

	int	H,V;

		printf ("static	unsigned long data%d[] = {\n",dct);		/* title	*/

		for (V=31;V>=0;V--){
			printf ("	");
			for (H=0;H<32;H++){
				if (H!=0){
					printf (",");
					if ( (H%8)==0 )	printf ("\n	");
				}
				printf ("0x%08x",RGBbuffer[H+V*32]);
			}
			if (V!=0)	printf (",\n");
		}

		printf ("\n};\n\n");

}

/************************************************************************
		hex number data
 ************************************************************************/

hexcode(s)
char	s;
{
	int	answer;

	if (!isxdigit(s)){
		fprintf (stderr,"Data Error \n");
		exit(1);
	}
	if (isdigit(s)){
		answer = s - '0';
	} else	{
		if (isupper(s))	answer = s - 'A' + 10;
		else			answer = s - 'a' + 10;	
	}

	
	return(answer);
}

/************************************************************************

 ************************************************************************/


LoadData(TABLEfp)
FILE	*TABLEfp;
{

	FILE	*CGXfp;
	FILE	*COLfp;
	int		charNO;
	char	lineword[101];

	/*----------- Read CGX Data --------------------*/
	if ( (CGXfp = ReadCGXfile(TABLEfp,lineword)) == NULL ){
		fprintf ( stderr,"CGX file open error\n" );
		exit(1);
	}
	fread(charBUF,sizeof(char),0x4000,CGXfp);
	fclose(CGXfp);

	/*----------- Read COL Data --------------------*/
	if ( (COLfp = ReadCOLfile(TABLEfp,lineword)) == NULL ){
		fprintf ( stderr,"COL file open error\n" );
		exit(1);
	}
	fread(colorBUF,sizeof(char),0x200,COLfp);
	fclose(COLfp);

	/*----------- MAIN --------------------*/

	fgets(lineword,128,TABLEfp);				/* palette read		*/
	PALETTE =  hexcode(lineword[0]);

	Convert4bit8bit(0x8000,charBUF,bitBUF);	

	ReadBlock(TABLEfp,lineword);				/* Make Character	*/


}


/************************************************************************
		8bit CGX character => mode7 DOT COLOR DATA
 ************************************************************************/

MakeData(charNO)
int charNO;
{

	int	H,V;
	int	colordata;
	int	cR,cG,cB;

	printf ( "unsigned long data%d[]= { \n",charNO );

	for (V = 7;V >= 0;V-- ){
		printf	("		");
		for (H = 0;H < 8;H++ ){

			if (H!=0) printf (",");

			colordata  = bitBUF[charNO*0x40+V*8+H];

			if ( colordata & 0xf != 0 ){
				printf ( "0xff%02x%02x%02x",cB,cG,cR);
			} else {
				printf ( "0x00ffffff");
			}
			
		}
		if (V!=0)	printf ( ",\n");
		else		printf ( "\n};\n" );
	}

}


/************************************************************************
		4bit CGX character => mode7 DOT COLOR DATA
 ************************************************************************/

Convert4bit8bit(data_count,readBUF,writeBUF)
int	data_count;
unsigned char	*readBUF,*writeBUF;
{

	int	i,j;
	int	t1,t2,t3,t4;
	int	pointer;

	int	attr = PALETTE*0x10 + 0x80;
	int	char_counter = 0;


	for(i=0;i<data_count;i=i+0x20){

		for(j=0;j<8;j++){

			t1 = readBUF[i+j*2+0];
			t2 = readBUF[i+j*2+1];
			t3 = readBUF[i+j*2+16];
			t4 = readBUF[i+j*2+17];

			pointer = i*2+j*8;

			writeBUF[pointer++] = ((t1>>7)&0x1) | ((t2>>6)&0x2) | ((t3>>5)&0x4) | ((t4>>4)&0x8) | attr;
			writeBUF[pointer++] = ((t1>>6)&0x1) | ((t2>>5)&0x2) | ((t3>>4)&0x4) | ((t4>>3)&0x8) | attr;
 			writeBUF[pointer++] = ((t1>>5)&0x1) | ((t2>>4)&0x2) | ((t3>>3)&0x4) | ((t4>>2)&0x8) | attr;
 			writeBUF[pointer++] = ((t1>>4)&0x1) | ((t2>>3)&0x2) | ((t3>>2)&0x4) | ((t4>>1)&0x8) | attr;
 			writeBUF[pointer++] = ((t1>>3)&0x1) | ((t2>>2)&0x2) | ((t3>>1)&0x4) | ( t4    &0x8) | attr;
 			writeBUF[pointer++] = ((t1>>2)&0x1) | ((t2>>1)&0x2) | ( t3    &0x4) | ((t4<<1)&0x8) | attr;
 			writeBUF[pointer++] = ((t1>>1)&0x1) | ( t2    &0x2) | ((t3<<1)&0x4) | ((t4<<2)&0x8) | attr;
 			writeBUF[pointer++] = ( t1    &0x1) | ((t2<<1)&0x2) | ((t3<<2)&0x4) | ((t4<<3)&0x8) | attr;

		}

		char_counter++;
		if ( char_counter > 1024 )	break;

	}

}


/************************************************************************
		8bit CGX character => mode7 DOT COLOR DATA
 ************************************************************************/


Convert8bit8bit(data_count,readBUF,writeBUF)
int	data_count;
unsigned char	*readBUF,*writeBUF;
{
	int	i,j;
	int	t1,t2,t3,t4,t5,t6,t7,t8;
	int	char_counter = 0;



	for(i=0;i<data_count;i=i+0x40){

		for(j=0;j<8;j++){

			t1 = readBUF[i+j*2+0];		/* ZP */
			t2 = readBUF[i+j*2+1];		/* ZQ */
			t3 = readBUF[i+j*2+16];		/* ZR */
			t4 = readBUF[i+j*2+17];		/* ZS */
			t5 = readBUF[i+j*2+32];		/* ZT */
			t6 = readBUF[i+j*2+33];		/* ZU */
			t7 = readBUF[i+j*2+48];		/* ZV */
			t8 = readBUF[i+j*2+49];		/* ZW */

			writeBUF[i+j*8+0] = ((t1>>7)&0x1) | ((t2>>6)&0x2) | ((t3>>5)&0x4) | ((t4>>4)&0x8) | ((t5>>3)&0x10) | ((t6>>2)&0x20) | ((t7>>1)&0x40) | ( t8    &0x80);
 			writeBUF[i+j*8+1] = ((t1>>6)&0x1) | ((t2>>5)&0x2) | ((t3>>4)&0x4) | ((t4>>3)&0x8) | ((t5>>2)&0x10) | ((t6>>1)&0x20) | ( t7    &0x40) | ((t8<<1)&0x80);
 			writeBUF[i+j*8+2] = ((t1>>5)&0x1) | ((t2>>4)&0x2) | ((t3>>3)&0x4) | ((t4>>2)&0x8) | ((t5>>1)&0x10) | ( t6    &0x20) | ((t7<<1)&0x40) | ((t8<<2)&0x80);
 			writeBUF[i+j*8+3] = ((t1>>4)&0x1) | ((t2>>3)&0x2) | ((t3>>2)&0x4) | ((t4>>1)&0x8) | ( t5    &0x10) | ((t6<<1)&0x20) | ((t7<<2)&0x40) | ((t8<<3)&0x80);
 			writeBUF[i+j*8+4] = ((t1>>3)&0x1) | ((t2>>2)&0x2) | ((t3>>1)&0x4) | ( t4    &0x8) | ((t5<<1)&0x10) | ((t6<<2)&0x20) | ((t7<<3)&0x40) | ((t8<<4)&0x80);
 			writeBUF[i+j*8+5] = ((t1>>2)&0x1) | ((t2>>1)&0x2) | ( t3    &0x4) | ((t4<<1)&0x8) | ((t5<<2)&0x10) | ((t6<<3)&0x20) | ((t7<<4)&0x40) | ((t8<<5)&0x80);
 			writeBUF[i+j*8+6] = ((t1>>1)&0x1) | ( t2    &0x2) | ((t3<<1)&0x4) | ((t4<<2)&0x8) | ((t5<<3)&0x10) | ((t6<<4)&0x20) | ((t7<<5)&0x40) | ((t8<<6)&0x80);
 			writeBUF[i+j*8+7] = ( t1    &0x1) | ((t2<<1)&0x2) | ((t3<<2)&0x4) | ((t4<<3)&0x8) | ((t5<<4)&0x10) | ((t6<<5)&0x20) | ((t7<<6)&0x40) | ((t8<<7)&0x80);

		}

		char_counter++;
		if ( char_counter > 1024 )	break;

	}
}






/*======================================================================*/
/*======================================================================*/
/*======================================================================*/
