/********************************************************************************
					RS232C Controller check program

						Programmed by Y.Nishida

														[ May.19, 1994 ]
 ********************************************************************************/

#include <stdio.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <termios.h>
#include <errno.h>
#include "controller.h"

static int serial;			/* file descripter for the serial device driver		*/


/********************************************************************************/
/*	Transmit a byte data to the serial port.									*/
/********************************************************************************/
static void
TransmitSerial(int code)
{
	unsigned char cc;

	cc = (unsigned char)code;
	write(serial,&cc,1);
}
/********************************************************************************/
/*	Reseive a byte data from the serial port.									*/
/********************************************************************************/
static int
ReseiveSerial(void)
{
	unsigned char cc;

	if (read(serial,&cc,1) <= 0) return(-1);
	return((int)cc);
}
/********************************************************************************/
/*	Initialize the game controller.												*/
/********************************************************************************/
extern int
InitController(void)
{
	struct termios setting;
	int			   device;

	if ((serial = open(SERIAL_PORT,O_RDWR)) >= 0) {
		ioctl(serial,TCGETS,&setting);

		setting.c_iflag	    = IGNBRK | IGNPAR;
		setting.c_oflag	    = 0;
		setting.c_cflag	    = B9600 | CS8 | CREAD | HUPCL | CLOCAL;
		setting.c_lflag	    = 0;
		setting.c_cc[VMIN]  = 0;
		setting.c_cc[VTIME] = 1;

		ioctl(serial,TCSETSF,&setting);
		ioctl(serial,TCFLSH,2);
	}
	return(device);
}
/********************************************************************************/
/*	Start to scan the game controller.											*/
/********************************************************************************/
extern void
ScanController(void)
{
	ioctl(serial,TCFLSH,0);				/* flush the input quene of serial port	*/
	TransmitSerial(0xff);				/* start scanning						*/
}
/********************************************************************************/
/*	Scan the game controller.													*/
/********************************************************************************/
extern long
GetController(void)
{
	int code1, code2, code3, code4;

	if ((code1 = ReseiveSerial()) < 0) return(-1);
	if ((code2 = ReseiveSerial()) < 0) return(-1);
	if ((code3 = ReseiveSerial()) < 0) return(-1);
	if ((code4 = ReseiveSerial()) < 0) return(-1);

	code1 = code1 & 0xff;
	code2 = code2 & 0x0f;
	code3 = code3 & 0xff;
	code4 = code4 & 0x0f;

	return(code4 << 24 | code3 << 16 | code2 << 8 | code1);
}
