/***************************************************************
	GL TestGame Program	( TestRace )
	<< game.c >>
									Programed By H.Yajima
****************************************************************/

#include	<stdio.h>
#include	<math.h>


#include	<gl/gl.h>
#include	<gl/device.h>

#include	"window.h"
#include	"library.h"
#include	"prototype.h"


/***************************************************************
	Global Memory
****************************************************************/

#define		MAXarea		128*128	
#define		MAXdraw		1000
#define		MAXmap		4096

DrawList	drawlist[MAXdraw];
AreaInfo	*AreaList[MAXarea];
AreaInfo	AreaData[MAXmap];
int			drawpointer;	/* drawlist */

CameraInfo	playercamera;
ObjectInfo	playerobject;

/***************************************************************
	Game Initialize
****************************************************************/
extern	void	InitGame()
{

	extern	GroundInfo	map[];

	DrawList	dlist;
	dlist.OBJPtr = map;


	SetPlayer(&playerobject,64*16,0,0,0,0,0);
	SetCamera(&playercamera,0,0,0,0,0,0,0,-50,200);
	CopyCamera(&playercamera,&playerobject);

	InitAreaList(AreaList,MAXarea);
	InitAreaData(AreaData,MAXmap);
	SetAreaData(AreaList,AreaData,&dlist);

	InitKart();

}


/***************************************************************
	Game Main
****************************************************************/
extern	void	MainGame()
{

	extern	GroundInfo	map[];

	MainPlayer(&playerobject);
	CopyCamera(&playercamera,&playerobject);
	MainCamera(&playercamera);

	/* MakeList(map,drawlist); */
	drawpointer = MakeDispList(&playercamera,drawlist,AreaList);
	/* AddDispList(&playerobject,drawlist,&drawpointer); */		/* player set */

	DrawScreen(drawlist,&playercamera);

	DispKart();

	SetMeter(&playercamera);



}


/******	DrawList ***********************************************/

/***************************************************************
	ADD DrawList
****************************************************************/


AddDispList(object,dlist,pointer)
ObjectInfo	*object;
DrawList	*dlist;
int			*pointer;
{

	extern	ShapeInfo	mycar;

	(dlist+(*pointer))->OBJPtr			= (GroundInfo *)object;
	(dlist+(*pointer))->OBJPtr->shape	= &mycar;
	(dlist+(*pointer))->OBJPtr->flags	= SHAPE_OBJECT;

	(*pointer)++;

	(dlist+(*pointer))->OBJPtr			= NULL;

}

/***************************************************************
	MapData ==> DrawList
****************************************************************/
MakeList(groundP,dlist)
GroundInfo	*groundP;
DrawList	*dlist;
{

	while( groundP->shape != NULL ){
		dlist->OBJPtr = groundP;
		dlist++;
		groundP++;
	}
	dlist->OBJPtr = NULL;

}

