/***************************************************************
	GL TestGame Program	( TestRace )
	<< main.c >>
									Programed By H.Yajima
****************************************************************/

#include	<stdio.h>
#include	<math.h>


#include	<gl/gl.h>
#include	<gl/device.h>

#include	"window.h"
#include	"library.h"
#include	"prototype.h"


/***************************************************************
	Global Memory
****************************************************************/

int		INTERVAL 	= 0;
long	CONTROLLER 	= 0;
			
/***************************************************************
	Main Program
****************************************************************/
main()
{

	int		i;
	short	val;
	int		timeCounter;


	timeCounter = TickCount();		/* Start Timer	*/



	prefsize(WindowSizeX,WindowSizeY);
	winopen("TestGame (Race)");
	/* SetColormap(); */
	SetColorTable();

	doublebuffer();
	RGBmode();
	gconfig();

	shademodel(FLAT);


	if (InitController() < 0){
		fprintf (stderr," CONTROLLER ERROR 1 \n");
		exit(1);
	}

	InitScreen();
	InitGame();

	while( (CONTROLLER & button_start) == 0){

		ScanController();
		ClearBitmap();								/*	Bitmap Clear	*/
		MainGame();
		swapbuffers();								/*  Double Buffer 	*/		
		INTERVAL = GameSyncro(&timeCounter);		/*  = WaitNMI		*/
													/*	Read Controller	*/
		CONTROLLER = GetController();

   }

	gexit();

}


/***************************************************************
	ClolrMap Entry
****************************************************************/

SetColormap()
{

	extern	Palette TestColor[];
	int	i;
	int	cR,cG,cB;

	for(i=0;i<256;i++){

		cR = TestColor[i].red	* 255;
		cG = TestColor[i].green * 255;
		cB = TestColor[i].blue	* 255;

		mapcolor(i+256,cR,cG,cB);

	}

}


/*============= RGB mode =============*/

unsigned	long	RGBdata[256];

SetColorTable()

{
	extern	Palette TestColor[];
	int	i;
	int	cR,cG,cB;

	for(i=0;i<256;i++){

		cR = TestColor[i].red	* 255;
		cG = TestColor[i].green * 255;
		cB = TestColor[i].blue	* 255;

		RGBdata[i] = cR+cG*256+cB*256*256+0xff000000;

	}

}



/***************************************************************
	Bitmap Clear
****************************************************************/

ClearBitmap()
{

	cpack(0xff000000);
	clear();

}

