/***************************************************************
	GL TestGame Program	( TestRace )
	<< map.h >>
									Programed By H.Yajima
****************************************************************/

#define	SHAPE_GROUND	1
#define	SHAPE_OBJECT	2

/******* Camera Infomation *******************/
typedef	struct	{
	double	positionX;
	double	positionY;
	double	positionZ;
	double	angleX;
	double	angleY;
	double	angleZ;
	double	offsetX;
	double	offsetY;
	double	offsetZ;
}	CameraInfo;


/**************** Palette Record ************************************/
typedef struct {
	float	red;
	float	green;
	float	blue;
} Palette;

/**************** Point Record **************************************/
typedef struct {
	short	pointX;
	short	pointY;
	short	pointZ;
	short	color;
	float	vectorX;
	float	vectorY;
	float	vectorZ;
} PointData,*PointPtr;

/**************** Face Record **************************************/
typedef struct {
	short	nvertexes;
	short	color;
	short	xmax;
	short	xmin;
	short	ymax;
	short	ymin;
	short	zmax;
	short	zmin;
	float	planeA;
	float	planeB;
	float	planeC;
	float	planeD;
	short	points[8];
} FaceData,*FacePtr;

/**************** Shape Infomation Record **************************/
typedef struct {
	short		npoints;
	short		nfaces;
	short		nhits;
	short		radius;
	short		xmax;
	short		ymax;
	short		zmax;
	short		reserved;
	PointPtr	point;
	FacePtr		face;
} ShapeInfo,*ShapePtr;

/**************** Ground Infomation Record *************************/
typedef struct {
	ShapePtr	shape;
	char		flags;
	char		angY;
	short		posX;
	short		posZ;
} GroundInfo,*GroundPtr;

/**************** Object Infomation Record *************************/
typedef struct {
	ShapePtr	shape;
	char		flags;
	char		dmmy;
	double		positionX;
	double		positionY;
	double		positionZ;
	double		angleX;
	double		angleY;
	double		angleZ;
} ObjectInfo,*ObjectPtr;

/**************** AnyObject Infomation Record **********************/
typedef struct {
	ShapePtr	shape;
	char		flags;
} AnyOBJInfo,*AnyOBJPtr;

/**************** DrawList Record **********************************/
typedef struct{
	GroundInfo	*OBJPtr;
} DrawList;

/**************** SortList Record **********************************/

typedef	struct	snode	{

	struct	snode	*next;
	struct	snode	*prev;
	GroundInfo		*map;
	double			rotateX;
	double			rotateY;
	double			rotateZ;
	double			angleX;
	double			angleY;
	double			angleZ;
	double			sortZ;

} SortList;


/*************** AreaList Record **********************************/

typedef	struct	node{
	struct	node	*next;
	struct	node	*prev;
	GroundInfo		*OBJPtr;
}	AreaInfo;


/**************** World Infomation Record **************************/


