/***************************************************************
	GL TestGame Program	( TestRace )
	<< main.c >>
									Programed By H.Yajima
****************************************************************/

#include	<stdio.h>
#include	<math.h>


#include	<gl/gl.h>
#include	<gl/device.h>

#include	"window.h"
#include	"library.h"
#include	"prototype.h"


/***************************************************************
	Global Memory
****************************************************************/

int		INTERVAL 	= 0;
int		CONTROLLER 	= 0;
			
/***************************************************************
	Main Program
****************************************************************/
main()
{

	int		i;
	short	val;
	int		timeCounter;


	timeCounter = TickCount();		/* Start Timer	*/



	prefsize(WindowSizeX,WindowSizeY);
	winopen("TestGame (Race)");
	SetColormap();

	doublebuffer();
	gconfig();

	shademodel(FLAT);


	InitScreen();
	InitGame();

	while( (CONTROLLER & button_start) == 0){

	ClearBitmap();								/*	Bitmap Clear	*/

	MainGame();

	swapbuffers();								/*  Double Buffer 	*/		
	INTERVAL = GameSyncro(&timeCounter);		/*  = WaitNMI		*/
	CONTROLLER = ScanController();				/*	Read Controller	*/

	}

	gexit();

}


/***************************************************************
	ClolrMap Entry
****************************************************************/

SetColormap()
{

	extern	Palette TestColor[];
	int	i;
	int	cR,cG,cB;

	for(i=0;i<256;i++){

		cR = TestColor[i].red	* 255;
		cG = TestColor[i].green * 255;
		cB = TestColor[i].blue	* 255;

		mapcolor(i+256,cR,cG,cB);

	}

}



/***************************************************************
	Bitmap Clear
****************************************************************/

ClearBitmap()
{

	color(0);
	clear();

}

