#define		FillSwitch	1
#define		ZOOMCAMERA	960.0/2
#define		ZCLIP		16
/***************************************************************
	GL TestGame Program	( TestRace )
	<< polygon.c >>
									Programed By H.Yajima
****************************************************************/

#define		TRUE	1
#define		FALSE	0

#include	<stdio.h>
#include	<math.h>

#include	<gl/gl.h>
#include	<gl/device.h>

#include	"window.h"
#include	"library.h"
#include	"prototype.h"

/***************************************************************
	External Memory
****************************************************************/

int		POLYGON;
extern	int	CONTROLLER;

extern	ShapeInfo	load1;

/******* Matrix Parameter ********************/

#define	M11	0
#define	M12	1
#define	M13	2
#define	M21	3
#define	M22	4
#define	M23	5
#define	M31	6
#define	M32	7
#define	M33	8



/******* Shape Rotation Point ****************/
typedef struct	{
	double	rotateX;
	double	rotateY;
	double	rotateZ;
}	RotatePoints;

/******* Shape Display Point *****************/
typedef struct	{
	double	displayX;
	double	displayY;
}	DisplayPoints;

/***************************************************************
	Parameter
****************************************************************/

#define		MAXshape	1000
#define		MAXPoint	4000

CameraInfo	camera;
double		WorldMatrix[10];
double		ObjectMatrix[10];
double		RotateMatrix[10];

RotatePoints		rotatepoint[MAXPoint];
DisplayPoints		displaypoint[MAXPoint];
int					overflag[MAXPoint];

SortList			SORTLIST[MAXshape];

/***************************************************************
	Polygon Initial
****************************************************************/

extern	void	InitScreen()
{
}


/***************************************************************
	Polygon Main
****************************************************************/

extern	void	DrawScreen(drawlist,camera)
DrawList	*drawlist;
CameraInfo	*camera;
{

	SortList	*sortlist;
	ShapeInfo	*shapeP;	
	int			shapecount;
	double		unitZ;

	POLYGON = 0;

	Make3DMatrix(WorldMatrix,camera->angleX,camera->angleY,camera->angleZ);
	UnitRotate(&unitZ);
	MakeSortList(drawlist,camera,&unitZ);		/* shape sortlist	 	*/
	MapZsort(SORTLIST);							/* Z simple sort		*/

	sortlist = SORTLIST[0].next;				/* shape start index 	*/
	while(sortlist != SORTLIST){

		MakeObjMatrix(sortlist);				/* object rotation		*/
		Rotation(sortlist);						/* point rotation		*/
		Projection(sortlist);					/* point projection		*/
		DrawPolygon(sortlist);					/* polygon draw			*/

		sortlist = sortlist->next;				/* shape next			*/

	}

}

/************************************************************************
	Map Unit Rotation
 ************************************************************************/
static	double	unitp[] = { -1056,-1056, 1056,-1056, -1056, 1056, 1056, 1056 };
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -*/

UnitRotate(unitZ)
double		*unitZ;
{
	double	*p		 = unitp;
	double	*matrixP = WorldMatrix;
	double	cz[4];
	int	i;
	*unitZ = 0;

	for(i=0;i<4;i++){
		cz[i] = (p[i*2+0] * *(matrixP+M13) + p[i*2+1] * *(matrixP+M33));
		if	( *unitZ < cz[i] ) *unitZ = cz[i];
	}

}

/***************************************************************
	Make SortList
****************************************************************/

MakeSortList(drawlist,camera,unitZ)
DrawList	*drawlist;
CameraInfo	*camera;
double		*unitZ;
{
	SortList	*list 	= SORTLIST;
	SortList	*root 	= SORTLIST;

	double		rx,ry,rz;
	ObjectInfo	*object;

	/*--- initialize ---*/
	root->next = list+1;
	root->prev = root;
	list++;

	/*--- main ----*/
	while(	drawlist->OBJPtr!= NULL ){
	
		if	(CenterRot(camera,drawlist->OBJPtr,&rx,&ry,&rz) == TRUE){

			list->map 		= drawlist->OBJPtr;
			list->next		= list+1;
			list->prev	 	= list-1;
			list->rotateX 	= rx;
			list->rotateY 	= ry;
			list->rotateZ 	= rz;

			switch (list->map->flags){
				case	SHAPE_GROUND:
					list->angleX = 0;
					list->angleY = 0;
					list->angleZ = 0;
					break;
				case	SHAPE_OBJECT:
					object = (ObjectPtr)(list->map);
					list->angleX = object->angleX;
					list->angleY = object->angleY;
					list->angleZ = object->angleZ;
					break;
			}

			/*- - - - map unit system - - - - - -*/
			if (list->map->shape->radius >= 0x400){
					list->sortZ = rz + *unitZ;
			} else 	list->sortZ = rz; 
			/*- - - - - - - - - - - - - - - - - -*/

			list++;		/* display sortlist 	*/

		}

		drawlist++;		/* map drawlist			*/
	}

	(list-1)->next = root;

}

/***************************************************************
	MapShape Center Rotation
***************************************************************/

#define		mapzoom	16

CenterRot(camera,map,rx,ry,rz)
CameraInfo	*camera;
GroundInfo	*map;
double		*rx,*ry,*rz;
{

	double		*matrixP = WorldMatrix;
	double		px,py,pz;
	ObjectInfo	*object;

	switch (map->flags){

		case	SHAPE_GROUND:
			px = (map->posX)*mapzoom-(camera->positionX);
			py = 0-(camera->positionY);
			pz = (map->posZ)*mapzoom-(camera->positionZ);
			break;
		case	SHAPE_OBJECT:
			object = (ObjectPtr)map;
			px = (object->positionX)-(camera->positionX);
			py = (object->positionY)-(camera->positionY);
			pz = (object->positionZ)-(camera->positionZ);
			break;
	}

		*rx = (px * *(matrixP+M11)+py * *(matrixP+M21)+pz * *(matrixP+M31))+(camera->offsetX);	
		*ry = (px * *(matrixP+M12)+py * *(matrixP+M22)+pz * *(matrixP+M32))+(camera->offsetY);	
		*rz = (px * *(matrixP+M13)+py * *(matrixP+M23)+pz * *(matrixP+M33))+(camera->offsetZ);	

		if ( *rz < -128*mapzoom	)	return(FALSE);
		if ( *rz > 0x200*mapzoom 	)	return(FALSE);

	return(TRUE);

}

/***************************************************************
		Bouble Sort
***************************************************************/


MapZsort(root)
SortList	*root;
{

	SortList	*pwork,*pnext;
	int			sortflag;
	double		r1,r2;

	sortflag = 1;
	while (sortflag){
		sortflag = 0;
		pwork = root -> next;
		while ( (pnext = pwork->next) != root ){
				r1 = pwork -> sortZ;
				r2 = pnext -> sortZ;
			if ( r1 < r2 ){
				(pwork -> prev)->next 	= pnext;
				(pnext -> next)->prev 	= pwork;
				pnext -> prev 			= pwork -> prev;
				pwork -> prev 			= pnext; 
				pwork -> next 			= pnext -> next;
				pnext -> next 			= pwork;
				sortflag = 1;
			} else {
				pwork = pnext;
			}
		}
	}

}



/***************************************************************
	Calc Rotation Matrix
***************************************************************/

MakeObjMatrix(sortlist)
SortList	*sortlist;
{
	double	ax,ay,az;
	int	i;
	ObjectInfo	*object;

	switch	(sortlist->map->flags){
		case	SHAPE_GROUND:
			for(i=0;i<9;i++){
				RotateMatrix[i] = WorldMatrix[i];
			}
			break;
		case	SHAPE_OBJECT:
			object = (ObjectPtr)(sortlist->map);
			Make3DMatrix(ObjectMatrix,object->angleX,object->angleY,object->angleZ);
			CalcMatrix(RotateMatrix,ObjectMatrix,WorldMatrix);
			break;
	}

}
/***************************************************************
	Rotation
***************************************************************/

Rotation(sortlist)
SortList	*sortlist;
{

	double			*matrixP 	= RotateMatrix;
	RotatePoints	*rotateP	= rotatepoint;
	int				*overflagP	= overflag;
	PointData		*bodyP		= sortlist->map->shape->point;
	int				pointtotal	= sortlist->map->shape->npoints;
	int				scale 		= 1;

	double			cx 			= sortlist->rotateX;
	double			cy 			= sortlist->rotateY;
	double			cz 			= sortlist->rotateZ;

	double			px,py,pz;

#if	0
	printf ( "%d,%d,%d\n",(int)sortlist->rotateX,(int)sortlist->rotateY,(int)sortlist->rotateZ);
#endif


	while( pointtotal-- ){

		px = (bodyP->pointX);
		py = (bodyP->pointY);
		pz = (bodyP->pointZ);

		rotateP -> rotateX = (px * *(matrixP+M11)
			  			     +py * *(matrixP+M21)
						     +pz * *(matrixP+M31))*scale
					  	     + cx;
		rotateP -> rotateY = (px * *(matrixP+M12)
						     +py * *(matrixP+M22)
					  	     +pz * *(matrixP+M32))*scale
					  	     + cy;
		rotateP -> rotateZ  =(px * *(matrixP+M13)
					  	     +py * *(matrixP+M23)
					  	     +pz * *(matrixP+M33))*scale
					  	     + cz;

		/*------ Z Overflow --------*/
		if ( rotateP->rotateZ > ZCLIP )	*overflagP = 0;
		else 							*overflagP = 1;
		*overflagP++;
		/*--------------------------*/

		*rotateP++;
		*bodyP++;

	}

}

/***************************************************************
	Projection
***************************************************************/

Projection(sortlist)
SortList	*sortlist;
{

	RotatePoints	*rotateP	= rotatepoint;
	DisplayPoints	*displayP	= displaypoint;
	int				pointtotal 	= sortlist->map->shape->npoints;
	double			displayCX	= WindowSizeX/2;
	double			displayCY	= WindowSizeY/2;

	while ( pointtotal-- ){

		if (rotateP -> rotateZ == 0.0){
			rotateP -> rotateZ = 0.1;
		}

		displayP -> displayX = rotateP -> rotateX/(rotateP -> rotateZ)*ZOOMCAMERA 	 + displayCX;
		displayP -> displayY = (rotateP -> rotateY/(rotateP -> rotateZ)*ZOOMCAMERA)  + displayCY;

		*displayP++;
		*rotateP++;

	}

}

/***************************************************************
	DrawPolygon
***************************************************************/
static	float			V[8][2];
static	int				COLOR;

DrawPolygon(sortlist)
SortList	*sortlist;
{

	FaceData		*faceP		= sortlist->map->shape->face;
	int				facetotal	= sortlist->map->shape->nfaces;
	int				i,j;
	int				Zclipflag;

	ortho2(0.0,(float)WindowSizeX,0.0,(float)WindowSizeY);

	for (i=0;i<facetotal;i++){

		switch(faceP->nvertexes){
			case	2:	FillLine(faceP);		break;
			case	3:	FillTriangle(faceP);	break;
			case	4:	FillSquare(faceP);		break;
			default	:	break;
		}

		faceP++;

	}

	gflush();

}

/***************************************************************
	FillLine
***************************************************************/
FillLine(faceP)
FaceData	*faceP;
{

}

/***************************************************************
	FillTriangle
***************************************************************/
FillTriangle(faceP)
FaceData	*faceP;
{

	DisplayPoints	*displayP	= displaypoint;
	int				*overflagP	= overflag;
	int				i,j;
	int				Zclipflag	= 0;
	double			x1,x2,y1,y2,x3,y3;
	int				vizflag;
	float			V0[2],V1[2],V2[2];
	int				toptotal;

	for(j=0;j<3;j++){
		Zclipflag = Zclipflag + *(overflagP+(faceP->points[j]));
	}

	if (Zclipflag == 0)	{

		x1 = (displayP+(faceP->points[0]))->displayX;
		y1 = (displayP+(faceP->points[0]))->displayY;
		x2 = (displayP+(faceP->points[1]))->displayX;
		y2 = (displayP+(faceP->points[1]))->displayY;
		x3 = (displayP+(faceP->points[2]))->displayX;
		y3 = (displayP+(faceP->points[2]))->displayY;

		vizflag = (( x2 - x1 ) * ( y3 - y2 ))  -  (( y2 - y1 ) * ( x3 - x2 ));

		if ( vizflag < 0 ){

			V[0][0] = x1;	V[0][1] = y1;	/* Set Vertex */
			V[1][0] = x2;	V[1][1] = y2;	
			V[2][0] = x3;	V[2][1] = y3;

			color(faceP->color+256);		/* Set Color */
			bgnpolygon();
				v2f(V[0]);
				v2f(V[1]);
				v2f(V[2]);
			endpolygon();
		}

	} else {

		toptotal = EntryZclip(faceP);		/* 	ZClip 			*/
		FillClipPolygon(faceP,toptotal);	/*	DrawPolygon		*/ 
	}

}

/***************************************************************
	FillSquare
***************************************************************/
FillSquare(faceP)
FaceData	*faceP;
{

	DisplayPoints	*displayP	= displaypoint;
	int				*overflagP	= overflag;	
	int				j;
	double			x1,y1,x2,y2,x3,y3;
	int				vizflag;
	int				Zclipflag	= 0;
	int				toptotal;


	for(j=0;j<4;j++){
		Zclipflag = Zclipflag + *(overflagP+(faceP->points[j]));
	}

	if (Zclipflag == 0)	{

		x1 = (displayP+(faceP->points[0]))->displayX;
		y1 = (displayP+(faceP->points[0]))->displayY;
		x2 = (displayP+(faceP->points[1]))->displayX;
		y2 = (displayP+(faceP->points[1]))->displayY;
		x3 = (displayP+(faceP->points[2]))->displayX;
		y3 = (displayP+(faceP->points[2]))->displayY;

		vizflag = (( x2 - x1 ) * ( y3 - y2 ))  -  (( y2 - y1 ) * ( x3 - x2 ));

		if (vizflag < 0 ){

			V[0][0] = x1;	V[0][1] = y1;	/* Set Vertex */
			V[1][0] = x2;	V[1][1] = y2;	
			V[2][0] = x3;	V[2][1] = y3;
			V[3][0] = (displayP+(faceP->points[3]))->displayX;
			V[3][1] = (displayP+(faceP->points[3]))->displayY;

			color(faceP->color+256);		/* Set Color */
			bgnpolygon();
				v2f(V[0]);
				v2f(V[1]);
				v2f(V[2]);
				v2f(V[3]);
			endpolygon();
		}

	} else {
		toptotal = EntryZclip(faceP);		/* 	ZClip 			*/
		FillClipPolygon(faceP,toptotal);	/*	DrawPolygon		*/ 
	}

}


/***************************************************************
	Z Clipping
***************************************************************/

DisplayPoints		Zclipdisplay[30];

EntryZclip(faceP)
FaceData		*faceP;	
{

	RotatePoints	*rotateP		= rotatepoint;
	DisplayPoints	*displayP		= displaypoint;
	int				toptotal		= faceP  -> nvertexes;
	int				clipvertex		= 0;
	int				i,j;
	int				work;

	double			x1,x2,y1,y2,z1,z2,cx,cy,cz;

	for(i=0;i<toptotal;i++){

		if	(i != toptotal-1)	j = i+1;
		else					j = 0;
		work = overflag[(faceP->points[i])]+overflag[(faceP->points[j])];

		switch(work){
		case 0:
			Zclipdisplay[clipvertex].displayX = (displayP + (faceP->points[i]) ) -> displayX;
			Zclipdisplay[clipvertex].displayY = (displayP + (faceP->points[i]) ) -> displayY;
			clipvertex++;
			break;
		case 1:

			if (overflag[(faceP->points[i])]==1){

				x1 = (rotateP + (faceP->points[i])) ->rotateX;
				y1 = (rotateP + (faceP->points[i])) ->rotateY;
				z1 = (rotateP + (faceP->points[i])) ->rotateZ;
				x2 = (rotateP + (faceP->points[j])) ->rotateX;
				y2 = (rotateP + (faceP->points[j])) ->rotateY;
				z2 = (rotateP + (faceP->points[j])) ->rotateZ;
				if (z1 == z2) break;
				cx = ((x2-x1)/(z2-z1))*(ZCLIP-z1)+x1;
				cy = ((y2-y1)/(z2-z1))*(ZCLIP-z1)+y1;

				ZclipProjection(cx,cy,(double)ZCLIP,Zclipdisplay+clipvertex);
				clipvertex++;

			} else {

				x1 = (rotateP + (faceP->points[i])) ->rotateX;
				y1 = (rotateP + (faceP->points[i])) ->rotateY;
				z1 = (rotateP + (faceP->points[i])) ->rotateZ;
				x2 = (rotateP + (faceP->points[j])) ->rotateX;
				y2 = (rotateP + (faceP->points[j])) ->rotateY;
				z2 = (rotateP + (faceP->points[j])) ->rotateZ;
				if (z1 == z2) break;
				cx = ((x2-x1)/(z2-z1))*(ZCLIP-z1)+x1;
				cy = ((y2-y1)/(z2-z1))*(ZCLIP-z1)+y1;

				Zclipdisplay[clipvertex].displayX = (displayP + (faceP->points[i]) ) -> displayX;
				Zclipdisplay[clipvertex].displayY = (displayP + (faceP->points[i]) ) -> displayY;
				clipvertex++;
				ZclipProjection(cx,cy,(double)ZCLIP,Zclipdisplay+clipvertex);
				clipvertex++;

			}
			
			break;
		default:
			break;
		}

	}


	return(clipvertex);

}


/*=========	Projection	=========*/

ZclipProjection(rx,ry,rz,displayP)
double			rx,ry,rz;
DisplayPoints	*displayP;
{
	displayP -> displayX =  rx/rz * ZOOMCAMERA  + (double)WindowSizeX/2;
	displayP -> displayY =  ry/rz * ZOOMCAMERA  + (double)WindowSizeY/2;
}



/***************************************************************
	FillPolygon
***************************************************************/

static	float	VX[20][2];

FillClipPolygon(faceP,toptotal)
FaceData	*faceP;
int			toptotal;
{
	int	i;
	float	vizflag = -0.1;

	for(i=0;i<toptotal;i++){
		VX[i][0] = Zclipdisplay[i].displayX;
		VX[i][1] = Zclipdisplay[i].displayY;
	}

#if	0
	vizflag = ((VX[1][0]-VX[0][0])*(VX[2][1]-VX[1][1]))  
			- ((VX[1][1]-VX[0][1])*(VX[2][0]-VX[1][0]));
#endif

	if ( vizflag < 0 ) {
		color(faceP->color+256);
		bgnpolygon();
			for(i=0;i<toptotal;i++)	v2f(VX[i]);
		endpolygon();
	} else {

	}
}




/***************************************************************
	3D library
***************************************************************/

/*====== Y->X->Z rotation ====================================*/

Make3DMatrix(matrix,aX,aY,aZ)
double	*matrix;
double	aX,aY,aZ;
{

	*matrix++	=  cos(aY)*cos(aZ)+sin(aX)*sin(aY)*sin(aZ);
	*matrix++	= -cos(aY)*sin(aZ)+sin(aX)*sin(aY)*cos(aZ);
	*matrix++	=  cos(aX)*sin(aY);

	*matrix++	=  cos(aX)*sin(aZ);
	*matrix++	=  cos(aX)*cos(aZ);
	*matrix++	= -sin(aX);

	*matrix++	= -sin(aY)*cos(aZ)+sin(aX)*cos(aY)*sin(aZ);
	*matrix++	=  sin(aY)*sin(aZ)+sin(aX)*cos(aY)*cos(aZ);
	*matrix		=  cos(aX)*cos(aY);

}

/*====== Matrix Mult ====================================*/

CalcMatrix(matrixC,matrixA,matrixB)
double	*matrixC,*matrixA,*matrixB;
{
	int	i;

#if	1
	*matrixC++ = matrixA[M11]*matrixB[M11]+matrixA[M21]*matrixB[M21]+matrixA[M31]*matrixB[M31];
	*matrixC++ = matrixA[M11]*matrixB[M12]+matrixA[M21]*matrixB[M22]+matrixA[M31]*matrixB[M32];
	*matrixC++ = matrixA[M11]*matrixB[M13]+matrixA[M21]*matrixB[M23]+matrixA[M31]*matrixB[M33];

	*matrixC++ = matrixA[M12]*matrixB[M11]+matrixA[M22]*matrixB[M21]+matrixA[M32]*matrixB[M31];
	*matrixC++ = matrixA[M12]*matrixB[M12]+matrixA[M22]*matrixB[M22]+matrixA[M32]*matrixB[M32];
	*matrixC++ = matrixA[M12]*matrixB[M13]+matrixA[M22]*matrixB[M23]+matrixA[M32]*matrixB[M33];

	*matrixC++ = matrixA[M13]*matrixB[M11]+matrixA[M23]*matrixB[M21]+matrixA[M33]*matrixB[M31];
	*matrixC++ = matrixA[M13]*matrixB[M12]+matrixA[M23]*matrixB[M22]+matrixA[M33]*matrixB[M32];
	*matrixC   = matrixA[M13]*matrixB[M13]+matrixA[M23]*matrixB[M23]+matrixA[M33]*matrixB[M33];
#endif

#if	0
	*matrixC++ = matrixA[M11]*matrixB[M11]+matrixA[M12]*matrixB[M21]+matrixA[M13]*matrixB[M31];
	*matrixC++ = matrixA[M11]*matrixB[M12]+matrixA[M12]*matrixB[M22]+matrixA[M13]*matrixB[M32];
	*matrixC++ = matrixA[M11]*matrixB[M13]+matrixA[M12]*matrixB[M23]+matrixA[M13]*matrixB[M33];

	*matrixC++ = matrixA[M21]*matrixB[M11]+matrixA[M22]*matrixB[M21]+matrixA[M23]*matrixB[M31];
	*matrixC++ = matrixA[M21]*matrixB[M12]+matrixA[M22]*matrixB[M22]+matrixA[M23]*matrixB[M32];
	*matrixC++ = matrixA[M21]*matrixB[M13]+matrixA[M22]*matrixB[M23]+matrixA[M23]*matrixB[M33];

	*matrixC++ = matrixA[M31]*matrixB[M11]+matrixA[M32]*matrixB[M21]+matrixA[M33]*matrixB[M31];
	*matrixC++ = matrixA[M31]*matrixB[M12]+matrixA[M32]*matrixB[M22]+matrixA[M33]*matrixB[M32];
	*matrixC   = matrixA[M31]*matrixB[M13]+matrixA[M32]*matrixB[M23]+matrixA[M33]*matrixB[M33];
#endif

}


/***************************************************************
	Draw Polygon
****************************************************************/

static	int		total = 3000;

static	float	V0[] = { 100,100 };
static	float	V1[] = { 100,116 };
static	float	V2[] = { 116,116 };
static	float	V3[] = { 116,100 };

extern	void	DrawTest()
{
	int	i;
	/* ortho2(-320.0,320.0,-240.0,240.0); */
	   ortho2(0.0,640.0,0.0,480.0);

	POLYGON = 0;
#if	0
	if ( CONTROLLER & button_A ) 		total = 4000;
	if ( CONTROLLER & button_B ) 		total = 6000;
	if ( CONTROLLER & button_select ) 	total = 8000;
	if ( CONTROLLER & button_start	) 	total = 10000;
	if ( CONTROLLER & button_up ) 		total = 12000;
	if ( CONTROLLER & button_down )		total = 14000;
	if ( CONTROLLER & button_left ) 	total = 16000;
	if ( CONTROLLER & button_right ) 	total = 18000;
#endif

	for (i=0;i<total;i++){
		color(RED);
		bgnpolygon();
			v2f(V0);
			v2f(V1);
			v2f(V2);
			v2f(V3);
		endpolygon();
		POLYGON++;
	}

}
