/***************************************************************
	GL TestGame Program	( TestRace )
	<< camera.c >>
									Programed By H.Yajima
****************************************************************/

#include	<stdio.h>
#include	<math.h>

#include	<gl/gl.h>
#include	<gl/device.h>

#include	"window.h"
#include	"library.h"
#include	"prototype.h"

extern	long	CONTROLLER;

/***************************************************************
	Camera Copy (( object position => camera position ))
****************************************************************/
extern	void	CopyCamera(camera,object)
CameraInfo	*camera;
ObjectInfo	*object;
{
	camera->positionX	= object->positionX;
	camera->positionY	= object->positionY;
	camera->positionZ 	= object->positionZ;
	camera->angleX		= object->angleX;
	camera->angleY		= object->angleY;
	camera->angleZ		= object->angleZ;
}

/***************************************************************
	Camera Main
****************************************************************/
extern	void	MainCamera(camera)
CameraInfo	*camera;
{

	if	(CONTROLLER & button_f1 )	OffsetCamera(camera,0,-20,0);
	if	(CONTROLLER & button_f2 )	OffsetCamera(camera,0,-50,200);
	if	(CONTROLLER & button_f3 )	OffsetCamera(camera,0,-200,400);


#if	0
	if ( CONTROLLER & button_A ) 		GoCamera(camera);
	if ( CONTROLLER & button_B ) 		BackCamera(camera);
	if ( CONTROLLER & button_up ) 		UpCamera(camera);
	if ( CONTROLLER & button_down )		DownCamera(camera);
	if ( CONTROLLER & button_left ) 	TurnLeftCamera(camera);
	if ( CONTROLLER & button_right ) 	TurnRightCamera(camera);
#endif

}


/***************************************************************
	Camera Main
****************************************************************/

OffsetCamera(camera,ox,oy,oz)
CameraInfo	*camera;
int	ox,oy,oz;
{
	camera->offsetX = ox;
	camera->offsetY = oy;
	camera->offsetZ = oz;
}



/***************************************************************
	Camera Control
****************************************************************
/*-------------------------------------------------------------*/
GoCamera(camera)
CameraInfo	*camera;
{
	int		camera_speed = 100;
	camera->positionX += camera_speed * sin ( camera->angleY );
	camera->positionZ += camera_speed * cos ( camera->angleY );
}
/*-------------------------------------------------------------*/
BackCamera(camera)
CameraInfo	*camera;
{
	int		camera_speed = -100;
	camera->positionX += camera_speed * sin ( camera->angleY );
	camera->positionZ += camera_speed * cos ( camera->angleY );
}
/*-------------------------------------------------------------*/
TurnLeftCamera(camera)
CameraInfo	*camera;
{
	camera->angleY -= 0.05;
}
/*-------------------------------------------------------------*/
TurnRightCamera(camera)
CameraInfo	*camera;
{
	camera->angleY += 0.05;
}
/*-------------------------------------------------------------*/
UpCamera(camera)
CameraInfo	*camera;
{

}
/*-------------------------------------------------------------*/
DownCamera(camera)
CameraInfo	*camera;
{

}

/*-------------------------------------------------------------*/
/*-------------------------------------------------------------*/
/*-------------------------------------------------------------*/
/*-------------------------------------------------------------*/




/***************************************************************
	Camera Initialize
****************************************************************/
extern	void	SetCamera(camera,px,py,pz,ax,ay,az,ox,oy,oz)
CameraInfo	*camera;
int	px,py,pz,ax,ay,az,ox,oy,oz;
{

	camera->positionX 	= px;
	camera->positionY 	= py;
	camera->positionZ 	= pz;

	camera->angleX 		= ax;
	camera->angleY 		= ay;
	camera->angleZ 		= az;

	camera->offsetX 	= ox;
	camera->offsetY 	= oy;
	camera->offsetZ 	= oz;

}
