/***************************************************************
	GL TestGame Program	( TestRace )
	<< fill.c >>
									Programed By H.Yajima
****************************************************************/

#define		TRUE	1
#define		FALSE	0


#include	<stdio.h>
#include	<math.h>

#include	<gl/gl.h>
#include	<gl/device.h>

#include	"window.h"
#include	"library.h"
#include	"prototype.h"


/***************************************************************
	Memory
***************************************************************/

static	DisplayPoints	Zclipdisplay[30];
extern	int				POLYGON;

/***************************************************************
	VIZ parameter 
***************************************************************/

#define		X1	0
#define		Y1	1
#define		X2	2
#define		Y2	3
#define		X3	4
#define		Y3	5

/***************************************************************
	FillLine
***************************************************************/
extern	void	FillLine(faceP)
FaceData	*faceP;
{

}



/***************************************************************
	FillTriangle
***************************************************************/
extern	void	FillTriangle(faceP,flag)
FaceData	*faceP;
int			flag;
{

	DisplayPoints	*displayP	= displaypoint;
	RotatePoints	*rotateP	= rotatepoint;
	int				*overflagP	= overflag;
	int				i,j;
	int				Zclipflag	= 0;
	double			dispdata[30];
	int				toptotal;
	int				vizflag;
	int				z0,z1,z2,zindex;


	/********** Z CLIP CHECK *****************/

	for(j=0;j<3;j++){
		Zclipflag = Zclipflag + *(overflagP+(faceP->points[j]));
	}

	/********** MAX CALC *********************/

	z0 = (rotateP+(faceP->points[0]))->rotateZ;
	z1 = (rotateP+(faceP->points[1]))->rotateZ;
	z2 = (rotateP+(faceP->points[2]))->rotateZ;
	switch	(flag){
		case	MaxSort:
			if 	(z0>z1)		zindex = z0;
			else			zindex = z1;
			if	(z2>zindex)	zindex = z2;
			break;
		case	MinSort:
			if 	(z0<z1)		zindex = z0;
			else			zindex = z1;
			if	(z2<zindex)	zindex = z2;
			if	(zindex<0)	zindex = 0;
			break;
	}			


	/********** MAIN *************************/

	if (Zclipflag == 0)	{

		dispdata[X1] = (displayP+(faceP->points[0]))->displayX;
		dispdata[Y1] = (displayP+(faceP->points[0]))->displayY;
		dispdata[X2] = (displayP+(faceP->points[1]))->displayX;
		dispdata[Y2] = (displayP+(faceP->points[1]))->displayY;
		dispdata[X3] = (displayP+(faceP->points[2]))->displayX;
		dispdata[Y3] = (displayP+(faceP->points[2]))->displayY;

		vizflag = (( dispdata[X2] - dispdata[X1] ) * ( dispdata[Y3] - dispdata[Y2] ))  
			    - (( dispdata[Y2] - dispdata[Y1] ) * ( dispdata[X3] - dispdata[X2] ));

		if ( (vizflag < 0) && (zindex < MAXtable) ){

			SetDrawbuffer(3,zindex,dispdata,faceP->color);		/*----- TOUROKU -----*/
			POLYGON++;
		}

	} else {

		toptotal = EntryZclip(faceP);							/* 	ZClip 			*/
		if (toptotal >2 ){

			for (i=0;i<toptotal;i++){
				dispdata[i*2+0] = Zclipdisplay[i].displayX;
				dispdata[i*2+1] = Zclipdisplay[i].displayY;
			}

			vizflag = (( dispdata[X2] - dispdata[X1] ) * ( dispdata[Y3] - dispdata[Y2] ))  
				    - (( dispdata[Y2] - dispdata[Y1] ) * ( dispdata[X3] - dispdata[X2] ));

			if ( (vizflag < 0) ){
				SetDrawbuffer(toptotal,zindex,dispdata,faceP->color); 
			}

		}
	}

}

/***************************************************************
	FillSquare
***************************************************************/
extern	void	FillSquare(faceP,flag)
FaceData	*faceP;
int			flag;
{

	DisplayPoints	*displayP	= displaypoint;
	RotatePoints	*rotateP	= rotatepoint;
	int				*overflagP	= overflag;	
	int				toptotal;
	int				j,i;
	int				Zclipflag	= 0;
	double			dispdata[30];
	int				vizflag;
	int				z0,z1,z2,z3,zindex;

	/********** Z CLIP CHECK *****************/
	for(j=0;j<4;j++){
		Zclipflag = Zclipflag + *(overflagP+(faceP->points[j]));
	}

	/********** MAX CALC *********************/

	z0 = (rotateP+(faceP->points[0]))->rotateZ;
	z1 = (rotateP+(faceP->points[1]))->rotateZ;
	z2 = (rotateP+(faceP->points[2]))->rotateZ;
	z3 = (rotateP+(faceP->points[3]))->rotateZ;

	switch(flag){
		case	MaxSort:
			if 	(z0>z1)		zindex = z0;
			else			zindex = z1;
			if	(z2>zindex)	zindex = z2;
			if	(z3>zindex)	zindex= z3;
			break;
		case	MinSort:
			if 	(z0<z1)		zindex = z0;
			else			zindex = z1;
			if	(z2<zindex)	zindex = z2;
			if	(z3<zindex)	zindex = z3;
			if	(zindex<0)	zindex = 0;
			break;
	}

	/********** MAIN *************************/

	if (Zclipflag == 0)	{


		dispdata[X1] = (displayP+(faceP->points[0]))->displayX;
		dispdata[Y1] = (displayP+(faceP->points[0]))->displayY;
		dispdata[X2] = (displayP+(faceP->points[1]))->displayX;
		dispdata[Y2] = (displayP+(faceP->points[1]))->displayY;
		dispdata[X3] = (displayP+(faceP->points[2]))->displayX;
		dispdata[Y3] = (displayP+(faceP->points[2]))->displayY;

		vizflag = (( dispdata[X2] - dispdata[X1] ) * ( dispdata[Y3] - dispdata[Y2] ))  
			    - (( dispdata[Y2] - dispdata[Y1] ) * ( dispdata[X3] - dispdata[X2] ));

		if ( (vizflag < 0) && (zindex < MAXtable) ){

			dispdata[6] = (displayP+(faceP->points[3]))->displayX;
			dispdata[7] = (displayP+(faceP->points[3]))->displayY;

			SetDrawbuffer(4,zindex,dispdata,faceP->color);	/*----- TOUROKU -----*/
			POLYGON++;
		}


	} else {

		toptotal = EntryZclip(faceP);							/* 	ZClip 			*/
		if (toptotal >2 ){

			for (i=0;i<toptotal;i++){
				dispdata[i*2+0] = Zclipdisplay[i].displayX;
				dispdata[i*2+1] = Zclipdisplay[i].displayY;
			}
			vizflag = (( dispdata[X2] - dispdata[X1] ) * ( dispdata[Y3] - dispdata[Y2] ))  
				    - (( dispdata[Y2] - dispdata[Y1] ) * ( dispdata[X3] - dispdata[X2] ));

			if ( (vizflag < 0) ){
				SetDrawbuffer(toptotal,zindex,dispdata,faceP->color); 
			}

		}

	}

}


/***************************************************************
	Z Clipping
***************************************************************/

EntryZclip(faceP)
FaceData		*faceP;	
{

	RotatePoints	*rotateP		= rotatepoint;
	DisplayPoints	*displayP		= displaypoint;
	int				toptotal		= faceP  -> nvertexes;
	int				clipvertex		= 0;
	int				i,j;
	int				work;

	double			x1,x2,y1,y2,z1,z2,cx,cy,cz;


	for(i=0;i<toptotal;i++){

		if	(i != toptotal-1)	j = i+1;
		else					j = 0;
		work = overflag[(faceP->points[i])]+overflag[(faceP->points[j])];

		switch(work){
		case 0:
			Zclipdisplay[clipvertex].displayX = (displayP + (faceP->points[i]) ) -> displayX;
			Zclipdisplay[clipvertex].displayY = (displayP + (faceP->points[i]) ) -> displayY;
			clipvertex++;
			break;
		case 1:

			if (overflag[(faceP->points[i])]==1){

				x1 = (rotateP + (faceP->points[i])) ->rotateX;
				y1 = (rotateP + (faceP->points[i])) ->rotateY;
				z1 = (rotateP + (faceP->points[i])) ->rotateZ;
				x2 = (rotateP + (faceP->points[j])) ->rotateX;
				y2 = (rotateP + (faceP->points[j])) ->rotateY;
				z2 = (rotateP + (faceP->points[j])) ->rotateZ;
				if (z1 == z2) break;
				cx = ((x2-x1)/(z2-z1))*(ZCLIP-z1)+x1;
				cy = ((y2-y1)/(z2-z1))*(ZCLIP-z1)+y1;

				ZclipProjection(cx,cy,(double)ZCLIP,Zclipdisplay+clipvertex);
				clipvertex++;

			} else {

				x1 = (rotateP + (faceP->points[i])) ->rotateX;
				y1 = (rotateP + (faceP->points[i])) ->rotateY;
				z1 = (rotateP + (faceP->points[i])) ->rotateZ;
				x2 = (rotateP + (faceP->points[j])) ->rotateX;
				y2 = (rotateP + (faceP->points[j])) ->rotateY;
				z2 = (rotateP + (faceP->points[j])) ->rotateZ;
				if (z1 == z2) break;
				cx = ((x2-x1)/(z2-z1))*(ZCLIP-z1)+x1;
				cy = ((y2-y1)/(z2-z1))*(ZCLIP-z1)+y1;

				Zclipdisplay[clipvertex].displayX = (displayP + (faceP->points[i]) ) -> displayX;
				Zclipdisplay[clipvertex].displayY = (displayP + (faceP->points[i]) ) -> displayY;
				clipvertex++;
				ZclipProjection(cx,cy,(double)ZCLIP,Zclipdisplay+clipvertex);
				clipvertex++;

			}
			
			break;
		default:
			break;
		}

	}


	return(clipvertex);

}

/***************************************************************
		ZClip Projection
***************************************************************/

ZclipProjection(rx,ry,rz,displayP)
double			rx,ry,rz;
DisplayPoints	*displayP;
{
	displayP -> displayX =  rx/rz * ZOOMCAMERA  + (double)WindowSizeX/2;
	displayP -> displayY =  ry/rz * ZOOMCAMERA  + (double)WindowSizeY/2;
}

