/***************************************************************
	GL TestGame Program	( TestRace )
	<< library.c >>
									Programed By H.Yajima
****************************************************************/

#include	<gl/gl.h>
#include	<gl/device.h>

#include	"library.h"




/************************************************************************
	CONVERT		( 0 ... 65535 )		
				( -32768 ... 32767 )  
 ************************************************************************/

extern	void	hexconv(number,hexmem)
int		number;
char	*hexmem;
{
	int	i;

	if (number > 0x10000)	number = 0xffff;
	if (number < -0x8000)	number = 0x8000;
	if (number < 0)	number = 0x10000 + number;

	for	(i=3;i>=0;i--){

		if ( (number%16)>9 ){
			*(hexmem+i)=(number%16)-10+'A';
		} else {
			*(hexmem+i)=(number%16)+'0';
		}
		number = number/16;
	}
				
	*(hexmem+4)= '\0';

}

/************************************************************************
	CONVERT		( 0 ... 65535 )		
				( 0 ... 9999 )
 ************************************************************************/

extern	void	decconv(number,decmem)
int		number;
char	*decmem;
{
	int	i;

	if (number > 9999)		number = 9999;
	if (number < 0)			number = 0;

	for	(i=3;i>=0;i--){
		*(decmem+i)=(number%10)+'0';
		number = number/10;
	}

	*(decmem+4)= '\0';

}


/************************************************************************
	TIME SYSTEM
 ************************************************************************/
#include 	<sys/time.h>
static struct timeval timebase;
/*-----------------------------------------------------------------------
	Get System time
------------------------------------------------------------------------*/

extern	int	TickCount(void)
{
	struct timeval tp;
	int sec,msec;

	gettimeofday(&tp,NULL);
	sec  = tp.tv_sec  - timebase.tv_sec;
	msec = tp.tv_usec / 1000;

	return(sec * 1000 + msec);

}



/*-----------------------------------------------------------------------
	Syncronize game frame
------------------------------------------------------------------------*/

extern	int	GameSyncro(timeCounter)
int	*timeCounter;
{
	int time,interval;

	while ((time = TickCount()) < (*timeCounter)+16 );
	interval	= time - (*timeCounter);
	*timeCounter = time;
	return(interval);

}


/************************************************************************
	Scan Controller.
 ************************************************************************/
#if	0

extern
int	ScanController(void)
{
	static int oldstat = 0;
	int  status,trigger;

	status = 0;
	if (getbutton(LEFTALTKEY) 		!= 0)	status = status | button_A;
	if (getbutton(LEFTCTRLKEY) 		!= 0)	status = status | button_B;
	if (getbutton(TABKEY) 			!= 0)	status = status | button_select;
	if (getbutton(ESCKEY)	 		!= 0)	status = status | button_start;
	if (getbutton(UPARROWKEY) 		!= 0)	status = status | button_up;
	if (getbutton(DOWNARROWKEY) 	!= 0)	status = status | button_down;
	if (getbutton(LEFTARROWKEY) 	!= 0)	status = status | button_left;
	if (getbutton(RIGHTARROWKEY) 	!= 0)	status = status | button_right;
	if (getbutton(ONEKEY)			!= 0) 	status = status | button_f1;
	if (getbutton(TWOKEY)			!= 0) 	status = status | button_f2;
	if (getbutton(THREEKEY)			!= 0) 	status = status | button_f3;
	if (getbutton(FOURKEY)			!= 0) 	status = status | button_f4;


	trigger = (status ^ oldstat) & status;
	oldstat = status;
	return((trigger<<16) + status);

}

#endif

/************************************************************************
	Scan Controller.
 ************************************************************************/
extern
int	KeyController(void)
{
	static int oldstat = 0;
	int  status,trigger;

	status = 0;
	if (getbutton(LEFTALTKEY) 		!= 0)	status = status | button_A;
	if (getbutton(LEFTCTRLKEY) 		!= 0)	status = status | button_B;
	if (getbutton(TABKEY) 			!= 0)	status = status | button_select;
	if (getbutton(ESCKEY)	 		!= 0)	status = status | button_start;
	if (getbutton(UPARROWKEY) 		!= 0)	status = status | button_up;
	if (getbutton(DOWNARROWKEY) 	!= 0)	status = status | button_down;
	if (getbutton(LEFTARROWKEY) 	!= 0)	status = status | button_left;
	if (getbutton(RIGHTARROWKEY) 	!= 0)	status = status | button_right;
	if (getbutton(ONEKEY)			!= 0) 	status = status | button_f1;
	if (getbutton(TWOKEY)			!= 0) 	status = status | button_f2;
	if (getbutton(THREEKEY)			!= 0) 	status = status | button_f3;
	if (getbutton(FOURKEY)			!= 0) 	status = status | button_f4;


	trigger = (status ^ oldstat) & status;
	oldstat = status;
	return((trigger<<16) + status);

}
