/***************************************************************
	GL TestGame Program	( TestRace )
	<< map.h >>
									Programed By H.Yajima
****************************************************************/

/******* Shape Flag *************************/

#define	SHAPE_GROUND	1
#define	SHAPE_OBJECT	2

#define	MaxSort			0
#define	MinSort			1

/******* Camera Patameter ********************/

#define		ZOOMCAMERA	960.0/2
#define		ZCLIP		16


/******* Zsort & Polygon Parameter ***********/

#define		MAXtable	0x2000		/* Zsort indextable MAX	*/
#define		MAXbuffer	0x1000		/* polygon facedata MAX	*/

/******* Camera Infomation *******************/
typedef	struct	{
	double	positionX;
	double	positionY;
	double	positionZ;
	double	angleX;
	double	angleY;
	double	angleZ;
	double	offsetX;
	double	offsetY;
	double	offsetZ;
}	CameraInfo;


/**************** Palette Record ************************************/
typedef struct {
	float	red;
	float	green;
	float	blue;
} Palette;

/**************** Point Record **************************************/
typedef struct {
	short	pointX;
	short	pointY;
	short	pointZ;
	short	color;
	float	vectorX;
	float	vectorY;
	float	vectorZ;
} PointData,*PointPtr;

/**************** Face Record **************************************/
typedef struct {
	short	nvertexes;
	short	color;
	short	xmax;
	short	xmin;
	short	ymax;
	short	ymin;
	short	zmax;
	short	zmin;
	float	planeA;
	float	planeB;
	float	planeC;
	float	planeD;
	short	points[8];
} FaceData,*FacePtr;

/**************** Shape Infomation Record **************************/
typedef struct {
	short		npoints;
	short		nfaces;
	short		nhits;
	short		radius;
	short		xmax;
	short		ymax;
	short		zmax;
	short		reserved;
	PointPtr	point;
	FacePtr		face;
} ShapeInfo,*ShapePtr;

/**************** Ground Infomation Record *************************/
typedef struct {
	ShapePtr	shape;
	char		flags;
	char		angY;
	short		posX;
	short		posZ;
} GroundInfo,*GroundPtr;

/**************** Object Infomation Record *************************/
typedef struct {
	ShapePtr	shape;
	char		flags;
	char		dmmy;
	double		positionX;
	double		positionY;
	double		positionZ;
	double		angleX;
	double		angleY;
	double		angleZ;
	double		speedX;
	double		speedY;
	double		speedZ;
	double		speedF;
	double		speedL;
	double		speedU;
	double		accelF;
	double		brakeF;
	double		frictionF;
	double		speedMAX;
	double		speedMIN;
	int			hundleL;
	int			hundleR;


} ObjectInfo,*ObjectPtr;

/**************** AnyObject Infomation Record **********************/
typedef struct {
	ShapePtr	shape;
	char		flags;
} AnyOBJInfo,*AnyOBJPtr;

/**************** DrawList Record **********************************/
typedef struct{
	GroundInfo	*OBJPtr;
} DrawList;

/**************** SortList Record **********************************/

typedef	struct	snode	{

	struct	snode	*next;
	struct	snode	*prev;
	GroundInfo		*map;
	double			rotateX;
	double			rotateY;
	double			rotateZ;
	double			angleX;
	double			angleY;
	double			angleZ;
	double			sortZ;

} SortList;


/*************** AreaList Record **********************************/

typedef	struct	node{
	struct	node	*next;
	struct	node	*prev;
	GroundInfo		*OBJPtr;
}	AreaInfo;


/*************** Zsort DrawBuffer Record **************************/

typedef	struct	sortnode{

	struct	sortnode	*next;			/* same 'Z' 			*/
	int					flag;			/* vertex count			*/
	int					color;			/* polygon color		*/
	float				points[15][2];	/* polygon display point */

}	DrawBuffer;


/**************** World Infomation Record **************************/




/******* Matrix Parameter ********************/

#define	M11	0
#define	M12	1
#define	M13	2
#define	M21	3
#define	M22	4
#define	M23	5
#define	M31	6
#define	M32	7
#define	M33	8

/******* Shape Rotation Point ****************/
typedef struct	{
	double	rotateX;
	double	rotateY;
	double	rotateZ;
}	RotatePoints;

/******* Shape Display Point *****************/
typedef struct	{
	double	displayX;
	double	displayY;
}	DisplayPoints;

