/***************************************************************
	GL TestGame Program	( TestRace )
	<< player.c >>
									Programed By H.Yajima
****************************************************************/

#include	<stdio.h>
#include	<math.h>


#include	<gl/gl.h>
#include	<gl/device.h>

#include	"window.h"
#include	"library.h"
#include	"prototype.h"
/***************************************************************
	External Memory
****************************************************************/

extern	AreaInfo	*AreaList[];

/***************************************************************
	Player Initial
****************************************************************/
extern	void	SetPlayer(player,px,py,pz,ax,ay,az)
ObjectInfo	*player;
int	px,py,pz,ax,ay,az;
{

	player->positionX 	= px;
	player->positionY 	= py;
	player->positionZ 	= pz;
	player->angleX 		= ax;
	player->angleY 		= ay;
	player->angleZ 		= az;

	player->speedX = 0;
	player->speedY = 0;
	player->speedZ = 0;
	player->speedF = 0;

	/* parameter	*/
	player->accelF 		= 1;
	player->frictionF 	= -0.5;
	player->brakeF 		= -3;
	player->speedMAX 	= 70;

}


/***************************************************************
	Player Main
****************************************************************/
extern	void	MainPlayer(player)
ObjectInfo	*player;
{
	extern	int	CONTROLLER;

	CheckPolygon(player);		/* Set angleX	*/


	if ( CONTROLLER & button_A ) 		GoPlayer(player);
	else								FrictionPlayer(player);
	if ( CONTROLLER & button_B ) 		BrakePlayer(player);
	if ( CONTROLLER & button_up ) 		UpPlayer(player);
	if ( CONTROLLER & button_down )		DownPlayer(player);
	if ( CONTROLLER & button_left ) 	TurnLeftPlayer(player);
	else								player->hundleL = 0;
	if ( CONTROLLER & button_right ) 	TurnRightPlayer(player);
	else								player->hundleR = 0;


	SpeedLimit(player);			/* speed limit			*/
	SpeedCalc(player);			/* speed -> position 	*/
}

/***************************************************************
	Limit
***************************************************************/

SpeedLimit(player)
ObjectInfo	*player;
{

	if 	 	(player->speedF > player->speedMAX)	player->speedF = player->speedMAX;
	else if (player->speedF < 0               ) player->speedF = 0;

}

/***************************************************************
	Speed Calc
***************************************************************/

double	Rslip = 0;
double	Lslip = 0;
double	pai = 3.141592;

SpeedCalc(player)
ObjectInfo	*player;
{
	int		speed;

	speed = player->speedF;

	player->positionX += speed * sin ( player->angleY );
	player->positionZ += speed * cos ( player->angleY );

	if ( player->hundleL > 10 ){
		player->positionX += speed/3 * sin ( (player->angleY) + pai/2);
		player->positionZ += speed/3 * cos ( (player->angleY) + pai/2);
	}

	if ( player->hundleR > 10 ){
		player->positionX += speed/3 * sin ( (player->angleY) - pai/2);
		player->positionZ += speed/3 * cos ( (player->angleY) - pai/2);
	}

}

/***************************************************************
	Player Control
***************************************************************/
/*-------------------------------------------------------------*/
GoPlayer(player)
ObjectInfo	*player;
{
	player->speedF += player->accelF;

}
/*-------------------------------------------------------------*/
FrictionPlayer(player)
ObjectInfo	*player;
{
	player->speedF += player->frictionF;
}

/*-------------------------------------------------------------*/
BrakePlayer(player)
ObjectInfo	*player;
{
	player->speedF += player->brakeF;
}

/*-------------------------------------------------------------*/
TurnLeftPlayer(player)
ObjectInfo	*player;
{
	player->angleY -= 0.05;
	(player->hundleL)++;
}
/*-------------------------------------------------------------*/
TurnRightPlayer(player)
ObjectInfo	*player;
{
	player->angleY += 0.05;
	(player->hundleR)++;

}
/*-------------------------------------------------------------*/
UpPlayer(player)
ObjectInfo	*player;
{

}
/*-------------------------------------------------------------*/
DownPlayer(player)
ObjectInfo	*player;
{

}

/*-------------------------------------------------------------*/
/*-------------------------------------------------------------*/
/*-------------------------------------------------------------*/
/*-------------------------------------------------------------*/


/***************************************************************
	Player BG Check
****************************************************************/

CheckPolygon(object)
ObjectInfo		*object;
{

	float	ANS,x1,x2,x3,z1,z2,z3,y1,sos;
	float	calcD;
	float	nextX,nextZ;

	double	nowAngle;

	int				wx,wz;
	int				objX,objZ;
	int				mapX,mapZ;
	int				areaNO;
	int				i,j,k;
	int				counter;
	int				R;				/* VFCv̔a					*/
	int				facecount;		/* VFCv\|Š */
	int				vertexcount; 	/* _̌						*/
	AreaInfo		*index;
	FacePtr			faceP;			/* tFCXւ̃|C^			*/
	PointPtr		pointP;			/* |Cgւ̃|C^			*/

	

	wx 		= (object->positionX)/16;
	wz 		= (object->positionZ)/16;
	objX 	= (object->positionX);
	objZ 	= (object->positionZ);
	areaNO 	= CalcAreaNO(wx,wz);

	index =	AreaList[areaNO];

	while (index != NULL){

		while ( (R = index->OBJPtr->shape->radius) >= 1000 ){

			mapX = (index->OBJPtr->posX)*16;
			mapZ = (index->OBJPtr->posZ)*16;

			if ( mapX + R - objX <  0 ) break;
			if ( mapX - R - objX >  0 ) break;
			if ( mapZ + R - objZ <  0 ) break;
			if ( mapZ - R - objZ >  0 ) break;

			facecount = index->OBJPtr->shape->nhits;
			faceP	  = index->OBJPtr->shape->face;
			pointP	  = index->OBJPtr->shape->point;

			for (i=0;i<facecount;i++,faceP++){

				if ( mapX + (faceP->xmax) - objX <  0 ) continue;
				if ( mapX + (faceP->xmin) - objX >  0 ) continue;
				if ( mapZ + (faceP->zmax) - objZ <  0 ) continue;
				if ( mapZ + (faceP->zmin) - objZ >  0 ) continue;

				vertexcount = faceP->nvertexes;

				for(j=0;j<vertexcount;j++){

					if (j == (vertexcount-1))  k=0;
					else					   k=j+1;

					x1 = mapX+(pointP+(faceP->points[j]))->pointX;
					x2 = mapX+(pointP+(faceP->points[k]))->pointX;
					x3 = objX;
					z1 = mapZ+(pointP+(faceP->points[j]))->pointZ;
					z2 = mapZ+(pointP+(faceP->points[k]))->pointZ;
					z3 = objZ;

					ANS = (z2-z1)*(x3-x2)-(x2-x1)*(z3-z2);
					if (ANS < 0 )	break;

					if (k==0){

						/* ---------- ʏ̂P_vZ --------- */

						y1 = (pointP+(faceP->points[j]))->pointY;
						calcD = -( x1*(faceP->planeA)+y1*(faceP->planeB)+z1*(faceP->planeC) );

				

						object->positionY = 
						- ( (faceP->planeA)*objX + (faceP->planeC)*objZ + calcD )/ (faceP->planeB);


						nowAngle = - ( acos( (double)(faceP->planeB) ) );

						nextX = objX+20*sin(object->angleY);
						nextZ = objZ+20*cos(object->angleY);

						sos   =   nextX*(faceP->planeA)
								+(object->positionY)*(faceP->planeB)
 							    +nextZ*(faceP->planeC)
								+calcD;

						if (sos >= 0){
							if (object->angleX > -nowAngle){
									object->angleX = object->angleX - 0.1/360.0*(2*3.141592);
							} else 	object->angleX = 0-nowAngle;
						} else {
							if (object->angleX < nowAngle){
									object->angleX = object->angleX + 0.1/360.0*(2*3.141592);
							} else 	object->angleX = nowAngle;
						}

#if	0
						printf ("sos%f\n",sos);
						printf ("objX(%d)objZ(%d)\n",objX,objZ);
						printf ("nextX(%f),nextZ(%f)\n",nextX,nextZ);
						printf ("A(%f)B(%f)C(%f)D(%f)\n",faceP->planeA,faceP->planeB,faceP->planeC,calcD);
						printf ("%f\n",object->positionY);
#endif

					}
				}

			}

			break;
		}

		next:
		index = index->next;
	}
}



