#define		DrawSwitch	1
/***************************************************************
	GL TestGame Program	( TestRace )
	<< polygon.c >>
									Programed By H.Yajima
****************************************************************/

#define		TRUE	1
#define		FALSE	0

#include	<stdio.h>
#include	<math.h>

#include	<gl/gl.h>
#include	<gl/device.h>

#include	"window.h"
#include	"library.h"
#include	"prototype.h"

/***************************************************************
		External Memory
***************************************************************/

int		POLYGON;
int		POLY_ZCLIP;

extern	int	CONTROLLER;
extern	ShapeInfo	load1;

/***************************************************************
		Global Memory
***************************************************************/

/***************************************************************
	Parameter
****************************************************************/

#define		mapzoom	16
#define		MAXshape	1000
#define		MAXPoint	4000

/******** Camera ************************/

CameraInfo	camera;
double		WorldMatrix[10];
double		ObjectMatrix[10];
double		RotateMatrix[10];

/******** Shape Point *******************/

RotatePoints		rotatepoint[MAXPoint];
DisplayPoints		displaypoint[MAXPoint];
int					overflag[MAXPoint];

/******** Shape Table *******************/

SortList			SORTLIST[MAXshape];



/***************************************************************
	Polygon Initial
****************************************************************/

extern	void	InitScreen()
{

}



/***************************************************************
	Polygon Main
****************************************************************/

extern	void	DrawScreen(drawlist,camera)
DrawList	*drawlist;
CameraInfo	*camera;
{

	SortList	*sortlist;
	ShapeInfo	*shapeP;	
	int			shapecount;
	double		unitZ;

	POLYGON 	= 0;
	POLY_ZCLIP	= 0;

	ortho2(0.0,(float)WindowSizeX,0.0,(float)WindowSizeY);

	Make3DMatrix(WorldMatrix,camera->angleX,camera->angleY,camera->angleZ);
	MakeSortList(drawlist,camera,&unitZ);		/* shape sortlist	 	*/

	ClearDrawtable();							/* table reset			*/

	sortlist = SORTLIST[0].next;				/* shape start index 	*/

	while(sortlist != SORTLIST){
		MakeObjMatrix(sortlist);				/* object rotation		*/
		Rotation(sortlist);						/* point rotation		*/
		Projection(sortlist);					/* point projection		*/
		DrawPolygon(sortlist);					/* polygon draw			*/
		sortlist = sortlist->next;				/* shape next			*/
	}

	DrawEntry();								/* Draw	*/

}


/***************************************************************
	Make SortList
****************************************************************/

MakeSortList(drawlist,camera,unitZ)
DrawList	*drawlist;
CameraInfo	*camera;
double		*unitZ;
{
	SortList	*list 	= SORTLIST;
	SortList	*root 	= SORTLIST;

	double		rx,ry,rz;
	ObjectInfo	*object;

	/*--- initialize ---*/
	root->next = list+1;
	root->prev = root;
	list++;

	/*--- main ----*/
	while(	drawlist->OBJPtr!= NULL ){
	
		if	(CenterRot(camera,drawlist->OBJPtr,&rx,&ry,&rz) == TRUE){

			list->map 		= drawlist->OBJPtr;
			list->next		= list+1;
			list->prev	 	= list-1;
			list->rotateX 	= rx;
			list->rotateY 	= ry;
			list->rotateZ 	= rz;

			switch (list->map->flags){
				case	SHAPE_GROUND:
					list->angleX = 0;
					list->angleY = 0;
					list->angleZ = 0;
					break;
				case	SHAPE_OBJECT:
					object = (ObjectPtr)(list->map);
					list->angleX = object->angleX;
					list->angleY = object->angleY;
					list->angleZ = object->angleZ;
					break;
			}
			list++;		/* display sortlist 	*/

		}
		drawlist++;		/* map drawlist			*/
	}

	(list-1)->next = root;

}

/***************************************************************
	MapShape Center Rotation
***************************************************************/


CenterRot(camera,map,rx,ry,rz)
CameraInfo	*camera;
GroundInfo	*map;
double		*rx,*ry,*rz;
{

	double		*matrixP = WorldMatrix;
	double		px,py,pz;
	ObjectInfo	*object;

	switch (map->flags){

		case	SHAPE_GROUND:
			px = (map->posX)*mapzoom-(camera->positionX);
			py = 0-(camera->positionY);
			pz = (map->posZ)*mapzoom-(camera->positionZ);
			break;
		case	SHAPE_OBJECT:
			object = (ObjectPtr)map;
			px = (object->positionX)-(camera->positionX);
			py = (object->positionY)-(camera->positionY);
			pz = (object->positionZ)-(camera->positionZ);
			break;
	}

		*rx = (px * *(matrixP+M11)+py * *(matrixP+M21)+pz * *(matrixP+M31))+(camera->offsetX);	
		*ry = (px * *(matrixP+M12)+py * *(matrixP+M22)+pz * *(matrixP+M32))+(camera->offsetY);	
		*rz = (px * *(matrixP+M13)+py * *(matrixP+M23)+pz * *(matrixP+M33))+(camera->offsetZ);	

		if ( *rz < -128*mapzoom	)		return(FALSE);
		if ( *rz > 0x200*mapzoom 	)	return(FALSE);

	return(TRUE);

}

/***************************************************************
	Calc Rotation Matrix
***************************************************************/

MakeObjMatrix(sortlist)
SortList	*sortlist;
{
	double	ax,ay,az;
	int	i;
	ObjectInfo	*object;

	switch	(sortlist->map->flags){
		case	SHAPE_GROUND:
			for(i=0;i<9;i++){
				RotateMatrix[i] = WorldMatrix[i];
			}
			break;
		case	SHAPE_OBJECT:
			object = (ObjectPtr)(sortlist->map);
			Make3DMatrix(ObjectMatrix,object->angleX,object->angleY,object->angleZ);
			CalcMatrix(RotateMatrix,ObjectMatrix,WorldMatrix);
			break;
	}

}
/***************************************************************
	Rotation
***************************************************************/

Rotation(sortlist)
SortList	*sortlist;
{

	double			*matrixP 	= RotateMatrix;
	RotatePoints	*rotateP	= rotatepoint;
	int				*overflagP	= overflag;
	PointData		*bodyP		= sortlist->map->shape->point;
	int				pointtotal	= sortlist->map->shape->npoints;
	int				scale 		= 1;

	double			cx 			= sortlist->rotateX;
	double			cy 			= sortlist->rotateY;
	double			cz 			= sortlist->rotateZ;

	double			px,py,pz;

#if	0
	printf ( "%d,%d,%d\n",(int)sortlist->rotateX,(int)sortlist->rotateY,(int)sortlist->rotateZ);
#endif


	while( pointtotal-- ){

		px = (bodyP->pointX);
		py = (bodyP->pointY);
		pz = (bodyP->pointZ);

		rotateP -> rotateX = (px * *(matrixP+M11)
			  			     +py * *(matrixP+M21)
						     +pz * *(matrixP+M31))*scale
					  	     + cx;
		rotateP -> rotateY = (px * *(matrixP+M12)
						     +py * *(matrixP+M22)
					  	     +pz * *(matrixP+M32))*scale
					  	     + cy;
		rotateP -> rotateZ  =(px * *(matrixP+M13)
					  	     +py * *(matrixP+M23)
					  	     +pz * *(matrixP+M33))*scale
					  	     + cz;

		/*------ Z Overflow --------*/
		if ( rotateP->rotateZ > ZCLIP )	*overflagP = 0;
		else 							*overflagP = 1;
		*overflagP++;
		/*--------------------------*/

		*rotateP++;
		*bodyP++;

	}

}

/***************************************************************
	Projection
***************************************************************/

Projection(sortlist)
SortList	*sortlist;
{

	RotatePoints	*rotateP	= rotatepoint;
	DisplayPoints	*displayP	= displaypoint;
	int				pointtotal 	= sortlist->map->shape->npoints;
	double			displayCX	= WindowSizeX/2;
	double			displayCY	= WindowSizeY/2;

	while ( pointtotal-- ){

		if (rotateP -> rotateZ == 0.0){
			rotateP -> rotateZ = 0.1;
		}

		displayP -> displayX = rotateP -> rotateX/(rotateP -> rotateZ)*ZOOMCAMERA 	 + displayCX;
		displayP -> displayY = (rotateP -> rotateY/(rotateP -> rotateZ)*ZOOMCAMERA)  + displayCY;

		*displayP++;
		*rotateP++;

	}

}

/***************************************************************
	DrawPolygon
***************************************************************/

DrawPolygon(sortlist)
SortList	*sortlist;
{

	FaceData		*faceP		= sortlist->map->shape->face;
	int				facetotal	= sortlist->map->shape->nfaces;
	int				i,j;
	int				Zclipflag;
	int				flag;



	switch (sortlist->map->flags){
		case	SHAPE_GROUND:	flag = 0;	break;
		case	SHAPE_OBJECT:	flag = 1;	break;
	}

	for (i=0;i<facetotal;i++){

		switch(faceP->nvertexes){
			case	2:	FillLine(faceP);			break;
			case	3:	FillTriangle(faceP,flag);	break;
			case	4:	FillSquare(faceP,flag);		break;
			default	:	break;
		}

		faceP++;

	}

	gflush();

}


/***************************************************************
	3D library
***************************************************************/

/*====== Y->X->Z rotation ====================================*/

Make3DMatrix(matrix,aX,aY,aZ)
double	*matrix;
double	aX,aY,aZ;
{

	*matrix++	=  cos(aY)*cos(aZ)+sin(aX)*sin(aY)*sin(aZ);
	*matrix++	= -cos(aY)*sin(aZ)+sin(aX)*sin(aY)*cos(aZ);
	*matrix++	=  cos(aX)*sin(aY);

	*matrix++	=  cos(aX)*sin(aZ);
	*matrix++	=  cos(aX)*cos(aZ);
	*matrix++	= -sin(aX);

	*matrix++	= -sin(aY)*cos(aZ)+sin(aX)*cos(aY)*sin(aZ);
	*matrix++	=  sin(aY)*sin(aZ)+sin(aX)*cos(aY)*cos(aZ);
	*matrix		=  cos(aX)*cos(aY);

}

/*====== Matrix Mult ====================================*/

CalcMatrix(matrixC,matrixA,matrixB)
double	*matrixC,*matrixA,*matrixB;
{
	int	i;

#if	1
	*matrixC++ = matrixA[M11]*matrixB[M11]+matrixA[M21]*matrixB[M21]+matrixA[M31]*matrixB[M31];
	*matrixC++ = matrixA[M11]*matrixB[M12]+matrixA[M21]*matrixB[M22]+matrixA[M31]*matrixB[M32];
	*matrixC++ = matrixA[M11]*matrixB[M13]+matrixA[M21]*matrixB[M23]+matrixA[M31]*matrixB[M33];

	*matrixC++ = matrixA[M12]*matrixB[M11]+matrixA[M22]*matrixB[M21]+matrixA[M32]*matrixB[M31];
	*matrixC++ = matrixA[M12]*matrixB[M12]+matrixA[M22]*matrixB[M22]+matrixA[M32]*matrixB[M32];
	*matrixC++ = matrixA[M12]*matrixB[M13]+matrixA[M22]*matrixB[M23]+matrixA[M32]*matrixB[M33];

	*matrixC++ = matrixA[M13]*matrixB[M11]+matrixA[M23]*matrixB[M21]+matrixA[M33]*matrixB[M31];
	*matrixC++ = matrixA[M13]*matrixB[M12]+matrixA[M23]*matrixB[M22]+matrixA[M33]*matrixB[M32];
	*matrixC   = matrixA[M13]*matrixB[M13]+matrixA[M23]*matrixB[M23]+matrixA[M33]*matrixB[M33];
#endif

#if	0
	*matrixC++ = matrixA[M11]*matrixB[M11]+matrixA[M12]*matrixB[M21]+matrixA[M13]*matrixB[M31];
	*matrixC++ = matrixA[M11]*matrixB[M12]+matrixA[M12]*matrixB[M22]+matrixA[M13]*matrixB[M32];
	*matrixC++ = matrixA[M11]*matrixB[M13]+matrixA[M12]*matrixB[M23]+matrixA[M13]*matrixB[M33];

	*matrixC++ = matrixA[M21]*matrixB[M11]+matrixA[M22]*matrixB[M21]+matrixA[M23]*matrixB[M31];
	*matrixC++ = matrixA[M21]*matrixB[M12]+matrixA[M22]*matrixB[M22]+matrixA[M23]*matrixB[M32];
	*matrixC++ = matrixA[M21]*matrixB[M13]+matrixA[M22]*matrixB[M23]+matrixA[M23]*matrixB[M33];

	*matrixC++ = matrixA[M31]*matrixB[M11]+matrixA[M32]*matrixB[M21]+matrixA[M33]*matrixB[M31];
	*matrixC++ = matrixA[M31]*matrixB[M12]+matrixA[M32]*matrixB[M22]+matrixA[M33]*matrixB[M32];
	*matrixC   = matrixA[M31]*matrixB[M13]+matrixA[M32]*matrixB[M23]+matrixA[M33]*matrixB[M33];
#endif

}


/***************************************************************
	Test Program
****************************************************************/

extern	void	DrawTest()
{

}
