/***************************************************************
	GL TestGame Program	( TestRace )
	<< zsort.c >>
									Programed By H.Yajima
****************************************************************/

#define		TRUE	1
#define		FALSE	0

#include	<stdio.h>
#include	<math.h>

#include	<gl/gl.h>
#include	<gl/device.h>

#include	"window.h"
#include	"library.h"
#include	"prototype.h"

/***************************************************************
	Memory
***************************************************************/

DrawBuffer	drawbuffer[MAXbuffer];
DrawBuffer	*drawtable[MAXtable];
int			DRAWpointer;

/***************************************************************
	Clear drawtable
	( Clear Bufeer )
***************************************************************/

extern	void	ClearDrawtable()
{
	int	i;
	for(i=0;i<MAXtable;i++){
		drawtable[i] = NULL;
	}
	DRAWpointer = 0;			/* pointer reset	*/
}

/***************************************************************
	Draw Entry
	( Polygon Draw Display )
***************************************************************/

extern	unsigned long	RGBdata[];

extern	void	DrawEntry()
{

	DrawBuffer	*bufferP;
	int	i,j;
	float	dataP;

	for(i=(MAXtable-1);i>=0;i--){
		if (drawtable[i] == NULL) continue;
		bufferP = drawtable[i];

		do {

			cpack(RGBdata[bufferP->color]);			
			bgnpolygon();
				for(j=0;j<(bufferP->flag);j++)	v2f(bufferP->points[j]);
			endpolygon();

			bufferP = bufferP->next;

		} while(bufferP != NULL);

	}
}

/***************************************************************
	Set drawtable
	( Buffer Write )
***************************************************************/

SetDrawbuffer(counter,index,dispdata,color)
int				counter;		/* polygon vertex counter 	*/
int				index;			/* polygon index			*/
double			*dispdata;
short	color;
{	

	int	i;

	if ( drawtable[index] == NULL ){
		drawtable[index] 			 = &drawbuffer[DRAWpointer];
		drawbuffer[DRAWpointer].next = NULL;
	} else {
		drawbuffer[DRAWpointer].next = drawtable[index];
		drawtable[index]			 = &drawbuffer[DRAWpointer];
	}
	drawbuffer[DRAWpointer].flag	 = counter;
	drawbuffer[DRAWpointer].color 	 = color;
	for (i=0;i<counter;i++){
		drawbuffer[DRAWpointer].points[i][0] = dispdata[i*2+0];
		drawbuffer[DRAWpointer].points[i][1] = dispdata[i*2+1];
	}
	DRAWpointer++;

}

