/***************************************************************
	GL SpeedCheck Program
****************************************************************/

#include	<stdio.h>
#include	<math.h>
#include 	<sys/time.h>

#include	<gl/gl.h>
#include	<gl/device.h>

#include	"data.h"

/***************************************************************
	Polygon Data
****************************************************************/

static	float	V0[]= { -2.0,-2.0 };
static	float	V1[]= {  2.0,-2.0 };
static	float	V2[]= {  2.0, 2.0 };
static	float	V3[]= { -2.0, 2.0 };

/***************************************************************
	Global Memory
****************************************************************/

int		INTERVAL = 0;
static struct timeval timebase;
static	int	timeCounter;

/***************************************************************
	Main Program
****************************************************************/
main()
{


	int	i;
	short	val;

	OpenTimer();
	prefsize(320*3,240*3);
	winopen("GL Speed Check");

	InitPlayer();
	
	zbuffer(TRUE);
	doublebuffer();
	RGBmode();
	gconfig();

	qdevice(ESCKEY);
	/* pixmode(PM_TTOB,1); */


	while(!(qtest() && qread(&val) == ESCKEY)){

		ClearBitmap();
		DrawPolygon();
		SetMeter();
		swapbuffers();
		INTERVAL = GameSyncro();

	}

	gexit();

}


/***************************************************************
	Bitmap Clear
****************************************************************/

ClearBitmap()
{

	cpack(0xff000000);
	clear();
	zclear();

}

/***************************************************************
	Init Player
****************************************************************/

extern	unsigned	long	*mario_data[];
extern	unsigned	long	*kuppa_data[];
extern	unsigned	long	*peach_data[];
extern	unsigned	long	*kong_data[];
extern	unsigned	long	*yossy_data[];
extern	unsigned	long	*kinopio_data[];
extern	unsigned	long	*kame_data[];

unsigned long *player_data[8][30];

InitPlayer()
{

	int	pattern;

		for(pattern=0;pattern<22;pattern++)	player_data[0][pattern] = mario_data[pattern];
		for(pattern=0;pattern<22;pattern++)	player_data[1][pattern] = kuppa_data[pattern];
		for(pattern=0;pattern<22;pattern++)	player_data[2][pattern] = peach_data[pattern];
		for(pattern=0;pattern<22;pattern++)	player_data[3][pattern] = kong_data[pattern];
		for(pattern=0;pattern<22;pattern++)	player_data[4][pattern] = yossy_data[pattern];
		for(pattern=0;pattern<22;pattern++)	player_data[5][pattern] = kinopio_data[pattern];
		for(pattern=0;pattern<22;pattern++)	player_data[6][pattern] = kame_data[pattern];

}


/***************************************************************
	Draw Polygon
****************************************************************/

int		ct = 0;
float	zoomparam = 2.0;

/* = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = */

DrawPolygon()

{
	int	i;
	int		playerCH,playerCV;

	playerCH = 100;
	playerCV = 100;
	


	afunction(0,AF_NOTEQUAL);

	ortho2(-320.0,320.0,-240.0,240.0);

	cpack(0xffffffff);
	rectzoom(zoomparam,zoomparam);

	for (i=0;i<1;i++){

		lrectwrite(playerCH,playerCV,playerCH+31,playerCV+31,player_data[i][ct]);	
		playerCH = playerCH+80;

	}

		ct++;				if (ct==22) 		ct=0;

}

/************************************************************************
	Get System time.
 ************************************************************************/
TickCount(void)
{
	struct timeval tp;
	int sec,msec;

	gettimeofday(&tp,NULL);
	sec  = tp.tv_sec  - timebase.tv_sec;
	msec = tp.tv_usec / 1000;

	return(sec * 1000 + msec);

}

/**********************************************************************
	Initialize parameter for test.
 **********************************************************************/

OpenTimer(void)
{
	timeCounter = TickCount();	
}


/************************************************************************
	Syncronize game frame.
 ************************************************************************/
GameSyncro(void)
{

	int time,interval;

	while ((time = TickCount()) < timeCounter+2);
	interval	= time - timeCounter;
	timeCounter = time;
	return(interval);

}

/************************************************************************
	Set Meter 
 ************************************************************************/

SetMeter()
{

	char	number[10];

	ortho2(-320.0,320.0,-240.0,240.0);

	cpack(0xffffffff);

	cmov2i(50,-200); 
	decconv(INTERVAL,number);
	charstr(number);
	charstr(" msec");

}

/************************************************************************
	CONVERT		( 0 ... 65535 )		
				( -32768 ... 32767 )  
 ************************************************************************/

hexconv(number,hexmem)
int		number;
char	*hexmem;
{
	int	i;

	if (number > 0x10000)	number = 0xffff;
	if (number < -0x8000)	number = 0x8000;
	if (number < 0)	number = 0x10000 + number;

	for	(i=3;i>=0;i--){

		if ( (number%16)>9 ){
			*(hexmem+i)=(number%16)-10+'A';
		} else {
			*(hexmem+i)=(number%16)+'0';
		}
		number = number/16;
	}
				
	*(hexmem+4)= '\0';

}

/************************************************************************
	CONVERT		( 0 ... 65535 )		
				( 0 ... 9999 )
 ************************************************************************/

decconv(number,decmem)
int		number;
char	*decmem;
{
	int	i;

	if (number > 9999)		number = 9999;
	if (number < 0)			number = 0;

	for	(i=3;i>=0;i--){
		*(decmem+i)=(number%10)+'0';
		number = number/10;
	}

	*(decmem+4)= '\0';

}



