/***************************************************************
	GL SpeedCheck Program
****************************************************************/

#include	<stdio.h>
#include	<math.h>
#include 	<sys/time.h>

#include	<gl/gl.h>
#include	<gl/device.h>

/***************************************************************
	Polygon Data
****************************************************************/

static	float	V0[]= { -0.8,-0.8,-12.0 };
static	float	V1[]= {  0.8,-0.8,-12.0 };
static	float	V2[]= {  0.8, 0.8,-12.0 };
static	float	V3[]= { -0.8, 0.8,-12.0 };

/***************************************************************
	Global Memory
****************************************************************/

int		INTERVAL = 0;
static struct timeval timebase;
static	int	timeCounter;

/***************************************************************
	Main Program
****************************************************************/
main()
{


	int	i;
	short	val;

	OpenTimer();
	prefsize(320*3,240*3);
	winopen("GL Speed Check");


	doublebuffer();
	/* RGBmode(); */
	gconfig();

	shademodel(FLAT);
	
	qdevice(ESCKEY);



	while(!(qtest() && qread(&val) == ESCKEY)){

	ClearBitmap();
	DrawPolygon();
	SetMeter();
	swapbuffers();	
	INTERVAL = GameSyncro();

	}

	gexit();

}


/***************************************************************
	Bitmap Clear
****************************************************************/

ClearBitmap()
{

	/* cpack(0x0); */
	color(BLACK);
	clear();

}

/***************************************************************
	Draw Polygon
****************************************************************/

DrawPolygon()
{
	int	i;





		perspective(600,(320.0*3)/(240.0*3),0.1,1000);

	/* ortho2(0.0,640.0,0.0,480.0);			*/



#if	1
	for (i=0;i<3000;i++){


		/* cpack(0xffffffff); */
		color(RED);
		bgnpolygon();
			v3f(V0);
			v3f(V1);
			v3f(V2);
			v3f(V3);
		endpolygon();



	}
#endif

}

/************************************************************************
	Get System time.
 ************************************************************************/
TickCount(void)
{
	struct timeval tp;
	int sec,msec;

	gettimeofday(&tp,NULL);
	sec  = tp.tv_sec  - timebase.tv_sec;
	msec = tp.tv_usec / 1000;

	return(sec * 1000 + msec);

}

/**********************************************************************
	Initialize parameter for test.
 **********************************************************************/

OpenTimer(void)
{
	timeCounter = TickCount();	
}


/************************************************************************
	Syncronize game frame.
 ************************************************************************/
GameSyncro(void)
{

	int time,interval;

	while ((time = TickCount()) < timeCounter+2);
	interval	= time - timeCounter;
	timeCounter = time;
	return(interval);

}

/************************************************************************
	Set Meter 
 ************************************************************************/

SetMeter()
{

	char	number[10];

	ortho2(-320.0,320.0,-240.0,240.0);

	/* cpack(0xffffffff); */
	color(RED);

	cmov2i(50,-200); 
	decconv(INTERVAL,number);
	charstr(number);
	charstr(" msec");

}

/************************************************************************
	CONVERT		( 0 ... 65535 )		
				( -32768 ... 32767 )  
 ************************************************************************/

hexconv(number,hexmem)
int		number;
char	*hexmem;
{
	int	i;

	if (number > 0x10000)	number = 0xffff;
	if (number < -0x8000)	number = 0x8000;
	if (number < 0)	number = 0x10000 + number;

	for	(i=3;i>=0;i--){

		if ( (number%16)>9 ){
			*(hexmem+i)=(number%16)-10+'A';
		} else {
			*(hexmem+i)=(number%16)+'0';
		}
		number = number/16;
	}
				
	*(hexmem+4)= '\0';

}

/************************************************************************
	CONVERT		( 0 ... 65535 )		
				( 0 ... 9999 )
 ************************************************************************/

decconv(number,decmem)
int		number;
char	*decmem;
{
	int	i;

	if (number > 9999)		number = 9999;
	if (number < 0)			number = 0;

	for	(i=3;i>=0;i--){
		*(decmem+i)=(number%10)+'0';
		number = number/10;
	}

	*(decmem+4)= '\0';

}



