/***************************************************************
	GL SpeedCheck Program
****************************************************************/

#include	<stdio.h>
#include	<math.h>
#include 	<sys/time.h>

#include	<gl/gl.h>
#include	<gl/device.h>



/***************************************************************
	Global Memory
****************************************************************/

int		INTERVAL = 0;
static struct timeval timebase;
static	int	timeCounter;

/***************************************************************
	Main Program
****************************************************************/
main()
{


	int	i;
	short	val;

	OpenTimer();
	prefsize(320*3,240*3);
	winopen("GL Speed Check");


	zbuffer(TRUE);
	doublebuffer();
	RGBmode();
	gconfig();

	InitTexture();
	qdevice(ESCKEY);

	while(!(qtest() && qread(&val) == ESCKEY)){

		ClearBitmap();
		DrawPolygon();
		SetMeter();
		swapbuffers();	
		INTERVAL = GameSyncro();

	}

	gexit();

}


/***************************************************************
	Bitmap Clear
****************************************************************/

ClearBitmap()
{

	cpack(0xff000000);
	clear();
	zclear();

}

/***************************************************************
	Initialize Texture Mapping
****************************************************************/

extern	unsigned long	data0[];
extern	unsigned long	data1[];
extern	unsigned long	data2[];
extern	unsigned long	data3[];
extern	unsigned long	data4[];
extern	unsigned long	data5[];
extern	unsigned long	data6[];
extern	unsigned long	data7[];
extern	unsigned long	data8[];
extern	unsigned long	data9[];

/* ---------------------------------------------------------- */

float texprops[] = { TX_MINFILTER,TX_POINT,
					 TX_MAGFILTER,TX_POINT,
					 TX_WRAP,TX_REPEAT,TX_NULL };

float tevprops[] = { TV_MODULATE,TV_NULL };

InitTexture()
{

	texdef2d(1,4,8,8,data5,7,texprops);
	tevdef(1,0,tevprops);


}

/***************************************************************
	Draw Polygon
****************************************************************/

static	float	t0[] = { 0.0,0.0 };
static	float	t1[] = { 8.0,0.0 };
static	float	t2[] = { 8.0,8.0 };
static	float	t3[] = { 0.0,8.0 };


static	float	V0[]= { -80.0,-80.0 };
static	float	V1[]= {  80.0,-80.0 };
static	float	V2[]= {  80.0, 80.0 };
static	float	V3[]= { -80.0, 80.0 };

/* = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = */


DrawPolygon()
{
	int	i;
	

	afunction(0,AF_NOTEQUAL);

	ortho2(-320.0,320.0,-240.0,240.0);


		cpack(0xffff00ff);

		bgnpolygon();
				v2f(V0);
				v2f(V1);
				v2f(V2);
				v2f(V3);
		endpolygon();


	for(i=0;i<30;i++){

		texbind(TX_TEXTURE_0,1);	/* texture ON 	*/
		tevbind(TV_ENV0,1);

#if	1
		cpack(0xffffffff);
		bgnpolygon();
			t2f(t0);	v2f(V0);
			t2f(t1);	v2f(V1);
			t2f(t2);	v2f(V2);
			t2f(t3);	v2f(V3); 
		endpolygon();
#endif

	}

		texbind(TX_TEXTURE_0,0);	/* texture OFF */



}



/************************************************************************
	Get System time.
 ************************************************************************/
TickCount(void)
{
	struct timeval tp;
	int sec,msec;

	gettimeofday(&tp,NULL);
	sec  = tp.tv_sec  - timebase.tv_sec;
	msec = tp.tv_usec / 1000;

	return(sec * 1000 + msec);

}

/**********************************************************************
	Initialize parameter for test.
 **********************************************************************/

OpenTimer(void)
{
	timeCounter = TickCount();	
}


/************************************************************************
	Syncronize game frame.
 ************************************************************************/
GameSyncro(void)
{

	int time,interval;

	while ((time = TickCount()) < timeCounter+2);
	interval	= time - timeCounter;
	timeCounter = time;
	return(interval);

}

/************************************************************************
	Set Meter 
 ************************************************************************/

SetMeter()
{

	char	number[10];

	ortho2(-320.0,320.0,-240.0,240.0);

	cpack(0xffffffff);

	cmov2i(50,-200); 
	decconv(INTERVAL,number);
	charstr(number);
	charstr(" msec");

}

/************************************************************************
	CONVERT		( 0 ... 65535 )		
				( -32768 ... 32767 )  
 ************************************************************************/

hexconv(number,hexmem)
int		number;
char	*hexmem;
{
	int	i;

	if (number > 0x10000)	number = 0xffff;
	if (number < -0x8000)	number = 0x8000;
	if (number < 0)	number = 0x10000 + number;

	for	(i=3;i>=0;i--){

		if ( (number%16)>9 ){
			*(hexmem+i)=(number%16)-10+'A';
		} else {
			*(hexmem+i)=(number%16)+'0';
		}
		number = number/16;
	}
				
	*(hexmem+4)= '\0';

}

/************************************************************************
	CONVERT		( 0 ... 65535 )		
				( 0 ... 9999 )
 ************************************************************************/

decconv(number,decmem)
int		number;
char	*decmem;
{
	int	i;

	if (number > 9999)		number = 9999;
	if (number < 0)			number = 0;

	for	(i=3;i>=0;i--){
		*(decmem+i)=(number%10)+'0';
		number = number/10;
	}

	*(decmem+4)= '\0';

}



