/************************************************************************

		<< TEST GAME >>		++ Game Color ++

 ************************************************************************/

#include "map.h"
#include "ToolBox.h"
#include "External.h"

#define	defaultBACK_red			0xffff
#define	defaultBACK_green		0xffff
#define	defaultBACK_blue		0xffff
#define	defaultPIXEL_red		0x0
#define	defaultPIXEL_green		0x0
#define	defaultPIXEL_blue		0x0

typedef struct {
	unsigned short red;
	unsigned short green;
	unsigned short blue;
} Color;

XColor	newsPalette[256] ;			/* mdvrpJ[Epbg		*/
Colormap colorMap;					/* J[E}bv					*/


/************************************************************************
	Cg\[Xe[u
 ************************************************************************/

static	int		lighttable[]={ 
	0x0f,0x0f,0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x09,0x0a,0x0b,0x0c,0x0d,0x0e,0x0f,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,

	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
};

static	int	light00[]={0xf0,0xf1,0xf2,0xf3,0xf4,0xf5,0xf6,0xf7,0xf8,0xf9,0xfa,0xfb,0xfc,0xfd,0xfe,0xff};
static	int	light01[]={0xf0,0xf1,0xf2,0xf3,0xf4,0xf5,0xf6,0xf7,0xf8,0xf9,0xfa,0xfb,0xfc,0xfd,0xfe,0xff};
static	int	light02[]={0x20,0x21,0x22,0x23,0x24,0x25,0x26,0x27,0x28,0x29,0x2a,0x2b,0x2c,0x2d,0x2e,0x2f};
static	int	light03[]={0x30,0x31,0x32,0x33,0x34,0x35,0x36,0x37,0x38,0x39,0x3a,0x3b,0x3c,0x3d,0x3e,0x3f};
static	int	light04[]={0x40,0x41,0x42,0x43,0x44,0x45,0x46,0x47,0x48,0x49,0x4a,0x4b,0x4c,0x4d,0x4e,0x4f};
static	int	light05[]={0x50,0x51,0x52,0x53,0x54,0x55,0x56,0x57,0x58,0x59,0x5a,0x5b,0x5c,0x5d,0x5e,0x5f};
static	int	light06[]={0x60,0x61,0x62,0x63,0x64,0x65,0x66,0x67,0x68,0x69,0x6a,0x6b,0x6c,0x6d,0x6e,0x6f};
static	int	light07[]={0x70,0x71,0x72,0x73,0x74,0x75,0x76,0x77,0x78,0x79,0x7a,0x7b,0x7c,0x7d,0x7e,0x7f};
static	int	light08[]={0x80,0x81,0x82,0x83,0x84,0x85,0x86,0x87,0x88,0x89,0x8a,0x8b,0x8c,0x8d,0x8e,0x8f};
static	int	light09[]={0x90,0x91,0x92,0x93,0x94,0x95,0x96,0x97,0x98,0x99,0x9a,0x9b,0x9c,0x9d,0x9e,0x9f};
static	int	light0a[]={0xa0,0xa1,0xa2,0xa3,0xa4,0xa5,0xa6,0xa7,0xa8,0xa9,0xaa,0xab,0xac,0xad,0xae,0xaf};
static	int	light0b[]={0xb0,0xb1,0xb2,0xb3,0xb4,0xb5,0xb6,0xb7,0xb8,0xb9,0xba,0xbb,0xbc,0xbd,0xbe,0xbf};
static	int	light0c[]={0xc0,0xc1,0xc2,0xc3,0xc4,0xc5,0xc6,0xc7,0xc8,0xc9,0xca,0xcb,0xcc,0xcd,0xce,0xcf};
static	int	light0d[]={0xd0,0xd1,0xd2,0xd3,0xd4,0xd5,0xd6,0xd7,0xd8,0xd9,0xda,0xdb,0xdc,0xdd,0xde,0xdf};
static	int	light0e[]={0xe0,0xe1,0xe2,0xe3,0xe4,0xe5,0xe6,0xe7,0xe8,0xe9,0xea,0xeb,0xec,0xed,0xee,0xef};
static	int	light0f[]={0xf0,0xf1,0xf2,0xf3,0xf4,0xf5,0xf6,0xf7,0xf8,0xf9,0xfa,0xfb,0xfc,0xfd,0xfe,0xff};

int	*lightindex[] ={
		light00,light01,light02,light03,light04,light05,light06,light07,
		light08,light09,light0a,light0b,light0c,light0d,light0e,light0f
};

/************************************************************************
	J[ԍ(pbgԍ)ăJ[f[^Ԃ
 ************************************************************************/

extern	int		CalcColor(colorNO,light,depth)
int		colorNO;
int		light;
int		depth;
{

	int		data;
	int		NO;
	int		*pt;

	/* NO = lighttable[colorNO];	ID		*/

	if (colorNO<0x10){
		pt = lightindex[colorNO];		/* Cg\[XԍI	*/
		return(pt[light]);
	} else {
		return(colorNO);				/* ̂܂܃J[Zbg		*/
	}


}


/************************************************************************
	J[p[^
 ************************************************************************/

static	double	ADDS[] = { 4.0,4.5,5.0,5.5,6.0,6.5,7.0,7.5,
						   8,9,10,11,12,13,14,15 };

static	Color	MaxColor[]={
	{0xffff,0xffff,0xffff},
	{0xffff,0xffff,0xffff},
	{0xffff,0xffff,0xffff},
	{0xc000,0xc000,0xc000},
	{0xffff,0x8000,0x0000},
	{0x2000,0x8000,0x2000},
	{0xffff,0xc000,0x8000},
	{0xa000,0xa000,0x0000},
	{0xa000,0x3000,0x0000},
	{0xffff,0xffff,0x0000},
	{0xffff,0x0000,0xffff},
	{0x0000,0xffff,0xffff},
	{0xffff,0x0000,0x0000},
	{0x0000,0xffff,0x0000},
	{0x0000,0x0000,0xffff},
	{0xffff,0xffff,0xffff},
};


/************************************************************************
	J[̏sȂ.
 ************************************************************************/

extern void InitColors()
{
	int		palet,color;
	int 	number;
	Visual *visual = DefaultVisual(display,0);

		colorMap = XCreateColormap(display,rootWindow,visual,AllocAll);

		/* TvJ[ */
		for (palet=0;palet<16;palet++){
			for(color=0;color<16;color++){
				number = palet*16+color;
				newsPalette[number].flags	= DoRed | DoGreen | DoBlue;
				newsPalette[number].pixel	= number;
				newsPalette[number].red 	= MaxColor[palet].red	*(ADDS[color])/15.0;
				newsPalette[number].green	= MaxColor[palet].green	*(ADDS[color])/15.0;
				newsPalette[number].blue	= MaxColor[palet].blue	*(ADDS[color])/15.0;
			}
		}

		/* {̂QF	*/
		newsPalette[defaultBACK].red   	= defaultBACK_red;
		newsPalette[defaultBACK].green 	= defaultBACK_green;
		newsPalette[defaultBACK].blue  	= defaultBACK_blue;
		newsPalette[defaultPIXEL].red   = defaultPIXEL_red;
		newsPalette[defaultPIXEL].green = defaultPIXEL_green;
		newsPalette[defaultPIXEL].blue  = defaultPIXEL_blue;


		/* 	̐F		*/
		newsPalette[0x2f].red   	= 0xc000;
		newsPalette[0x2f].green 	= 0xffff;
		newsPalette[0x2f].blue  	= 0xffff;
		/* nʂ̐F		*/
		newsPalette[0x2e].red   	= 0x4000;
		newsPalette[0x2e].green 	= 0xc000;
		newsPalette[0x2e].blue  	= 0x4000;




		XStoreColors(display,colorMap,newsPalette,256);
		XSetWindowColormap(display,mainWindow,colorMap);		
		XSetWindowColormap(display,topLevel.menuBar->window.windowID,colorMap);
}


/************************************************************************
	J[E}bvANeBuɂ.
 ************************************************************************/
extern void ActiveColorMap(event)
XEventPtr event;
{
}
/************************************************************************
	J[E}bvCANeBuɂ.
 ************************************************************************/
extern void InactiveColorMap(event)
XEventPtr event;
{
}

