/************************************************************************

		<< TEST GAME >>		++ draw main rutine ++

 ************************************************************************/

#include	<stdio.h>
#include	<string.h>
#include	<ctype.h>
#include	<math.h>

#include 	"ToolBox.h"
#include 	"map.h"
#include 	"External.h"
#include 	"Prototype.h"
#include 	"WindowSize.h"


/************************************************************************
		[Nq`l
 ************************************************************************/

#define		maxdraw		1000			/*	\ő吔						*/
#define		maxarea		128*128			/*	GAő吔					*/
#define		maxmap		4096			/*	1world  ő map			*/

extern		WorldInfo	TestMapData;	/* ROM}bvf[^ւ̃|C^		*/

DrawList	drawlist[maxdraw];			/* \p|C^z				*/

AreaInfo	*AreaList[maxarea];			/* GAf[^ւ̃|Cge[u	*/
AreaInfo	AreaData[maxmap];			/* P[hł̃}bvf[^		*/


/***********************************************************************
	݂̃|S`FbN
***********************************************************************/

extern	void	CheckPolygon(object)
ObjectInfo		*object;
{

	float	ANS,x1,x2,x3,z1,z2,z3,y1,sos;
	float	calcD;
	float	nextX,nextZ;

	int				wx,wz;
	int				objX,objZ;		/* vC[̍W		*/
	int				mapX,mapZ;		/* VFCv̒SW	*/
	int				areaNO;
	int				i,j,k;
	int				counter;
	int				R;				/* VFCv̔a					*/
	int				facecount;		/* VFCv\|Š */
	int				vertexcount; 	/* _̌						*/
	AreaInfo		*index;
	FacePtr			faceP;			/* tFCXւ̃|C^			*/
	PointPtr		pointP;			/* |Cgւ̃|C^			*/


	wx 		= (object->positionX)/16;
	wz 		= (object->positionZ)/16;
	objX 	= (object->positionX);
	objZ 	= (object->positionZ);
	areaNO 	= CalcAreaNO(wx,wz);		/* ݂̃JʒũGAԍvZ	*/

	index =	AreaList[areaNO];

	while (index != NULL){

		while ( (R = index->ground->shape->radius) >= 1000 ){

			mapX = (index->ground->posX)*16;
			mapZ = (index->ground->posZ)*16;

			if ( mapX + R - objX <  0 ) break;
			if ( mapX - R - objX >  0 ) break;
			if ( mapZ + R - objZ <  0 ) break;
			if ( mapZ - R - objZ >  0 ) break;

			facecount = index->ground->shape->nhits;
			faceP	  = index->ground->shape->face;
			pointP	  = index->ground->shape->point;

			for (i=0;i<facecount;i++,faceP++){

				if ( mapX + (faceP->xmax) - objX <  0 ) continue;
				if ( mapX + (faceP->xmin) - objX >  0 ) continue;
				if ( mapZ + (faceP->zmax) - objZ <  0 ) continue;
				if ( mapZ + (faceP->zmin) - objZ >  0 ) continue;

				vertexcount = faceP->nvertexes;

				for(j=0;j<vertexcount;j++){

					if (j == (vertexcount-1))  k=0;
					else					   k=j+1;

					x1 = mapX+(pointP+(faceP->points[j]))->pointX;
					x2 = mapX+(pointP+(faceP->points[k]))->pointX;
					x3 = objX;
					z1 = mapZ+(pointP+(faceP->points[j]))->pointZ;
					z2 = mapZ+(pointP+(faceP->points[k]))->pointZ;
					z3 = objZ;

					ANS = (z2-z1)*(x3-x2)-(x2-x1)*(z3-z2);
					if (ANS < 0 )	break;

					if (k==0){

						/* ---------- ʏ̂P_vZ --------- */

						y1 = (pointP+(faceP->points[j]))->pointY;
						calcD = -( x1*(faceP->planeA)+y1*(faceP->planeB)+z1*(faceP->planeC) );

				

						object->positionY = 
						- ( (faceP->planeA)*objX + (faceP->planeC)*objZ + calcD )/ (faceP->planeB);


						object->angleX = - (acos((double)(faceP->planeB))*AngleParam/(2*3.141592));



						nextX = objX+20*sin((double)(object->angleY)/AngleParam*2*3.141592);
						nextZ = objZ+20*cos((double)(object->angleY)/AngleParam*2*3.141592);

						sos   =   nextX*(faceP->planeA)
								+(object->positionY)*(faceP->planeB)
 							    +nextZ*(faceP->planeC)
								+calcD;

						if (sos >= 0) object->angleX = 0.0-(object->angleX);

#if	0
						printf ("sos%f\n",sos);
						printf ("objX(%d)objZ(%d)\n",objX,objZ);
						printf ("nextX(%f),nextZ(%f)\n",nextX,nextZ);
						printf ("A(%f)B(%f)C(%f)D(%f)\n",faceP->planeA,faceP->planeB,faceP->planeC,calcD);
						printf ("%f\n",object->positionY);
#endif

					}
				}

			}

			break;
		}

		next:
		index = index->next;
	}
}



/***********************************************************************
		Rc`̏ݒ
***********************************************************************/
extern	void	DrawInit()
{
	int			BGcount		= TestMapData.count;
	DrawList	objectP;
	objectP.ground = TestMapData.ground;

	InitAreaList(AreaList,maxarea);				/* GA}bvf[^ւindextable	*/
	InitAreaData(AreaData,maxmap);				/* ő}bvTCY						*/
	SetAreaData(AreaList,AreaData,&objectP);	/* qnl̃}bvf[^o^			*/

}

/***********************************************************************
		Rc`惁C[`
***********************************************************************/

extern	void	DrawMain(camera)
CameraInfo	*camera;
{

	int			BGcount		= TestMapData.count;
	GroundInfo	*groundP	= TestMapData.ground;

	DrawBackScreen(camera);						/* bitmap NA					*/

	/* MakeList(BGcount,groundP,drawlist);		/* J͈͂drawXg쐬		*/

#if	0
	MakeDispList(camera,drawlist,AreaList);
#endif

	DrawScreen(camera,drawlist);				/* drawXgɏ]Fill			*/

}

/***********************************************************************
		}bvf[^𑦎 << DRAWLIST >>
***********************************************************************/

MakeList(BGcount,groundP,dlist)
int			BGcount;
GroundInfo	*groundP;
DrawList	*dlist;
{

	DrawList	*droot = dlist;

	while(BGcount--){
		dlist->ground = groundP;
		dlist++;
		groundP++;
	}
	dlist->ground = NULL;

}

/***********************************************************************
		IuWFNg̈ʒuƊpx̃Zbg
***********************************************************************/

extern	void	InitObject(object,wx,wy,wz,ax,ay,az)
ObjectInfo	*object;
int			wx,wy,wz;
int			ax,ay,az;
{

	object->positionX = wx;
	object->positionY = wy;
	object->positionZ = wz;

	object->angleX = ax;
	object->angleY = ay;
	object->angleZ = az;

}


/***********************************************************************
		wi̕`
***********************************************************************/

#define		ZOOM			400
#define		groundColor		0x2e
#define		skyColor		0x2f

DrawBackScreen(camera)
CameraInfo	*camera;
{
	extern	GC		GameGC;
	extern	Pixmap	GamePixmap;
	int		gy;
	double	ang;

	/* rbg}bv̈nʂƋ̗̈œh蕪 */

	XSetForeground(display,GameGC,skyColor);
	XFillRectangle (display,GamePixmap,GameGC,0,0,GamePixmapWidth,GamePixmapHeight);

	ang = tan ( ((double)(camera->angleX)/1024) *2*3.141592);
	if (ang != 0) {
		ang = ZOOM*(-ang);
	}
	gy = (GamePixmapHeight/2)+ ang;
	if (gy < 0 ){
		gy = 0;
	}

	XSetForeground(display,GameGC,groundColor);
	XFillRectangle (display,GamePixmap,GameGC,0,gy,GamePixmapWidth,GamePixmapHeight-gy);

}


