/************************************************************************
                                                                         
               Project Reality Code name RACE1                           
                                                                         
                    ++ 3D shape data ++                                  
                                                                         
************************************************************************/

#include	"map.h"

/************************************************************************
 		The mount4 	
************************************************************************/

static PointData mount4Points[] = { 
	{    256,   272,     0,  0, 0.364040, 0.931383, 0.000000 },
	{    128,   416,     0,  0, 0.610337, 0.792142, 0.000000 },
	{    128,     0,  1024,  0, 0.303032, 0.890060, 0.340537 },
	{    256,     0,  1024,  0, 0.000000, 0.966485, 0.256723 },
	{    384,     0,  1024,  0, 0.207548, 0.958317, 0.196348 },
	{    384,   176,     0,  0, 0.363003, 0.931788, 0.000000 },
	{    512,   112,     0,  0, 0.271623, 0.962404, 0.000000 },
	{    512,     0,  1024,  0, 0.151997, 0.980028, 0.128226 },
	{    640,     0,  1024,  0, 0.118553, 0.989909, 0.077629 },
	{    640,    64,     0,  0, 0.200156, 0.979764, 0.000000 },
	{    768,     0,  1024,  0, 0.081358, 0.995817, 0.041586 },
	{    768,    32,     0,  0, 0.122805, 0.992431, 0.000000 },
	{    896,     0,  1024,  0, 0.041412, 0.998925, 0.020823 },
	{    896,    16,     0,  0, 0.082834, 0.996563, 0.000000 },
	{    128,     0, -1024,  0, 0.303032, 0.890060,-0.340537 },
	{    256,     0, -1024,  0, 0.000000, 0.966485,-0.256723 },
	{    384,     0, -1024,  0, 0.207548, 0.958317,-0.196348 },
	{    512,     0, -1024,  0, 0.151997, 0.980028,-0.128226 },
	{    640,     0, -1024,  0, 0.118553, 0.989909,-0.077629 },
	{    768,     0, -1024,  0, 0.081358, 0.995817,-0.041586 },
	{   1024,     0,     0,  0, 0.124035, 0.992278, 0.000000 },
	{   1024,     0,  1024,  0, 0.062139, 0.998037, 0.007827 },
	{   1024,     0, -1024,  0, 0.062139, 0.998037,-0.007827 },
	{    896,     0, -1024,  0, 0.041412, 0.998925,-0.020823 },
	{      0,   480,     0,  0, 0.000000, 1.000000, 0.000000 },
	{      0,     0, -1024,  0, 0.000000, 0.905459,-0.424434 },
	{      0,     0,  1024,  0, 0.000000, 0.905459, 0.424434 },
	{  -1024,     0,  1024,  0,-0.062139, 0.998037, 0.007827 },
	{   -896,     0,  1024,  0,-0.041412, 0.998925, 0.020823 },
	{   -896,    16,     0,  0,-0.082834, 0.996563, 0.000000 },
	{  -1024,     0,     0,  0,-0.124035, 0.992278, 0.000000 },
	{  -1024,     0, -1024,  0,-0.062139, 0.998037,-0.007827 },
	{   -896,     0, -1024,  0,-0.041412, 0.998925,-0.020823 },
	{   -128,     0,  1024,  0,-0.303032, 0.890060, 0.340537 },
	{   -128,   416,     0,  0,-0.610337, 0.792142, 0.000000 },
	{   -128,     0, -1024,  0,-0.303032, 0.890060,-0.340537 },
	{   -768,    32,     0,  0,-0.122805, 0.992431, 0.000000 },
	{   -256,   272,     0,  0,-0.364040, 0.931383, 0.000000 },
	{   -256,     0, -1024,  0, 0.000000, 0.966485,-0.256723 },
	{   -384,     0, -1024,  0,-0.207548, 0.958317,-0.196348 },
	{   -384,   176,     0,  0,-0.363003, 0.931788, 0.000000 },
	{   -512,   112,     0,  0,-0.271623, 0.962404, 0.000000 },
	{   -512,     0, -1024,  0,-0.151997, 0.980028,-0.128226 },
	{   -640,     0, -1024,  0,-0.118553, 0.989909,-0.077629 },
	{   -640,    64,     0,  0,-0.200156, 0.979764, 0.000000 },
	{   -768,     0, -1024,  0,-0.081358, 0.995817,-0.041586 },
	{   -768,     0,  1024,  0,-0.081358, 0.995817, 0.041586 },
	{   -256,     0,  1024,  0, 0.000000, 0.966485, 0.256723 },
	{   -384,     0,  1024,  0,-0.207548, 0.958317, 0.196348 },
	{   -512,     0,  1024,  0,-0.151997, 0.980028, 0.128226 },
	{   -640,     0,  1024,  0,-0.118553, 0.989909, 0.077629 }
};

static FaceData mount4Faces[] = { 
	{ 3,  8,  256,  128,  416,    0, 1024,    0, 0.721589, 0.641413, 0.260574, -359.191101,{  0,  1,  2} },
	{ 3,  8,  256,  128,  272,    0, 1024,    0, 0.000000, 0.966485, 0.256723, -262.883942,{  3,  0,  2} },
	{ 3,  8,  384,  256,  272,    0, 1024,    0, 0.594407, 0.792543, 0.136218, -367.739990,{  4,  5,  0} },
	{ 3,  8,  384,  256,  272,    0, 1024,    0, 0.000000, 0.966485, 0.256723, -262.883942,{  4,  0,  3} },
	{ 3,  8,  512,  384,  176,    0, 1024,    0, 0.445089, 0.890178, 0.097363, -327.585388,{  6,  5,  7} },
	{ 3,  8,  512,  384,  176,    0, 1024,    0, 0.000000, 0.985549, 0.169391, -173.456604,{  7,  5,  4} },
	{ 3,  8,  640,  512,  112,    0, 1024,    0, 0.350524, 0.934730, 0.058421, -284.157898,{  8,  9,  6} },
	{ 3,  8,  640,  512,  112,    0, 1024,    0, 0.000000, 0.994072, 0.108727, -111.336029,{  8,  6,  7} },
	{ 3,  8,  768,  640,   64,    0, 1024,    0, 0.242424, 0.969697, 0.030303, -217.212128,{ 10, 11,  9} },
	{ 3,  8,  768,  640,   64,    0, 1024,    0, 0.000000, 0.998053, 0.062378,  -63.875366,{ 10,  9,  8} },
	{ 3,  8,  896,  768,   32,    0, 1024,    0, 0.124020, 0.992159, 0.015502, -126.996307,{ 12, 13, 11} },
	{ 3,  8,  896,  768,   32,    0, 1024,    0, 0.000000, 0.999512, 0.031235,  -31.984386,{ 12, 11, 10} },
	{ 3,  8,  256,  128,  416,    0,    0,-1024, 0.721589, 0.641413,-0.260574, -359.191101,{  0, 14,  1} },
	{ 3,  8,  256,  128,  272,    0,    0,-1024, 0.000000, 0.966485,-0.256723, -262.883942,{ 15, 14,  0} },
	{ 3,  8,  384,  256,  272,    0,    0,-1024, 0.594407, 0.792543,-0.136218, -367.739990,{ 16,  0,  5} },
	{ 3,  8,  384,  256,  272,    0,    0,-1024, 0.000000, 0.966485,-0.256723, -262.883942,{ 16, 15,  0} },
	{ 3,  8,  512,  384,  176,    0,    0,-1024, 0.445089, 0.890178,-0.097363, -327.585388,{  6, 17,  5} },
	{ 3,  8,  512,  384,  176,    0,    0,-1024, 0.000000, 0.985549,-0.169391, -173.456604,{ 17, 16,  5} },
	{ 3,  8,  640,  512,  112,    0,    0,-1024, 0.350524, 0.934730,-0.058421, -284.157898,{ 18,  6,  9} },
	{ 3,  8,  640,  512,  112,    0,    0,-1024, 0.000000, 0.994072,-0.108727, -111.336029,{ 18, 17,  6} },
	{ 3,  8,  768,  640,   64,    0,    0,-1024, 0.242424, 0.969697,-0.030303, -217.212128,{ 19,  9, 11} },
	{ 3,  8,  768,  640,   64,    0,    0,-1024, 0.000000, 0.998053,-0.062378,  -63.875366,{ 19, 18,  9} },
	{ 3,  8, 1024,  896,   16,    0, 1024,    0, 0.124035, 0.992278, 0.000000, -127.011566,{ 20, 13, 21} },
	{ 3,  8, 1024,  896,   16,    0, 1024,    0, 0.000000, 0.999878, 0.015623,  -15.998047,{ 13, 12, 21} },
	{ 3,  8, 1024,  896,   16,    0,    0,-1024, 0.000000, 0.999878,-0.015623,  -15.998047,{ 22, 23, 13} },
	{ 3,  8, 1024,  896,   16,    0,    0,-1024, 0.124035, 0.992278, 0.000000, -127.011566,{ 22, 13, 20} },
	{ 3,  8,  128,    0,  480,    0,    0,-1024, 0.420326, 0.840651,-0.341514, -403.512512,{ 14, 24,  1} },
	{ 3,  8,  128,    0,  480,    0,    0,-1024, 0.000000, 0.905459,-0.424434, -434.620300,{ 14, 25, 24} },
	{ 3,  8,  128,    0,  480,    0, 1024,    0, 0.420326, 0.840651, 0.341514, -403.512512,{  1, 24,  2} },
	{ 3,  8,  128,    0,  480,    0, 1024,    0, 0.000000, 0.905459, 0.424434, -434.620300,{ 24, 26,  2} },
	{ 3,  8,  896,  768,   32,    0,    0,-1024, 0.124020, 0.992159,-0.015502, -126.996307,{ 23, 11, 13} },
	{ 3,  8,  896,  768,   32,    0,    0,-1024, 0.000000, 0.999512,-0.031235,  -31.984386,{ 23, 19, 11} },
	{ 3,  8, -896,-1024,   16,    0, 1024,    0, 0.000000, 0.999878, 0.015623,  -15.998047,{ 27, 28, 29} },
	{ 3,  8, -896,-1024,   16,    0, 1024,    0,-0.124035, 0.992278, 0.000000, -127.011566,{ 27, 29, 30} },
	{ 3,  8, -896,-1024,   16,    0,    0,-1024,-0.124035, 0.992278, 0.000000, -127.011566,{ 30, 29, 31} },
	{ 3,  8, -896,-1024,   16,    0,    0,-1024, 0.000000, 0.999878,-0.015623,  -15.998047,{ 29, 32, 31} },
	{ 3,  8,    0, -128,  480,    0, 1024,    0,-0.420326, 0.840651, 0.341514, -403.512512,{ 33, 24, 34} },
	{ 3,  8,    0, -128,  480,    0, 1024,    0, 0.000000, 0.905459, 0.424434, -434.620300,{ 33, 26, 24} },
	{ 3,  8,    0, -128,  480,    0,    0,-1024,-0.420326, 0.840651,-0.341514, -403.512512,{ 34, 24, 35} },
	{ 3,  8,    0, -128,  480,    0,    0,-1024, 0.000000, 0.905459,-0.424434, -434.620300,{ 24, 25, 35} },
	{ 3,  8, -768, -896,   32,    0, 1024,    0,-0.124020, 0.992159, 0.015502, -126.996307,{ 28, 36, 29} },
	{ 3,  8, -128, -256,  416,    0,    0,-1024,-0.721589, 0.641413,-0.260574, -359.191101,{ 37, 34, 35} },
	{ 3,  8, -128, -256,  272,    0,    0,-1024, 0.000000, 0.966485,-0.256723, -262.883942,{ 38, 37, 35} },
	{ 3,  8, -256, -384,  272,    0,    0,-1024,-0.594407, 0.792543,-0.136218, -367.739990,{ 39, 40, 37} },
	{ 3,  8, -256, -384,  272,    0,    0,-1024, 0.000000, 0.966485,-0.256723, -262.883942,{ 39, 37, 38} },
	{ 3,  8, -384, -512,  176,    0,    0,-1024,-0.445089, 0.890178,-0.097363, -327.585388,{ 41, 40, 42} },
	{ 3,  8, -384, -512,  176,    0,    0,-1024, 0.000000, 0.985549,-0.169391, -173.456604,{ 42, 40, 39} },
	{ 3,  8, -512, -640,  112,    0,    0,-1024,-0.350524, 0.934730,-0.058421, -284.157898,{ 43, 44, 41} },
	{ 3,  8, -512, -640,  112,    0,    0,-1024, 0.000000, 0.994072,-0.108727, -111.336029,{ 43, 41, 42} },
	{ 3,  8, -640, -768,   64,    0,    0,-1024,-0.242424, 0.969697,-0.030303, -217.212128,{ 45, 36, 44} },
	{ 3,  8, -640, -768,   64,    0,    0,-1024, 0.000000, 0.998053,-0.062378,  -63.875366,{ 45, 44, 43} },
	{ 3,  8, -768, -896,   32,    0,    0,-1024,-0.124020, 0.992159,-0.015502, -126.996307,{ 32, 29, 36} },
	{ 3,  8, -768, -896,   32,    0,    0,-1024, 0.000000, 0.999512,-0.031235,  -31.984386,{ 32, 36, 45} },
	{ 3,  8, -768, -896,   32,    0, 1024,    0, 0.000000, 0.999512, 0.031235,  -31.984386,{ 28, 46, 36} },
	{ 3,  8, -128, -256,  416,    0, 1024,    0,-0.721589, 0.641413, 0.260574, -359.191101,{ 37, 33, 34} },
	{ 3,  8, -128, -256,  272,    0, 1024,    0, 0.000000, 0.966485, 0.256723, -262.883942,{ 47, 33, 37} },
	{ 3,  8, -256, -384,  272,    0, 1024,    0,-0.594407, 0.792543, 0.136218, -367.739990,{ 48, 37, 40} },
	{ 3,  8, -256, -384,  272,    0, 1024,    0, 0.000000, 0.966485, 0.256723, -262.883942,{ 48, 47, 37} },
	{ 3,  8, -384, -512,  176,    0, 1024,    0,-0.445089, 0.890178, 0.097363, -327.585388,{ 41, 49, 40} },
	{ 3,  8, -384, -512,  176,    0, 1024,    0, 0.000000, 0.985549, 0.169391, -173.456604,{ 49, 48, 40} },
	{ 3,  8, -512, -640,  112,    0, 1024,    0,-0.350524, 0.934730, 0.058421, -284.157898,{ 50, 41, 44} },
	{ 3,  8, -512, -640,  112,    0, 1024,    0, 0.000000, 0.994072, 0.108727, -111.336029,{ 50, 49, 41} },
	{ 3,  8, -640, -768,   64,    0, 1024,    0,-0.242424, 0.969697, 0.030303, -217.212128,{ 46, 44, 36} },
	{ 3,  8, -640, -768,   64,    0, 1024,    0, 0.000000, 0.998053, 0.062378,  -63.875366,{ 46, 50, 44} }
};

ShapeInfo	mount4 = { 51,64,64,1024,1024,480,1024,0,mount4Points,mount4Faces };

/************************************************************************
 		The bridge2 	
************************************************************************/

static PointData bridge2Points[] = { 
	{  -1024,     0,  1024,  0,-0.365652, 0.930752, 0.000000 },
	{   -128,   352,  1024,  0,-0.557354, 0.770165,-0.310165 },
	{  -1024,     0,   768,  0,-0.095644, 0.984679,-0.145807 },
	{      0,     0,   640,  0, 0.000000, 0.929574,-0.368635 },
	{   1024,     0,  1024,  0, 0.365652, 0.930752, 0.000000 },
	{   1024,     0,   768,  0, 0.162745, 0.954966,-0.248101 },
	{    128,   352,  1024,  0, 0.557354, 0.770165,-0.310165 },
	{   1024,     0, -1024,  0, 0.365652, 0.930752, 0.000000 },
	{    128,   352, -1024,  0, 0.557354, 0.770165, 0.310165 },
	{   1024,     0,  -768,  0, 0.162745, 0.954966, 0.248101 },
	{      0,     0,  -640,  0, 0.000000, 0.948959, 0.315400 },
	{   -128,   352, -1024,  0,-0.557354, 0.770165, 0.310165 },
	{  -1024,   -64,   192,  0, 0.124850, 0.918762,-0.374551 },
	{   -640,   -64,   320,  0, 0.007754, 0.925729,-0.378108 },
	{   -640,   -64,     0,  0,-0.018001, 0.958183, 0.285588 },
	{  -1024,   -64,  -192,  0,-0.140789, 0.949153, 0.281579 },
	{    352,   -64,    32,  0,-0.009572, 0.925202,-0.379353 },
	{    320,   -64,  -352,  0, 0.019522, 0.957524, 0.287692 },
	{   1024,   -64,   192,  0, 0.090110, 0.921220,-0.378462 },
	{   1024,   -64,  -192,  0,-0.065460, 0.955384, 0.288023 },
	{   -640,     0,   -96,  0,-0.018001, 0.958183, 0.285588 },
	{  -1024,     0,  -288,  0,-0.093291, 0.978000, 0.186582 },
	{    320,     0,  -448,  0, 0.019522, 0.957524, 0.287692 },
	{   1024,     0,  -288,  0,-0.065460, 0.955384, 0.288023 },
	{  -1024,     0,   256,  0, 0.082393, 0.965461,-0.247178 },
	{   -640,     0,   384,  0, 0.005098, 0.968600,-0.248573 },
	{    352,     0,    96,  0,-0.009572, 0.925202,-0.379353 },
	{   1024,     0,   256,  0, 0.090110, 0.921220,-0.378462 },
	{  -1024,     0,  -768,  0,-0.162745, 0.954966, 0.248101 },
	{  -1024,     0, -1024,  0,-0.365652, 0.930752, 0.000000 },
	{   -128,   320,  -960,  0,-1.000000, 0.000000, 0.000000 },
	{   -128,   320,   960,  0,-1.000000, 0.000000, 0.000000 },
	{    128,   320,   960,  0, 1.000000, 0.000000, 0.000000 },
	{    128,   320,  -960,  0, 1.000000, 0.000000, 0.000000 },
	{    128,   448,  -800,  0, 0.948683, 0.316228, 0.000000 },
	{    128,   416,  -800,  0, 1.000000, 0.000000, 0.000000 },
	{    128,   352,  -992,  0, 1.000000, 0.000000, 0.000000 },
	{    128,   512,  -448,  0, 0.948683, 0.316228, 0.000000 },
	{    128,   480,  -448,  0, 1.000000, 0.000000, 0.000000 },
	{    128,   544,     0,  0, 1.000000, 0.000000, 0.000000 },
	{    128,   512,     0,  0, 1.000000, 0.000000, 0.000000 },
	{    128,   512,   448,  0, 0.948683, 0.316228, 0.000000 },
	{    128,   480,   448,  0, 1.000000, 0.000000, 0.000000 },
	{    128,   448,   800,  0, 0.948683, 0.316228, 0.000000 },
	{    128,   416,   800,  0, 1.000000, 0.000000, 0.000000 },
	{    128,   352,   992,  0, 1.000000, 0.000000, 0.000000 },
	{    128,   448,  -768,  0, 0.707107, 0.707107, 0.000000 },
	{    128,   352,  -768,  0, 1.000000, 0.000000, 0.000000 },
	{    128,   352,  -800,  0, 1.000000, 0.000000, 0.000000 },
	{    128,   512,  -416,  0, 0.707107, 0.707107, 0.000000 },
	{    128,   352,  -416,  0, 1.000000, 0.000000, 0.000000 },
	{    128,   352,  -448,  0, 1.000000, 0.000000, 0.000000 },
	{    128,   544,   -32,  0, 0.707107, 0.707107, 0.000000 },
	{    128,   544,    32,  0, 0.707107, 0.707107, 0.000000 },
	{    128,   352,    32,  0, 1.000000, 0.000000, 0.000000 },
	{    128,   352,   -32,  0, 1.000000, 0.000000, 0.000000 },
	{    128,   512,   416,  0, 0.707107, 0.707107, 0.000000 },
	{    128,   352,   448,  0, 1.000000, 0.000000, 0.000000 },
	{    128,   352,   416,  0, 1.000000, 0.000000, 0.000000 },
	{    128,   448,   768,  0, 0.707107, 0.707107, 0.000000 },
	{    128,   352,   800,  0, 1.000000, 0.000000, 0.000000 },
	{    128,   352,   768,  0, 1.000000, 0.000000, 0.000000 },
	{   -128,   448,   800,  0,-0.948683, 0.316228, 0.000000 },
	{   -128,   416,   800,  0,-1.000000, 0.000000, 0.000000 },
	{   -128,   352,   992,  0,-1.000000, 0.000000, 0.000000 },
	{   -128,   512,   448,  0,-0.948683, 0.316228, 0.000000 },
	{   -128,   480,   448,  0,-1.000000, 0.000000, 0.000000 },
	{   -128,   544,     0,  0,-1.000000, 0.000000, 0.000000 },
	{   -128,   512,     0,  0,-1.000000, 0.000000, 0.000000 },
	{   -128,   512,  -448,  0,-0.948683, 0.316228, 0.000000 },
	{   -128,   480,  -448,  0,-1.000000, 0.000000, 0.000000 },
	{   -128,   448,  -800,  0,-0.948683, 0.316228, 0.000000 },
	{   -128,   416,  -800,  0,-1.000000, 0.000000, 0.000000 },
	{   -128,   352,  -992,  0,-1.000000, 0.000000, 0.000000 },
	{   -128,   448,   768,  0,-0.707107, 0.707107, 0.000000 },
	{   -128,   352,   768,  0,-1.000000, 0.000000, 0.000000 },
	{   -128,   352,   800,  0,-1.000000, 0.000000, 0.000000 },
	{   -128,   512,   416,  0,-0.707107, 0.707107, 0.000000 },
	{   -128,   352,   416,  0,-1.000000, 0.000000, 0.000000 },
	{   -128,   352,   448,  0,-1.000000, 0.000000, 0.000000 },
	{   -128,   544,    32,  0,-0.707107, 0.707107, 0.000000 },
	{   -128,   544,   -32,  0,-0.707107, 0.707107, 0.000000 },
	{   -128,   352,   -32,  0,-1.000000, 0.000000, 0.000000 },
	{   -128,   352,    32,  0,-1.000000, 0.000000, 0.000000 },
	{   -128,   512,  -416,  0,-0.707107, 0.707107, 0.000000 },
	{   -128,   352,  -448,  0,-1.000000, 0.000000, 0.000000 },
	{   -128,   352,  -416,  0,-1.000000, 0.000000, 0.000000 },
	{   -128,   448,  -768,  0,-0.707107, 0.707107, 0.000000 },
	{   -128,   352,  -800,  0,-1.000000, 0.000000, 0.000000 },
	{   -128,   352,  -768,  0,-1.000000, 0.000000, 0.000000 }
};

static FaceData bridge2Faces[] = { 
	{ 3, 13, -128,-1024,  352,    0, 1024,  768,-0.365652, 0.930752, 0.000000, -374.428040,{  0,  1,  2} },
	{ 3, 13,    0,-1024,  352,    0, 1024,  640,-0.086082, 0.719959,-0.688657,  440.740387,{  1,  3,  2} },
	{ 3, 13, 1024,  128,  352,    0, 1024,  768, 0.365652, 0.930752, 0.000000, -374.428040,{  4,  5,  6} },
	{ 3, 13, 1024,    0,  352,    0, 1024,  640, 0.086082, 0.719959,-0.688657,  440.740387,{  6,  5,  3} },
	{ 3, 13, 1024,  128,  352,    0, -768,-1024, 0.365652, 0.930752, 0.000000, -374.428040,{  7,  8,  9} },
	{ 3, 13, 1024,    0,  352,    0, -640,-1024, 0.086082, 0.719959, 0.688657,  440.740387,{  8, 10,  9} },
	{ 3, 13,  128, -128,  352,    0, 1024,  640, 0.000000, 0.737154,-0.675725,  432.463776,{  1,  6,  3} },
	{ 3, 13,  128, -128,  352,    0, -640,-1024, 0.000000, 0.737154, 0.675725,  432.463776,{ 11, 10,  8} },
	{ 4,191, -640,-1024,  -64,  -64,  320, -192, 0.000000, 1.000000, 0.000000,   64.000000,{ 12, 13, 14, 15} },
	{ 4,191,  352, -640,  -64,  -64,  320, -352, 0.000000, 1.000000, 0.000000,   64.000000,{ 13, 16, 17, 14} },
	{ 4,191, 1024,  320,  -64,  -64,  192, -352, 0.000000, 1.000000, 0.000000,   64.000000,{ 18, 19, 17, 16} },
	{ 4,143, -640,-1024,    0,  -64,    0, -288,-0.267261, 0.801784, 0.534522, -119.733032,{ 15, 14, 20, 21} },
	{ 4,143,  320, -640,    0,  -64,    0, -448, 0.199309, 0.815357, 0.543571,  179.740814,{ 14, 17, 22, 20} },
	{ 4,143, 1024,  320,    0,  -64, -192, -448,-0.125078, 0.825516, 0.550344,  286.579163,{ 17, 19, 23, 22} },
	{ 4,141, -640,-1024,    0,  -64,  384,  192, 0.229416, 0.688247,-0.688247,  411.112976,{ 24, 25, 13, 12} },
	{ 4,141,  352, -640,    0,  -64,  384,   32,-0.201095, 0.692662,-0.692662,  137.281082,{ 25, 26, 16, 13} },
	{ 4,141, 1024,  352,    0,  -64,  256,   32, 0.166022, 0.697294,-0.697294,    8.500344,{ 26, 27, 18, 16} },
	{ 3,221,    0,-1024,    0,    0,  768,  384, 0.000000, 1.000000, 0.000000,    0.000000,{  2,  3, 25} },
	{ 3,220, -640,-1024,    0,    0,  768,  256, 0.000000, 1.000000, 0.000000,    0.000000,{  2, 25, 24} },
	{ 3,220, -640,-1024,    0,    0,  768,  256, 0.000000, 1.000000, 0.000000,    0.000000,{  2, 25, 24} },
	{ 2,221,  352,    0,    0,    0,  640,   96, 0.275954, 0.944440, 0.178558, -114.277222,{  3, 26} },
	{ 4,222, 1024,    0,    0,    0,  768,   96, 0.000000, 1.000000, 0.000000,    0.000000,{  3,  5, 27, 26} },
	{ 3, 13, -128,-1024,  352,    0, -768,-1024,-0.365652, 0.930752, 0.000000, -374.428040,{ 28, 11, 29} },
	{ 3, 13,    0,-1024,  352,    0, -640,-1024,-0.086082, 0.719959, 0.688657,  440.740387,{ 28, 10, 11} },
	{ 3,220,    0,-1024,    0,    0, -288, -768, 0.000000, 1.000000, 0.000000,    0.000000,{ 21, 10, 28} },
	{ 3,221,    0,-1024,    0,    0,  -96, -640, 0.000000, 1.000000, 0.000000,    0.000000,{ 21, 20, 10} },
	{ 3,220,  320, -640,    0,    0,  -96, -640, 0.000000, 1.000000, 0.000000,    0.000000,{ 20, 22, 10} },
	{ 4,222, 1024,    0,    0,    0, -288, -768, 0.000000, 1.000000, 0.000000,    0.000000,{ 22, 23,  9, 10} },
	{ 3,219,  352, -640,    0,    0,  640,   96, 0.000000, 1.000000, 0.000000,    0.000000,{  3, 26, 25} },
	{ 4,  4,  128, -128,  352,  352, 1024,-1024, 0.000000, 1.000000, 0.000000, -352.000000,{  1,  6,  8, 11} },
	{ 4, 15, -128, -128,  352,  320, 1024,-1024,-1.000000, 0.000000, 0.000000, -128.000000,{  1, 11, 30, 31} },
	{ 4, 15,  128,  128,  352,  320, 1024,-1024, 1.000000, 0.000000, 0.000000, -128.000000,{  8,  6, 32, 33} },
	{ 4,207,  128,  128,  448,  352, -800,-1024, 1.000000, 0.000000, 0.000000, -128.000000,{  8, 34, 35, 36} },
	{ 4,207,  128,  128,  512,  416, -448, -800, 1.000000, 0.000000, 0.000000, -128.000000,{ 34, 37, 38, 35} },
	{ 4,207,  128,  128,  544,  480,    0, -448, 1.000000, 0.000000, 0.000000, -128.000000,{ 37, 39, 40, 38} },
	{ 4,207,  128,  128,  544,  480,  448,    0, 1.000000, 0.000000, 0.000000, -128.000000,{ 39, 41, 42, 40} },
	{ 4,207,  128,  128,  512,  416,  800,  448, 1.000000, 0.000000, 0.000000, -128.000000,{ 41, 43, 44, 42} },
	{ 4,207,  128,  128,  448,  352, 1024,  800, 1.000000, 0.000000, 0.000000, -128.000000,{ 43,  6, 45, 44} },
	{ 4,207,  128,  128,  448,  352, -768, -800, 1.000000, 0.000000, 0.000000, -128.000000,{ 34, 46, 47, 48} },
	{ 4,207,  128,  128,  512,  352, -416, -448, 1.000000, 0.000000, 0.000000, -128.000000,{ 37, 49, 50, 51} },
	{ 4,207,  128,  128,  544,  352,   32,  -32, 1.000000, 0.000000, 0.000000, -128.000000,{ 52, 53, 54, 55} },
	{ 4,207,  128,  128,  512,  352,  448,  416, 1.000000, 0.000000, 0.000000, -128.000000,{ 56, 41, 57, 58} },
	{ 4,207,  128,  128,  448,  352,  800,  768, 1.000000, 0.000000, 0.000000, -128.000000,{ 59, 43, 60, 61} },
	{ 4,207, -128, -128,  448,  352, 1024,  800,-1.000000, 0.000000, 0.000000, -128.000000,{  1, 62, 63, 64} },
	{ 4,207, -128, -128,  512,  416,  800,  448,-1.000000, 0.000000, 0.000000, -128.000000,{ 62, 65, 66, 63} },
	{ 4,207, -128, -128,  544,  480,  448,    0,-1.000000, 0.000000, 0.000000, -128.000000,{ 65, 67, 68, 66} },
	{ 4,207, -128, -128,  544,  480,    0, -448,-1.000000, 0.000000, 0.000000, -128.000000,{ 67, 69, 70, 68} },
	{ 4,207, -128, -128,  512,  416, -448, -800,-1.000000, 0.000000, 0.000000, -128.000000,{ 69, 71, 72, 70} },
	{ 4,207, -128, -128,  448,  352, -800,-1024,-1.000000, 0.000000, 0.000000, -128.000000,{ 71, 11, 73, 72} },
	{ 4,207, -128, -128,  448,  352,  800,  768,-1.000000, 0.000000, 0.000000, -128.000000,{ 62, 74, 75, 76} },
	{ 4,207, -128, -128,  512,  352,  448,  416,-1.000000, 0.000000, 0.000000, -128.000000,{ 65, 77, 78, 79} },
	{ 4,207, -128, -128,  544,  352,   32,  -32,-1.000000, 0.000000, 0.000000, -128.000000,{ 80, 81, 82, 83} },
	{ 4,207, -128, -128,  512,  352, -416, -448,-1.000000, 0.000000, 0.000000, -128.000000,{ 84, 69, 85, 86} },
	{ 4,207, -128, -128,  448,  352, -768, -800,-1.000000, 0.000000, 0.000000, -128.000000,{ 87, 71, 88, 89} },
	{ 4,207,  128, -128,  448,  448,  800,  768, 0.000000, 1.000000, 0.000000, -448.000000,{ 62, 43, 59, 74} },
	{ 4,207,  128, -128,  512,  512,  448,  416, 0.000000, 1.000000, 0.000000, -512.000000,{ 65, 41, 56, 77} },
	{ 4,207,  128, -128,  544,  544,   32,  -32, 0.000000, 1.000000, 0.000000, -544.000000,{ 80, 53, 52, 81} },
	{ 4,207,  128, -128,  512,  512, -416, -448, 0.000000, 1.000000, 0.000000, -512.000000,{ 84, 49, 37, 69} },
	{ 4,207,  128, -128,  448,  448, -768, -800, 0.000000, 1.000000, 0.000000, -448.000000,{ 87, 46, 34, 71} }
};

ShapeInfo	bridge2 = { 90,59,59,1024,1024,544,1024,0,bridge2Points,bridge2Faces };

/************************************************************************
 		The fuji2 	
************************************************************************/

static PointData fuji2Points[] = { 
	{   -512,   416,     0,  0, 0.151682, 0.988429, 0.000000 },
	{   -768,   480,     0,  0, 0.122509, 0.992467, 0.000000 },
	{   -768,     0,  1024,  0, 0.055466, 0.909577, 0.411817 },
	{   -512,     0,  1024,  0, 0.000000, 0.926467, 0.376377 },
	{   -256,     0,  1024,  0, 0.113907, 0.939532, 0.322962 },
	{   -256,   320,     0,  0, 0.238698, 0.971094, 0.000000 },
	{      0,   224,     0,  0, 0.238223, 0.971210, 0.000000 },
	{      0,     0,  1024,  0, 0.116347, 0.963517, 0.241035 },
	{    256,     0,  1024,  0, 0.118012, 0.981057, 0.153624 },
	{    256,   128,     0,  0, 0.200256, 0.979744, 0.000000 },
	{    512,     0,  1024,  0, 0.081270, 0.993239, 0.082897 },
	{    512,    64,     0,  0, 0.122809, 0.992430, 0.000000 },
	{    768,     0,  1024,  0, 0.041401, 0.998276, 0.041611 },
	{    768,    32,     0,  0, 0.082839, 0.996563, 0.000000 },
	{   -768,     0, -1024,  0, 0.055466, 0.909577,-0.411817 },
	{   -512,     0, -1024,  0, 0.000000, 0.926467,-0.376377 },
	{   -256,     0, -1024,  0, 0.113907, 0.939532,-0.322962 },
	{      0,     0, -1024,  0, 0.116347, 0.963517,-0.241035 },
	{    256,     0, -1024,  0, 0.118012, 0.981057,-0.153624 },
	{    512,     0, -1024,  0, 0.081270, 0.993239,-0.082897 },
	{   1024,     0,     0,  0, 0.124035, 0.992278, 0.000000 },
	{   1024,     0,  1024,  0, 0.062145, 0.997944, 0.015650 },
	{   1024,     0, -1024,  0, 0.062145, 0.997944,-0.015650 },
	{    768,     0, -1024,  0, 0.041401, 0.998276,-0.041611 },
	{  -1024,   480,     0,  0, 0.000000, 1.000000, 0.000000 },
	{  -1024,     0, -1024,  0, 0.000000, 0.905459,-0.424434 },
	{  -1024,     0,  1024,  0, 0.000000, 0.905459, 0.424434 }
};

static FaceData fuji2Faces[] = { 
	{ 3, 13, -512, -768,  480,    0, 1024,    0, 0.220779, 0.883116, 0.413960, -254.337326,{  0,  1,  2} },
	{ 3, 13, -512, -768,  416,    0, 1024,    0, 0.000000, 0.926467, 0.376377, -385.410095,{  3,  0,  2} },
	{ 3, 13, -256, -512,  416,    0, 1024,    0, 0.336994, 0.898650, 0.280828, -201.297485,{  4,  5,  0} },
	{ 3, 13, -256, -512,  416,    0, 1024,    0, 0.000000, 0.926467, 0.376377, -385.410095,{  4,  0,  3} },
	{ 3, 13,    0, -256,  320,    0, 1024,    0, 0.343982, 0.917286, 0.200656, -205.472031,{  6,  5,  7} },
	{ 3, 13,    0, -256,  320,    0, 1024,    0, 0.000000, 0.954480, 0.298275, -305.433594,{  7,  5,  4} },
	{ 3, 13,  256,    0,  224,    0, 1024,    0, 0.348743, 0.929981, 0.116248, -208.315765,{  8,  9,  6} },
	{ 3, 13,  256,    0,  224,    0, 1024,    0, 0.000000, 0.976900, 0.213697, -218.825607,{  8,  6,  7} },
	{ 3, 13,  512,  256,  128,    0, 1024,    0, 0.242091, 0.968364, 0.060523, -185.925903,{ 10, 11,  9} },
	{ 3, 13,  512,  256,  128,    0, 1024,    0, 0.000000, 0.992278, 0.124035, -127.011566,{ 10,  9,  8} },
	{ 3, 13,  768,  512,   64,    0, 1024,    0, 0.123975, 0.991801, 0.030994, -126.950546,{ 12, 13, 11} },
	{ 3, 13,  768,  512,   64,    0, 1024,    0, 0.000000, 0.998053, 0.062378,  -63.875366,{ 12, 11, 10} },
	{ 3, 13, -512, -768,  480,    0,    0,-1024, 0.220779, 0.883116,-0.413960, -254.337326,{  0, 14,  1} },
	{ 3, 13, -512, -768,  416,    0,    0,-1024, 0.000000, 0.926467,-0.376377, -385.410095,{ 15, 14,  0} },
	{ 3, 13, -256, -512,  416,    0,    0,-1024, 0.336994, 0.898650,-0.280828, -201.297485,{ 16,  0,  5} },
	{ 3, 13, -256, -512,  416,    0,    0,-1024, 0.000000, 0.926467,-0.376377, -385.410095,{ 16, 15,  0} },
	{ 3, 13,    0, -256,  320,    0,    0,-1024, 0.343982, 0.917286,-0.200656, -205.472031,{  6, 17,  5} },
	{ 3, 13,    0, -256,  320,    0,    0,-1024, 0.000000, 0.954480,-0.298275, -305.433594,{ 17, 16,  5} },
	{ 3, 13,  256,    0,  224,    0,    0,-1024, 0.348743, 0.929981,-0.116248, -208.315765,{ 18,  6,  9} },
	{ 3, 13,  256,    0,  224,    0,    0,-1024, 0.000000, 0.976900,-0.213697, -218.825607,{ 18, 17,  6} },
	{ 3, 13,  512,  256,  128,    0,    0,-1024, 0.242091, 0.968364,-0.060523, -185.925903,{ 19,  9, 11} },
	{ 3, 13,  512,  256,  128,    0,    0,-1024, 0.000000, 0.992278,-0.124035, -127.011566,{ 19, 18,  9} },
	{ 3, 13, 1024,  768,   32,    0, 1024,    0, 0.124035, 0.992278, 0.000000, -127.011566,{ 20, 13, 21} },
	{ 3, 13, 1024,  768,   32,    0, 1024,    0, 0.000000, 0.999512, 0.031235,  -31.984386,{ 13, 12, 21} },
	{ 3, 13, 1024,  768,   32,    0,    0,-1024, 0.000000, 0.999512,-0.031235,  -31.984386,{ 22, 23, 13} },
	{ 3, 13, 1024,  768,   32,    0,    0,-1024, 0.124035, 0.992278, 0.000000, -127.011566,{ 22, 13, 20} },
	{ 3, 13, -768,-1024,  480,    0,    0,-1024, 0.000000, 0.905459,-0.424434, -434.620300,{ 14, 24,  1} },
	{ 3, 13, -768,-1024,  480,    0,    0,-1024, 0.000000, 0.905459,-0.424434, -434.620300,{ 14, 25, 24} },
	{ 3, 13, -768,-1024,  480,    0, 1024,    0, 0.000000, 0.905459, 0.424434, -434.620300,{  1, 24,  2} },
	{ 3, 13, -768,-1024,  480,    0, 1024,    0, 0.000000, 0.905459, 0.424434, -434.620300,{ 24, 26,  2} },
	{ 3, 13,  768,  512,   64,    0,    0,-1024, 0.123975, 0.991801,-0.030994, -126.950546,{ 23, 11, 13} },
	{ 3, 13,  768,  512,   64,    0,    0,-1024, 0.000000, 0.998053,-0.062378,  -63.875366,{ 23, 19, 11} }
};

ShapeInfo	fuji2 = { 27,32,32,1024,1024,480,1024,0,fuji2Points,fuji2Faces };

/************************************************************************
 		The loadEW 	
************************************************************************/

static PointData loadEWPoints[] = { 
	{   1024,     0,  1024,  0, 0.000000, 1.000000, 0.000000 },
	{   1024,     0,   128,  0, 0.000000, 1.000000, 0.000000 },
	{    320,     0,   128,  0, 0.000000, 1.000000, 0.000000 },
	{   -640,     0,  1024,  0, 0.000000, 1.000000, 0.000000 },
	{  -1024,     0,   128,  0, 0.000000, 1.000000, 0.000000 },
	{  -1024,     0,  1024,  0, 0.000000, 1.000000, 0.000000 },
	{   1024,     0,  -128,  0, 0.000000, 1.000000, 0.000000 },
	{   1024,     0, -1024,  0, 0.000000, 1.000000, 0.000000 },
	{   -640,     0, -1024,  0, 0.000000, 1.000000, 0.000000 },
	{  -1024,     0,  -128,  0, 0.000000, 1.000000, 0.000000 },
	{  -1024,     0, -1024,  0, 0.000000, 1.000000, 0.000000 }
};

static FaceData loadEWFaces[] = { 
	{ 3,222, 1024,  320,    0,    0, 1024,  128, 0.000000, 1.000000, 0.000000,    0.000000,{  0,  1,  2} },
	{ 3,221, 1024, -640,    0,    0, 1024,  128, 0.000000, 1.000000, 0.000000,    0.000000,{  0,  2,  3} },
	{ 4,222,  320,-1024,    0,    0, 1024,  128, 0.000000, 1.000000, 0.000000,    0.000000,{  2,  4,  5,  3} },
	{ 3,221, 1024, -640,    0,    0, -128,-1024, 0.000000, 1.000000, 0.000000,    0.000000,{  6,  7,  8} },
	{ 3,222, 1024,-1024,    0,    0, -128,-1024, 0.000000, 1.000000, 0.000000,    0.000000,{  6,  8,  9} },
	{ 3,221, -640,-1024,    0,    0, -128,-1024, 0.000000, 1.000000, 0.000000,    0.000000,{  9,  8, 10} },
	{ 3, 79, 1024,  320,    0,    0,  128, -128, 0.000000, 1.000000, 0.000000,    0.000000,{  1,  6,  2} },
	{ 4, 79, 1024,-1024,    0,    0,  128, -128, 0.000000, 1.000000, 0.000000,    0.000000,{  2,  6,  9,  4} }
};

ShapeInfo	loadEW = { 11,8,8,1024,1024,0,1024,0,loadEWPoints,loadEWFaces };

/************************************************************************
 		The hito 	
************************************************************************/

static PointData hitoPoints[] = { 
	{      0,    96,    -2,  0, 0.000000,-0.928964,-0.370169 },
	{      0,   146,   -14,  0, 0.000000, 0.444905,-0.895578 },
	{    -30,   154,    24,  0,-0.873393, 0.471097, 0.123495 },
	{     30,   154,    24,  0, 0.873393, 0.471097, 0.123495 },
	{     12,   178,   -12,  0, 0.660458, 0.280119,-0.696655 },
	{    -12,   178,   -12,  0,-0.660458, 0.280119,-0.696655 },
	{      0,   190,     0,  0, 0.000000, 1.000000, 0.000000 },
	{     12,   178,    12,  0, 0.723673, 0.137942, 0.676217 },
	{    -12,   178,    12,  0,-0.723673, 0.137942, 0.676217 },
	{      0,   156,    -6,  0, 0.000000,-0.994746,-0.102372 },
	{     -6,   166,     2,  0, 0.000000, 0.000000, 0.000000 },
	{      6,   166,     2,  0, 0.000000, 0.000000, 0.000000 },
	{     14,   150,     6,  0, 0.000000, 0.000000, 0.000000 },
	{    -14,   150,     6,  0, 0.000000, 0.000000, 0.000000 },
	{    -16,   106,    12,  0,-0.929236, 0.328717, 0.168718 },
	{     16,   106,    12,  0, 0.929236, 0.328717, 0.168718 },
	{      0,   100,   -12,  0, 0.000000, 0.383064,-0.923722 },
	{      0,    78,    -2,  0, 0.000000,-0.993172,-0.116662 },
	{    -14,   100,    -4,  0, 0.000000, 0.000000, 0.000000 },
	{    -14,   102,    10,  0, 0.000000, 0.000000, 0.000000 },
	{    -14,    54,     4,  0, 0.000000, 0.000000, 0.000000 },
	{    -14,    10,     8,  0,-0.616959, 0.682986, 0.391014 },
	{    -14,    46,    16,  0, 0.000000, 0.000000, 0.000000 },
	{     14,    10,     8,  0, 0.616959, 0.682986, 0.391014 },
	{     20,     0,    16,  0, 0.844650,-0.000116, 0.535319 },
	{     14,     0,   -10,  0, 0.807976,-0.558936,-0.186456 },
	{      8,     0,    16,  0, 0.000000,-0.433189, 0.901303 },
	{    -14,     0,   -10,  0,-0.807976,-0.558936,-0.186456 },
	{    -20,     0,    16,  0,-0.844650,-0.000116, 0.535319 },
	{     24,   142,     0,  0, 0.000000, 0.000000, 0.000000 },
	{     26,   148,    14,  0, 0.000000, 0.000000, 0.000000 },
	{     32,   116,    14,  0, 0.000000, 0.000000, 0.000000 },
	{     32,    90,     8,  0,-0.921736, 0.063235, 0.382628 },
	{     32,   108,    22,  0, 0.000000, 0.000000, 0.000000 },
	{     -8,     0,    16,  0, 0.000000,-0.433189, 0.901303 },
	{    -32,   116,    14,  0, 0.000000, 0.000000, 0.000000 },
	{    -26,   148,    14,  0, 0.000000, 0.000000, 0.000000 },
	{    -24,   142,     0,  0, 0.000000, 0.000000, 0.000000 },
	{    -32,   108,    22,  0, 0.000000, 0.000000, 0.000000 },
	{    -32,    90,     8,  0, 0.921736, 0.063235, 0.382628 },
	{     14,    54,     4,  0, 0.000000, 0.000000, 0.000000 },
	{     14,   102,    10,  0, 0.000000, 0.000000, 0.000000 },
	{     14,   100,    -4,  0, 0.000000, 0.000000, 0.000000 },
	{     14,    46,    16,  0, 0.000000, 0.000000, 0.000000 },
	{    -32,    84,    10,  0, 0.993072,-0.107677,-0.047052 },
	{    -28,    90,     2,  0, 0.868222,-0.111612, 0.483460 },
	{    -32,    88,     8,  0, 0.963708,-0.264400,-0.036878 },
	{    -28,    78,    -2,  0, 0.000000, 0.000000, 0.000000 },
	{     28,    90,     2,  0,-0.868222,-0.111612, 0.483460 },
	{     32,    84,    10,  0,-0.993072,-0.107677,-0.047052 },
	{     32,    88,     8,  0,-0.963708,-0.264400,-0.036878 },
	{     28,    78,    -2,  0, 0.000000, 0.000000, 0.000000 },
	{      0,   172,   -10,  0, 0.000000, 0.000000, 0.000000 },
	{      0,   166,   -16,  0, 0.000000, 0.000000, 0.000000 },
	{      0,   166,    -8,  0, 0.000000, 0.000000, 0.000000 },
	{      0,     0,    32,  0, 0.000000, 1.000000, 0.000000 },
	{     40,     0,    24,  0, 0.000000, 1.000000, 0.000000 },
	{     32,     0,     0,  0, 0.000000, 1.000000, 0.000000 },
	{      0,     0,   -20,  0, 0.000000, 1.000000, 0.000000 },
	{    -32,     0,     0,  0, 0.000000, 1.000000, 0.000000 },
	{    -40,     0,    24,  0, 0.000000, 1.000000, 0.000000 }
};

static FaceData hitoFaces[] = { 
	{ 2, 15,    0,    0,  146,   96,   -2,  -14, 0.791241, 0.142709, 0.594620,  -12.510798,{  0,  1} },
	{ 3, 15,   30,  -30,  154,  146,   24,  -14, 0.000000, 0.978550,-0.206010, -145.752411,{  2,  3,  1} },
	{ 3, 15,   30,    0,  154,   96,   24,  -14, 0.791241,-0.142709,-0.594620,   12.510798,{  1,  3,  0} },
	{ 3, 15,    0,  -30,  154,   96,   24,  -14,-0.791241,-0.142709,-0.594620,   12.510798,{  2,  1,  0} },
	{ 3, 15,   12,  -12,  190,  178,    0,  -12, 0.000000, 0.707107,-0.707107, -134.350281,{  4,  5,  6} },
	{ 3, 15,   12,    0,  190,  178,   12,  -12, 0.707107, 0.707107, 0.000000, -134.350281,{  7,  4,  6} },
	{ 3, 15,   12,  -12,  190,  178,   12,    0, 0.000000, 0.707107, 0.707107, -134.350281,{  8,  7,  6} },
	{ 3, 15,    0,  -12,  190,  178,   12,  -12,-0.707107, 0.707107, 0.000000, -134.350281,{  8,  6,  5} },
	{ 3, 15,   12,  -12,  178,  156,   -6,  -12, 0.000000,-0.263117,-0.964764,   35.257732,{  9,  5,  4} },
	{ 3, 15,   12,    0,  178,  156,   12,  -12, 0.877896,-0.478852, 0.000000,   74.700928,{  9,  4,  7} },
	{ 3, 15,   12,  -12,  178,  156,   12,   -6, 0.000000,-0.633238, 0.773957,  103.428841,{  9,  7,  8} },
	{ 3, 15,    0,  -12,  178,  156,   12,  -12,-0.877896,-0.478852, 0.000000,   74.700928,{  5,  9,  8} },
	{ 4, 15,   14,  -14,  166,  150,    6,    2, 0.000000,-0.242536,-0.970142,   42.201199,{ 10, 11, 12, 13} },
	{ 4, 15,   14,  -14,  166,  150,    6,    2, 0.000000, 0.242536, 0.970142,  -42.201199,{ 13, 12, 11, 10} },
	{ 3, 15,   30,  -30,  154,   96,   24,   -2, 0.000000,-0.409056, 0.912509,   41.094387,{  3,  2,  0} },
	{ 3, 15,   16,  -16,  106,  100,   12,  -12, 0.000000, 0.970142,-0.242536,  -99.924675,{ 14, 15, 16} },
	{ 3, 15,   16,    0,  106,   78,   12,  -12, 0.835538,-0.227357,-0.500186,   16.733486,{ 17, 16, 15} },
	{ 3, 15,    0,  -16,  106,   78,   12,  -12,-0.835538,-0.227357,-0.500186,   16.733486,{ 17, 14, 16} },
	{ 3, 15,   16,  -16,  106,   78,   12,   -2, 0.000000,-0.447214, 0.894427,   36.671513,{ 15, 14, 17} },
	{ 3, 15,  -14,  -14,  102,   54,   10,   -4, 1.000000, 0.000000, 0.000000,   14.000000,{ 18, 19, 20} },
	{ 3, 15,  -14,  -14,  102,   54,   10,   -4,-1.000000, 0.000000, 0.000000,  -14.000000,{ 20, 19, 18} },
	{ 3, 15,  -14,  -14,   54,   10,   16,    4,-1.000000, 0.000000, 0.000000,  -14.000000,{ 20, 21, 22} },
	{ 3, 15,  -14,  -14,   54,   10,   16,    4, 1.000000, 0.000000, 0.000000,   14.000000,{ 22, 21, 20} },
	{ 3, 15,   20,   14,   10,    0,   16,  -10, 0.903213, 0.375181,-0.208434,  -14.729327,{ 23, 24, 25} },
	{ 3, 15,   14,    8,   10,    0,   16,  -10,-0.903213, 0.375181,-0.208434,   10.560649,{ 25, 26, 23} },
	{ 3, 15,   14,    8,   10,    0,   16,  -10, 0.903213,-0.375181, 0.208434,  -10.560649,{ 23, 26, 25} },
	{ 3, 15,   20,    8,    0,    0,   16,  -10, 0.000000,-1.000000, 0.000000,    0.000000,{ 24, 26, 25} },
	{ 3, 15,   20,    8,   10,    0,   16,    8, 0.000000, 0.624695, 0.780869,  -12.493901,{ 26, 24, 23} },
	{ 3, 15,  -14,  -20,   10,    0,   16,  -10,-0.903213, 0.375181,-0.208434,  -14.729327,{ 27, 28, 21} },
	{ 3, 15,   32,   24,  148,  116,   14,    0, 0.960039, 0.180007,-0.214294,  -48.601986,{ 29, 30, 31} },
	{ 3, 15,   32,   24,  148,  116,   14,    0,-0.960039,-0.180007, 0.214294,   48.601986,{ 31, 30, 29} },
	{ 3, 15,   32,   32,  116,   90,   22,    8,-1.000000, 0.000000, 0.000000,   32.000000,{ 31, 32, 33} },
	{ 3, 15,   32,   32,  116,   90,   22,    8, 1.000000, 0.000000, 0.000000,  -32.000000,{ 33, 32, 31} },
	{ 3, 15,   -8,  -14,   10,    0,   16,  -10, 0.903213, 0.375181,-0.208434,   10.560649,{ 21, 34, 27} },
	{ 3, 15,   -8,  -14,   10,    0,   16,  -10,-0.903213,-0.375181, 0.208434,  -10.560649,{ 27, 34, 21} },
	{ 3, 15,   -8,  -20,    0,    0,   16,  -10, 0.000000,-1.000000, 0.000000,    0.000000,{ 27, 34, 28} },
	{ 3, 15,   -8,  -20,   10,    0,   16,    8, 0.000000, 0.624695, 0.780869,  -12.493901,{ 21, 28, 34} },
	{ 3, 15,  -24,  -32,  148,  116,   14,    0,-0.960039, 0.180007,-0.214294,  -48.601986,{ 35, 36, 37} },
	{ 3, 15,  -24,  -32,  148,  116,   14,    0, 0.960039,-0.180007, 0.214294,   48.601986,{ 37, 36, 35} },
	{ 3, 15,  -32,  -32,  116,   90,   22,    8, 1.000000, 0.000000, 0.000000,   32.000000,{ 38, 39, 35} },
	{ 3, 15,  -32,  -32,  116,   90,   22,    8,-1.000000, 0.000000, 0.000000,  -32.000000,{ 35, 39, 38} },
	{ 3, 15,   14,   14,  102,   54,   10,   -4,-1.000000, 0.000000, 0.000000,   14.000000,{ 40, 41, 42} },
	{ 3, 15,   14,   14,  102,   54,   10,   -4, 1.000000, 0.000000, 0.000000,  -14.000000,{ 42, 41, 40} },
	{ 3, 15,   14,   14,   54,   10,   16,    4, 1.000000, 0.000000, 0.000000,  -14.000000,{ 43, 23, 40} },
	{ 3, 15,   14,   14,   54,   10,   16,    4,-1.000000, 0.000000, 0.000000,   14.000000,{ 40, 23, 43} },
	{ 3, 15,  -28,  -32,   90,   84,   10,    2, 0.818182, 0.181818, 0.545455,    5.454545,{ 44, 45, 39} },
	{ 3, 15,  -28,  -32,   90,   84,   10,    2,-0.745356,-0.298142,-0.596285,    7.155419,{ 44, 46, 45} },
	{ 3, 15,  -28,  -32,   90,   88,    8,    2, 0.832050, 0.000000, 0.554700,   22.188009,{ 45, 39, 46} },
	{ 3, 15,  -32,  -32,   90,   84,   10,    8, 1.000000, 0.000000, 0.000000,   32.000000,{ 39, 44, 46} },
	{ 3, 15,  -28,  -32,   90,   78,   10,   -2, 0.921443,-0.122859, 0.368577,   36.120552,{ 47, 45, 44} },
	{ 3, 15,  -28,  -32,   90,   78,   10,   -2,-0.921443, 0.122859,-0.368577,  -36.120552,{ 44, 45, 47} },
	{ 3, 15,   32,   28,   90,   84,   10,    2,-0.818182, 0.181818, 0.545455,    5.454545,{ 32, 48, 49} },
	{ 3, 15,   32,   28,   90,   84,   10,    2, 0.745356,-0.298142,-0.596285,    7.155419,{ 48, 50, 49} },
	{ 3, 15,   32,   28,   90,   88,    8,    2,-0.832050, 0.000000, 0.554700,   22.188009,{ 50, 32, 48} },
	{ 3, 15,   32,   32,   90,   84,   10,    8,-1.000000, 0.000000, 0.000000,   32.000000,{ 50, 49, 32} },
	{ 3, 15,   32,   28,   90,   78,   10,   -2,-0.921443,-0.122859, 0.368577,   36.120552,{ 49, 48, 51} },
	{ 3, 15,   32,   28,   90,   78,   10,   -2, 0.921443, 0.122859,-0.368577,  -36.120552,{ 51, 48, 49} },
	{ 3, 15,    0,    0,  172,  166,   -8,  -16,-1.000000, 0.000000, 0.000000,    0.000000,{ 52, 53, 54} },
	{ 3, 15,    0,    0,  172,  166,   -8,  -16, 1.000000, 0.000000, 0.000000,    0.000000,{ 54, 53, 52} },
	{ 6,240,   40,  -40,    0,    0,   32,  -20, 0.000000, 1.000000, 0.000000,    0.000000,{ 55, 56, 57, 58, 59, 60} }
};

ShapeInfo	hito = { 61,60,60,40,40,190,32,0,hitoPoints,hitoFaces };

/************************************************************************
 		The grass1 	
************************************************************************/

static PointData grass1Points[] = { 
	{  -1024,     0,  1024,  0, 0.000000, 1.000000, 0.000000 },
	{   1024,     0,  1024,  0, 0.000000, 1.000000, 0.000000 },
	{   1024,     0, -1024,  0, 0.000000, 1.000000, 0.000000 },
	{  -1024,     0, -1024,  0, 0.000000, 1.000000, 0.000000 }
};

static FaceData grass1Faces[] = { 
	{ 4,220, 1024,-1024,    0,    0, 1024,-1024, 0.000000, 1.000000, 0.000000,    0.000000,{  0,  1,  2,  3} }
};

ShapeInfo	grass1 = { 4,1,1,1024,1024,0,1024,0,grass1Points,grass1Faces };

/************************************************************************
 		The grass2 	
************************************************************************/

static PointData grass2Points[] = { 
	{   -512,     0,  -512,  0, 0.000000, 1.000000, 0.000000 },
	{      0,     0,  -512,  0, 0.000000, 1.000000, 0.000000 },
	{      0,     0, -1024,  0, 0.000000, 1.000000, 0.000000 },
	{   -512,     0, -1024,  0, 0.000000, 1.000000, 0.000000 },
	{    512,     0,  -512,  0, 0.000000, 1.000000, 0.000000 },
	{    512,     0, -1024,  0, 0.000000, 1.000000, 0.000000 },
	{  -1024,     0,  1024,  0, 0.000000, 1.000000, 0.000000 },
	{   -512,     0,  1024,  0, 0.000000, 1.000000, 0.000000 },
	{   -512,     0,   512,  0, 0.000000, 1.000000, 0.000000 },
	{  -1024,     0,   512,  0, 0.000000, 1.000000, 0.000000 },
	{  -1024,     0,  -512,  0, 0.000000, 1.000000, 0.000000 },
	{  -1024,     0, -1024,  0, 0.000000, 1.000000, 0.000000 },
	{   1024,     0,  -512,  0, 0.000000, 1.000000, 0.000000 },
	{   1024,     0, -1024,  0, 0.000000, 1.000000, 0.000000 },
	{    512,     0,  1024,  0, 0.000000, 1.000000, 0.000000 },
	{   1024,     0,  1024,  0, 0.000000, 1.000000, 0.000000 },
	{   1024,     0,   512,  0, 0.000000, 1.000000, 0.000000 },
	{    512,     0,   512,  0, 0.000000, 1.000000, 0.000000 },
	{  -1024,     0,     0,  0, 0.000000, 1.000000, 0.000000 },
	{   -512,     0,     0,  0, 0.000000, 1.000000, 0.000000 },
	{      0,     0,     0,  0, 0.000000, 1.000000, 0.000000 },
	{    512,     0,     0,  0, 0.000000, 1.000000, 0.000000 },
	{   1024,     0,     0,  0, 0.000000, 1.000000, 0.000000 },
	{      0,     0,  1024,  0, 0.000000, 1.000000, 0.000000 },
	{      0,     0,   512,  0, 0.000000, 1.000000, 0.000000 }
};

static FaceData grass2Faces[] = { 
	{ 4,220,    0, -512,    0,    0, -512,-1024, 0.000000, 1.000000, 0.000000,    0.000000,{  0,  1,  2,  3} },
	{ 4,218,  512,    0,    0,    0, -512,-1024, 0.000000, 1.000000, 0.000000,    0.000000,{  1,  4,  5,  2} },
	{ 4,220, -512,-1024,    0,    0, 1024,  512, 0.000000, 1.000000, 0.000000,    0.000000,{  6,  7,  8,  9} },
	{ 4,218, -512,-1024,    0,    0, -512,-1024, 0.000000, 1.000000, 0.000000,    0.000000,{ 10,  0,  3, 11} },
	{ 4,220, 1024,  512,    0,    0, -512,-1024, 0.000000, 1.000000, 0.000000,    0.000000,{  4, 12, 13,  5} },
	{ 4,218, 1024,  512,    0,    0, 1024,  512, 0.000000, 1.000000, 0.000000,    0.000000,{ 14, 15, 16, 17} },
	{ 4,220, -512,-1024,    0,    0,    0, -512, 0.000000, 1.000000, 0.000000,    0.000000,{ 18, 19,  0, 10} },
	{ 4,218,    0, -512,    0,    0,    0, -512, 0.000000, 1.000000, 0.000000,    0.000000,{ 19, 20,  1,  0} },
	{ 4,220,  512,    0,    0,    0,    0, -512, 0.000000, 1.000000, 0.000000,    0.000000,{ 20, 21,  4,  1} },
	{ 4,218, 1024,  512,    0,    0,    0, -512, 0.000000, 1.000000, 0.000000,    0.000000,{ 21, 22, 12,  4} },
	{ 4,218,    0, -512,    0,    0, 1024,  512, 0.000000, 1.000000, 0.000000,    0.000000,{  7, 23, 24,  8} },
	{ 4,220,  512,    0,    0,    0, 1024,  512, 0.000000, 1.000000, 0.000000,    0.000000,{ 23, 14, 17, 24} },
	{ 4,220,    0, -512,    0,    0,  512,    0, 0.000000, 1.000000, 0.000000,    0.000000,{  8, 24, 20, 19} },
	{ 4,218,  512,    0,    0,    0,  512,    0, 0.000000, 1.000000, 0.000000,    0.000000,{ 24, 17, 21, 20} },
	{ 4,218, -512,-1024,    0,    0,  512,    0, 0.000000, 1.000000, 0.000000,    0.000000,{  9,  8, 19, 18} },
	{ 4,220, 1024,  512,    0,    0,  512,    0, 0.000000, 1.000000, 0.000000,    0.000000,{ 17, 16, 22, 21} }
};

ShapeInfo	grass2 = { 25,16,16,1024,1024,0,1024,0,grass2Points,grass2Faces };

/************************************************************************
 		The wood1 	
************************************************************************/

static PointData wood1Points[] = { 
	{    -16,    80,   -16,  0,-0.707107, 0.000000,-0.707107 },
	{     16,    80,   -16,  0, 0.707107, 0.000000,-0.707107 },
	{     16,     0,   -16,  0, 0.707107, 0.000000,-0.707107 },
	{    -16,     0,   -16,  0,-0.707107, 0.000000,-0.707107 },
	{    -16,    80,    16,  0,-0.707107, 0.000000, 0.707107 },
	{    -16,     0,    16,  0,-0.707107, 0.000000, 0.707107 },
	{     16,     0,    16,  0, 0.707107, 0.000000, 0.707107 },
	{     16,    80,    16,  0, 0.707107, 0.000000, 0.707107 },
	{      0,   432,     0,  0, 0.000000, 1.000000, 0.000000 },
	{    128,    80,  -128,  0, 0.687870,-0.231668,-0.687870 },
	{   -128,    80,  -128,  0,-0.687870,-0.231668,-0.687870 },
	{    128,    80,   128,  0, 0.687870,-0.231668, 0.687870 },
	{   -128,    80,   128,  0,-0.687870,-0.231668, 0.687870 }
};

static FaceData wood1Faces[] = { 
	{ 4,143,   16,  -16,   80,    0,  -16,  -16, 0.000000, 0.000000,-1.000000,  -16.000000,{  0,  1,  2,  3} },
	{ 4,143,   16,  -16,   80,    0,   16,   16, 0.000000, 0.000000, 1.000000,  -16.000000,{  4,  5,  6,  7} },
	{ 4,141,   16,   16,   80,    0,   16,  -16, 1.000000, 0.000000, 0.000000,  -16.000000,{  1,  7,  6,  2} },
	{ 4,141,  -16,  -16,   80,    0,   16,  -16,-1.000000, 0.000000, 0.000000,  -16.000000,{  0,  3,  5,  4} },
	{ 3,122,  128, -128,  432,   80,    0, -128, 0.000000, 0.341743,-0.939793, -147.632996,{  8,  9, 10} },
	{ 3,123,  128,    0,  432,   80,  128, -128, 0.939793, 0.341743, 0.000000, -147.632996,{  8, 11,  9} },
	{ 3,121,  128, -128,  432,   80,  128,    0, 0.000000, 0.341743, 0.939793, -147.632996,{  8, 12, 11} },
	{ 4,116,  128, -128,   80,   80,  128, -128, 0.000000,-1.000000, 0.000000,   80.000000,{ 12, 10,  9, 11} },
	{ 3,122,    0, -128,  432,   80,  128, -128,-0.939793, 0.341743, 0.000000, -147.632996,{ 12,  8, 10} }
};

ShapeInfo	wood1 = { 13,9,9,128,128,432,128,0,wood1Points,wood1Faces };

/************************************************************************
 		The load11 	
************************************************************************/

static PointData load11Points[] = { 
	{    128,     0, -1024,  0, 0.000000, 1.000000, 0.000000 },
	{   -128,     0, -1024,  0, 0.000000, 1.000000, 0.000000 },
	{   -128,     0,  -768,  0, 0.000000, 0.998068,-0.062137 },
	{    128,     0,  -768,  0, 0.000000, 0.998068,-0.062137 },
	{   -128,    32,  -512,  0,-0.014125, 0.989001,-0.147236 },
	{    128,    32,  -512,  0, 0.014125, 0.989001,-0.147236 },
	{   -128,    96,  -256,  0,-0.049199, 0.979591,-0.194888 },
	{    128,    96,  -256,  0, 0.049199, 0.979591,-0.194888 },
	{   -128,   160,     0,  0,-0.089840, 0.966865,-0.238959 },
	{    128,   160,     0,  0, 0.089840, 0.966865,-0.238959 },
	{   -128,   256,   256,  0,-0.143619, 0.960462,-0.238510 },
	{    128,   256,   256,  0, 0.143619, 0.960462,-0.238510 },
	{   -128,   320,   512,  0,-0.221002, 0.967686,-0.121418 },
	{    128,   320,   512,  0, 0.221002, 0.967686,-0.121418 },
	{   -128,   352,   768,  0,-0.185776, 0.980692,-0.061071 },
	{    128,   352,   768,  0, 0.185776, 0.980692,-0.061071 },
	{   -128,   352,  1024,  0,-0.186076, 0.982535, 0.000000 },
	{    128,   352,  1024,  0, 0.186076, 0.982535, 0.000000 },
	{   1024,     0,   768,  0, 0.355632, 0.933829,-0.038583 },
	{   1024,     0,  1024,  0, 0.365652, 0.930752, 0.000000 },
	{   1024,     0,   512,  0, 0.336336, 0.941742, 0.000000 },
	{   1024,     0,   256,  0, 0.294679, 0.952373,-0.078428 },
	{   1024,     0,     0,  0, 0.208260, 0.971027,-0.117194 },
	{   1024,     0,  -256,  0, 0.129493, 0.988267,-0.080989 },
	{   1024,     0,  -512,  0, 0.059378, 0.994913,-0.081383 },
	{   1024,     0,  -768,  0, 0.011919, 0.999071,-0.041422 },
	{   1024,     0, -1024,  0, 0.000000, 1.000000, 0.000000 },
	{  -1024,     0,   768,  0,-0.355632, 0.933829,-0.038583 },
	{  -1024,     0,  1024,  0,-0.365652, 0.930752, 0.000000 },
	{  -1024,     0,   512,  0,-0.336336, 0.941742, 0.000000 },
	{  -1024,     0,   256,  0,-0.294679, 0.952373,-0.078428 },
	{  -1024,     0,     0,  0,-0.208260, 0.971027,-0.117194 },
	{  -1024,     0,  -256,  0,-0.129493, 0.988267,-0.080989 },
	{  -1024,     0,  -512,  0,-0.059378, 0.994913,-0.081383 },
	{  -1024,     0,  -768,  0,-0.011919, 0.999071,-0.041422 },
	{  -1024,     0, -1024,  0, 0.000000, 1.000000, 0.000000 }
};

static FaceData load11Faces[] = { 
	{ 4,  4,  128, -128,    0,    0, -768,-1024, 0.000000, 1.000000, 0.000000,    0.000000,{  0,  1,  2,  3} },
	{ 4,  4,  128, -128,   32,    0, -512, -768, 0.000000, 0.992278,-0.124035,  -95.258675,{  3,  2,  4,  5} },
	{ 4,  4,  128, -128,   96,   32, -256, -512, 0.000000, 0.970142,-0.242536, -155.222794,{  5,  4,  6,  7} },
	{ 4,  4,  128, -128,  160,   96,    0, -256, 0.000000, 0.970142,-0.242536, -155.222794,{  7,  6,  8,  9} },
	{ 4,  4,  128, -128,  256,  160,  256,    0, 0.000000, 0.936329,-0.351123, -149.812668,{  9,  8, 10, 11} },
	{ 4,  4,  128, -128,  320,  256,  512,  256, 0.000000, 0.970142,-0.242536, -186.267365,{ 11, 10, 12, 13} },
	{ 4,  4,  128, -128,  352,  320,  768,  512, 0.000000, 0.992278,-0.124035, -254.023132,{ 13, 12, 14, 15} },
	{ 4,  4,  128, -128,  352,  352, 1024,  768, 0.000000, 1.000000, 0.000000, -352.000000,{ 15, 14, 16, 17} },
	{ 4, 13, 1024,  128,  352,    0, 1024,  768, 0.365652, 0.930752, 0.000000, -374.428040,{ 18, 15, 17, 19} },
	{ 3, 13, 1024,  128,  352,    0,  768,  512, 0.363202, 0.924515,-0.115564, -283.165863,{ 13, 15, 18} },
	{ 3, 13, 1024,  128,  320,    0,  768,  512, 0.336336, 0.941742, 0.000000, -344.408478,{ 20, 13, 18} },
	{ 3, 13, 1024,  128,  320,    0,  512,  256, 0.267112, 0.934893,-0.233723, -213.689789,{ 21, 11, 13} },
	{ 3, 13, 1024,  128,  320,    0,  512,  256, 0.336336, 0.941742, 0.000000, -344.408478,{ 21, 13, 20} },
	{ 3, 13, 1024,  128,  256,    0,  256,    0, 0.164912, 0.923509,-0.346316, -168.870255,{  9, 11, 22} },
	{ 3, 13, 1024,  128,  256,    0,  256,    0, 0.274721, 0.961524, 0.000000, -281.314423,{ 22, 11, 21} },
	{ 3, 13, 1024,  128,  160,    0,    0, -256, 0.103387, 0.964944,-0.241236, -167.624512,{ 23,  7,  9} },
	{ 3, 13, 1024,  128,  160,    0,    0, -256, 0.175791, 0.984428, 0.000000, -180.009613,{ 23,  9, 22} },
	{ 3, 13, 1024,  128,   96,    0, -256, -512, 0.034627, 0.969561,-0.242390, -159.561981,{ 24,  5,  7} },
	{ 3, 13, 1024,  128,   96,    0, -256, -512, 0.106533, 0.994309, 0.000000, -109.089920,{ 24,  7, 23} },
	{ 3, 13, 1024,  128,   32,    0, -512, -768, 0.000000, 0.992278,-0.124035,  -95.258675,{ 25,  3,  5} },
	{ 3, 13, 1024,  128,   32,    0, -512, -768, 0.035692, 0.999363, 0.000000,  -36.548126,{ 25,  5, 24} },
	{ 4, 13, 1024,  128,    0,    0, -768,-1024, 0.000000, 1.000000, 0.000000,    0.000000,{ 26,  0,  3, 25} },
	{ 4, 13, -128,-1024,  352,    0, 1024,  768,-0.365652, 0.930752, 0.000000, -374.428040,{ 27, 28, 16, 14} },
	{ 3, 13, -128,-1024,  352,    0,  768,  512,-0.363202, 0.924515,-0.115564, -283.165863,{ 12, 27, 14} },
	{ 3, 13, -128,-1024,  320,    0,  768,  512,-0.336336, 0.941742, 0.000000, -344.408478,{ 29, 27, 12} },
	{ 3, 13, -128,-1024,  320,    0,  512,  256,-0.267112, 0.934893,-0.233723, -213.689789,{ 30, 12, 10} },
	{ 3, 13, -128,-1024,  320,    0,  512,  256,-0.336336, 0.941742, 0.000000, -344.408478,{ 30, 29, 12} },
	{ 3, 13, -128,-1024,  256,    0,  256,    0,-0.164912, 0.923509,-0.346316, -168.870255,{  8, 31, 10} },
	{ 3, 13, -128,-1024,  256,    0,  256,    0,-0.274721, 0.961524, 0.000000, -281.314423,{ 31, 30, 10} },
	{ 3, 13, -128,-1024,  160,    0,    0, -256,-0.103387, 0.964944,-0.241236, -167.624512,{ 32,  8,  6} },
	{ 3, 13, -128,-1024,  160,    0,    0, -256,-0.175791, 0.984428, 0.000000, -180.009613,{ 32, 31,  8} },
	{ 3, 13, -128,-1024,   96,    0, -256, -512,-0.034627, 0.969561,-0.242390, -159.561981,{ 33,  6,  4} },
	{ 3, 13, -128,-1024,   96,    0, -256, -512,-0.106533, 0.994309, 0.000000, -109.089920,{ 33, 32,  6} },
	{ 3, 13, -128,-1024,   32,    0, -512, -768, 0.000000, 0.992278,-0.124035,  -95.258675,{ 34,  4,  2} },
	{ 3, 13, -128,-1024,   32,    0, -512, -768,-0.035692, 0.999363, 0.000000,  -36.548126,{ 34, 33,  4} },
	{ 4, 13, -128,-1024,    0,    0, -768,-1024, 0.000000, 1.000000, 0.000000,    0.000000,{ 35, 34,  2,  1} }
};

ShapeInfo	load11 = { 36,36,36,1024,1024,352,1024,0,load11Points,load11Faces };

/************************************************************************
 		The rail1 	
************************************************************************/

static PointData rail1Points[] = { 
	{    -48,    32,  1024,  0, 0.000000, 1.000000, 0.000000 },
	{    -32,    32,  1024,  0, 0.000000, 1.000000, 0.000000 },
	{    -32,    32, -1024,  0, 0.000000, 1.000000, 0.000000 },
	{    -48,    32, -1024,  0, 0.000000, 1.000000, 0.000000 },
	{     32,    32,  1024,  0, 0.000000, 1.000000, 0.000000 },
	{     48,    32,  1024,  0, 0.000000, 1.000000, 0.000000 },
	{     48,    32, -1024,  0, 0.000000, 1.000000, 0.000000 },
	{     32,    32, -1024,  0, 0.000000, 1.000000, 0.000000 },
	{   -112,    16,  -960,  0, 0.000000, 1.000000, 0.000000 },
	{    112,    16,  -960,  0, 0.000000, 1.000000, 0.000000 },
	{    112,    16,  -992,  0, 0.000000, 1.000000, 0.000000 },
	{   -112,    16,  -992,  0, 0.000000, 1.000000, 0.000000 },
	{   -112,    16,  -640,  0, 0.000000, 1.000000, 0.000000 },
	{    112,    16,  -640,  0, 0.000000, 1.000000, 0.000000 },
	{    112,    16,  -672,  0, 0.000000, 1.000000, 0.000000 },
	{   -112,    16,  -672,  0, 0.000000, 1.000000, 0.000000 },
	{   -112,    16,  -720,  0, 0.000000, 1.000000, 0.000000 },
	{    112,    16,  -720,  0, 0.000000, 1.000000, 0.000000 },
	{    112,    16,  -752,  0, 0.000000, 1.000000, 0.000000 },
	{   -112,    16,  -752,  0, 0.000000, 1.000000, 0.000000 },
	{   -112,    16,  -800,  0, 0.000000, 1.000000, 0.000000 },
	{    112,    16,  -800,  0, 0.000000, 1.000000, 0.000000 },
	{    112,    16,  -832,  0, 0.000000, 1.000000, 0.000000 },
	{   -112,    16,  -832,  0, 0.000000, 1.000000, 0.000000 },
	{   -112,    16,   720,  0, 0.000000, 1.000000, 0.000000 },
	{    112,    16,   720,  0, 0.000000, 1.000000, 0.000000 },
	{    112,    16,   688,  0, 0.000000, 1.000000, 0.000000 },
	{   -112,    16,   688,  0, 0.000000, 1.000000, 0.000000 },
	{   -112,    16,   960,  0, 0.000000, 1.000000, 0.000000 },
	{    112,    16,   960,  0, 0.000000, 1.000000, 0.000000 },
	{    112,    16,   928,  0, 0.000000, 1.000000, 0.000000 },
	{   -112,    16,   928,  0, 0.000000, 1.000000, 0.000000 },
	{   -112,    16,   880,  0, 0.000000, 1.000000, 0.000000 },
	{    112,    16,   880,  0, 0.000000, 1.000000, 0.000000 },
	{    112,    16,   848,  0, 0.000000, 1.000000, 0.000000 },
	{   -112,    16,   848,  0, 0.000000, 1.000000, 0.000000 },
	{   -112,    16,   800,  0, 0.000000, 1.000000, 0.000000 },
	{    112,    16,   800,  0, 0.000000, 1.000000, 0.000000 },
	{    112,    16,   768,  0, 0.000000, 1.000000, 0.000000 },
	{   -112,    16,   768,  0, 0.000000, 1.000000, 0.000000 },
	{   -112,    16,   400,  0, 0.000000, 1.000000, 0.000000 },
	{    112,    16,   400,  0, 0.000000, 1.000000, 0.000000 },
	{    112,    16,   368,  0, 0.000000, 1.000000, 0.000000 },
	{   -112,    16,   368,  0, 0.000000, 1.000000, 0.000000 },
	{   -112,    16,   640,  0, 0.000000, 1.000000, 0.000000 },
	{    112,    16,   640,  0, 0.000000, 1.000000, 0.000000 },
	{    112,    16,   608,  0, 0.000000, 1.000000, 0.000000 },
	{   -112,    16,   608,  0, 0.000000, 1.000000, 0.000000 },
	{   -112,    16,   560,  0, 0.000000, 1.000000, 0.000000 },
	{    112,    16,   560,  0, 0.000000, 1.000000, 0.000000 },
	{    112,    16,   528,  0, 0.000000, 1.000000, 0.000000 },
	{   -112,    16,   528,  0, 0.000000, 1.000000, 0.000000 },
	{   -112,    16,   480,  0, 0.000000, 1.000000, 0.000000 },
	{    112,    16,   480,  0, 0.000000, 1.000000, 0.000000 },
	{    112,    16,   448,  0, 0.000000, 1.000000, 0.000000 },
	{   -112,    16,   448,  0, 0.000000, 1.000000, 0.000000 },
	{   -112,    16,    80,  0, 0.000000, 1.000000, 0.000000 },
	{    112,    16,    80,  0, 0.000000, 1.000000, 0.000000 },
	{    112,    16,    48,  0, 0.000000, 1.000000, 0.000000 },
	{   -112,    16,    48,  0, 0.000000, 1.000000, 0.000000 },
	{   -112,    16,   320,  0, 0.000000, 1.000000, 0.000000 },
	{    112,    16,   320,  0, 0.000000, 1.000000, 0.000000 },
	{    112,    16,   288,  0, 0.000000, 1.000000, 0.000000 },
	{   -112,    16,   288,  0, 0.000000, 1.000000, 0.000000 },
	{   -112,    16,   240,  0, 0.000000, 1.000000, 0.000000 },
	{    112,    16,   240,  0, 0.000000, 1.000000, 0.000000 },
	{    112,    16,   208,  0, 0.000000, 1.000000, 0.000000 },
	{   -112,    16,   208,  0, 0.000000, 1.000000, 0.000000 },
	{   -112,    16,   160,  0, 0.000000, 1.000000, 0.000000 },
	{    112,    16,   160,  0, 0.000000, 1.000000, 0.000000 },
	{    112,    16,   128,  0, 0.000000, 1.000000, 0.000000 },
	{   -112,    16,   128,  0, 0.000000, 1.000000, 0.000000 },
	{   -112,    16,  -240,  0, 0.000000, 1.000000, 0.000000 },
	{    112,    16,  -240,  0, 0.000000, 1.000000, 0.000000 },
	{    112,    16,  -272,  0, 0.000000, 1.000000, 0.000000 },
	{   -112,    16,  -272,  0, 0.000000, 1.000000, 0.000000 },
	{   -112,    16,     0,  0, 0.000000, 1.000000, 0.000000 },
	{    112,    16,     0,  0, 0.000000, 1.000000, 0.000000 },
	{    112,    16,   -32,  0, 0.000000, 1.000000, 0.000000 },
	{   -112,    16,   -32,  0, 0.000000, 1.000000, 0.000000 },
	{   -112,    16,   -80,  0, 0.000000, 1.000000, 0.000000 },
	{    112,    16,   -80,  0, 0.000000, 1.000000, 0.000000 },
	{    112,    16,  -112,  0, 0.000000, 1.000000, 0.000000 },
	{   -112,    16,  -112,  0, 0.000000, 1.000000, 0.000000 },
	{   -112,    16,  -160,  0, 0.000000, 1.000000, 0.000000 },
	{    112,    16,  -160,  0, 0.000000, 1.000000, 0.000000 },
	{    112,    16,  -192,  0, 0.000000, 1.000000, 0.000000 },
	{   -112,    16,  -192,  0, 0.000000, 1.000000, 0.000000 },
	{   -112,    16,  -560,  0, 0.000000, 1.000000, 0.000000 },
	{    112,    16,  -560,  0, 0.000000, 1.000000, 0.000000 },
	{    112,    16,  -592,  0, 0.000000, 1.000000, 0.000000 },
	{   -112,    16,  -592,  0, 0.000000, 1.000000, 0.000000 },
	{   -112,    16,  -320,  0, 0.000000, 1.000000, 0.000000 },
	{    112,    16,  -320,  0, 0.000000, 1.000000, 0.000000 },
	{    112,    16,  -352,  0, 0.000000, 1.000000, 0.000000 },
	{   -112,    16,  -352,  0, 0.000000, 1.000000, 0.000000 },
	{   -112,    16,  -400,  0, 0.000000, 1.000000, 0.000000 },
	{    112,    16,  -400,  0, 0.000000, 1.000000, 0.000000 },
	{    112,    16,  -432,  0, 0.000000, 1.000000, 0.000000 },
	{   -112,    16,  -432,  0, 0.000000, 1.000000, 0.000000 },
	{   -112,    16,  -480,  0, 0.000000, 1.000000, 0.000000 },
	{    112,    16,  -480,  0, 0.000000, 1.000000, 0.000000 },
	{    112,    16,  -512,  0, 0.000000, 1.000000, 0.000000 },
	{   -112,    16,  -512,  0, 0.000000, 1.000000, 0.000000 },
	{   -112,    16,  -880,  0, 0.000000, 1.000000, 0.000000 },
	{    112,    16,  -880,  0, 0.000000, 1.000000, 0.000000 },
	{    112,    16,  -912,  0, 0.000000, 1.000000, 0.000000 },
	{   -112,    16,  -912,  0, 0.000000, 1.000000, 0.000000 },
	{  -1024,     0,  1024,  0, 0.000000, 1.000000, 0.000000 },
	{   -192,     0,  1024,  0, 0.000000, 1.000000, 0.000000 },
	{   -192,     0, -1024,  0, 0.000000, 1.000000, 0.000000 },
	{  -1024,     0, -1024,  0, 0.000000, 1.000000, 0.000000 },
	{    192,     0,  1024,  0, 0.000000, 1.000000, 0.000000 },
	{   1024,     0,  1024,  0, 0.000000, 1.000000, 0.000000 },
	{   1024,     0, -1024,  0, 0.000000, 1.000000, 0.000000 },
	{    192,     0, -1024,  0, 0.000000, 1.000000, 0.000000 }
};

static FaceData rail1Faces[] = { 
	{ 4, 15,  -32,  -48,   32,   32, 1024,-1024, 0.000000, 1.000000, 0.000000,  -32.000000,{  0,  1,  2,  3} },
	{ 4, 15,   48,   32,   32,   32, 1024,-1024, 0.000000, 1.000000, 0.000000,  -32.000000,{  4,  5,  6,  7} },
	{ 4,  8,  112, -112,   16,   16, -960, -992, 0.000000, 1.000000, 0.000000,  -16.000000,{  8,  9, 10, 11} },
	{ 4,  8,  112, -112,   16,   16, -640, -672, 0.000000, 1.000000, 0.000000,  -16.000000,{ 12, 13, 14, 15} },
	{ 4,  8,  112, -112,   16,   16, -720, -752, 0.000000, 1.000000, 0.000000,  -16.000000,{ 16, 17, 18, 19} },
	{ 4,  8,  112, -112,   16,   16, -800, -832, 0.000000, 1.000000, 0.000000,  -16.000000,{ 20, 21, 22, 23} },
	{ 4,  8,  112, -112,   16,   16,  720,  688, 0.000000, 1.000000, 0.000000,  -16.000000,{ 24, 25, 26, 27} },
	{ 4,  8,  112, -112,   16,   16,  960,  928, 0.000000, 1.000000, 0.000000,  -16.000000,{ 28, 29, 30, 31} },
	{ 4,  8,  112, -112,   16,   16,  880,  848, 0.000000, 1.000000, 0.000000,  -16.000000,{ 32, 33, 34, 35} },
	{ 4,  8,  112, -112,   16,   16,  800,  768, 0.000000, 1.000000, 0.000000,  -16.000000,{ 36, 37, 38, 39} },
	{ 4,  8,  112, -112,   16,   16,  400,  368, 0.000000, 1.000000, 0.000000,  -16.000000,{ 40, 41, 42, 43} },
	{ 4,  8,  112, -112,   16,   16,  640,  608, 0.000000, 1.000000, 0.000000,  -16.000000,{ 44, 45, 46, 47} },
	{ 4,  8,  112, -112,   16,   16,  560,  528, 0.000000, 1.000000, 0.000000,  -16.000000,{ 48, 49, 50, 51} },
	{ 4,  8,  112, -112,   16,   16,  480,  448, 0.000000, 1.000000, 0.000000,  -16.000000,{ 52, 53, 54, 55} },
	{ 4,  8,  112, -112,   16,   16,   80,   48, 0.000000, 1.000000, 0.000000,  -16.000000,{ 56, 57, 58, 59} },
	{ 4,  8,  112, -112,   16,   16,  320,  288, 0.000000, 1.000000, 0.000000,  -16.000000,{ 60, 61, 62, 63} },
	{ 4,  8,  112, -112,   16,   16,  240,  208, 0.000000, 1.000000, 0.000000,  -16.000000,{ 64, 65, 66, 67} },
	{ 4,  8,  112, -112,   16,   16,  160,  128, 0.000000, 1.000000, 0.000000,  -16.000000,{ 68, 69, 70, 71} },
	{ 4,  8,  112, -112,   16,   16, -240, -272, 0.000000, 1.000000, 0.000000,  -16.000000,{ 72, 73, 74, 75} },
	{ 4,  8,  112, -112,   16,   16,    0,  -32, 0.000000, 1.000000, 0.000000,  -16.000000,{ 76, 77, 78, 79} },
	{ 4,  8,  112, -112,   16,   16,  -80, -112, 0.000000, 1.000000, 0.000000,  -16.000000,{ 80, 81, 82, 83} },
	{ 4,  8,  112, -112,   16,   16, -160, -192, 0.000000, 1.000000, 0.000000,  -16.000000,{ 84, 85, 86, 87} },
	{ 4,  8,  112, -112,   16,   16, -560, -592, 0.000000, 1.000000, 0.000000,  -16.000000,{ 88, 89, 90, 91} },
	{ 4,  8,  112, -112,   16,   16, -320, -352, 0.000000, 1.000000, 0.000000,  -16.000000,{ 92, 93, 94, 95} },
	{ 4,  8,  112, -112,   16,   16, -400, -432, 0.000000, 1.000000, 0.000000,  -16.000000,{ 96, 97, 98, 99} },
	{ 4,  8,  112, -112,   16,   16, -480, -512, 0.000000, 1.000000, 0.000000,  -16.000000,{100,101,102,103} },
	{ 4,  8,  112, -112,   16,   16, -880, -912, 0.000000, 1.000000, 0.000000,  -16.000000,{104,105,106,107} },
	{ 4, 13, -192,-1024,    0,    0, 1024,-1024, 0.000000, 1.000000, 0.000000,    0.000000,{108,109,110,111} },
	{ 4, 13, 1024,  192,    0,    0, 1024,-1024, 0.000000, 1.000000, 0.000000,    0.000000,{112,113,114,115} }
};

ShapeInfo	rail1 = { 116,29,29,1024,1024,32,1024,0,rail1Points,rail1Faces };

/************************************************************************
 		The fuji1 	
************************************************************************/

static PointData fuji1Points[] = { 
	{    512,   416,     0,  0,-0.151682, 0.988429, 0.000000 },
	{    768,   480,     0,  0,-0.122509, 0.992467, 0.000000 },
	{    768,     0, -1024,  0,-0.055466, 0.909577,-0.411817 },
	{    512,     0, -1024,  0, 0.000000, 0.926467,-0.376377 },
	{    256,     0, -1024,  0,-0.113907, 0.939532,-0.322962 },
	{    256,   320,     0,  0,-0.238698, 0.971094, 0.000000 },
	{      0,   224,     0,  0,-0.238223, 0.971210, 0.000000 },
	{      0,     0, -1024,  0,-0.116347, 0.963517,-0.241035 },
	{   -256,     0, -1024,  0,-0.118012, 0.981057,-0.153624 },
	{   -256,   128,     0,  0,-0.200256, 0.979744, 0.000000 },
	{   -512,     0, -1024,  0,-0.081270, 0.993239,-0.082897 },
	{   -512,    64,     0,  0,-0.122809, 0.992430, 0.000000 },
	{   -768,     0, -1024,  0,-0.041401, 0.998276,-0.041611 },
	{   -768,    32,     0,  0,-0.082839, 0.996563, 0.000000 },
	{    768,     0,  1024,  0,-0.055466, 0.909577, 0.411817 },
	{    512,     0,  1024,  0, 0.000000, 0.926467, 0.376377 },
	{    256,     0,  1024,  0,-0.113907, 0.939532, 0.322962 },
	{      0,     0,  1024,  0,-0.116347, 0.963517, 0.241035 },
	{   -256,     0,  1024,  0,-0.118012, 0.981057, 0.153624 },
	{   -512,     0,  1024,  0,-0.081270, 0.993239, 0.082897 },
	{  -1024,     0,     0,  0,-0.124035, 0.992278, 0.000000 },
	{  -1024,     0, -1024,  0,-0.062145, 0.997944,-0.015650 },
	{  -1024,     0,  1024,  0,-0.062145, 0.997944, 0.015650 },
	{   -768,     0,  1024,  0,-0.041401, 0.998276, 0.041611 },
	{   1024,   480,     0,  0, 0.000000, 1.000000, 0.000000 },
	{   1024,     0,  1024,  0, 0.000000, 0.905459, 0.424434 },
	{   1024,     0, -1024,  0, 0.000000, 0.905459,-0.424434 }
};

static FaceData fuji1Faces[] = { 
	{ 3, 13,  768,  512,  480,    0,    0,-1024,-0.220779, 0.883116,-0.413960, -254.337326,{  0,  1,  2} },
	{ 3, 13,  768,  512,  416,    0,    0,-1024, 0.000000, 0.926467,-0.376377, -385.410095,{  3,  0,  2} },
	{ 3, 13,  512,  256,  416,    0,    0,-1024,-0.336994, 0.898650,-0.280828, -201.297485,{  4,  5,  0} },
	{ 3, 13,  512,  256,  416,    0,    0,-1024, 0.000000, 0.926467,-0.376377, -385.410095,{  4,  0,  3} },
	{ 3, 13,  256,    0,  320,    0,    0,-1024,-0.343982, 0.917286,-0.200656, -205.472031,{  6,  5,  7} },
	{ 3, 13,  256,    0,  320,    0,    0,-1024, 0.000000, 0.954480,-0.298275, -305.433594,{  7,  5,  4} },
	{ 3, 13,    0, -256,  224,    0,    0,-1024,-0.348743, 0.929981,-0.116248, -208.315765,{  8,  9,  6} },
	{ 3, 13,    0, -256,  224,    0,    0,-1024, 0.000000, 0.976900,-0.213697, -218.825607,{  8,  6,  7} },
	{ 3, 13, -256, -512,  128,    0,    0,-1024,-0.242091, 0.968364,-0.060523, -185.925903,{ 10, 11,  9} },
	{ 3, 13, -256, -512,  128,    0,    0,-1024, 0.000000, 0.992278,-0.124035, -127.011566,{ 10,  9,  8} },
	{ 3, 13, -512, -768,   64,    0,    0,-1024,-0.123975, 0.991801,-0.030994, -126.950546,{ 12, 13, 11} },
	{ 3, 13, -512, -768,   64,    0,    0,-1024, 0.000000, 0.998053,-0.062378,  -63.875366,{ 12, 11, 10} },
	{ 3, 13,  768,  512,  480,    0, 1024,    0,-0.220779, 0.883116, 0.413960, -254.337326,{  0, 14,  1} },
	{ 3, 13,  768,  512,  416,    0, 1024,    0, 0.000000, 0.926467, 0.376377, -385.410095,{ 15, 14,  0} },
	{ 3, 13,  512,  256,  416,    0, 1024,    0,-0.336994, 0.898650, 0.280828, -201.297485,{ 16,  0,  5} },
	{ 3, 13,  512,  256,  416,    0, 1024,    0, 0.000000, 0.926467, 0.376377, -385.410095,{ 16, 15,  0} },
	{ 3, 13,  256,    0,  320,    0, 1024,    0,-0.343982, 0.917286, 0.200656, -205.472031,{  6, 17,  5} },
	{ 3, 13,  256,    0,  320,    0, 1024,    0, 0.000000, 0.954480, 0.298275, -305.433594,{ 17, 16,  5} },
	{ 3, 13,    0, -256,  224,    0, 1024,    0,-0.348743, 0.929981, 0.116248, -208.315765,{ 18,  6,  9} },
	{ 3, 13,    0, -256,  224,    0, 1024,    0, 0.000000, 0.976900, 0.213697, -218.825607,{ 18, 17,  6} },
	{ 3, 13, -256, -512,  128,    0, 1024,    0,-0.242091, 0.968364, 0.060523, -185.925903,{ 19,  9, 11} },
	{ 3, 13, -256, -512,  128,    0, 1024,    0, 0.000000, 0.992278, 0.124035, -127.011566,{ 19, 18,  9} },
	{ 3, 13, -768,-1024,   32,    0,    0,-1024,-0.124035, 0.992278, 0.000000, -127.011566,{ 20, 13, 21} },
	{ 3, 13, -768,-1024,   32,    0,    0,-1024, 0.000000, 0.999512,-0.031235,  -31.984386,{ 13, 12, 21} },
	{ 3, 13, -768,-1024,   32,    0, 1024,    0, 0.000000, 0.999512, 0.031235,  -31.984386,{ 22, 23, 13} },
	{ 3, 13, -768,-1024,   32,    0, 1024,    0,-0.124035, 0.992278, 0.000000, -127.011566,{ 22, 13, 20} },
	{ 3, 13, 1024,  768,  480,    0, 1024,    0, 0.000000, 0.905459, 0.424434, -434.620300,{ 14, 24,  1} },
	{ 3, 13, 1024,  768,  480,    0, 1024,    0, 0.000000, 0.905459, 0.424434, -434.620300,{ 14, 25, 24} },
	{ 3, 13, 1024,  768,  480,    0,    0,-1024, 0.000000, 0.905459,-0.424434, -434.620300,{  1, 24,  2} },
	{ 3, 13, 1024,  768,  480,    0,    0,-1024, 0.000000, 0.905459,-0.424434, -434.620300,{ 24, 26,  2} },
	{ 3, 13, -512, -768,   64,    0, 1024,    0,-0.123975, 0.991801, 0.030994, -126.950546,{ 23, 11, 13} },
	{ 3, 13, -512, -768,   64,    0, 1024,    0, 0.000000, 0.998053, 0.062378,  -63.875366,{ 23, 19, 11} }
};

ShapeInfo	fuji1 = { 27,32,32,1024,1024,480,1024,0,fuji1Points,fuji1Faces };

/************************************************************************
 		The curveNW 	
************************************************************************/

static PointData curveNWPoints[] = { 
	{  -1024,     0,  1024,  0,-0.020210, 0.999591, 0.020210 },
	{   -128,     0,  1024,  0, 0.000000, 1.000000, 0.000000 },
	{   -192,     0,   768,  0,-0.006647, 0.997989, 0.063031 },
	{   -320,    32,   512,  0,-0.015208, 0.995793, 0.090356 },
	{   -768,     0,   192,  0,-0.063031, 0.997989, 0.006647 },
	{  -1024,     0,   128,  0, 0.000000, 1.000000, 0.000000 },
	{   -512,    32,   320,  0,-0.090356, 0.995793, 0.015208 },
	{    128,     0,  1024,  0,-0.022121, 0.998580, 0.048468 },
	{    -32,    32,   512,  0, 0.010166, 0.997419, 0.071077 },
	{   -224,    64,   224,  0,-0.028593, 0.999182, 0.028593 },
	{   -512,    32,    32,  0,-0.071077, 0.997419,-0.010166 },
	{  -1024,     0,  -128,  0,-0.048468, 0.998580, 0.022121 },
	{  -1024,     0, -1024,  0,-0.031208, 0.999398,-0.015154 },
	{   1024,     0, -1024,  0, 0.020374, 0.999585,-0.020374 },
	{   1024,     0,  1024,  0, 0.015154, 0.999398, 0.031208 }
};

static FaceData curveNWFaces[] = { 
	{ 3,222, -128,-1024,    0,    0, 1024,  768, 0.000000, 1.000000, 0.000000,    0.000000,{  0,  1,  2} },
	{ 3,221, -192,-1024,   32,    0, 1024,  512, 0.033121, 0.993638, 0.107644,  -76.311371,{  0,  2,  3} },
	{ 3,222, -768,-1024,    0,    0, 1024,  128, 0.000000, 1.000000, 0.000000,    0.000000,{  0,  4,  5} },
	{ 3,221, -512,-1024,   32,    0, 1024,  192,-0.107644, 0.993638,-0.033121,  -76.311371,{  0,  6,  4} },
	{ 3,222, -320,-1024,   32,    0, 1024,  320,-0.026298, 0.999308, 0.026298,  -53.857452,{  0,  3,  6} },
	{ 3,  4,  128, -192,   32,    0, 1024,  512,-0.066290, 0.994354, 0.082863,  -76.366364,{  7,  8,  2} },
	{ 3,  4,  128, -192,    0,    0, 1024,  768, 0.000000, 1.000000, 0.000000,    0.000000,{  1,  7,  2} },
	{ 3,  4,  -32, -320,   32,    0,  768,  512, 0.000000, 0.992278, 0.124035,  -95.258675,{  2,  8,  3} },
	{ 3,  4,  -32, -320,   64,   32,  512,  224, 0.000000, 0.993884, 0.110432,  -88.345222,{  9,  3,  8} },
	{ 3,  4, -512,-1024,   32,    0,  192, -128,-0.082863, 0.994354, 0.066290,  -76.366364,{  4, 10, 11} },
	{ 3,  4, -768,-1024,    0,    0,  192, -128, 0.000000, 1.000000, 0.000000,    0.000000,{  5,  4, 11} },
	{ 3,  4, -512, -768,   32,    0,  320,   32,-0.124035, 0.992278, 0.000000,  -95.258675,{  4,  6, 10} },
	{ 3,  4, -224, -512,   64,   32,  512,  224,-0.082761, 0.993127, 0.082761, -100.636871,{  3,  9,  6} },
	{ 3,  4, -224, -512,   64,   32,  320,   32,-0.110432, 0.993884, 0.000000,  -88.345222,{  6,  9, 10} },
	{ 3,222, -512,-1024,   32,    0,   32,-1024,-0.062378, 0.998053, 0.000000,  -63.875366,{ 11, 10, 12} },
	{ 3,221, 1024,-1024,   32,    0,   32,-1024, 0.000000, 0.999541,-0.030289,  -31.016066,{ 10, 13, 12} },
	{ 3,222, 1024, -512,   64,    0,  224,-1024,-0.045888, 0.994238,-0.096874,  -52.210251,{ 10,  9, 13} },
	{ 3,221, 1024, -224,   64,    0,  512,-1024, 0.096874, 0.994238, 0.045888,  -52.210251,{  8, 13,  9} },
	{ 3,221, 1024,  -32,   32,    0, 1024,  512, 0.000000, 0.998053, 0.062378,  -63.875366,{  7, 14,  8} },
	{ 3,222, 1024,  -32,   32,    0, 1024,-1024, 0.030289, 0.999541, 0.000000,  -31.016066,{  8, 14, 13} }
};

ShapeInfo	curveNW = { 15,20,20,1024,1024,64,1024,0,curveNWPoints,curveNWFaces };

/************************************************************************
 		The loadSN 	
************************************************************************/

static PointData loadSNPoints[] = { 
	{  -1024,     0,  1024,  0, 0.000000, 1.000000, 0.000000 },
	{   -128,     0,  1024,  0, 0.000000, 1.000000, 0.000000 },
	{   -128,     0,   320,  0, 0.000000, 1.000000, 0.000000 },
	{  -1024,     0,  -640,  0, 0.000000, 1.000000, 0.000000 },
	{   -128,     0, -1024,  0, 0.000000, 1.000000, 0.000000 },
	{  -1024,     0, -1024,  0, 0.000000, 1.000000, 0.000000 },
	{    128,     0,  1024,  0, 0.000000, 1.000000, 0.000000 },
	{   1024,     0,  1024,  0, 0.000000, 1.000000, 0.000000 },
	{   1024,     0,  -640,  0, 0.000000, 1.000000, 0.000000 },
	{    128,     0, -1024,  0, 0.000000, 1.000000, 0.000000 },
	{   1024,     0, -1024,  0, 0.000000, 1.000000, 0.000000 }
};

static FaceData loadSNFaces[] = { 
	{ 3,222, -128,-1024,    0,    0, 1024,  320, 0.000000, 1.000000, 0.000000,    0.000000,{  0,  1,  2} },
	{ 3,221, -128,-1024,    0,    0, 1024, -640, 0.000000, 1.000000, 0.000000,    0.000000,{  0,  2,  3} },
	{ 4,222, -128,-1024,    0,    0,  320,-1024, 0.000000, 1.000000, 0.000000,    0.000000,{  2,  4,  5,  3} },
	{ 3,221, 1024,  128,    0,    0, 1024, -640, 0.000000, 1.000000, 0.000000,    0.000000,{  6,  7,  8} },
	{ 3,222, 1024,  128,    0,    0, 1024,-1024, 0.000000, 1.000000, 0.000000,    0.000000,{  6,  8,  9} },
	{ 3,221, 1024,  128,    0,    0, -640,-1024, 0.000000, 1.000000, 0.000000,    0.000000,{  9,  8, 10} },
	{ 3, 79,  128, -128,    0,    0, 1024,  320, 0.000000, 1.000000, 0.000000,    0.000000,{  1,  6,  2} },
	{ 4, 79,  128, -128,    0,    0, 1024,-1024, 0.000000, 1.000000, 0.000000,    0.000000,{  2,  6,  9,  4} }
};

ShapeInfo	loadSN = { 11,8,8,1024,1024,0,1024,0,loadSNPoints,loadSNFaces };

/************************************************************************
 		The mount1 	
************************************************************************/

static PointData mount1Points[] = { 
	{    256,   208,     0,  0, 0.150625, 0.988591, 0.000000 },
	{    128,   240,     0,  0, 0.122277, 0.992496, 0.000000 },
	{    128,     0,  1024,  0, 0.059447, 0.973577, 0.220484 },
	{    256,     0,  1024,  0, 0.000000, 0.979987, 0.199060 },
	{    384,     0,  1024,  0, 0.117472, 0.978685, 0.168452 },
	{    384,   160,     0,  0, 0.237791, 0.971316, 0.000000 },
	{    512,   112,     0,  0, 0.237660, 0.971348, 0.000000 },
	{    512,     0,  1024,  0, 0.118125, 0.985298, 0.123429 },
	{    640,     0,  1024,  0, 0.118553, 0.989909, 0.077629 },
	{    640,    64,     0,  0, 0.200156, 0.979764, 0.000000 },
	{    768,     0,  1024,  0, 0.081358, 0.995817, 0.041586 },
	{    768,    32,     0,  0, 0.122805, 0.992431, 0.000000 },
	{    896,     0,  1024,  0, 0.041412, 0.998925, 0.020823 },
	{    896,    16,     0,  0, 0.082834, 0.996563, 0.000000 },
	{    128,     0, -1024,  0, 0.059447, 0.973577,-0.220484 },
	{    256,     0, -1024,  0, 0.000000, 0.979987,-0.199060 },
	{    384,     0, -1024,  0, 0.117472, 0.978685,-0.168452 },
	{    512,     0, -1024,  0, 0.118125, 0.985298,-0.123429 },
	{    640,     0, -1024,  0, 0.118553, 0.989909,-0.077629 },
	{    768,     0, -1024,  0, 0.081358, 0.995817,-0.041586 },
	{   1024,     0,     0,  0, 0.124035, 0.992278, 0.000000 },
	{   1024,     0,  1024,  0, 0.062139, 0.998037, 0.007827 },
	{   1024,     0, -1024,  0, 0.062139, 0.998037,-0.007827 },
	{    896,     0, -1024,  0, 0.041412, 0.998925,-0.020823 },
	{      0,   240,     0,  0, 0.000000, 1.000000, 0.000000 },
	{      0,     0, -1024,  0, 0.000000, 0.973616,-0.228191 },
	{      0,     0,  1024,  0, 0.000000, 0.973616, 0.228191 },
	{  -1024,     0,  1024,  0,-0.062139, 0.998037, 0.007827 },
	{   -896,     0,  1024,  0,-0.041412, 0.998925, 0.020823 },
	{   -896,    16,     0,  0,-0.082834, 0.996563, 0.000000 },
	{  -1024,     0,     0,  0,-0.124035, 0.992278, 0.000000 },
	{  -1024,     0, -1024,  0,-0.062139, 0.998037,-0.007827 },
	{   -896,     0, -1024,  0,-0.041412, 0.998925,-0.020823 },
	{   -128,     0,  1024,  0,-0.059447, 0.973577, 0.220484 },
	{   -128,   240,     0,  0,-0.122277, 0.992496, 0.000000 },
	{   -128,     0, -1024,  0,-0.059447, 0.973577,-0.220484 },
	{   -768,    32,     0,  0,-0.122805, 0.992431, 0.000000 },
	{   -256,   208,     0,  0,-0.150625, 0.988591, 0.000000 },
	{   -256,     0, -1024,  0, 0.000000, 0.979987,-0.199060 },
	{   -384,     0, -1024,  0,-0.117472, 0.978685,-0.168452 },
	{   -384,   160,     0,  0,-0.237791, 0.971316, 0.000000 },
	{   -512,   112,     0,  0,-0.237660, 0.971348, 0.000000 },
	{   -512,     0, -1024,  0,-0.118125, 0.985298,-0.123429 },
	{   -640,     0, -1024,  0,-0.118553, 0.989909,-0.077629 },
	{   -640,    64,     0,  0,-0.200156, 0.979764, 0.000000 },
	{   -768,     0, -1024,  0,-0.081358, 0.995817,-0.041586 },
	{   -768,     0,  1024,  0,-0.081358, 0.995817, 0.041586 },
	{   -256,     0,  1024,  0, 0.000000, 0.979987, 0.199060 },
	{   -384,     0,  1024,  0,-0.117472, 0.978685, 0.168452 },
	{   -512,     0,  1024,  0,-0.118125, 0.985298, 0.123429 },
	{   -640,     0,  1024,  0,-0.118553, 0.989909, 0.077629 }
};

static FaceData mount1Faces[] = { 
	{ 3,  8,  256,  128,  240,    0, 1024,    0, 0.236499, 0.945996, 0.221718, -257.311035,{  0,  1,  2} },
	{ 3,  8,  256,  128,  208,    0, 1024,    0, 0.000000, 0.979987, 0.199060, -203.837357,{  3,  0,  2} },
	{ 3,  8,  384,  256,  208,    0, 1024,    0, 0.347425, 0.926467, 0.144760, -281.645844,{  4,  5,  0} },
	{ 3,  8,  384,  256,  208,    0, 1024,    0, 0.000000, 0.979987, 0.199060, -203.837357,{  4,  0,  3} },
	{ 3,  8,  512,  384,  160,    0, 1024,    0, 0.349297, 0.931457, 0.101878, -283.163025,{  6,  5,  7} },
	{ 3,  8,  512,  384,  160,    0, 1024,    0, 0.000000, 0.988012, 0.154377, -158.081924,{  7,  5,  4} },
	{ 3,  8,  640,  512,  112,    0, 1024,    0, 0.350524, 0.934730, 0.058421, -284.157898,{  8,  9,  6} },
	{ 3,  8,  640,  512,  112,    0, 1024,    0, 0.000000, 0.994072, 0.108727, -111.336029,{  8,  6,  7} },
	{ 3,  8,  768,  640,   64,    0, 1024,    0, 0.242424, 0.969697, 0.030303, -217.212128,{ 10, 11,  9} },
	{ 3,  8,  768,  640,   64,    0, 1024,    0, 0.000000, 0.998053, 0.062378,  -63.875366,{ 10,  9,  8} },
	{ 3,  8,  896,  768,   32,    0, 1024,    0, 0.124020, 0.992159, 0.015502, -126.996307,{ 12, 13, 11} },
	{ 3,  8,  896,  768,   32,    0, 1024,    0, 0.000000, 0.999512, 0.031235,  -31.984386,{ 12, 11, 10} },
	{ 3,  8,  256,  128,  240,    0,    0,-1024, 0.236499, 0.945996,-0.221718, -257.311035,{  0, 14,  1} },
	{ 3,  8,  256,  128,  208,    0,    0,-1024, 0.000000, 0.979987,-0.199060, -203.837357,{ 15, 14,  0} },
	{ 3,  8,  384,  256,  208,    0,    0,-1024, 0.347425, 0.926467,-0.144760, -281.645844,{ 16,  0,  5} },
	{ 3,  8,  384,  256,  208,    0,    0,-1024, 0.000000, 0.979987,-0.199060, -203.837357,{ 16, 15,  0} },
	{ 3,  8,  512,  384,  160,    0,    0,-1024, 0.349297, 0.931457,-0.101878, -283.163025,{  6, 17,  5} },
	{ 3,  8,  512,  384,  160,    0,    0,-1024, 0.000000, 0.988012,-0.154377, -158.081924,{ 17, 16,  5} },
	{ 3,  8,  640,  512,  112,    0,    0,-1024, 0.350524, 0.934730,-0.058421, -284.157898,{ 18,  6,  9} },
	{ 3,  8,  640,  512,  112,    0,    0,-1024, 0.000000, 0.994072,-0.108727, -111.336029,{ 18, 17,  6} },
	{ 3,  8,  768,  640,   64,    0,    0,-1024, 0.242424, 0.969697,-0.030303, -217.212128,{ 19,  9, 11} },
	{ 3,  8,  768,  640,   64,    0,    0,-1024, 0.000000, 0.998053,-0.062378,  -63.875366,{ 19, 18,  9} },
	{ 3,  8, 1024,  896,   16,    0, 1024,    0, 0.124035, 0.992278, 0.000000, -127.011566,{ 20, 13, 21} },
	{ 3,  8, 1024,  896,   16,    0, 1024,    0, 0.000000, 0.999878, 0.015623,  -15.998047,{ 13, 12, 21} },
	{ 3,  8, 1024,  896,   16,    0,    0,-1024, 0.000000, 0.999878,-0.015623,  -15.998047,{ 22, 23, 13} },
	{ 3,  8, 1024,  896,   16,    0,    0,-1024, 0.124035, 0.992278, 0.000000, -127.011566,{ 22, 13, 20} },
	{ 3,  8,  128,    0,  240,    0,    0,-1024, 0.000000, 0.973616,-0.228191, -233.667908,{ 14, 24,  1} },
	{ 3,  8,  128,    0,  240,    0,    0,-1024, 0.000000, 0.973616,-0.228191, -233.667908,{ 14, 25, 24} },
	{ 3,  8,  128,    0,  240,    0, 1024,    0, 0.000000, 0.973616, 0.228191, -233.667908,{  1, 24,  2} },
	{ 3,  8,  128,    0,  240,    0, 1024,    0, 0.000000, 0.973616, 0.228191, -233.667908,{ 24, 26,  2} },
	{ 3,  8,  896,  768,   32,    0,    0,-1024, 0.124020, 0.992159,-0.015502, -126.996307,{ 23, 11, 13} },
	{ 3,  8,  896,  768,   32,    0,    0,-1024, 0.000000, 0.999512,-0.031235,  -31.984386,{ 23, 19, 11} },
	{ 3,  8, -896,-1024,   16,    0, 1024,    0, 0.000000, 0.999878, 0.015623,  -15.998047,{ 27, 28, 29} },
	{ 3,  8, -896,-1024,   16,    0, 1024,    0,-0.124035, 0.992278, 0.000000, -127.011566,{ 27, 29, 30} },
	{ 3,  8, -896,-1024,   16,    0,    0,-1024,-0.124035, 0.992278, 0.000000, -127.011566,{ 30, 29, 31} },
	{ 3,  8, -896,-1024,   16,    0,    0,-1024, 0.000000, 0.999878,-0.015623,  -15.998047,{ 29, 32, 31} },
	{ 3,  8,    0, -128,  240,    0, 1024,    0, 0.000000, 0.973616, 0.228191, -233.667908,{ 33, 24, 34} },
	{ 3,  8,    0, -128,  240,    0, 1024,    0, 0.000000, 0.973616, 0.228191, -233.667908,{ 33, 26, 24} },
	{ 3,  8,    0, -128,  240,    0,    0,-1024, 0.000000, 0.973616,-0.228191, -233.667908,{ 34, 24, 35} },
	{ 3,  8,    0, -128,  240,    0,    0,-1024, 0.000000, 0.973616,-0.228191, -233.667908,{ 24, 25, 35} },
	{ 3,  8, -768, -896,   32,    0, 1024,    0,-0.124020, 0.992159, 0.015502, -126.996307,{ 28, 36, 29} },
	{ 3,  8, -128, -256,  240,    0,    0,-1024,-0.236499, 0.945996,-0.221718, -257.311035,{ 37, 34, 35} },
	{ 3,  8, -128, -256,  208,    0,    0,-1024, 0.000000, 0.979987,-0.199060, -203.837357,{ 38, 37, 35} },
	{ 3,  8, -256, -384,  208,    0,    0,-1024,-0.347425, 0.926467,-0.144760, -281.645844,{ 39, 40, 37} },
	{ 3,  8, -256, -384,  208,    0,    0,-1024, 0.000000, 0.979987,-0.199060, -203.837357,{ 39, 37, 38} },
	{ 3,  8, -384, -512,  160,    0,    0,-1024,-0.349297, 0.931457,-0.101878, -283.163025,{ 41, 40, 42} },
	{ 3,  8, -384, -512,  160,    0,    0,-1024, 0.000000, 0.988012,-0.154377, -158.081924,{ 42, 40, 39} },
	{ 3,  8, -512, -640,  112,    0,    0,-1024,-0.350524, 0.934730,-0.058421, -284.157898,{ 43, 44, 41} },
	{ 3,  8, -512, -640,  112,    0,    0,-1024, 0.000000, 0.994072,-0.108727, -111.336029,{ 43, 41, 42} },
	{ 3,  8, -640, -768,   64,    0,    0,-1024,-0.242424, 0.969697,-0.030303, -217.212128,{ 45, 36, 44} },
	{ 3,  8, -640, -768,   64,    0,    0,-1024, 0.000000, 0.998053,-0.062378,  -63.875366,{ 45, 44, 43} },
	{ 3,  8, -768, -896,   32,    0,    0,-1024,-0.124020, 0.992159,-0.015502, -126.996307,{ 32, 29, 36} },
	{ 3,  8, -768, -896,   32,    0,    0,-1024, 0.000000, 0.999512,-0.031235,  -31.984386,{ 32, 36, 45} },
	{ 3,  8, -768, -896,   32,    0, 1024,    0, 0.000000, 0.999512, 0.031235,  -31.984386,{ 28, 46, 36} },
	{ 3,  8, -128, -256,  240,    0, 1024,    0,-0.236499, 0.945996, 0.221718, -257.311035,{ 37, 33, 34} },
	{ 3,  8, -128, -256,  208,    0, 1024,    0, 0.000000, 0.979987, 0.199060, -203.837357,{ 47, 33, 37} },
	{ 3,  8, -256, -384,  208,    0, 1024,    0,-0.347425, 0.926467, 0.144760, -281.645844,{ 48, 37, 40} },
	{ 3,  8, -256, -384,  208,    0, 1024,    0, 0.000000, 0.979987, 0.199060, -203.837357,{ 48, 47, 37} },
	{ 3,  8, -384, -512,  160,    0, 1024,    0,-0.349297, 0.931457, 0.101878, -283.163025,{ 41, 49, 40} },
	{ 3,  8, -384, -512,  160,    0, 1024,    0, 0.000000, 0.988012, 0.154377, -158.081924,{ 49, 48, 40} },
	{ 3,  8, -512, -640,  112,    0, 1024,    0,-0.350524, 0.934730, 0.058421, -284.157898,{ 50, 41, 44} },
	{ 3,  8, -512, -640,  112,    0, 1024,    0, 0.000000, 0.994072, 0.108727, -111.336029,{ 50, 49, 41} },
	{ 3,  8, -640, -768,   64,    0, 1024,    0,-0.242424, 0.969697, 0.030303, -217.212128,{ 46, 44, 36} },
	{ 3,  8, -640, -768,   64,    0, 1024,    0, 0.000000, 0.998053, 0.062378,  -63.875366,{ 46, 50, 44} }
};

ShapeInfo	mount1 = { 51,64,64,1024,1024,240,1024,0,mount1Points,mount1Faces };

/************************************************************************
 		The bigmount 	
************************************************************************/

static PointData bigmountPoints[] = { 
	{  -2048,     0,     0,  0,-0.488880, 0.846723, 0.209896 },
	{  -1728,     0,   448,  0,-0.438479, 0.843057, 0.311433 },
	{  -1280,   896,     0,  0,-0.468169, 0.744139, 0.476524 },
	{  -1472,     0,   896,  0,-0.319785, 0.904274, 0.282889 },
	{   -896,   896,   448,  0,-0.611056, 0.629054, 0.480522 },
	{   -960,     0,  1280,  0,-0.423084, 0.820160, 0.385145 },
	{   -448,     0,  1856,  0,-0.214089, 0.854398, 0.473466 },
	{   -256,  1344,   960,  0,-0.408831, 0.690687, 0.596497 },
	{      0,     0,  2048,  0, 0.002342, 0.913847, 0.406053 },
	{    448,   960,  1216,  0, 0.207468, 0.711136, 0.671746 },
	{   1216,     0,  1600,  0, 0.342830, 0.856058, 0.386822 },
	{   1600,     0,   960,  0, 0.446764, 0.847118, 0.287737 },
	{    768,  1152,   640,  0, 0.536129, 0.711046, 0.454950 },
	{   1856,     0,   576,  0, 0.422937, 0.823413, 0.378305 },
	{   1024,  1152,   256,  0, 0.482876, 0.621102, 0.617304 },
	{   2048,     0,     0,  0, 0.540448, 0.808772,-0.231956 },
	{   1344,  1344,    64,  0, 0.667313, 0.725658, 0.167673 },
	{   1600,     0,  -640,  0, 0.486265, 0.790139,-0.373129 },
	{   1152,  1152,  -192,  0, 0.582986, 0.565749,-0.583143 },
	{   1216,     0, -1088,  0, 0.330649, 0.782714,-0.527286 },
	{    768,  1152,  -704,  0, 0.471663, 0.640359,-0.606197 },
	{    704,     0, -1344,  0, 0.345333, 0.793433,-0.501207 },
	{    512,  1088,  -832,  0, 0.345300, 0.568111,-0.747006 },
	{      0,     0, -2048,  0, 0.088079, 0.908550,-0.408386 },
	{   -128,  1024, -1280,  0, 0.085173, 0.673618,-0.734156 },
	{  -1152,     0, -1600,  0,-0.328505, 0.848982,-0.413901 },
	{  -1408,     0,  -896,  0,-0.494592, 0.814047,-0.304477 },
	{   -640,   960, -1088,  0,-0.522603, 0.678876,-0.515765 },
	{  -1792,     0,  -448,  0,-0.454267, 0.770140,-0.447802 },
	{  -1152,   832,  -448,  0,-0.492700, 0.700876,-0.515770 },
	{  -1408,  1152,  -192,  0,-0.458358, 0.870574,-0.178909 },
	{      0,  1792,   192,  0,-0.028465, 0.898843, 0.437346 },
	{    256,  1792,     0,  0, 0.383643, 0.923237, 0.021234 },
	{      0,  1792,  -192,  0, 0.054933, 0.864525,-0.499578 },
	{   -320,  1792,   -64,  0,-0.498601, 0.866448,-0.025801 },
	{  -2048,     0,  2048,  0, 0.000000, 1.000000, 0.000000 },
	{  -2048,     0, -2048,  0, 0.000000, 1.000000, 0.000000 },
	{   2048,     0, -2048,  0, 0.000000, 1.000000, 0.000000 },
	{   2048,     0,  2048,  0, 0.000000, 1.000000, 0.000000 }
};

static FaceData bigmountFaces[] = { 
	{ 3,  8,-1280,-2048,  896,    0,  448,    0,-0.667424, 0.572078, 0.476731,-1366.883911,{  0,  1,  2} },
	{ 3,  8, -896,-1728,  896,    0,  896,  448,-0.675926, 0.627646, 0.386244,-1341.037964,{  1,  3,  4} },
	{ 3,  8, -896,-1728,  896,    0,  448,    0,-0.620539, 0.576215, 0.531891,-1310.578491,{  1,  4,  2} },
	{ 3,  8, -896,-1472,  896,    0, 1280,  448,-0.471791, 0.617822, 0.629055,-1258.109375,{  3,  5,  4} },
	{ 3,  8, -256, -960, 1344,    0, 1856,  960,-0.654980, 0.481705, 0.582204,-1374.002197,{  5,  6,  7} },
	{ 3,  8,  448, -448,  960,    0, 2048, 1216,-0.281283, 0.700082, 0.656327,-1344.157471,{  6,  8,  9} },
	{ 3,  8, 1216,    0,  960,    0, 2048, 1216, 0.289603, 0.546108, 0.786064,-1609.859253,{  8, 10,  9} },
	{ 3,  8, 1600,  768, 1152,    0, 1600,  640, 0.681975, 0.606200, 0.409185,-1483.977051,{ 10, 11, 12} },
	{ 3,  8, 1856, 1024, 1152,    0,  960,  256, 0.664040, 0.602555, 0.442694,-1487.450439,{ 11, 13, 14} },
	{ 3,  8, 2048, 1344, 1344,    0,  576,    0, 0.854635, 0.434100, 0.284878,-1750.292725,{ 13, 15, 16} },
	{ 3,  8, 2048, 1152, 1152,    0,    0, -640, 0.720363, 0.476240,-0.504254,-1475.303711,{ 15, 17, 18} },
	{ 3,  8, 1600,  768, 1152,    0, -640,-1088, 0.675771, 0.455877,-0.579232,-1451.941895,{ 17, 19, 20} },
	{ 3,  8, 1216,  512, 1088,    0, -832,-1344, 0.400028, 0.447090,-0.800055,-1356.893921,{ 19, 21, 22} },
	{ 3,  8,  704, -128, 1024,    0,-1280,-2048, 0.601317, 0.526152,-0.601317,-1231.496826,{ 21, 23, 24} },
	{ 3,  8,    0,-1152, 1024,    0,-1280,-2048,-0.303377, 0.547162,-0.780113,-1597.670654,{ 23, 25, 24} },
	{ 3,  8, -640,-1408,  960,    0, -896,-1600,-0.775880, 0.564277,-0.282138,-1345.235107,{ 25, 26, 27} },
	{ 3,  8,-1152,-1792,  832,    0, -448, -896,-0.655627, 0.504329,-0.561966,-1426.644531,{ 28, 29, 26} },
	{ 3,  8,-1408,-2048, 1152,    0,    0, -448,-0.806236, 0.371124,-0.460706,-1651.171143,{  0, 30, 28} },
	{ 3,  8,-1280,-2048, 1152,    0,    0, -192,-0.446809, 0.382979, 0.808511, -915.063843,{  0,  2, 30} },
	{ 3,  8,-1152,-1792, 1152,    0, -192, -448,-0.428772, 0.329825,-0.841053,-1145.151367,{ 30, 29, 28} },
	{ 3,  8, -640,-1408,  960,    0, -448,-1088,-0.727607, 0.485071,-0.485071,-1459.094360,{ 29, 27, 26} },
	{ 3,  8, -128,-1152, 1024,    0,-1088,-1600,-0.348737, 0.579035,-0.736954,-1580.871094,{ 27, 24, 25} },
	{ 3,  8,  704, -128, 1088,    0, -832,-1344, 0.484670, 0.441006,-0.755386,-1356.447021,{ 24, 22, 21} },
	{ 3,  8, 1216,  512, 1152,    0, -704,-1088, 0.323781, 0.410122,-0.852623,-1321.371094,{ 22, 20, 19} },
	{ 3,  8, 1600,  768, 1152,    0, -192, -704, 0.702615, 0.478168,-0.526961,-1461.438354,{ 20, 18, 17} },
	{ 3,  8, 2048, 1152, 1344,    0,   64, -192, 0.603973, 0.350454,-0.715820,-1236.937256,{ 16, 15, 18} },
	{ 3,  8, 1856, 1024, 1344,    0,  576,   64, 0.261410, 0.428980, 0.864663, -983.221863,{ 14, 13, 16} },
	{ 3,  8, 1600,  768, 1152,    0,  960,  256, 0.664040, 0.602555, 0.442694,-1487.450439,{ 12, 11, 14} },
	{ 3,  8, 1216,  448, 1152,    0, 1600,  640, 0.551213, 0.650148, 0.522945,-1506.987183,{  9, 10, 12} },
	{ 3,  8,  448, -448, 1344,    0, 1856,  960, 0.000000, 0.554700, 0.832050,-1544.285400,{  6,  9,  7} },
	{ 3,  8, -256, -960, 1344,    0, 1280,  448,-0.727127, 0.494303, 0.476394,-1307.825684,{  5,  7,  4} },
	{ 3,  8,  768,    0, 1792,  960, 1216,  192, 0.382120, 0.791931, 0.476266,-1510.583252,{  9, 12, 31} },
	{ 3,  8,  448, -256, 1792,  960, 1216,  192, 0.238480, 0.802159, 0.547419,-1542.573730,{  7,  9, 31} },
	{ 3,  8,    0, -896, 1792,  896,  960,  192,-0.663902, 0.720808, 0.199171,-1329.929321,{  4,  7, 31} },
	{ 3,  8, 1024,  256, 1792, 1152,  640,    0, 0.527372, 0.773479, 0.351581,-1521.081299,{ 12, 14, 32} },
	{ 3,  8, 1152,  256, 1792, 1152,    0, -704, 0.487769, 0.792624,-0.365826,-1545.250977,{ 32, 18, 20} },
	{ 3,  8,  768,    0, 1792, 1088, -192, -832, 0.155126, 0.723923,-0.672214,-1426.334717,{ 33, 20, 22} },
	{ 3,  8,  512, -128, 1792, 1024, -192,-1280, 0.324050, 0.754504,-0.570715,-1461.648682,{ 33, 22, 24} },
	{ 3,  8, -320,-1280, 1792,  896,  448,  -64,-0.575664, 0.652028, 0.493427,-1321.067627,{  4, 34,  2} },
	{ 3,  8, -320,-1280, 1792,  832,    0, -448,-0.663563, 0.690374,-0.288214,-1467.936157,{ 34, 29,  2} },
	{ 3,  8,-1152,-1408, 1152,  832,    0, -448, 0.829399, 0.535096, 0.160529,  582.184570,{  2, 29, 30} },
	{ 3,  8,  768,    0, 1792, 1152,  640,    0, 0.369386, 0.788024, 0.492515,-1506.702637,{ 31, 12, 32} },
	{ 3,  8,  768,    0, 1792, 1152,    0, -704, 0.355434, 0.805651,-0.473912,-1534.717773,{ 33, 32, 20} },
	{ 3,  8, -320,-1152, 1792,  832,  -64,-1088,-0.626966, 0.688888,-0.363795,-1458.399780,{ 34, 27, 29} },
	{ 3,  8,    0, -640, 1792,  960,  -64,-1088,-0.228026, 0.789322,-0.570066,-1523.917358,{ 34, 33, 27} },
	{ 3,  8,    0, -640, 1792,  960, -192,-1280,-0.297167, 0.796184,-0.527051,-1527.955200,{ 33, 24, 27} },
	{ 3,  8,    0, -896, 1792,  896,  448,  -64,-0.476497, 0.646674, 0.595621,-1273.198730,{  4, 31, 34} },
	{ 3,  8, 1344,  256, 1792, 1152,  256,    0, 0.172758, 0.537469, 0.825398,-1007.369751,{ 32, 14, 16} },
	{ 3,  8, 1344,  256, 1792, 1152,   64, -192, 0.304419, 0.638299,-0.707039,-1221.762695,{ 32, 16, 18} },
	{ 4,207,  256, -320, 1792, 1792,  192, -192, 0.000000, 1.000000, 0.000000,-1792.000000,{ 31, 32, 33, 34} },
	{ 3, 13,    0,-2048,    0,    0, 2048, 1856, 0.000000, 1.000000, 0.000000,    0.000000,{ 35,  8,  6} },
	{ 3, 13, -448,-2048,    0,    0, 2048, 1280, 0.000000, 1.000000, 0.000000,    0.000000,{ 35,  6,  5} },
	{ 3, 13, -960,-2048,    0,    0, 2048,  896, 0.000000, 1.000000, 0.000000,    0.000000,{ 35,  5,  3} },
	{ 3, 13,-1472,-2048,    0,    0, 2048,  448, 0.000000, 1.000000, 0.000000,    0.000000,{ 35,  3,  1} },
	{ 3, 13,-1728,-2048,    0,    0, 2048,    0, 0.000000, 1.000000, 0.000000,    0.000000,{ 35,  1,  0} },
	{ 3, 13,-1792,-2048,    0,    0,    0,-2048, 0.000000, 1.000000, 0.000000,    0.000000,{  0, 28, 36} },
	{ 3, 13,-1408,-2048,    0,    0, -448,-2048, 0.000000, 1.000000, 0.000000,    0.000000,{ 28, 26, 36} },
	{ 3, 13,-1152,-2048,    0,    0, -896,-2048, 0.000000, 1.000000, 0.000000,    0.000000,{ 26, 25, 36} },
	{ 3, 13,    0,-2048,    0,    0,-1600,-2048, 0.000000, 1.000000, 0.000000,    0.000000,{ 25, 23, 36} },
	{ 3, 13, 2048,    0,    0,    0,-1344,-2048, 0.000000, 1.000000, 0.000000,    0.000000,{ 21, 37, 23} },
	{ 3, 13, 2048,  704,    0,    0,-1088,-2048, 0.000000, 1.000000, 0.000000,    0.000000,{ 19, 37, 21} },
	{ 3, 13, 2048, 1216,    0,    0, -640,-2048, 0.000000, 1.000000, 0.000000,    0.000000,{ 17, 37, 19} },
	{ 3, 13, 2048, 1600,    0,    0,    0,-2048, 0.000000, 1.000000, 0.000000,    0.000000,{ 15, 37, 17} },
	{ 3, 13, 2048,    0,    0,    0, 2048, 1600, 0.000000, 1.000000, 0.000000,    0.000000,{  8, 38, 10} },
	{ 3, 13, 2048, 1216,    0,    0, 2048,  960, 0.000000, 1.000000, 0.000000,    0.000000,{ 38, 11, 10} },
	{ 3, 13, 2048, 1600,    0,    0, 2048,  576, 0.000000, 1.000000, 0.000000,    0.000000,{ 38, 13, 11} },
	{ 3, 13, 2048, 1856,    0,    0, 2048,    0, 0.000000, 1.000000, 0.000000,    0.000000,{ 13, 38, 15} }
};

ShapeInfo	bigmount = { 39,67,67,2048,2048,1792,2048,0,bigmountPoints,bigmountFaces };

/************************************************************************
 		The mountain 	
************************************************************************/

static PointData mountainPoints[] = { 
	{  -2048,     0, -2048,  0,-0.222473, 0.949216,-0.222473 },
	{  -2048,     0,  2048,  0,-0.222473, 0.949216, 0.222473 },
	{      0,   960,     0,  0, 0.000000, 1.000000, 0.000000 },
	{   2048,     0, -2048,  0, 0.222473, 0.949216,-0.222473 },
	{   2048,     0,  2048,  0, 0.222473, 0.949216, 0.222473 }
};

static FaceData mountainFaces[] = { 
	{ 3,  8,    0,-2048,  960,    0, 2048,-2048,-0.424434, 0.905459, 0.000000, -869.240601,{  0,  1,  2} },
	{ 3,  8, 2048,    0,  960,    0, 2048,-2048, 0.424434, 0.905459, 0.000000, -869.240601,{  3,  2,  4} },
	{ 3,  8, 2048,-2048,  960,    0, 2048,    0, 0.000000, 0.905459, 0.424434, -869.240601,{  1,  4,  2} },
	{ 3,  8, 2048,-2048,  960,    0,    0,-2048, 0.000000, 0.905459,-0.424434, -869.240601,{  0,  2,  3} }
};

ShapeInfo	mountain = { 5,4,4,2048,2048,960,2048,0,mountainPoints,mountainFaces };

/************************************************************************
 		The takiop2 	
************************************************************************/

static PointData takiop2Points[] = { 
	{  -1024,     0, -1024,  0,-0.325174, 0.909347,-0.259517 },
	{  -1024,     0,  1024,  0,-0.318967, 0.936446, 0.146045 },
	{   -512,   384,  -320,  0,-0.362401, 0.931779,-0.021307 },
	{      0,     0,  1024,  0,-0.630663, 0.648909, 0.425655 },
	{   1024,     0, -1024,  0, 0.231966, 0.940222,-0.249347 },
	{      0,   640,  1024,  0,-0.147723, 0.986801, 0.066344 },
	{   1024,     0,  1024,  0, 0.529999, 0.847998, 0.000000 }
};

static FaceData takiop2Faces[] = { 
	{ 3, 13, -512,-1024,  384,    0, 1024,-1024,-0.600000, 0.800000, 0.000000, -614.400024,{  0,  1,  2} },
	{ 3, 13,    0,-1024,  384,    0, 1024, -320, 0.000000, 0.961524, 0.274721, -281.314423,{  1,  3,  2} },
	{ 3,  8, 1024,-1024,  384,    0, -320,-1024, 0.000000, 0.877896,-0.478852, -490.344574,{  0,  2,  4} },
	{ 3,  8, 1024, -512,  640,    0, 1024,-1024, 0.133386, 0.962985,-0.234240, -376.449005,{  2,  5,  4} },
	{ 3,  8,    0, -512,  640,  384, 1024, -320, 0.000000, 0.000000, 0.000000,    0.000000,{  2,  5,  5} },
	{ 3,  8, 1024,    0,  640,    0, 1024,-1024, 0.529999, 0.847998, 0.000000, -542.718933,{  5,  6,  4} },
	{ 3,  8,    0, -512,  640,    0, 1024, -320,-0.934488, 0.000000, 0.355995, -364.539215,{  2,  3,  5} }
};

ShapeInfo	takiop2 = { 7,7,7,1024,1024,640,1024,0,takiop2Points,takiop2Faces };

/************************************************************************
 		The takiop1 	
************************************************************************/

static PointData takiop1Points[] = { 
	{  -1024,     0,  1024,  0,-0.234774, 0.947465, 0.217235 },
	{   -384,   320,   320,  0,-0.331985, 0.942393, 0.040992 },
	{  -1024,     0, -1024,  0,-0.231242, 0.965496,-0.119765 },
	{      0,     0, -1024,  0,-0.659249, 0.666985,-0.347163 },
	{   1024,     0,  1024,  0, 0.216429, 0.948060, 0.233111 },
	{      0,   640, -1024,  0,-0.184745, 0.982730,-0.010580 },
	{   1024,     0, -1024,  0, 0.529999, 0.847998, 0.000000 }
};

static FaceData takiop1Faces[] = { 
	{ 3, 13, -384,-1024,  320,    0, 1024,-1024,-0.447214, 0.894427, 0.000000, -457.946716,{  0,  1,  2} },
	{ 3, 13,    0,-1024,  320,    0,  320,-1024, 0.000000, 0.972806,-0.231621, -237.179413,{  2,  1,  3} },
	{ 3,  8, 1024,-1024,  320,    0, 1024,  320, 0.000000, 0.910366, 0.413803, -423.734222,{  0,  4,  1} },
	{ 3,  8, 1024, -384,  640,    0, 1024,-1024, 0.091153, 0.962575, 0.255228, -354.694122,{  1,  4,  5} },
	{ 3,  8,    0, -384,  640,  320,  320,-1024, 0.000000, 0.000000, 0.000000,    0.000000,{  1,  5,  5} },
	{ 3,  8, 1024,    0,  640,    0, 1024,-1024, 0.529999, 0.847998, 0.000000, -542.718933,{  5,  4,  6} },
	{ 3,  8,    0, -384,  640,    0,  320,-1024,-0.961524, 0.000000,-0.274721, -281.314453,{  1,  5,  3} }
};

ShapeInfo	takiop1 = { 7,7,7,1024,1024,640,1024,0,takiop1Points,takiop1Faces };

/************************************************************************
 		The waterfall 	
************************************************************************/

static PointData waterfallPoints[] = { 
	{   -320,   -64,   416,  0,-0.072143, 0.937018,-0.341750 },
	{   -640,   -64,   192,  0, 0.122304, 0.921078,-0.369671 },
	{   -640,     0,   256,  0, 0.162263, 0.856230,-0.490450 },
	{   -320,     0,   480,  0,-0.270730, 0.934624,-0.230615 },
	{   -320,     0,  -448,  0, 0.107203, 0.921716, 0.372757 },
	{   -640,     0,  -256,  0, 0.092220, 0.854000, 0.512034 },
	{   -640,   -64,  -192,  0, 0.085250, 0.951244, 0.296426 },
	{   -320,   -64,  -384,  0,-0.139848, 0.824245, 0.548692 },
	{    128,   640,   -96,  0,-0.534539, 0.663813, 0.523088 },
	{      0,     0,   -96,  0,-0.905835, 0.276148, 0.321256 },
	{      0,     0,    96,  0,-0.843113, 0.219687,-0.490813 },
	{    128,   640,    96,  0,-0.534539, 0.663813,-0.523088 },
	{   -128,   -64,   160,  0,-0.421996, 0.762761,-0.490015 },
	{   -128,     0,   224,  0,-0.702979, 0.572580,-0.421868 },
	{   -320,   -64,   352,  0, 0.148223, 0.938204, 0.312735 },
	{   -224,   -64,   192,  0, 0.318632, 0.947870, 0.004013 },
	{   -320,   -32,   256,  0, 0.006673, 0.999875,-0.014332 },
	{   -352,   -64,   128,  0,-0.028595, 0.971405,-0.235702 },
	{   -416,   -64,   192,  0,-0.192450, 0.962250,-0.192450 },
	{   -480,   -64,   256,  0,-0.195750, 0.978749, 0.061090 },
	{   -160,   -64,  -160,  0, 0.694759, 0.694759, 0.186067 },
	{   -224,     0,  -160,  0,-0.074224, 0.993606, 0.085073 },
	{   -256,   -64,   -96,  0,-0.115196, 0.730608, 0.673010 },
	{   -288,   -64,  -160,  0,-0.706211, 0.706211,-0.050316 },
	{   -224,   -64,  -256,  0, 0.000000, 0.832050,-0.554700 },
	{    128,   800,  -224,  0, 0.027481, 0.943113, 0.331334 },
	{      0,   640,  -320,  0,-0.930836, 0.326836, 0.163470 },
	{   -128,     0,  -448,  0,-0.611706, 0.742402, 0.273230 },
	{    -64,   192,  -704,  0,-0.910734, 0.391755, 0.130736 },
	{   -256,     0,  -832,  0,-0.586875, 0.809344, 0.023231 },
	{    128,   768,  -640,  0,-0.224320, 0.963274,-0.147590 },
	{      0,   640, -1024,  0,-0.682144, 0.558747,-0.471680 },
	{      0,   640,   320,  0,-0.894223, 0.365650,-0.258195 },
	{    128,   800,   224,  0, 0.025632, 0.943368,-0.330757 },
	{    -64,   384,   576,  0,-0.963401, 0.266508, 0.028850 },
	{    -96,     0,   768,  0,-0.704404, 0.690944, 0.162514 },
	{    128,   768,   640,  0,-0.393800, 0.901745, 0.178261 },
	{      0,   640,  1024,  0,-0.545529, 0.696238, 0.466531 },
	{  -1024,   -64,  -192,  0,-0.016289, 0.895423, 0.444918 },
	{  -1024,   -64,   192,  0, 0.000000, 0.923880,-0.382683 },
	{      0,   -64,   -96,  0,-0.616113, 0.738318, 0.274394 },
	{      0,   -64,    96,  0,-0.733349, 0.506732,-0.453235 },
	{    -64,     0,  1024,  0,-0.532050, 0.592029, 0.605330 },
	{    -96,     0, -1024,  0,-0.359726, 0.525316,-0.771129 },
	{   -256,   -64,  -256,  0, 0.702101, 0.711517,-0.028249 },
	{   -320,   -64,  -320,  0, 0.087318, 0.718809,-0.689703 },
	{   -352,    32,  -224,  0, 0.000800, 0.984324,-0.176368 },
	{   -448,   -64,  -256,  0,-0.504701, 0.681393,-0.530076 },
	{   -512,   -64,  -128,  0,-0.473690, 0.876393, 0.086910 },
	{   -384,   -64,   -64,  0, 0.267261, 0.801784, 0.534522 },
	{  -1024,     0,   256,  0, 0.000000, 0.923880,-0.382683 },
	{  -1024,     0,  1024,  0, 0.000000, 1.000000, 0.000000 },
	{   -640,     0,  1024,  0, 0.000000, 1.000000, 0.000000 },
	{  -1024,     0, -1024,  0, 0.000000, 1.000000, 0.000000 },
	{  -1024,     0,  -288,  0,-0.024129, 0.956860, 0.289545 },
	{   -192,    96,   480,  0,-0.151235, 0.988376,-0.015534 },
	{   1024,     0,  1024,  0, 0.374766, 0.599625, 0.707107 },
	{   1024,     0, -1024,  0, 0.477177, 0.644650,-0.597268 },
	{   1024,     0,   640,  0, 0.620466, 0.774486, 0.123263 },
	{   1024,     0,     0,  0, 0.597757, 0.801677, 0.000000 },
	{   1024,     0,  -480,  0, 0.657751, 0.752988,-0.019312 }
};

static FaceData waterfallFaces[] = { 
	{ 4,143, -320, -640,    0,  -64,  480,  192, 0.443607, 0.633724,-0.633724,  446.141876,{  0,  1,  2,  3} },
	{ 4,143, -320, -640,    0,  -64, -192, -448, 0.390567, 0.650945, 0.650945,  416.604492,{  4,  5,  6,  7} },
	{ 4,191,  128,    0,  640,    0,   96,  -96,-0.980581, 0.196116, 0.000000,    0.000002,{  8,  9, 10, 11} },
	{ 4,143, -128, -320,    0,  -64,  480,  160,-0.685994, 0.514496,-0.514496,   27.439770,{ 12,  0,  3, 13} },
	{ 3,  0, -224, -320,  -32,  -64,  352,  192, 0.466252, 0.839254, 0.279751,  104.440536,{ 14, 15, 16} },
	{ 3,  0, -224, -352,  -32,  -64,  256,  128, 0.136083, 0.952579,-0.272166,  143.703400,{ 15, 17, 16} },
	{ 3,  0, -320, -416,  -32,  -64,  256,  128,-0.192450, 0.962250,-0.192450,   18.475210,{ 17, 18, 16} },
	{ 3,  0, -320, -480,  -32,  -64,  256,  192,-0.192450, 0.962250,-0.192450,   18.475210,{ 18, 19, 16} },
	{ 3,  0, -320, -480,  -32,  -64,  352,  256,-0.186411, 0.932055, 0.310685, -109.361084,{ 14, 16, 19} },
	{ 3,  0, -160, -256,    0,  -64,  -96, -160, 0.485071, 0.485071, 0.727607,  225.073059,{ 20, 21, 22} },
	{ 3,  0, -224, -288,    0,  -64,  -96, -160,-0.666667, 0.666667, 0.333333,  -96.000000,{ 21, 23, 22} },
	{ 3,  0, -160, -224,    0,  -64, -160, -256, 0.639602, 0.639602,-0.426401,   75.046646,{ 20, 24, 21} },
	{ 3,  0, -224, -288,    0,  -64, -160, -256,-0.639602, 0.639602,-0.426401, -211.495102,{ 24, 23, 21} },
	{ 3,  8,  128,    0,  800,  640,  -96, -320,-0.807000, 0.368914, 0.461143,  -88.539459,{  8, 25, 26} },
	{ 3,  8,  128,    0,  640,    0,  -96, -320,-0.855442, 0.171088, 0.488824,   46.927071,{ 26,  9,  8} },
	{ 3,  8,    0, -128,  640,    0,  -96, -448,-0.933142, 0.118764, 0.339324,   32.575142,{ 26, 27,  9} },
	{ 3,  8,    0, -128,  640,    0, -320, -704,-0.973668, 0.211667,-0.084667, -162.560165,{ 26, 28, 27} },
	{ 3,  8,  -64, -256,  192,    0, -448, -832,-0.763370, 0.593732, 0.254457,   16.285223,{ 28, 29, 27} },
	{ 3,  8,  128,  -64,  768,  192, -320, -704,-0.914390, 0.330737,-0.233461, -286.379150,{ 26, 30, 28} },
	{ 3,  8,    0, -256,  640,    0, -704,-1024,-0.760529, 0.445827, 0.472053,  198.052261,{ 28, 31, 29} },
	{ 3,  8,  128,  -64,  768,  192, -640,-1024,-0.933346, 0.287183, 0.215387,   36.759468,{ 30, 31, 28} },
	{ 3,  8,  128,    0,  800,  640, -224, -640,-0.765257, 0.641829,-0.049371, -426.569153,{ 25, 30, 26} },
	{ 3,  8,  128,    0,  800,  640,  320,   96,-0.807000, 0.368914,-0.461143,  -88.539459,{ 11, 32, 33} },
	{ 3,  8,  128,    0,  640,    0,  320,   96,-0.855442, 0.171088,-0.488824,   46.927071,{ 32, 11, 10} },
	{ 3,  8,    0, -128,  640,    0,  320,   96,-0.686398, 0.240239,-0.686398,   65.894226,{ 32, 10, 13} },
	{ 3,  8,    0, -128,  640,    0,  576,  224,-0.978447, 0.202070,-0.042541, -115.711945,{ 32, 13, 34} },
	{ 3,  8,  -64, -128,  384,    0,  768,  224,-0.992011, 0.111844, 0.058354, -140.048599,{ 34, 13, 35} },
	{ 3,  8,  128,  -64,  768,  384,  640,  320,-0.890348, 0.413376, 0.190789, -325.613037,{ 32, 34, 36} },
	{ 3,  8,    0,  -96,  640,    0, 1024,  576,-0.990159, 0.119186, 0.073345, -151.384338,{ 34, 35, 37} },
	{ 3,  8,  128,  -64,  768,  384, 1024,  576,-0.876405, 0.461266,-0.138380, -153.509186,{ 36, 34, 37} },
	{ 3,  8,  128,    0,  800,  640,  640,  224,-0.765257, 0.641829, 0.049371, -426.569153,{ 33, 32, 36} },
	{ 3,191, -320, -640,  -64,  -64,  416, -192, 0.000000, 1.000000, 0.000000,   64.000000,{  6,  1,  0} },
	{ 4,191, -640,-1024,  -64,  -64,  192, -192, 0.000000, 1.000000, 0.000000,   64.000000,{  6, 38, 39,  1} },
	{ 4,191,    0,    0,    0,  -64,   96,  -96,-1.000000, 0.000000, 0.000000,    0.000000,{ 10,  9, 40, 41} },
	{ 3,  8,    0,  -96,  640,    0, 1024,  768,-0.987429, 0.098743, 0.123429, -189.586288,{ 37, 35, 42} },
	{ 3,  8,    0, -256,  640,    0, -832,-1024,-0.763171, 0.114476,-0.635976, -724.503662,{ 31, 43, 29} },
	{ 3,  0, -256, -352,   32,  -64, -224, -320, 0.514496, 0.685994,-0.514496,   43.903637,{ 44, 45, 46} },
	{ 3,  0, -320, -448,   32,  -64, -224, -320,-0.358569, 0.597614,-0.717137, -305.978516,{ 45, 47, 46} },
	{ 3,  0, -352, -512,   32,  -64, -128, -256,-0.618853, 0.721995,-0.309426, -310.251495,{ 47, 48, 46} },
	{ 3,  0, -352, -512,   32,  -64,  -64, -224,-0.232845, 0.853766, 0.465690,   -4.967361,{ 48, 49, 46} },
	{ 3,  0, -256, -384,   32,  -64,  -64, -256, 0.698536, 0.543305, 0.465690,  332.813354,{ 44, 46, 49} },
	{ 5,221, -320,-1024,    0,    0, 1024,  256, 0.000000, 1.000000, 0.000000,    0.000000,{  3,  2, 50, 51, 52} },
	{ 4,221, -320,-1024,    0,    0, -256,-1024, 0.000000, 1.000000, 0.000000,    0.000000,{ 53, 54,  5,  4} },
	{ 4,143, -640,-1024,    0,  -64,  256,  192, 0.000000, 0.707107,-0.707107,  181.019333,{ 50,  2,  1, 39} },
	{ 3,143, -640,-1024,    0,  -64, -192, -256, 0.000000, 0.707107, 0.707107,  181.019333,{ 38,  6,  5} },
	{ 3,141, -640,-1024,    0,  -64, -192, -288,-0.046176, 0.831163, 0.554109,  112.299316,{ 38,  5, 54} },
	{ 3,143,    0, -128,    0,  -64,  224,   96,-0.577350, 0.577350,-0.577350,   55.425625,{ 13, 10, 12} },
	{ 3,143,    0, -128,    0,  -64,  160,   96,-0.447214, 0.000000,-0.894427,   85.865005,{ 12, 10, 41} },
	{ 4,220,  -64, -640,    0,    0, 1024,  480, 0.000000, 1.000000, 0.000000,    0.000000,{ 52, 42, 35,  3} },
	{ 3, 95,  -96, -320,   96,    0,  768,  480,-0.543710, 0.724946, 0.422885, -376.972198,{  3, 35, 55} },
	{ 3, 95, -128, -320,   96,    0,  480,  224,-0.547153, 0.729537,-0.410365,   21.886129,{  3, 55, 13} },
	{ 3, 95,  -96, -192,   96,    0,  768,  224, 0.771136, 0.635053,-0.045361,  108.866211,{ 55, 35, 13} },
	{ 3,143,    0, -320,    0,  -64,  -96, -384,-0.668965, 0.000000, 0.743294,   71.356232,{  9,  7, 40} },
	{ 3,143,    0, -320,    0,  -64,  -96, -448,-0.283452, 0.953431, 0.103074,    9.895067,{  9, 27,  7} },
	{ 3,143, -128, -320,    0,  -64, -384, -448, 0.000000, 0.707107, 0.707107,  316.783844,{  7, 27,  4} },
	{ 4,220, -128,-1024,    0,    0, -448,-1024, 0.000000, 1.000000, 0.000000,    0.000000,{  4, 27, 29, 53} },
	{ 3,219,  -96,-1024,    0,    0, -832,-1024, 0.000000, 1.000000, 0.000000,    0.000000,{ 29, 43, 53} },
	{ 5,191,    0, -640,  -64,  -64,  416, -384, 0.000000, 1.000000, 0.000000,   64.000000,{  0, 12, 40,  7,  6} },
	{ 3,191,    0, -128,  -64,  -64,  160,  -96, 0.000000, 1.000000, 0.000000,   64.000000,{ 12, 41, 40} },
	{ 3,  8, 1024,  -64,  640,    0, 1024, 1024, 0.000000, 0.000000, 1.000000,-1024.000000,{ 42, 56, 37} },
	{ 3,  8, 1024,  -96,  640,    0,-1024,-1024, 0.000000, 0.000000,-1.000000,-1024.000000,{ 31, 57, 43} },
	{ 3,  8, 1024,    0,  640,    0, 1024,  640, 0.529999, 0.847998, 0.000000, -542.718933,{ 37, 56, 58} },
	{ 3,  8, 1024,    0,  768,    0, 1024,  640, 0.588978, 0.687141, 0.425373, -875.352173,{ 37, 58, 36} },
	{ 3,  8, 1024,  128,  800,    0,  640,  224, 0.649684, 0.757965, 0.058305, -702.591858,{ 36, 58, 33} },
	{ 3,  8, 1024,  128,  800,    0,  224,    0, 0.340838, 0.587290,-0.734112, -349.017822,{ 33, 59, 11} },
	{ 3,  8, 1024,  128,  800,    0,  640,    0, 0.666016, 0.745938, 0.000000, -682.000122,{ 33, 58, 59} },
	{ 3,  8, 1024,  128,  640,    0,   96,  -96, 0.581238, 0.813733, 0.000000, -595.187927,{ 11, 59,  8} },
	{ 3,  8, 1024,  128,  800,    0,    0, -224, 0.340838, 0.587290, 0.734112, -349.017822,{  8, 59, 25} },
	{ 3,  8, 1024,  128,  800,    0, -224, -640, 0.655641, 0.752849,-0.057911, -699.173462,{ 25, 60, 30} },
	{ 3,  8, 1024,  128,  800,    0,    0, -480, 0.666016, 0.745938, 0.000000, -682.000122,{ 25, 59, 60} },
	{ 3,  8, 1024,  128,  768,    0, -480,-1024, 0.650791, 0.759257, 0.000000, -666.410339,{ 30, 60, 57} },
	{ 3,  8, 1024,    0,  768,    0, -640,-1024, 0.481621, 0.770594,-0.417405, -920.602417,{ 30, 57, 31} }
};

ShapeInfo	waterfall = { 61,72,72,1024,1024,800,1024,0,waterfallPoints,waterfallFaces };

/************************************************************************
 		The mount2 	
************************************************************************/

static PointData mount2Points[] = { 
	{    256,   208,     0,  0, 0.150625, 0.988591, 0.000000 },
	{    128,   240,     0,  0, 0.122277, 0.992496, 0.000000 },
	{    128,     0,  1024,  0, 0.059447, 0.973577, 0.220484 },
	{    256,     0,  1024,  0, 0.000000, 0.979987, 0.199060 },
	{    384,     0,  1024,  0, 0.117472, 0.978685, 0.168452 },
	{    384,   160,     0,  0, 0.237791, 0.971316, 0.000000 },
	{    512,   112,     0,  0, 0.237660, 0.971348, 0.000000 },
	{    512,     0,  1024,  0, 0.118125, 0.985298, 0.123429 },
	{    640,     0,  1024,  0, 0.118553, 0.989909, 0.077629 },
	{    640,    64,     0,  0, 0.200156, 0.979764, 0.000000 },
	{    768,     0,  1024,  0, 0.081358, 0.995817, 0.041586 },
	{    768,    32,     0,  0, 0.122805, 0.992431, 0.000000 },
	{    896,     0,  1024,  0, 0.041412, 0.998925, 0.020823 },
	{    896,    16,     0,  0, 0.082834, 0.996563, 0.000000 },
	{    128,     0, -1024,  0, 0.059447, 0.973577,-0.220484 },
	{    256,     0, -1024,  0, 0.000000, 0.979987,-0.199060 },
	{    384,     0, -1024,  0, 0.117472, 0.978685,-0.168452 },
	{    512,     0, -1024,  0, 0.118125, 0.985298,-0.123429 },
	{    640,     0, -1024,  0, 0.118553, 0.989909,-0.077629 },
	{    768,     0, -1024,  0, 0.081358, 0.995817,-0.041586 },
	{   1024,     0,     0,  0, 0.124035, 0.992278, 0.000000 },
	{   1024,     0,  1024,  0, 0.062139, 0.998037, 0.007827 },
	{   1024,     0, -1024,  0, 0.062139, 0.998037,-0.007827 },
	{    896,     0, -1024,  0, 0.041412, 0.998925,-0.020823 },
	{      0,   240,     0,  0, 0.000000, 1.000000, 0.000000 },
	{      0,     0, -1024,  0, 0.000000, 0.973616,-0.228191 },
	{      0,     0,  1024,  0, 0.000000, 0.973616, 0.228191 },
	{  -1024,     0,  1024,  0,-0.062139, 0.998037, 0.007827 },
	{   -896,     0,  1024,  0,-0.041412, 0.998925, 0.020823 },
	{   -896,    16,     0,  0,-0.082834, 0.996563, 0.000000 },
	{  -1024,     0,     0,  0,-0.124035, 0.992278, 0.000000 },
	{  -1024,     0, -1024,  0,-0.062139, 0.998037,-0.007827 },
	{   -896,     0, -1024,  0,-0.041412, 0.998925,-0.020823 },
	{   -128,     0,  1024,  0,-0.059447, 0.973577, 0.220484 },
	{   -128,   240,     0,  0,-0.122277, 0.992496, 0.000000 },
	{   -128,     0, -1024,  0,-0.059447, 0.973577,-0.220484 },
	{   -768,    32,     0,  0,-0.122805, 0.992431, 0.000000 },
	{   -256,   208,     0,  0,-0.150625, 0.988591, 0.000000 },
	{   -256,     0, -1024,  0, 0.000000, 0.979987,-0.199060 },
	{   -384,     0, -1024,  0,-0.117472, 0.978685,-0.168452 },
	{   -384,   160,     0,  0,-0.237791, 0.971316, 0.000000 },
	{   -512,   112,     0,  0,-0.237660, 0.971348, 0.000000 },
	{   -512,     0, -1024,  0,-0.118125, 0.985298,-0.123429 },
	{   -640,     0, -1024,  0,-0.118553, 0.989909,-0.077629 },
	{   -640,    64,     0,  0,-0.200156, 0.979764, 0.000000 },
	{   -768,     0, -1024,  0,-0.081358, 0.995817,-0.041586 },
	{   -768,     0,  1024,  0,-0.081358, 0.995817, 0.041586 },
	{   -256,     0,  1024,  0, 0.000000, 0.979987, 0.199060 },
	{   -384,     0,  1024,  0,-0.117472, 0.978685, 0.168452 },
	{   -512,     0,  1024,  0,-0.118125, 0.985298, 0.123429 },
	{   -640,     0,  1024,  0,-0.118553, 0.989909, 0.077629 }
};

static FaceData mount2Faces[] = { 
	{ 3, 13,  256,  128,  240,    0, 1024,    0, 0.236499, 0.945996, 0.221718, -257.311035,{  0,  1,  2} },
	{ 3, 13,  256,  128,  208,    0, 1024,    0, 0.000000, 0.979987, 0.199060, -203.837357,{  3,  0,  2} },
	{ 3, 13,  384,  256,  208,    0, 1024,    0, 0.347425, 0.926467, 0.144760, -281.645844,{  4,  5,  0} },
	{ 3, 13,  384,  256,  208,    0, 1024,    0, 0.000000, 0.979987, 0.199060, -203.837357,{  4,  0,  3} },
	{ 3, 13,  512,  384,  160,    0, 1024,    0, 0.349297, 0.931457, 0.101878, -283.163025,{  6,  5,  7} },
	{ 3, 13,  512,  384,  160,    0, 1024,    0, 0.000000, 0.988012, 0.154377, -158.081924,{  7,  5,  4} },
	{ 3, 13,  640,  512,  112,    0, 1024,    0, 0.350524, 0.934730, 0.058421, -284.157898,{  8,  9,  6} },
	{ 3, 13,  640,  512,  112,    0, 1024,    0, 0.000000, 0.994072, 0.108727, -111.336029,{  8,  6,  7} },
	{ 3, 13,  768,  640,   64,    0, 1024,    0, 0.242424, 0.969697, 0.030303, -217.212128,{ 10, 11,  9} },
	{ 3, 13,  768,  640,   64,    0, 1024,    0, 0.000000, 0.998053, 0.062378,  -63.875366,{ 10,  9,  8} },
	{ 3, 13,  896,  768,   32,    0, 1024,    0, 0.124020, 0.992159, 0.015502, -126.996307,{ 12, 13, 11} },
	{ 3, 13,  896,  768,   32,    0, 1024,    0, 0.000000, 0.999512, 0.031235,  -31.984386,{ 12, 11, 10} },
	{ 3, 13,  256,  128,  240,    0,    0,-1024, 0.236499, 0.945996,-0.221718, -257.311035,{  0, 14,  1} },
	{ 3, 13,  256,  128,  208,    0,    0,-1024, 0.000000, 0.979987,-0.199060, -203.837357,{ 15, 14,  0} },
	{ 3, 13,  384,  256,  208,    0,    0,-1024, 0.347425, 0.926467,-0.144760, -281.645844,{ 16,  0,  5} },
	{ 3, 13,  384,  256,  208,    0,    0,-1024, 0.000000, 0.979987,-0.199060, -203.837357,{ 16, 15,  0} },
	{ 3, 13,  512,  384,  160,    0,    0,-1024, 0.349297, 0.931457,-0.101878, -283.163025,{  6, 17,  5} },
	{ 3, 13,  512,  384,  160,    0,    0,-1024, 0.000000, 0.988012,-0.154377, -158.081924,{ 17, 16,  5} },
	{ 3, 13,  640,  512,  112,    0,    0,-1024, 0.350524, 0.934730,-0.058421, -284.157898,{ 18,  6,  9} },
	{ 3, 13,  640,  512,  112,    0,    0,-1024, 0.000000, 0.994072,-0.108727, -111.336029,{ 18, 17,  6} },
	{ 3, 13,  768,  640,   64,    0,    0,-1024, 0.242424, 0.969697,-0.030303, -217.212128,{ 19,  9, 11} },
	{ 3, 13,  768,  640,   64,    0,    0,-1024, 0.000000, 0.998053,-0.062378,  -63.875366,{ 19, 18,  9} },
	{ 3, 13, 1024,  896,   16,    0, 1024,    0, 0.124035, 0.992278, 0.000000, -127.011566,{ 20, 13, 21} },
	{ 3, 13, 1024,  896,   16,    0, 1024,    0, 0.000000, 0.999878, 0.015623,  -15.998047,{ 13, 12, 21} },
	{ 3, 13, 1024,  896,   16,    0,    0,-1024, 0.000000, 0.999878,-0.015623,  -15.998047,{ 22, 23, 13} },
	{ 3, 13, 1024,  896,   16,    0,    0,-1024, 0.124035, 0.992278, 0.000000, -127.011566,{ 22, 13, 20} },
	{ 3, 13,  128,    0,  240,    0,    0,-1024, 0.000000, 0.973616,-0.228191, -233.667908,{ 14, 24,  1} },
	{ 3, 13,  128,    0,  240,    0,    0,-1024, 0.000000, 0.973616,-0.228191, -233.667908,{ 14, 25, 24} },
	{ 3, 13,  128,    0,  240,    0, 1024,    0, 0.000000, 0.973616, 0.228191, -233.667908,{  1, 24,  2} },
	{ 3, 13,  128,    0,  240,    0, 1024,    0, 0.000000, 0.973616, 0.228191, -233.667908,{ 24, 26,  2} },
	{ 3, 13,  896,  768,   32,    0,    0,-1024, 0.124020, 0.992159,-0.015502, -126.996307,{ 23, 11, 13} },
	{ 3, 13,  896,  768,   32,    0,    0,-1024, 0.000000, 0.999512,-0.031235,  -31.984386,{ 23, 19, 11} },
	{ 3, 13, -896,-1024,   16,    0, 1024,    0, 0.000000, 0.999878, 0.015623,  -15.998047,{ 27, 28, 29} },
	{ 3, 13, -896,-1024,   16,    0, 1024,    0,-0.124035, 0.992278, 0.000000, -127.011566,{ 27, 29, 30} },
	{ 3, 13, -896,-1024,   16,    0,    0,-1024,-0.124035, 0.992278, 0.000000, -127.011566,{ 30, 29, 31} },
	{ 3, 13, -896,-1024,   16,    0,    0,-1024, 0.000000, 0.999878,-0.015623,  -15.998047,{ 29, 32, 31} },
	{ 3, 13,    0, -128,  240,    0, 1024,    0, 0.000000, 0.973616, 0.228191, -233.667908,{ 33, 24, 34} },
	{ 3, 13,    0, -128,  240,    0, 1024,    0, 0.000000, 0.973616, 0.228191, -233.667908,{ 33, 26, 24} },
	{ 3, 13,    0, -128,  240,    0,    0,-1024, 0.000000, 0.973616,-0.228191, -233.667908,{ 34, 24, 35} },
	{ 3, 13,    0, -128,  240,    0,    0,-1024, 0.000000, 0.973616,-0.228191, -233.667908,{ 24, 25, 35} },
	{ 3, 13, -768, -896,   32,    0, 1024,    0,-0.124020, 0.992159, 0.015502, -126.996307,{ 28, 36, 29} },
	{ 3, 13, -128, -256,  240,    0,    0,-1024,-0.236499, 0.945996,-0.221718, -257.311035,{ 37, 34, 35} },
	{ 3, 13, -128, -256,  208,    0,    0,-1024, 0.000000, 0.979987,-0.199060, -203.837357,{ 38, 37, 35} },
	{ 3, 13, -256, -384,  208,    0,    0,-1024,-0.347425, 0.926467,-0.144760, -281.645844,{ 39, 40, 37} },
	{ 3, 13, -256, -384,  208,    0,    0,-1024, 0.000000, 0.979987,-0.199060, -203.837357,{ 39, 37, 38} },
	{ 3, 13, -384, -512,  160,    0,    0,-1024,-0.349297, 0.931457,-0.101878, -283.163025,{ 41, 40, 42} },
	{ 3, 13, -384, -512,  160,    0,    0,-1024, 0.000000, 0.988012,-0.154377, -158.081924,{ 42, 40, 39} },
	{ 3, 13, -512, -640,  112,    0,    0,-1024,-0.350524, 0.934730,-0.058421, -284.157898,{ 43, 44, 41} },
	{ 3, 13, -512, -640,  112,    0,    0,-1024, 0.000000, 0.994072,-0.108727, -111.336029,{ 43, 41, 42} },
	{ 3, 13, -640, -768,   64,    0,    0,-1024,-0.242424, 0.969697,-0.030303, -217.212128,{ 45, 36, 44} },
	{ 3, 13, -640, -768,   64,    0,    0,-1024, 0.000000, 0.998053,-0.062378,  -63.875366,{ 45, 44, 43} },
	{ 3, 13, -768, -896,   32,    0,    0,-1024,-0.124020, 0.992159,-0.015502, -126.996307,{ 32, 29, 36} },
	{ 3, 13, -768, -896,   32,    0,    0,-1024, 0.000000, 0.999512,-0.031235,  -31.984386,{ 32, 36, 45} },
	{ 3, 13, -768, -896,   32,    0, 1024,    0, 0.000000, 0.999512, 0.031235,  -31.984386,{ 28, 46, 36} },
	{ 3, 13, -128, -256,  240,    0, 1024,    0,-0.236499, 0.945996, 0.221718, -257.311035,{ 37, 33, 34} },
	{ 3, 13, -128, -256,  208,    0, 1024,    0, 0.000000, 0.979987, 0.199060, -203.837357,{ 47, 33, 37} },
	{ 3, 13, -256, -384,  208,    0, 1024,    0,-0.347425, 0.926467, 0.144760, -281.645844,{ 48, 37, 40} },
	{ 3, 13, -256, -384,  208,    0, 1024,    0, 0.000000, 0.979987, 0.199060, -203.837357,{ 48, 47, 37} },
	{ 3, 13, -384, -512,  160,    0, 1024,    0,-0.349297, 0.931457, 0.101878, -283.163025,{ 41, 49, 40} },
	{ 3, 13, -384, -512,  160,    0, 1024,    0, 0.000000, 0.988012, 0.154377, -158.081924,{ 49, 48, 40} },
	{ 3, 13, -512, -640,  112,    0, 1024,    0,-0.350524, 0.934730, 0.058421, -284.157898,{ 50, 41, 44} },
	{ 3, 13, -512, -640,  112,    0, 1024,    0, 0.000000, 0.994072, 0.108727, -111.336029,{ 50, 49, 41} },
	{ 3, 13, -640, -768,   64,    0, 1024,    0,-0.242424, 0.969697, 0.030303, -217.212128,{ 46, 44, 36} },
	{ 3, 13, -640, -768,   64,    0, 1024,    0, 0.000000, 0.998053, 0.062378,  -63.875366,{ 46, 50, 44} }
};

ShapeInfo	mount2 = { 51,64,64,1024,1024,240,1024,0,mount2Points,mount2Faces };

/************************************************************************
 		The test 	
************************************************************************/

static PointData testPoints[] = { 
	{  -1024,   640,   960,  0, 0.000000, 1.000000, 0.000000 },
	{   1024,   640,   960,  0, 0.000000, 1.000000, 0.000000 },
	{   1024,   640,   640,  0, 0.000000, 0.973249,-0.229753 },
	{  -1024,   640,   640,  0, 0.000000, 0.973249,-0.229753 },
	{   1024,     0,  -640,  0, 0.000000, 0.973249,-0.229753 },
	{  -1024,     0,  -640,  0, 0.000000, 0.973249,-0.229753 },
	{   1024,     0, -1024,  0, 0.000000, 1.000000, 0.000000 },
	{  -1024,     0, -1024,  0, 0.000000, 1.000000, 0.000000 }
};

static FaceData testFaces[] = { 
	{ 4,  0, 1024,-1024,  640,  640,  960,  640, 0.000000, 1.000000, 0.000000, -640.000000,{  0,  1,  2,  3} },
	{ 4, 14, 1024,-1024,  640,    0,  640, -640, 0.000000, 0.894427,-0.447214, -286.216705,{  3,  2,  4,  5} },
	{ 4,  0, 1024,-1024,    0,    0, -640,-1024, 0.000000, 1.000000, 0.000000,    0.000000,{  5,  4,  6,  7} }
};

ShapeInfo	test = { 8,3,3,1024,1024,640,960,0,testPoints,testFaces };

/************************************************************************
 		The lake 	
************************************************************************/

static PointData lakePoints[] = { 
	{   1024,     0, -1024,  0, 0.000000, 1.000000, 0.000000 },
	{    224,     0, -1024,  0, 0.000000, 1.000000, 0.000000 },
	{    512,     0,  -768,  0,-0.011713, 0.965717, 0.259333 },
	{  -1024,     0, -1024,  0, 0.000000, 1.000000, 0.000000 },
	{  -1024,     0,   160,  0, 0.261844, 0.961526, 0.083095 },
	{   -640,     0,   672,  0, 0.270653, 0.897907,-0.347145 },
	{  -1024,     0,  1024,  0, 0.000000, 1.000000, 0.000000 },
	{   1024,     0,  -288,  0,-0.247451, 0.932255, 0.263948 },
	{    864,     0,   416,  0,-0.250433, 0.903791,-0.347051 },
	{      0,     0,   832,  0,-0.040674, 0.910463,-0.411587 },
	{      0,     0,  1024,  0, 0.000000, 1.000000, 0.000000 },
	{   1024,     0,  1024,  0, 0.000000, 1.000000, 0.000000 },
	{   1024,     0,   256,  0,-0.325058, 0.888074,-0.325058 },
	{    512,   -64,  -672,  0,-0.014868, 0.944144, 0.329198 },
	{   1024,   -64,  -192,  0,-0.247451, 0.932255, 0.263948 },
	{   -928,   -64,   160,  0, 0.424079, 0.905112,-0.030497 },
	{   1024,   -64,   192,  0,-0.325058, 0.888074,-0.325058 },
	{    864,   -64,   352,  0,-0.250433, 0.903791,-0.347051 },
	{      0,   -64,   768,  0,-0.053975, 0.835930,-0.546175 },
	{   -576,   -64,   640,  0, 0.265939, 0.856703,-0.441968 }
};

static FaceData lakeFaces[] = { 
	{ 3,222, 1024,  224,    0,    0, -768,-1024, 0.000000, 1.000000, 0.000000,    0.000000,{  0,  1,  2} },
	{ 4,221,  512,-1024,    0,    0,  160,-1024, 0.000000, 1.000000, 0.000000,    0.000000,{  1,  3,  4,  2} },
	{ 3,222, -640,-1024,    0,    0, 1024,  160, 0.000000, 1.000000, 0.000000,    0.000000,{  5,  4,  6} },
	{ 3,221, 1024,  512,    0,    0, -288,-1024, 0.000000, 1.000000, 0.000000,    0.000000,{  0,  2,  7} },
	{ 4,223, 1024,    0,    0,    0, 1024,  416, 0.000000, 1.000000, 0.000000,    0.000000,{  8,  9, 10, 11} },
	{ 4,222,    0,-1024,    0,    0, 1024,  672, 0.000000, 1.000000, 0.000000,    0.000000,{  9,  5,  6, 10} },
	{ 3,220, 1024,  864,    0,    0, 1024,  256, 0.000000, 1.000000, 0.000000,    0.000000,{ 12,  8, 11} },
	{ 4,141, 1024,  512,    0,  -64, -192, -768,-0.461375, 0.738200, 0.492133,  614.182007,{  7,  2, 13, 14} },
	{ 4,141,  512,-1024,    0,  -64,  160, -768, 0.408603, 0.612904, 0.676308,  310.199890,{  2,  4, 15, 13} },
	{ 4,143, 1024,  864,    0,  -64,  416,  192,-0.577350, 0.577350,-0.577350,  739.008301,{ 12, 16, 17,  8} },
	{ 4,143,  864,    0,    0,  -64,  832,  352,-0.322292, 0.669376,-0.669376,  556.920654,{ 17, 18,  9,  8} },
	{ 4,143,    0, -640,    0,  -64,  832,  640, 0.177297, 0.576215,-0.797836,  649.615784,{ 18, 19,  5,  9} },
	{ 3,141, -640,-1024,    0,  -64,  672,  160, 0.512148, 0.768221,-0.384111,  585.896790,{ 15,  4,  5} },
	{ 3,143, -576, -928,    0,  -64,  672,  160, 0.541884, 0.740574,-0.397381,  613.845703,{ 15,  5, 19} },
	{ 5,191,  864, -928,  -64,  -64,  768, -672, 0.000000, 1.000000, 0.000000,   64.000000,{ 19, 18, 17, 13, 15} },
	{ 4,191, 1024,  512,  -64,  -64,  352, -672, 0.000000, 1.000000, 0.000000,   64.000000,{ 17, 16, 14, 13} }
};

ShapeInfo	lake = { 20,16,16,1024,1024,0,1024,0,lakePoints,lakeFaces };

/************************************************************************
 		The curveSE 	
************************************************************************/

static PointData curveSEPoints[] = { 
	{   1024,     0, -1024,  0, 0.020210, 0.999591,-0.020210 },
	{    128,     0, -1024,  0, 0.000000, 1.000000, 0.000000 },
	{    192,     0,  -768,  0, 0.006647, 0.997989,-0.063031 },
	{    320,    32,  -512,  0, 0.015208, 0.995793,-0.090356 },
	{    768,     0,  -192,  0, 0.063031, 0.997989,-0.006647 },
	{   1024,     0,  -128,  0, 0.000000, 1.000000, 0.000000 },
	{    512,    32,  -320,  0, 0.090356, 0.995793,-0.015208 },
	{   -128,     0, -1024,  0, 0.022121, 0.998580,-0.048468 },
	{     32,    32,  -512,  0,-0.010166, 0.997419,-0.071077 },
	{    224,    64,  -224,  0, 0.028593, 0.999182,-0.028593 },
	{    512,    32,   -32,  0, 0.071077, 0.997419, 0.010166 },
	{   1024,     0,   128,  0, 0.048468, 0.998580,-0.022121 },
	{   1024,     0,  1024,  0, 0.031208, 0.999398, 0.015154 },
	{  -1024,     0,  1024,  0,-0.020374, 0.999585, 0.020374 },
	{  -1024,     0, -1024,  0,-0.015154, 0.999398,-0.031208 }
};

static FaceData curveSEFaces[] = { 
	{ 3,222, 1024,  128,    0,    0, -768,-1024, 0.000000, 1.000000, 0.000000,    0.000000,{  0,  1,  2} },
	{ 3,221, 1024,  192,   32,    0, -512,-1024,-0.033121, 0.993638,-0.107644,  -76.311371,{  0,  2,  3} },
	{ 3,222, 1024,  768,    0,    0, -128,-1024, 0.000000, 1.000000, 0.000000,    0.000000,{  0,  4,  5} },
	{ 3,221, 1024,  512,   32,    0, -192,-1024, 0.107644, 0.993638, 0.033121,  -76.311371,{  0,  6,  4} },
	{ 3,222, 1024,  320,   32,    0, -320,-1024, 0.026298, 0.999308,-0.026298,  -53.857452,{  0,  3,  6} },
	{ 3,  4,  192, -128,   32,    0, -512,-1024, 0.066290, 0.994354,-0.082863,  -76.366364,{  7,  8,  2} },
	{ 3,  4,  192, -128,    0,    0, -768,-1024, 0.000000, 1.000000, 0.000000,    0.000000,{  1,  7,  2} },
	{ 3,  4,  320,   32,   32,    0, -512, -768, 0.000000, 0.992278,-0.124035,  -95.258675,{  2,  8,  3} },
	{ 3,  4,  320,   32,   64,   32, -224, -512, 0.000000, 0.993884,-0.110432,  -88.345222,{  9,  3,  8} },
	{ 3,  4, 1024,  512,   32,    0,  128, -192, 0.082863, 0.994354,-0.066290,  -76.366364,{  4, 10, 11} },
	{ 3,  4, 1024,  768,    0,    0,  128, -192, 0.000000, 1.000000, 0.000000,    0.000000,{  5,  4, 11} },
	{ 3,  4,  768,  512,   32,    0,  -32, -320, 0.124035, 0.992278, 0.000000,  -95.258675,{  4,  6, 10} },
	{ 3,  4,  512,  224,   64,   32, -224, -512, 0.082761, 0.993127,-0.082761, -100.636871,{  3,  9,  6} },
	{ 3,  4,  512,  224,   64,   32,  -32, -320, 0.110432, 0.993884, 0.000000,  -88.345222,{  6,  9, 10} },
	{ 3,222, 1024,  512,   32,    0, 1024,  -32, 0.062378, 0.998053, 0.000000,  -63.875366,{ 11, 10, 12} },
	{ 3,221, 1024,-1024,   32,    0, 1024,  -32, 0.000000, 0.999541, 0.030289,  -31.016066,{ 10, 13, 12} },
	{ 3,222,  512,-1024,   64,    0, 1024, -224, 0.045888, 0.994238, 0.096874,  -52.210251,{ 10,  9, 13} },
	{ 3,221,  224,-1024,   64,    0, 1024, -512,-0.096874, 0.994238,-0.045888,  -52.210251,{  8, 13,  9} },
	{ 3,221,   32,-1024,   32,    0, -512,-1024, 0.000000, 0.998053,-0.062378,  -63.875366,{  7, 14,  8} },
	{ 3,222,   32,-1024,   32,    0, 1024,-1024,-0.030289, 0.999541, 0.000000,  -31.016066,{  8, 14, 13} }
};

ShapeInfo	curveSE = { 15,20,20,1024,1024,64,1024,0,curveSEPoints,curveSEFaces };

/************************************************************************
 		The grass3 	
************************************************************************/

static PointData grass3Points[] = { 
	{  -1024,     0,  1024,  0, 0.000000, 1.000000, 0.000000 },
	{   -192,     0,  1024,  0, 0.000000, 1.000000, 0.000000 },
	{   -576,     0,   480,  0, 0.000000, 1.000000, 0.000000 },
	{   1024,     0,   -96,  0, 0.000000, 1.000000, 0.000000 },
	{   1024,     0,  1024,  0, 0.000000, 1.000000, 0.000000 },
	{  -1024,     0,   -96,  0, 0.000000, 1.000000, 0.000000 },
	{   -192,     0, -1024,  0, 0.000000, 1.000000, 0.000000 },
	{  -1024,     0, -1024,  0, 0.000000, 1.000000, 0.000000 },
	{   1024,     0, -1024,  0, 0.000000, 1.000000, 0.000000 }
};

static FaceData grass3Faces[] = { 
	{ 3,220, -192,-1024,    0,    0, 1024,  480, 0.000000, 1.000000, 0.000000,    0.000000,{  0,  1,  2} },
	{ 3,218, 1024, -576,    0,    0, 1024,  -96, 0.000000, 1.000000, 0.000000,    0.000000,{  1,  3,  2} },
	{ 3,220, 1024, -192,    0,    0, 1024,  -96, 0.000000, 1.000000, 0.000000,    0.000000,{  1,  4,  3} },
	{ 3,218, -576,-1024,    0,    0, 1024,  -96, 0.000000, 1.000000, 0.000000,    0.000000,{  0,  2,  5} },
	{ 3,220, -192,-1024,    0,    0,  480,-1024, 0.000000, 1.000000, 0.000000,    0.000000,{  2,  6,  5} },
	{ 3,218, -192,-1024,    0,    0,  -96,-1024, 0.000000, 1.000000, 0.000000,    0.000000,{  5,  6,  7} },
	{ 3,219, 1024, -576,    0,    0,  480,-1024, 0.000000, 1.000000, 0.000000,    0.000000,{  2,  3,  6} },
	{ 3,220, 1024, -192,    0,    0,  -96,-1024, 0.000000, 1.000000, 0.000000,    0.000000,{  3,  8,  6} }
};

ShapeInfo	grass3 = { 9,8,8,1024,1024,0,1024,0,grass3Points,grass3Faces };

/************************************************************************
 		The load10 	
************************************************************************/

static PointData load10Points[] = { 
	{   -128,     0,  1024,  0, 0.000000, 1.000000, 0.000000 },
	{    128,     0,  1024,  0, 0.000000, 1.000000, 0.000000 },
	{    128,     0,   768,  0, 0.000000, 0.998068, 0.062137 },
	{   -128,     0,   768,  0, 0.000000, 0.998068, 0.062137 },
	{    128,    32,   512,  0, 0.014125, 0.989001, 0.147236 },
	{   -128,    32,   512,  0,-0.014125, 0.989001, 0.147236 },
	{    128,    96,   256,  0, 0.049199, 0.979591, 0.194888 },
	{   -128,    96,   256,  0,-0.049199, 0.979591, 0.194888 },
	{    128,   160,     0,  0, 0.089840, 0.966865, 0.238959 },
	{   -128,   160,     0,  0,-0.089840, 0.966865, 0.238959 },
	{    128,   256,  -256,  0, 0.143619, 0.960462, 0.238510 },
	{   -128,   256,  -256,  0,-0.143619, 0.960462, 0.238510 },
	{    128,   320,  -512,  0, 0.221002, 0.967686, 0.121418 },
	{   -128,   320,  -512,  0,-0.221002, 0.967686, 0.121418 },
	{    128,   352,  -768,  0, 0.185776, 0.980692, 0.061071 },
	{   -128,   352,  -768,  0,-0.185776, 0.980692, 0.061071 },
	{    128,   352, -1024,  0, 0.186076, 0.982535, 0.000000 },
	{   -128,   352, -1024,  0,-0.186076, 0.982535, 0.000000 },
	{  -1024,     0,  -768,  0,-0.355632, 0.933829, 0.038583 },
	{  -1024,     0, -1024,  0,-0.365652, 0.930752, 0.000000 },
	{  -1024,     0,  -512,  0,-0.336336, 0.941742, 0.000000 },
	{  -1024,     0,  -256,  0,-0.294679, 0.952373, 0.078428 },
	{  -1024,     0,     0,  0,-0.208260, 0.971027, 0.117194 },
	{  -1024,     0,   256,  0,-0.129493, 0.988267, 0.080989 },
	{  -1024,     0,   512,  0,-0.059378, 0.994913, 0.081383 },
	{  -1024,     0,   768,  0,-0.011919, 0.999071, 0.041422 },
	{  -1024,     0,  1024,  0, 0.000000, 1.000000, 0.000000 },
	{   1024,     0,  -768,  0, 0.355632, 0.933829, 0.038583 },
	{   1024,     0, -1024,  0, 0.365652, 0.930752, 0.000000 },
	{   1024,     0,  -512,  0, 0.336336, 0.941742, 0.000000 },
	{   1024,     0,  -256,  0, 0.294679, 0.952373, 0.078428 },
	{   1024,     0,     0,  0, 0.208260, 0.971027, 0.117194 },
	{   1024,     0,   256,  0, 0.129493, 0.988267, 0.080989 },
	{   1024,     0,   512,  0, 0.059378, 0.994913, 0.081383 },
	{   1024,     0,   768,  0, 0.011919, 0.999071, 0.041422 },
	{   1024,     0,  1024,  0, 0.000000, 1.000000, 0.000000 }
};

static FaceData load10Faces[] = { 
	{ 4,  4,  128, -128,    0,    0, 1024,  768, 0.000000, 1.000000, 0.000000,    0.000000,{  0,  1,  2,  3} },
	{ 4,  4,  128, -128,   32,    0,  768,  512, 0.000000, 0.992278, 0.124035,  -95.258675,{  3,  2,  4,  5} },
	{ 4,  4,  128, -128,   96,   32,  512,  256, 0.000000, 0.970142, 0.242536, -155.222794,{  5,  4,  6,  7} },
	{ 4,  4,  128, -128,  160,   96,  256,    0, 0.000000, 0.970142, 0.242536, -155.222794,{  7,  6,  8,  9} },
	{ 4,  4,  128, -128,  256,  160,    0, -256, 0.000000, 0.936329, 0.351123, -149.812668,{  9,  8, 10, 11} },
	{ 4,  4,  128, -128,  320,  256, -256, -512, 0.000000, 0.970142, 0.242536, -186.267365,{ 11, 10, 12, 13} },
	{ 4,  4,  128, -128,  352,  320, -512, -768, 0.000000, 0.992278, 0.124035, -254.023132,{ 13, 12, 14, 15} },
	{ 4,  4,  128, -128,  352,  352, -768,-1024, 0.000000, 1.000000, 0.000000, -352.000000,{ 15, 14, 16, 17} },
	{ 4, 13, -128,-1024,  352,    0, -768,-1024,-0.365652, 0.930752, 0.000000, -374.428040,{ 18, 15, 17, 19} },
	{ 3, 13, -128,-1024,  352,    0, -512, -768,-0.363202, 0.924515, 0.115564, -283.165863,{ 13, 15, 18} },
	{ 3, 13, -128,-1024,  320,    0, -512, -768,-0.336336, 0.941742, 0.000000, -344.408478,{ 20, 13, 18} },
	{ 3, 13, -128,-1024,  320,    0, -256, -512,-0.267112, 0.934893, 0.233723, -213.689789,{ 21, 11, 13} },
	{ 3, 13, -128,-1024,  320,    0, -256, -512,-0.336336, 0.941742, 0.000000, -344.408478,{ 21, 13, 20} },
	{ 3, 13, -128,-1024,  256,    0,    0, -256,-0.164912, 0.923509, 0.346316, -168.870255,{  9, 11, 22} },
	{ 3, 13, -128,-1024,  256,    0,    0, -256,-0.274721, 0.961524, 0.000000, -281.314423,{ 22, 11, 21} },
	{ 3, 13, -128,-1024,  160,    0,  256,    0,-0.103387, 0.964944, 0.241236, -167.624512,{ 23,  7,  9} },
	{ 3, 13, -128,-1024,  160,    0,  256,    0,-0.175791, 0.984428, 0.000000, -180.009613,{ 23,  9, 22} },
	{ 3, 13, -128,-1024,   96,    0,  512,  256,-0.034627, 0.969561, 0.242390, -159.561981,{ 24,  5,  7} },
	{ 3, 13, -128,-1024,   96,    0,  512,  256,-0.106533, 0.994309, 0.000000, -109.089920,{ 24,  7, 23} },
	{ 3, 13, -128,-1024,   32,    0,  768,  512, 0.000000, 0.992278, 0.124035,  -95.258675,{ 25,  3,  5} },
	{ 3, 13, -128,-1024,   32,    0,  768,  512,-0.035692, 0.999363, 0.000000,  -36.548126,{ 25,  5, 24} },
	{ 4, 13, -128,-1024,    0,    0, 1024,  768, 0.000000, 1.000000, 0.000000,    0.000000,{ 26,  0,  3, 25} },
	{ 4, 13, 1024,  128,  352,    0, -768,-1024, 0.365652, 0.930752, 0.000000, -374.428040,{ 27, 28, 16, 14} },
	{ 3, 13, 1024,  128,  352,    0, -512, -768, 0.363202, 0.924515, 0.115564, -283.165863,{ 12, 27, 14} },
	{ 3, 13, 1024,  128,  320,    0, -512, -768, 0.336336, 0.941742, 0.000000, -344.408478,{ 29, 27, 12} },
	{ 3, 13, 1024,  128,  320,    0, -256, -512, 0.267112, 0.934893, 0.233723, -213.689789,{ 30, 12, 10} },
	{ 3, 13, 1024,  128,  320,    0, -256, -512, 0.336336, 0.941742, 0.000000, -344.408478,{ 30, 29, 12} },
	{ 3, 13, 1024,  128,  256,    0,    0, -256, 0.164912, 0.923509, 0.346316, -168.870255,{  8, 31, 10} },
	{ 3, 13, 1024,  128,  256,    0,    0, -256, 0.274721, 0.961524, 0.000000, -281.314423,{ 31, 30, 10} },
	{ 3, 13, 1024,  128,  160,    0,  256,    0, 0.103387, 0.964944, 0.241236, -167.624512,{ 32,  8,  6} },
	{ 3, 13, 1024,  128,  160,    0,  256,    0, 0.175791, 0.984428, 0.000000, -180.009613,{ 32, 31,  8} },
	{ 3, 13, 1024,  128,   96,    0,  512,  256, 0.034627, 0.969561, 0.242390, -159.561981,{ 33,  6,  4} },
	{ 3, 13, 1024,  128,   96,    0,  512,  256, 0.106533, 0.994309, 0.000000, -109.089920,{ 33, 32,  6} },
	{ 3, 13, 1024,  128,   32,    0,  768,  512, 0.000000, 0.992278, 0.124035,  -95.258675,{ 34,  4,  2} },
	{ 3, 13, 1024,  128,   32,    0,  768,  512, 0.035692, 0.999363, 0.000000,  -36.548126,{ 34, 33,  4} },
	{ 4, 13, 1024,  128,    0,    0, 1024,  768, 0.000000, 1.000000, 0.000000,    0.000000,{ 35, 34,  2,  1} }
};

ShapeInfo	load10 = { 36,36,36,1024,1024,352,1024,0,load10Points,load10Faces };

/************************************************************************
 		The mycar 	
************************************************************************/

static PointData mycarPoints[] = { 
	{    -18,    20,    28,  0,-0.224949, 0.948049, 0.224949 },
	{     18,    20,    28,  0, 0.224949, 0.948049, 0.224949 },
	{     18,    20,   -28,  0, 0.297877, 0.943960,-0.142155 },
	{    -18,    20,   -28,  0,-0.297877, 0.943960,-0.142155 },
	{     18,    10,    28,  0, 0.224949,-0.948049, 0.224949 },
	{    -18,    10,    28,  0,-0.224949,-0.948049, 0.224949 },
	{    -18,    10,   -28,  0,-0.224949,-0.948049,-0.224949 },
	{     18,    10,   -28,  0, 0.224949,-0.948049,-0.224949 },
	{     22,    18,   -28,  0, 0.782011, 0.522117,-0.340370 },
	{     22,    18,    28,  0, 0.782011, 0.522117, 0.340370 },
	{     22,    12,    28,  0, 0.782011,-0.522117, 0.340370 },
	{     22,    12,   -28,  0, 0.782011,-0.522117,-0.340370 },
	{    -22,    18,    28,  0,-0.782011, 0.522117, 0.340370 },
	{    -22,    18,   -28,  0,-0.782011, 0.522117,-0.340370 },
	{    -22,    12,   -28,  0,-0.782011,-0.522117,-0.340370 },
	{    -22,    12,    28,  0,-0.782011,-0.522117, 0.340370 },
	{    -18,    18,   -32,  0,-0.441386, 0.323117,-0.837122 },
	{     18,    18,   -32,  0, 0.441386, 0.323117,-0.837122 },
	{     18,    12,   -32,  0, 0.340370,-0.522117,-0.782011 },
	{    -18,    12,   -32,  0,-0.340370,-0.522117,-0.782011 },
	{    -18,    18,    32,  0,-0.340370, 0.522117, 0.782011 },
	{    -18,    12,    32,  0,-0.340370,-0.522117, 0.782011 },
	{     18,    12,    32,  0, 0.340370,-0.522117, 0.782011 },
	{     18,    18,    32,  0, 0.340370, 0.522117, 0.782011 }
};

static FaceData mycarFaces[] = { 
	{ 4,  0,   18,  -18,   20,   20,   28,  -28, 0.000000, 1.000000, 0.000000,  -20.000000,{  0,  1,  2,  3} },
	{ 4,  0,   18,  -18,   10,   10,   28,  -28, 0.000000,-1.000000, 0.000000,   10.000000,{  4,  5,  6,  7} },
	{ 4,  0,   22,   22,   18,   12,   28,  -28, 1.000000, 0.000000, 0.000000,  -22.000000,{  8,  9, 10, 11} },
	{ 4,  0,  -22,  -22,   18,   12,   28,  -28,-1.000000, 0.000000, 0.000000,  -22.000000,{ 12, 13, 14, 15} },
	{ 4,  0,   18,  -18,   18,   12,  -32,  -32, 0.000000, 0.000000,-1.000000,  -32.000000,{ 16, 17, 18, 19} },
	{ 4,  0,  -18,  -22,   20,   18,   28,  -28,-0.447214, 0.894427, 0.000000,  -25.938389,{ 12,  0,  3, 13} },
	{ 4,  0,   18,  -18,   20,   18,  -28,  -32, 0.000000, 0.894427,-0.447214,  -30.410524,{  3,  2, 17, 16} },
	{ 4,  0,   22,   18,   20,   18,   28,  -28, 0.447214, 0.894427, 0.000000,  -25.938389,{  1,  9,  8,  2} },
	{ 4,  0,   18,  -18,   20,   18,  -28,  -32, 0.000000,-0.894427, 0.447214,   30.410524,{  3, 16, 17,  2} },
	{ 4,  0,   22,   18,   12,   10,   28,  -28, 0.447214,-0.894427, 0.000000,    0.894427,{ 10,  4,  7, 11} },
	{ 4,  0,  -18,  -22,   12,   10,   28,  -28,-0.447214,-0.894427, 0.000000,    0.894427,{  5, 15, 14,  6} },
	{ 4,  0,   18,  -18,   18,   12,   32,   32, 0.000000, 0.000000, 1.000000,  -32.000000,{ 20, 21, 22, 23} },
	{ 4,  0,   18,  -18,   20,   18,   32,   28, 0.000000, 0.894427, 0.447214,  -30.410524,{ 20, 23,  1,  0} },
	{ 4,  0,   18,  -18,   12,   10,   32,   28, 0.000000,-0.894427, 0.447214,   -3.577709,{ 22, 21,  5,  4} },
	{ 3,  0,   22,   18,   20,   18,   32,   28, 0.408248, 0.816497, 0.408248,  -35.109356,{ 23,  9,  1} },
	{ 3,  0,   22,   18,   12,   10,   32,   28, 0.408248,-0.816497, 0.408248,  -10.614456,{ 10, 22,  4} },
	{ 4,  0,   22,   18,   18,   12,   32,   28, 0.707107, 0.000000, 0.707107,  -35.355339,{  9, 23, 22, 10} },
	{ 3,  0,  -18,  -22,   20,   18,   32,   28,-0.408248, 0.816497, 0.408248,  -35.109356,{ 12, 20,  0} },
	{ 3,  0,  -18,  -22,   12,   10,   32,   28,-0.408248,-0.816497, 0.408248,  -10.614456,{ 21, 15,  5} },
	{ 4,  0,  -18,  -22,   18,   12,   32,   28,-0.707107, 0.000000, 0.707107,  -35.355339,{ 12, 15, 21, 20} },
	{ 4,  0,   18,  -18,   12,   10,  -28,  -32, 0.000000,-0.894427,-0.447214,   -3.577709,{ 18,  7,  6, 19} },
	{ 3,  0,   22,   18,   20,   18,  -28,  -32, 0.408248, 0.816497,-0.408248,  -35.109356,{ 17,  2,  8} },
	{ 3,  0,   22,   18,   12,   10,  -28,  -32, 0.408248,-0.816497,-0.408248,  -10.614456,{ 11,  7, 18} },
	{ 4,  0,   22,   18,   18,   12,  -28,  -32, 0.707107, 0.000000,-0.707107,  -35.355339,{  8, 11, 18, 17} },
	{ 3,  0,  -18,  -22,   20,   18,  -28,  -32,-0.408248, 0.816497,-0.408248,  -35.109356,{ 13,  3, 16} },
	{ 3,  0,  -18,  -22,   12,   10,  -28,  -32,-0.408248,-0.816497,-0.408248,  -10.614456,{ 19,  6, 14} },
	{ 4,  0,  -18,  -22,   18,   12,  -28,  -32,-0.707107, 0.000000,-0.707107,  -35.355339,{ 13, 16, 19, 14} }
};

ShapeInfo	mycar = { 24,27,27,32,22,20,32,0,mycarPoints,mycarFaces };

/************************************************************************
 		The curveSW 	
************************************************************************/

static PointData curveSWPoints[] = { 
	{  -1024,     0, -1024,  0,-0.020210, 0.999591,-0.020210 },
	{  -1024,     0,  -128,  0, 0.000000, 1.000000, 0.000000 },
	{   -768,     0,  -192,  0,-0.063031, 0.997989,-0.006647 },
	{   -512,    32,  -320,  0,-0.090356, 0.995793,-0.015208 },
	{   -192,     0,  -768,  0,-0.006647, 0.997989,-0.063031 },
	{   -128,     0, -1024,  0, 0.000000, 1.000000, 0.000000 },
	{   -320,    32,  -512,  0,-0.015208, 0.995793,-0.090356 },
	{  -1024,     0,   128,  0,-0.048468, 0.998580,-0.022121 },
	{   -512,    32,   -32,  0,-0.071077, 0.997419, 0.010166 },
	{   -224,    64,  -224,  0,-0.028593, 0.999182,-0.028593 },
	{    -32,    32,  -512,  0, 0.010166, 0.997419,-0.071077 },
	{    128,     0, -1024,  0,-0.022121, 0.998580,-0.048468 },
	{   1024,     0, -1024,  0, 0.015154, 0.999398,-0.031208 },
	{   1024,     0,  1024,  0, 0.020374, 0.999585, 0.020374 },
	{  -1024,     0,  1024,  0,-0.031208, 0.999398, 0.015154 }
};

static FaceData curveSWFaces[] = { 
	{ 3,222, -768,-1024,    0,    0, -128,-1024, 0.000000, 1.000000, 0.000000,    0.000000,{  0,  1,  2} },
	{ 3,221, -512,-1024,   32,    0, -192,-1024,-0.107644, 0.993638, 0.033121,  -76.311371,{  0,  2,  3} },
	{ 3,222, -128,-1024,    0,    0, -768,-1024, 0.000000, 1.000000, 0.000000,    0.000000,{  0,  4,  5} },
	{ 3,221, -192,-1024,   32,    0, -512,-1024, 0.033121, 0.993638,-0.107644,  -76.311371,{  0,  6,  4} },
	{ 3,222, -320,-1024,   32,    0, -320,-1024,-0.026298, 0.999308,-0.026298,  -53.857452,{  0,  3,  6} },
	{ 3,  4, -512,-1024,   32,    0,  128, -192,-0.082863, 0.994354,-0.066290,  -76.366364,{  7,  8,  2} },
	{ 3,  4, -768,-1024,    0,    0,  128, -192, 0.000000, 1.000000, 0.000000,    0.000000,{  1,  7,  2} },
	{ 3,  4, -512, -768,   32,    0,  -32, -320,-0.124035, 0.992278, 0.000000,  -95.258675,{  2,  8,  3} },
	{ 3,  4, -224, -512,   64,   32,  -32, -320,-0.110432, 0.993884, 0.000000,  -88.345222,{  9,  3,  8} },
	{ 3,  4,  128, -192,   32,    0, -512,-1024,-0.066290, 0.994354,-0.082863,  -76.366364,{  4, 10, 11} },
	{ 3,  4,  128, -192,    0,    0, -768,-1024, 0.000000, 1.000000, 0.000000,    0.000000,{  5,  4, 11} },
	{ 3,  4,  -32, -320,   32,    0, -512, -768, 0.000000, 0.992278,-0.124035,  -95.258675,{  4,  6, 10} },
	{ 3,  4, -224, -512,   64,   32, -224, -512,-0.082761, 0.993127,-0.082761, -100.636871,{  3,  9,  6} },
	{ 3,  4,  -32, -320,   64,   32, -224, -512, 0.000000, 0.993884,-0.110432,  -88.345222,{  6,  9, 10} },
	{ 3,222, 1024,  -32,   32,    0, -512,-1024, 0.000000, 0.998053,-0.062378,  -63.875366,{ 11, 10, 12} },
	{ 3,221, 1024,  -32,   32,    0, 1024,-1024, 0.030289, 0.999541, 0.000000,  -31.016066,{ 10, 13, 12} },
	{ 3,222, 1024, -224,   64,    0, 1024, -512, 0.096874, 0.994238,-0.045888,  -52.210251,{ 10,  9, 13} },
	{ 3,221, 1024, -512,   64,    0, 1024, -224,-0.045888, 0.994238, 0.096874,  -52.210251,{  8, 13,  9} },
	{ 3,221, -512,-1024,   32,    0, 1024,  -32,-0.062378, 0.998053, 0.000000,  -63.875366,{  7, 14,  8} },
	{ 3,222, 1024,-1024,   32,    0, 1024,  -32, 0.000000, 0.999541, 0.030289,  -31.016066,{  8, 14, 13} }
};

ShapeInfo	curveSW = { 15,20,20,1024,1024,64,1024,0,curveSWPoints,curveSWFaces };

/************************************************************************
 		The curveNE 	
************************************************************************/

static PointData curveNEPoints[] = { 
	{   1024,     0,  1024,  0, 0.020210, 0.999591, 0.020210 },
	{   1024,     0,   128,  0, 0.000000, 1.000000, 0.000000 },
	{    768,     0,   192,  0, 0.063031, 0.997989, 0.006647 },
	{    512,    32,   320,  0, 0.090356, 0.995793, 0.015208 },
	{    192,     0,   768,  0, 0.006647, 0.997989, 0.063031 },
	{    128,     0,  1024,  0, 0.000000, 1.000000, 0.000000 },
	{    320,    32,   512,  0, 0.015208, 0.995793, 0.090356 },
	{   1024,     0,  -128,  0, 0.048468, 0.998580, 0.022121 },
	{    512,    32,    32,  0, 0.071077, 0.997419,-0.010166 },
	{    224,    64,   224,  0, 0.028593, 0.999182, 0.028593 },
	{     32,    32,   512,  0,-0.010166, 0.997419, 0.071077 },
	{   -128,     0,  1024,  0, 0.022121, 0.998580, 0.048468 },
	{  -1024,     0,  1024,  0,-0.015154, 0.999398, 0.031208 },
	{  -1024,     0, -1024,  0,-0.020374, 0.999585,-0.020374 },
	{   1024,     0, -1024,  0, 0.031208, 0.999398,-0.015154 }
};

static FaceData curveNEFaces[] = { 
	{ 3,222, 1024,  768,    0,    0, 1024,  128, 0.000000, 1.000000, 0.000000,    0.000000,{  0,  1,  2} },
	{ 3,221, 1024,  512,   32,    0, 1024,  192, 0.107644, 0.993638,-0.033121,  -76.311371,{  0,  2,  3} },
	{ 3,222, 1024,  128,    0,    0, 1024,  768, 0.000000, 1.000000, 0.000000,    0.000000,{  0,  4,  5} },
	{ 3,221, 1024,  192,   32,    0, 1024,  512,-0.033121, 0.993638, 0.107644,  -76.311371,{  0,  6,  4} },
	{ 3,222, 1024,  320,   32,    0, 1024,  320, 0.026298, 0.999308, 0.026298,  -53.857452,{  0,  3,  6} },
	{ 3,  4, 1024,  512,   32,    0,  192, -128, 0.082863, 0.994354, 0.066290,  -76.366364,{  7,  8,  2} },
	{ 3,  4, 1024,  768,    0,    0,  192, -128, 0.000000, 1.000000, 0.000000,    0.000000,{  1,  7,  2} },
	{ 3,  4,  768,  512,   32,    0,  320,   32, 0.124035, 0.992278, 0.000000,  -95.258675,{  2,  8,  3} },
	{ 3,  4,  512,  224,   64,   32,  320,   32, 0.110432, 0.993884, 0.000000,  -88.345222,{  9,  3,  8} },
	{ 3,  4,  192, -128,   32,    0, 1024,  512, 0.066290, 0.994354, 0.082863,  -76.366364,{  4, 10, 11} },
	{ 3,  4,  192, -128,    0,    0, 1024,  768, 0.000000, 1.000000, 0.000000,    0.000000,{  5,  4, 11} },
	{ 3,  4,  320,   32,   32,    0,  768,  512, 0.000000, 0.992278, 0.124035,  -95.258675,{  4,  6, 10} },
	{ 3,  4,  512,  224,   64,   32,  512,  224, 0.082761, 0.993127, 0.082761, -100.636871,{  3,  9,  6} },
	{ 3,  4,  320,   32,   64,   32,  512,  224, 0.000000, 0.993884, 0.110432,  -88.345222,{  6,  9, 10} },
	{ 3,222,   32,-1024,   32,    0, 1024,  512, 0.000000, 0.998053, 0.062378,  -63.875366,{ 11, 10, 12} },
	{ 3,221,   32,-1024,   32,    0, 1024,-1024,-0.030289, 0.999541, 0.000000,  -31.016066,{ 10, 13, 12} },
	{ 3,222,  224,-1024,   64,    0,  512,-1024,-0.096874, 0.994238, 0.045888,  -52.210251,{ 10,  9, 13} },
	{ 3,221,  512,-1024,   64,    0,  224,-1024, 0.045888, 0.994238,-0.096874,  -52.210251,{  8, 13,  9} },
	{ 3,221, 1024,  512,   32,    0,   32,-1024, 0.062378, 0.998053, 0.000000,  -63.875366,{  7, 14,  8} },
	{ 3,222, 1024,-1024,   32,    0,   32,-1024, 0.000000, 0.999541,-0.030289,  -31.016066,{  8, 14, 13} }
};

ShapeInfo	curveNE = { 15,20,20,1024,1024,64,1024,0,curveNEPoints,curveNEFaces };

/************************************************************************
 		The bridge 	
************************************************************************/
	
static PointData bridgePoints[] = { 
	{  -1024,     0,  1024,  0,-0.365652, 0.930752, 0.000000 },
	{   -128,   352,  1024,  0,-0.466823, 0.767847,-0.438734 },
	{  -1024,     0,   768,  0,-0.095644, 0.984679,-0.145807 },
	{      0,     0,   640,  0, 0.000000, 0.929574,-0.368635 },
	{   1024,     0,  1024,  0, 0.365652, 0.930752, 0.000000 },
	{   1024,     0,   768,  0, 0.162745, 0.954966,-0.248101 },
	{    128,   352,  1024,  0, 0.162085, 0.856780,-0.489548 },
	{   1024,     0, -1024,  0, 0.365652, 0.930752, 0.000000 },
	{    128,   352, -1024,  0,-0.195510, 0.851505, 0.486534 },
	{   1024,     0,  -768,  0, 0.162745, 0.954966, 0.248101 },
	{      0,     0,  -640,  0, 0.000000, 0.948959, 0.315400 },
	{   -128,   352, -1024,  0,-0.466823, 0.767847, 0.438734 },
	{   -128,   320,  -960,  0,-1.000000, 0.000000, 0.000000 },
	{   -128,   320,   960,  0,-1.000000, 0.000000, 0.000000 },
	{    128,   448,  -800,  0,-1.000000, 0.000000, 0.000000 },
	{    128,   512,  -448,  0, 0.000000, 0.000000, 0.000000 },
	{    128,   480,  -448,  0, 0.000000, 0.000000, 0.000000 },
	{    128,   416,  -800,  0,-1.000000, 0.000000, 0.000000 },
	{    128,   544,     0,  0, 0.000000, 0.000000, 0.000000 },
	{    128,   512,     0,  0, 0.000000, 0.000000, 0.000000 },
	{    128,   352,   992,  0, 0.000000, 0.000000, 0.000000 },
	{    128,   416,   800,  0, 0.000000, 0.000000, 0.000000 },
	{    128,   448,   800,  0, 0.000000, 0.000000, 0.000000 },
	{    128,   480,   448,  0, 0.000000, 0.000000, 0.000000 },
	{    128,   512,   448,  0, 0.000000, 0.000000, 0.000000 },
	{    128,   512,  -416,  0, 0.000000, 0.000000, 0.000000 },
	{    128,   352,  -416,  0, 0.000000, 0.000000, 0.000000 },
	{    128,   352,  -448,  0, 0.000000, 0.000000, 0.000000 },
	{    128,   448,  -768,  0, 0.000000, 0.000000, 0.000000 },
	{    128,   352,  -768,  0, 0.000000, 0.000000, 0.000000 },
	{    128,   352,  -800,  0, 0.000000, 0.000000, 0.000000 },
	{    128,   352,   448,  0, 0.000000, 0.000000, 0.000000 },
	{    128,   352,   416,  0, 0.000000, 0.000000, 0.000000 },
	{    128,   512,   416,  0, 0.000000, 0.000000, 0.000000 },
	{    128,   352,   800,  0, 0.000000, 0.000000, 0.000000 },
	{    128,   352,   768,  0, 0.000000, 0.000000, 0.000000 },
	{    128,   448,   768,  0, 0.000000, 0.000000, 0.000000 },
	{    128,   512,   -32,  0, 0.000000, 0.000000, 0.000000 },
	{    128,   512,    32,  0, 0.000000, 0.000000, 0.000000 },
	{    128,   352,    32,  0, 0.000000, 0.000000, 0.000000 },
	{    128,   352,   -32,  0, 0.000000, 0.000000, 0.000000 },
	{    128,   352,  -992,  0,-1.000000, 0.000000, 0.000000 },
	{  -1024,   -64,   192,  0, 0.124850, 0.918762,-0.374551 },
	{   -640,   -64,   320,  0, 0.007754, 0.925729,-0.378108 },
	{   -640,   -64,     0,  0,-0.018001, 0.958183, 0.285588 },
	{  -1024,   -64,  -192,  0,-0.140789, 0.949153, 0.281579 },
	{    352,   -64,    32,  0,-0.009572, 0.925202,-0.379353 },
	{    320,   -64,  -352,  0, 0.019522, 0.957524, 0.287692 },
	{   1024,   -64,   192,  0, 0.090110, 0.921220,-0.378462 },
	{   1024,   -64,  -192,  0,-0.065460, 0.955384, 0.288023 },
	{   -640,     0,   -96,  0,-0.018001, 0.958183, 0.285588 },
	{  -1024,     0,  -288,  0,-0.093291, 0.978000, 0.186582 },
	{    320,     0,  -448,  0, 0.019522, 0.957524, 0.287692 },
	{   1024,     0,  -288,  0,-0.065460, 0.955384, 0.288023 },
	{  -1024,     0,   256,  0, 0.082393, 0.965461,-0.247178 },
	{   -640,     0,   384,  0, 0.005098, 0.968600,-0.248573 },
	{    352,     0,    96,  0,-0.009572, 0.925202,-0.379353 },
	{   1024,     0,   256,  0, 0.090110, 0.921220,-0.378462 },
	{  -1024,     0,  -768,  0,-0.162745, 0.954966, 0.248101 },
	{  -1024,     0, -1024,  0,-0.365652, 0.930752, 0.000000 },
	{   -128,   448,  -800,  0, 0.000000, 0.000000, 0.000000 },
	{   -128,   416,  -800,  0, 0.000000, 0.000000, 0.000000 },
	{   -128,   352,  -992,  0, 0.000000, 0.000000, 0.000000 },
	{   -128,   512,  -448,  0, 0.000000, 0.000000, 0.000000 },
	{   -128,   480,  -448,  0, 0.000000, 0.000000, 0.000000 },
	{   -128,   544,     0,  0, 0.000000, 0.000000, 0.000000 },
	{   -128,   512,     0,  0, 0.000000, 0.000000, 0.000000 },
	{   -128,   352,   992,  0, 0.000000, 0.000000, 0.000000 },
	{   -128,   416,   800,  0, 0.000000, 0.000000, 0.000000 },
	{   -128,   448,   800,  0, 0.000000, 0.000000, 0.000000 },
	{   -128,   480,   448,  0, 0.000000, 0.000000, 0.000000 },
	{   -128,   512,   448,  0, 0.000000, 0.000000, 0.000000 },
	{   -128,   512,  -416,  0, 0.000000, 0.000000, 0.000000 },
	{   -128,   352,  -416,  0, 0.000000, 0.000000, 0.000000 },
	{   -128,   352,  -448,  0, 0.000000, 0.000000, 0.000000 },
	{   -128,   448,  -768,  0, 0.000000, 0.000000, 0.000000 },
	{   -128,   352,  -768,  0, 0.000000, 0.000000, 0.000000 },
	{   -128,   352,  -800,  0, 0.000000, 0.000000, 0.000000 },
	{   -128,   352,   448,  0, 0.000000, 0.000000, 0.000000 },
	{   -128,   352,   416,  0, 0.000000, 0.000000, 0.000000 },
	{   -128,   512,   416,  0, 0.000000, 0.000000, 0.000000 },
	{   -128,   512,   -32,  0, 0.000000, 0.000000, 0.000000 },
	{   -128,   512,    32,  0, 0.000000, 0.000000, 0.000000 },
	{   -128,   352,    32,  0, 0.000000, 0.000000, 0.000000 },
	{   -128,   352,   -32,  0, 0.000000, 0.000000, 0.000000 },
	{    128,   320,  -960,  0, 0.000000, 0.000000, 0.000000 },
	{    128,   320,   960,  0, 0.000000, 0.000000, 0.000000 },
	{   -128,   544,    32,  0, 0.000000, 0.000000, 0.000000 },
	{    128,   544,    32,  0, 0.000000, 0.000000, 0.000000 },
	{    128,   544,   -32,  0, 0.000000, 0.000000, 0.000000 },
	{   -128,   544,   -32,  0, 0.000000, 0.000000, 0.000000 },
	{   -128,   352,   800,  0, 0.000000, 0.000000, 0.000000 },
	{   -128,   352,   768,  0, 0.000000, 0.000000, 0.000000 },
	{   -128,   448,   768,  0, 0.000000, 0.000000, 0.000000 }
};

static FaceData bridgeFaces[] = { 
	{ 4,  4,  128, -128,  352,  352, 1024,-1024, 0.000000, 1.000000, 0.000000, -352.000000,{  1,  6,  8, 11} },
	{ 3, 13, -128,-1024,  352,    0, 1024,  768,-0.365652, 0.930752, 0.000000, -374.428040,{  0,  1,  2} },
	{ 3, 13,    0,-1024,  352,    0, 1024,  640,-0.086082, 0.719959,-0.688657,  440.740387,{  1,  3,  2} },
	{ 3, 13, 1024,  128,  352,    0, 1024,  768, 0.365652, 0.930752, 0.000000, -374.428040,{  4,  5,  6} },
	{ 3, 13, 1024,    0,  352,    0, 1024,  640, 0.086082, 0.719959,-0.688657,  440.740387,{  6,  5,  3} },
	{ 3, 13, 1024,  128,  352,    0, -768,-1024, 0.365652, 0.930752, 0.000000, -374.428040,{  7,  8,  9} },
	{ 3, 13, 1024,    0,  352,    0, -640,-1024, 0.086082, 0.719959, 0.688657,  440.740387,{  8, 10,  9} },
	{ 3, 13,  128, -128,  352,    0, 1024,  640, 0.000000, 0.737154,-0.675725,  432.463776,{  1,  6,  3} },
	{ 3, 13,  128, -128,  352,    0, -640,-1024, 0.000000, 0.737154, 0.675725,  432.463776,{ 11, 10,  8} },
	{ 4,143, -128, -128,  352,  320, 1024,-1024,-1.000000, 0.000000, 0.000000, -128.000000,{ 11, 12, 13,  1} },
	{ 4,207,  128,  128,  512,  416, -448, -800, 1.000000, 0.000000, 0.000000, -128.000000,{ 14, 15, 16, 17} },
	{ 4,207,  128,  128,  544,  480,    0, -448, 1.000000, 0.000000, 0.000000, -128.000000,{ 15, 18, 19, 16} },
	{ 4,207,  128,  128,  448,  352, 1024,  800, 1.000000, 0.000000, 0.000000, -128.000000,{  6, 20, 21, 22} },
	{ 4,207,  128,  128,  512,  416,  800,  448, 1.000000, 0.000000, 0.000000, -128.000000,{ 22, 21, 23, 24} },
	{ 4,207,  128,  128,  544,  480,  448,    0, 1.000000, 0.000000, 0.000000, -128.000000,{ 24, 23, 19, 18} },
	{ 4,207,  128,  128,  512,  352, -416, -448, 1.000000, 0.000000, 0.000000, -128.000000,{ 16, 25, 26, 27} },
	{ 4,207,  128,  128,  448,  352, -768, -800, 1.000000, 0.000000, 0.000000, -128.000000,{ 17, 28, 29, 30} },
	{ 4,207,  128,  128,  512,  352,  448,  416, 1.000000, 0.000000, 0.000000, -128.000000,{ 23, 31, 32, 33} },
	{ 4,207,  128,  128,  448,  352,  800,  768, 1.000000, 0.000000, 0.000000, -128.000000,{ 21, 34, 35, 36} },
	{ 4,207,  128,  128,  512,  352,   32,  -32, 1.000000, 0.000000, 0.000000, -128.000000,{ 37, 38, 39, 40} },
	{ 4,207,  128,  128,  512,  416, -448, -800,-1.000000, 0.000000, 0.000000,  128.000000,{ 14, 17, 16, 15} },
	{ 4,207,  128,  128,  544,  480,    0, -448,-1.000000, 0.000000, 0.000000,  128.000000,{ 15, 16, 19, 18} },
	{ 4,207,  128,  128,  512,  352, -416, -448,-1.000000, 0.000000, 0.000000,  128.000000,{ 16, 27, 26, 25} },
	{ 4,207,  128,  128,  448,  352, -768, -800,-1.000000, 0.000000, 0.000000,  128.000000,{ 17, 30, 29, 28} },
	{ 4,207,  128,  128,  448,  352, 1024,  800,-1.000000, 0.000000, 0.000000,  128.000000,{  6, 22, 21, 20} },
	{ 4,207,  128,  128,  512,  416,  800,  448,-1.000000, 0.000000, 0.000000,  128.000000,{ 22, 24, 23, 21} },
	{ 4,207,  128,  128,  544,  480,  448,    0,-1.000000, 0.000000, 0.000000,  128.000000,{ 24, 18, 19, 23} },
	{ 4,207,  128,  128,  512,  352,  448,  416,-1.000000, 0.000000, 0.000000,  128.000000,{ 23, 33, 32, 31} },
	{ 4,207,  128,  128,  448,  352,  800,  768,-1.000000, 0.000000, 0.000000,  128.000000,{ 21, 36, 35, 34} },
	{ 4,207,  128,  128,  512,  352,   32,  -32,-1.000000, 0.000000, 0.000000,  128.000000,{ 37, 40, 39, 38} },
	{ 4,207,  128,  128,  448,  352, -800,-1024,-1.000000, 0.000000, 0.000000,  128.000000,{  8, 41, 17, 14} },
	{ 4, 15,  128, -128,  352,  352, 1024,-1024, 0.000000,-1.000000, 0.000000,  352.000000,{  6,  1, 11,  8} },
	{ 4,191, -640,-1024,  -64,  -64,  320, -192, 0.000000, 1.000000, 0.000000,   64.000000,{ 42, 43, 44, 45} },
	{ 4,191,  352, -640,  -64,  -64,  320, -352, 0.000000, 1.000000, 0.000000,   64.000000,{ 43, 46, 47, 44} },
	{ 4,191, 1024,  320,  -64,  -64,  192, -352, 0.000000, 1.000000, 0.000000,   64.000000,{ 48, 49, 47, 46} },
	{ 4,143, -640,-1024,    0,  -64,    0, -288,-0.267261, 0.801784, 0.534522, -119.733032,{ 45, 44, 50, 51} },
	{ 4,143,  320, -640,    0,  -64,    0, -448, 0.199309, 0.815357, 0.543571,  179.740814,{ 44, 47, 52, 50} },
	{ 4,143, 1024,  320,    0,  -64, -192, -448,-0.125078, 0.825516, 0.550344,  286.579163,{ 47, 49, 53, 52} },
	{ 4,141, -640,-1024,    0,  -64,  384,  192, 0.229416, 0.688247,-0.688247,  411.112976,{ 54, 55, 43, 42} },
	{ 4,141,  352, -640,    0,  -64,  384,   32,-0.201095, 0.692662,-0.692662,  137.281082,{ 55, 56, 46, 43} },
	{ 4,141, 1024,  352,    0,  -64,  256,   32, 0.166022, 0.697294,-0.697294,    8.500344,{ 56, 57, 48, 46} },
	{ 3,221,    0,-1024,    0,    0,  768,  384, 0.000000, 1.000000, 0.000000,    0.000000,{  2,  3, 55} },
	{ 3,220, -640,-1024,    0,    0,  768,  256, 0.000000, 1.000000, 0.000000,    0.000000,{  2, 55, 54} },
	{ 3,220, -640,-1024,    0,    0,  768,  256, 0.000000, 1.000000, 0.000000,    0.000000,{  2, 55, 54} },
	{ 2,221,  352,    0,    0,    0,  640,   96, 0.769822, 0.399062, 0.498120, -318.796844,{  3, 56} },
	{ 4,222, 1024,    0,    0,    0,  768,   96, 0.000000, 1.000000, 0.000000,    0.000000,{  3,  5, 57, 56} },
	{ 3, 13, -128,-1024,  352,    0, -768,-1024,-0.365652, 0.930752, 0.000000, -374.428040,{ 58, 11, 59} },
	{ 3, 13,    0,-1024,  352,    0, -640,-1024,-0.086082, 0.719959, 0.688657,  440.740387,{ 58, 10, 11} },
	{ 3,220,    0,-1024,    0,    0, -288, -768, 0.000000, 1.000000, 0.000000,    0.000000,{ 51, 10, 58} },
	{ 3,221,    0,-1024,    0,    0,  -96, -640, 0.000000, 1.000000, 0.000000,    0.000000,{ 51, 50, 10} },
	{ 3,220,  320, -640,    0,    0,  -96, -640, 0.000000, 1.000000, 0.000000,    0.000000,{ 50, 52, 10} },
	{ 4,222, 1024,    0,    0,    0, -288, -768, 0.000000, 1.000000, 0.000000,    0.000000,{ 52, 53,  9, 10} },
	{ 3,219,  352, -640,    0,    0,  640,   96, 0.000000, 1.000000, 0.000000,    0.000000,{  3, 56, 55} },
	{ 4,207, -128, -128,  448,  352, -800,-1024, 1.000000, 0.000000, 0.000000,  128.000000,{ 11, 60, 61, 62} },
	{ 4,207, -128, -128,  512,  416, -448, -800, 1.000000, 0.000000, 0.000000,  128.000000,{ 60, 63, 64, 61} },
	{ 4,207, -128, -128,  544,  480,    0, -448, 1.000000, 0.000000, 0.000000,  128.000000,{ 63, 65, 66, 64} },
	{ 4,207, -128, -128,  448,  352, 1024,  800, 1.000000, 0.000000, 0.000000,  128.000000,{  1, 67, 68, 69} },
	{ 4,207, -128, -128,  512,  416,  800,  448, 1.000000, 0.000000, 0.000000,  128.000000,{ 69, 68, 70, 71} },
	{ 4,207, -128, -128,  544,  480,  448,    0, 1.000000, 0.000000, 0.000000,  128.000000,{ 71, 70, 66, 65} },
	{ 4,207, -128, -128,  512,  352, -416, -448, 1.000000, 0.000000, 0.000000,  128.000000,{ 64, 72, 73, 74} },
	{ 4,207, -128, -128,  448,  352, -768, -800, 1.000000, 0.000000, 0.000000,  128.000000,{ 61, 75, 76, 77} },
	{ 4,207, -128, -128,  512,  352,  448,  416, 1.000000, 0.000000, 0.000000,  128.000000,{ 70, 78, 79, 80} },
	{ 4,207, -128, -128,  512,  352,   32,  -32, 1.000000, 0.000000, 0.000000,  128.000000,{ 81, 82, 83, 84} },
	{ 4,207, -128, -128,  512,  416, -448, -800,-1.000000, 0.000000, 0.000000, -128.000000,{ 60, 61, 64, 63} },
	{ 4,207, -128, -128,  544,  480,    0, -448,-1.000000, 0.000000, 0.000000, -128.000000,{ 63, 64, 66, 65} },
	{ 4,207, -128, -128,  512,  352, -416, -448,-1.000000, 0.000000, 0.000000, -128.000000,{ 64, 74, 73, 72} },
	{ 4,207, -128, -128,  448,  352, -768, -800,-1.000000, 0.000000, 0.000000, -128.000000,{ 61, 77, 76, 75} },
	{ 4,207, -128, -128,  448,  352, 1024,  800,-1.000000, 0.000000, 0.000000, -128.000000,{  1, 69, 68, 67} },
	{ 4,207, -128, -128,  512,  416,  800,  448,-1.000000, 0.000000, 0.000000, -128.000000,{ 69, 71, 70, 68} },
	{ 4,207, -128, -128,  544,  480,  448,    0,-1.000000, 0.000000, 0.000000, -128.000000,{ 71, 65, 66, 70} },
	{ 4,207, -128, -128,  512,  352,  448,  416,-1.000000, 0.000000, 0.000000, -128.000000,{ 70, 80, 79, 78} },
	{ 4,207, -128, -128,  512,  352,   32,  -32,-1.000000, 0.000000, 0.000000, -128.000000,{ 81, 84, 83, 82} },
	{ 4,207, -128, -128,  448,  352, -800,-1024,-1.000000, 0.000000, 0.000000, -128.000000,{ 11, 62, 61, 60} },
	{ 4,143,  128,  128,  352,  320, 1024,-1024,-1.000000, 0.000000, 0.000000,  128.000000,{  8, 85, 86,  6} },
	{ 4,143,  128,  128,  352,  320, 1024,-1024, 1.000000, 0.000000, 0.000000, -128.000000,{  8,  6, 86, 85} },
	{ 4,207,  128, -128,  544,  544,   32,  -32, 0.000000, 1.000000, 0.000000, -544.000000,{ 87, 88, 89, 90} },
	{ 4,207,  128, -128,  544,  544,   32,  -32, 0.000000,-1.000000, 0.000000,  544.000000,{ 87, 90, 89, 88} },
	{ 4,207,  128, -128,  512,  512,  448,  416, 0.000000, 1.000000, 0.000000, -512.000000,{ 71, 24, 33, 80} },
	{ 4,207,  128, -128,  512,  512,  448,  416, 0.000000,-1.000000, 0.000000,  512.000000,{ 71, 80, 33, 24} },
	{ 4,207,  128, -128,  512,  512, -416, -448, 0.000000, 1.000000, 0.000000, -512.000000,{ 72, 25, 15, 63} },
	{ 4,207,  128, -128,  512,  512, -416, -448, 0.000000,-1.000000, 0.000000,  512.000000,{ 72, 63, 15, 25} },
	{ 4,207, -128, -128,  448,  352,  800,  768, 1.000000, 0.000000, 0.000000,  128.000000,{ 68, 91, 92, 93} },
	{ 4,207, -128, -128,  448,  352,  800,  768,-1.000000, 0.000000, 0.000000, -128.000000,{ 68, 93, 92, 91} },
	{ 4,207,  128, -128,  448,  448, -768, -800, 0.000000, 1.000000, 0.000000, -448.000000,{ 75, 28, 14, 60} },
	{ 4,207,  128, -128,  448,  448, -768, -800, 0.000000,-1.000000, 0.000000,  448.000000,{ 75, 60, 14, 28} },
	{ 4,207,  128, -128,  448,  448,  800,  768, 0.000000, 1.000000, 0.000000, -448.000000,{ 69, 22, 36, 93} },
	{ 4,207,  128, -128,  448,  448,  800,  768, 0.000000,-1.000000, 0.000000,  448.000000,{ 69, 93, 36, 22} },
	{ 4,  4,  128, -128,  352,  352, 1024,-1024, 0.000000, 1.000000, 0.000000, -352.000000,{  1,  6,  8, 11} }
};

ShapeInfo	bridge = { 94,88,1,1024,1024,544,1024,0,bridgePoints,bridgeFaces };

/************************************************************************
 		The mount3 	
************************************************************************/

static PointData mount3Points[] = { 
	{    512,   416,     0,  0, 0.150625, 0.988591, 0.000000 },
	{    256,   480,     0,  0, 0.122277, 0.992496, 0.000000 },
	{    256,     0,  2048,  0, 0.059447, 0.973577, 0.220484 },
	{    512,     0,  2048,  0, 0.000000, 0.979987, 0.199060 },
	{    768,     0,  2048,  0, 0.117472, 0.978685, 0.168452 },
	{    768,   320,     0,  0, 0.237791, 0.971316, 0.000000 },
	{   1024,   224,     0,  0, 0.237660, 0.971348, 0.000000 },
	{   1024,     0,  2048,  0, 0.118125, 0.985298, 0.123429 },
	{   1280,     0,  2048,  0, 0.118553, 0.989909, 0.077629 },
	{   1280,   128,     0,  0, 0.200156, 0.979764, 0.000000 },
	{   1536,     0,  2048,  0, 0.081358, 0.995817, 0.041586 },
	{   1536,    64,     0,  0, 0.122805, 0.992431, 0.000000 },
	{   1792,     0,  2048,  0, 0.041412, 0.998925, 0.020823 },
	{   1792,    32,     0,  0, 0.082834, 0.996563, 0.000000 },
	{    256,     0, -2048,  0, 0.059447, 0.973577,-0.220484 },
	{    512,     0, -2048,  0, 0.000000, 0.979987,-0.199060 },
	{    768,     0, -2048,  0, 0.117472, 0.978685,-0.168452 },
	{   1024,     0, -2048,  0, 0.118125, 0.985298,-0.123429 },
	{   1280,     0, -2048,  0, 0.118553, 0.989909,-0.077629 },
	{   1536,     0, -2048,  0, 0.081358, 0.995817,-0.041586 },
	{   2048,     0,     0,  0, 0.124035, 0.992278, 0.000000 },
	{   2048,     0,  2048,  0, 0.062139, 0.998037, 0.007827 },
	{   2048,     0, -2048,  0, 0.062139, 0.998037,-0.007827 },
	{   1792,     0, -2048,  0, 0.041412, 0.998925,-0.020823 },
	{      0,   480,     0,  0, 0.000000, 1.000000, 0.000000 },
	{      0,     0, -2048,  0, 0.000000, 0.973616,-0.228191 },
	{      0,     0,  2048,  0, 0.000000, 0.973616, 0.228191 },
	{  -2048,     0,  2048,  0,-0.062139, 0.998037, 0.007827 },
	{  -1792,     0,  2048,  0,-0.041412, 0.998925, 0.020823 },
	{  -1792,    32,     0,  0,-0.082834, 0.996563, 0.000000 },
	{  -2048,     0,     0,  0,-0.124035, 0.992278, 0.000000 },
	{  -2048,     0, -2048,  0,-0.062139, 0.998037,-0.007827 },
	{  -1792,     0, -2048,  0,-0.041412, 0.998925,-0.020823 },
	{   -256,     0,  2048,  0,-0.059447, 0.973577, 0.220484 },
	{   -256,   480,     0,  0,-0.122277, 0.992496, 0.000000 },
	{   -256,     0, -2048,  0,-0.059447, 0.973577,-0.220484 },
	{  -1536,    64,     0,  0,-0.122805, 0.992431, 0.000000 },
	{   -512,   416,     0,  0,-0.150625, 0.988591, 0.000000 },
	{   -512,     0, -2048,  0, 0.000000, 0.979987,-0.199060 },
	{   -768,     0, -2048,  0,-0.117472, 0.978685,-0.168452 },
	{   -768,   320,     0,  0,-0.237791, 0.971316, 0.000000 },
	{  -1024,   224,     0,  0,-0.237660, 0.971348, 0.000000 },
	{  -1024,     0, -2048,  0,-0.118125, 0.985298,-0.123429 },
	{  -1280,     0, -2048,  0,-0.118553, 0.989909,-0.077629 },
	{  -1280,   128,     0,  0,-0.200156, 0.979764, 0.000000 },
	{  -1536,     0, -2048,  0,-0.081358, 0.995817,-0.041586 },
	{  -1536,     0,  2048,  0,-0.081358, 0.995817, 0.041586 },
	{   -512,     0,  2048,  0, 0.000000, 0.979987, 0.199060 },
	{   -768,     0,  2048,  0,-0.117472, 0.978685, 0.168452 },
	{  -1024,     0,  2048,  0,-0.118125, 0.985298, 0.123429 },
	{  -1280,     0,  2048,  0,-0.118553, 0.989909, 0.077629 }
};

static FaceData mount3Faces[] = { 
	{ 3,  8,  512,  256,  480,    0, 2048,    0, 0.236499, 0.945996, 0.221718, -514.622070,{  0,  1,  2} },
	{ 3,  8,  512,  256,  416,    0, 2048,    0, 0.000000, 0.979987, 0.199060, -407.674713,{  3,  0,  2} },
	{ 3,  8,  768,  512,  416,    0, 2048,    0, 0.347425, 0.926467, 0.144760, -563.291687,{  4,  5,  0} },
	{ 3,  8,  768,  512,  416,    0, 2048,    0, 0.000000, 0.979987, 0.199060, -407.674713,{  4,  0,  3} },
	{ 3,  8, 1024,  768,  320,    0, 2048,    0, 0.349297, 0.931457, 0.101878, -566.326050,{  6,  5,  7} },
	{ 3,  8, 1024,  768,  320,    0, 2048,    0, 0.000000, 0.988012, 0.154377, -316.163849,{  7,  5,  4} },
	{ 3,  8, 1280, 1024,  224,    0, 2048,    0, 0.350524, 0.934730, 0.058421, -568.315796,{  8,  9,  6} },
	{ 3,  8, 1280, 1024,  224,    0, 2048,    0, 0.000000, 0.994072, 0.108727, -222.672058,{  8,  6,  7} },
	{ 3,  8, 1536, 1280,  128,    0, 2048,    0, 0.242424, 0.969697, 0.030303, -434.424255,{ 10, 11,  9} },
	{ 3,  8, 1536, 1280,  128,    0, 2048,    0, 0.000000, 0.998053, 0.062378, -127.750732,{ 10,  9,  8} },
	{ 3,  8, 1792, 1536,   64,    0, 2048,    0, 0.124020, 0.992159, 0.015502, -253.992615,{ 12, 13, 11} },
	{ 3,  8, 1792, 1536,   64,    0, 2048,    0, 0.000000, 0.999512, 0.031235,  -63.968773,{ 12, 11, 10} },
	{ 3,  8,  512,  256,  480,    0,    0,-2048, 0.236499, 0.945996,-0.221718, -514.622070,{  0, 14,  1} },
	{ 3,  8,  512,  256,  416,    0,    0,-2048, 0.000000, 0.979987,-0.199060, -407.674713,{ 15, 14,  0} },
	{ 3,  8,  768,  512,  416,    0,    0,-2048, 0.347425, 0.926467,-0.144760, -563.291687,{ 16,  0,  5} },
	{ 3,  8,  768,  512,  416,    0,    0,-2048, 0.000000, 0.979987,-0.199060, -407.674713,{ 16, 15,  0} },
	{ 3,  8, 1024,  768,  320,    0,    0,-2048, 0.349297, 0.931457,-0.101878, -566.326050,{  6, 17,  5} },
	{ 3,  8, 1024,  768,  320,    0,    0,-2048, 0.000000, 0.988012,-0.154377, -316.163849,{ 17, 16,  5} },
	{ 3,  8, 1280, 1024,  224,    0,    0,-2048, 0.350524, 0.934730,-0.058421, -568.315796,{ 18,  6,  9} },
	{ 3,  8, 1280, 1024,  224,    0,    0,-2048, 0.000000, 0.994072,-0.108727, -222.672058,{ 18, 17,  6} },
	{ 3,  8, 1536, 1280,  128,    0,    0,-2048, 0.242424, 0.969697,-0.030303, -434.424255,{ 19,  9, 11} },
	{ 3,  8, 1536, 1280,  128,    0,    0,-2048, 0.000000, 0.998053,-0.062378, -127.750732,{ 19, 18,  9} },
	{ 3,  8, 2048, 1792,   32,    0, 2048,    0, 0.124035, 0.992278, 0.000000, -254.023132,{ 20, 13, 21} },
	{ 3,  8, 2048, 1792,   32,    0, 2048,    0, 0.000000, 0.999878, 0.015623,  -31.996094,{ 13, 12, 21} },
	{ 3,  8, 2048, 1792,   32,    0,    0,-2048, 0.000000, 0.999878,-0.015623,  -31.996094,{ 22, 23, 13} },
	{ 3,  8, 2048, 1792,   32,    0,    0,-2048, 0.124035, 0.992278, 0.000000, -254.023132,{ 22, 13, 20} },
	{ 3,  8,  256,    0,  480,    0,    0,-2048, 0.000000, 0.973616,-0.228191, -467.335815,{ 14, 24,  1} },
	{ 3,  8,  256,    0,  480,    0,    0,-2048, 0.000000, 0.973616,-0.228191, -467.335815,{ 14, 25, 24} },
	{ 3,  8,  256,    0,  480,    0, 2048,    0, 0.000000, 0.973616, 0.228191, -467.335815,{  1, 24,  2} },
	{ 3,  8,  256,    0,  480,    0, 2048,    0, 0.000000, 0.973616, 0.228191, -467.335815,{ 24, 26,  2} },
	{ 3,  8, 1792, 1536,   64,    0,    0,-2048, 0.124020, 0.992159,-0.015502, -253.992615,{ 23, 11, 13} },
	{ 3,  8, 1792, 1536,   64,    0,    0,-2048, 0.000000, 0.999512,-0.031235,  -63.968773,{ 23, 19, 11} },
	{ 3,  8,-1792,-2048,   32,    0, 2048,    0, 0.000000, 0.999878, 0.015623,  -31.996094,{ 27, 28, 29} },
	{ 3,  8,-1792,-2048,   32,    0, 2048,    0,-0.124035, 0.992278, 0.000000, -254.023132,{ 27, 29, 30} },
	{ 3,  8,-1792,-2048,   32,    0,    0,-2048,-0.124035, 0.992278, 0.000000, -254.023132,{ 30, 29, 31} },
	{ 3,  8,-1792,-2048,   32,    0,    0,-2048, 0.000000, 0.999878,-0.015623,  -31.996094,{ 29, 32, 31} },
	{ 3,  8,    0, -256,  480,    0, 2048,    0, 0.000000, 0.973616, 0.228191, -467.335815,{ 33, 24, 34} },
	{ 3,  8,    0, -256,  480,    0, 2048,    0, 0.000000, 0.973616, 0.228191, -467.335815,{ 33, 26, 24} },
	{ 3,  8,    0, -256,  480,    0,    0,-2048, 0.000000, 0.973616,-0.228191, -467.335815,{ 34, 24, 35} },
	{ 3,  8,    0, -256,  480,    0,    0,-2048, 0.000000, 0.973616,-0.228191, -467.335815,{ 24, 25, 35} },
	{ 3,  8,-1536,-1792,   64,    0, 2048,    0,-0.124020, 0.992159, 0.015502, -253.992615,{ 28, 36, 29} },
	{ 3,  8, -256, -512,  480,    0,    0,-2048,-0.236499, 0.945996,-0.221718, -514.622070,{ 37, 34, 35} },
	{ 3,  8, -256, -512,  416,    0,    0,-2048, 0.000000, 0.979987,-0.199060, -407.674713,{ 38, 37, 35} },
	{ 3,  8, -512, -768,  416,    0,    0,-2048,-0.347425, 0.926467,-0.144760, -563.291687,{ 39, 40, 37} },
	{ 3,  8, -512, -768,  416,    0,    0,-2048, 0.000000, 0.979987,-0.199060, -407.674713,{ 39, 37, 38} },
	{ 3,  8, -768,-1024,  320,    0,    0,-2048,-0.349297, 0.931457,-0.101878, -566.326050,{ 41, 40, 42} },
	{ 3,  8, -768,-1024,  320,    0,    0,-2048, 0.000000, 0.988012,-0.154377, -316.163849,{ 42, 40, 39} },
	{ 3,  8,-1024,-1280,  224,    0,    0,-2048,-0.350524, 0.934730,-0.058421, -568.315796,{ 43, 44, 41} },
	{ 3,  8,-1024,-1280,  224,    0,    0,-2048, 0.000000, 0.994072,-0.108727, -222.672058,{ 43, 41, 42} },
	{ 3,  8,-1280,-1536,  128,    0,    0,-2048,-0.242424, 0.969697,-0.030303, -434.424255,{ 45, 36, 44} },
	{ 3,  8,-1280,-1536,  128,    0,    0,-2048, 0.000000, 0.998053,-0.062378, -127.750732,{ 45, 44, 43} },
	{ 3,  8,-1536,-1792,   64,    0,    0,-2048,-0.124020, 0.992159,-0.015502, -253.992615,{ 32, 29, 36} },
	{ 3,  8,-1536,-1792,   64,    0,    0,-2048, 0.000000, 0.999512,-0.031235,  -63.968773,{ 32, 36, 45} },
	{ 3,  8,-1536,-1792,   64,    0, 2048,    0, 0.000000, 0.999512, 0.031235,  -63.968773,{ 28, 46, 36} },
	{ 3,  8, -256, -512,  480,    0, 2048,    0,-0.236499, 0.945996, 0.221718, -514.622070,{ 37, 33, 34} },
	{ 3,  8, -256, -512,  416,    0, 2048,    0, 0.000000, 0.979987, 0.199060, -407.674713,{ 47, 33, 37} },
	{ 3,  8, -512, -768,  416,    0, 2048,    0,-0.347425, 0.926467, 0.144760, -563.291687,{ 48, 37, 40} },
	{ 3,  8, -512, -768,  416,    0, 2048,    0, 0.000000, 0.979987, 0.199060, -407.674713,{ 48, 47, 37} },
	{ 3,  8, -768,-1024,  320,    0, 2048,    0,-0.349297, 0.931457, 0.101878, -566.326050,{ 41, 49, 40} },
	{ 3,  8, -768,-1024,  320,    0, 2048,    0, 0.000000, 0.988012, 0.154377, -316.163849,{ 49, 48, 40} },
	{ 3,  8,-1024,-1280,  224,    0, 2048,    0,-0.350524, 0.934730, 0.058421, -568.315796,{ 50, 41, 44} },
	{ 3,  8,-1024,-1280,  224,    0, 2048,    0, 0.000000, 0.994072, 0.108727, -222.672058,{ 50, 49, 41} },
	{ 3,  8,-1280,-1536,  128,    0, 2048,    0,-0.242424, 0.969697, 0.030303, -434.424255,{ 46, 44, 36} },
	{ 3,  8,-1280,-1536,  128,    0, 2048,    0, 0.000000, 0.998053, 0.062378, -127.750732,{ 46, 50, 44} }
};

ShapeInfo	mount3 = { 51,64,64,2048,2048,480,2048,0,mount3Points,mount3Faces };

