
#include	<stdio.h>
#include	"map.h"


typedef	struct	{
		unsigned	short	red;
		unsigned	short	green;
		unsigned	short	blue;
}	Color;

Palette	Pal[256];
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -*/
static	double	ADDS[] = { 4.0,4.5,5.0,5.5,6.0,6.5,7.0,7.5,
						   8,9,10,11,12,13,14,15 };

static	Color	MaxColor[]={	{0xffff,0xffff,0xffff},
								{0xffff,0xffff,0xffff},
								{0xffff,0xffff,0xffff},
								{0xc000,0xc000,0xc000},
								{0xffff,0x8000,0x0000},
								{0x2000,0x8000,0x2000},
								{0xffff,0xc000,0x8000},
								{0xa000,0xa000,0x0000},
								{0xa000,0x3000,0x0000},
								{0xffff,0xffff,0x0000},
								{0xffff,0x0000,0xffff},
								{0x0000,0xffff,0xffff},
								{0xffff,0x0000,0x0000},
								{0x0000,0xffff,0x0000},
								{0x0000,0x0000,0xffff},
								{0xffff,0xffff,0xffff},
};
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -*/

main()
{
	int	palet,color,number;

	printf ("/************************************************************************\n");
	printf ("                                                                         \n");
	printf ("               Project Reality Code name RACE1                           \n");
	printf ("                                                                         \n");
	printf ("                    ++ color data ++                                     \n");
	printf ("                                                                         \n");
	printf ("************************************************************************/\n");

	printf ("\n");
	printf ("#include	\"map.h\"\n");
	printf ("\n");

	printf ("/************************************************************************\n");
	printf (" 		Palette	Table\n");
	printf ("************************************************************************/\n");

	printf ("\n");

	printf ("static	Palette TestColor[]={\n");
	
	for (palet=0;palet<16;palet++){
		for(color=0;color<16;color++){
			number = palet*16+color;
			Pal[number].red		= ( MaxColor[palet].red	  * (ADDS[color])/15.0 )/(unsigned int)0xffff;
			Pal[number].green	= ( MaxColor[palet].green * (ADDS[color])/15.0 )/(unsigned int)0xffff;
			Pal[number].blue	= ( MaxColor[palet].blue  * (ADDS[color])/15.0 )/(unsigned int)0xffff;
		}
	}
		Pal[4].red   	= (double)0xff00/(double)0xffff;
		Pal[4].green 	= (double)0x8000/(double)0xffff;
		Pal[4].blue  	= (double)0x0000/(double)0xffff;
	
		Pal[8].red   	= (double)0x8000/(double)0xffff;
		Pal[8].green 	= (double)0x4000/(double)0xffff;
		Pal[8].blue  	= (double)0x0000/(double)0xffff;

		Pal[13].red   	= (double)0x0800/(double)0xffff;
		Pal[13].green 	= (double)0xf800/(double)0xffff;
		Pal[13].blue  	= (double)0x0800/(double)0xffff;

		Pal[15].red   	= (double)0xf000/(double)0xffff;
		Pal[15].green 	= (double)0xf000/(double)0xffff;
		Pal[15].blue  	= (double)0xf000/(double)0xffff;

/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -*/
	for (palet=0;palet<16;palet++){
		for(color=0;color<16;color++){
			number = palet*16+color;
			printf ("	{ %9f,%9f,%9f }",Pal[number].red,Pal[number].green,Pal[number].blue);
			if (number!=255) printf (",\n");
		}
	}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -*/

	printf ("\n};\n\n");

}

/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -*/
